/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.graphtodb;

import com.sysuptime.common.graph.GraphScheduleBean;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class GraphScheduleProcessor {
    private static final Logger _logger = Logger.getLogger((String)GraphScheduleProcessor.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getInterval() {
        PreparedStatement preparedStatement;
        Connection connection;
        long l2;
        block4: {
            l2 = 0L;
            connection = null;
            preparedStatement = null;
            try {
                connection = DefaultConnection.getConnection();
                preparedStatement = connection.prepareStatement("SELECT PERIOD_C FROM TOPO_GRAPH_SCHEDULE");
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                l2 = resultSet.getLong(1);
            }
            catch (SQLException sQLException) {
                try {
                    _logger.error((Object)sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeConnection(connection, preparedStatement);
                    throw throwable;
                }
                DefaultConnection.closeConnection(connection, preparedStatement);
            }
        }
        DefaultConnection.closeConnection(connection, preparedStatement);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphScheduleBean getScheduleDataById(int n2) {
        GraphScheduleBean graphScheduleBean = null;
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT SCHEDULE_ID_C,SCHEDULE_NAME_C,START_DATE_TIME_C,END_DATE_TIME_C,PERIOD_C,REPETITIONS_C,IS_SUSPENDED_C,TIMEOUT_C,RETRIES_C FROM TOPO_GRAPH_SCHEDULE WHERE SCHEDULE_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setObject(1, Integer.toString(n2));
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                graphScheduleBean = new GraphScheduleBean();
                int n3 = resultSet.getInt("SCHEDULE_ID_C");
                graphScheduleBean.setScheduleId(n3);
                String string2 = resultSet.getString("SCHEDULE_NAME_C");
                graphScheduleBean.setScheduleName(string2);
                long l2 = resultSet.getLong("START_DATE_TIME_C");
                graphScheduleBean.setStartDateTime(l2);
                long l3 = resultSet.getLong("END_DATE_TIME_C");
                graphScheduleBean.setEndDateTime(l3);
                long l4 = resultSet.getLong("PERIOD_C");
                graphScheduleBean.setPeriod(l4);
                int n4 = resultSet.getInt("REPETITIONS_C");
                graphScheduleBean.setRepetitions(n4);
                int n5 = resultSet.getInt("RETRIES_C");
                graphScheduleBean.setRetries(n5);
                graphScheduleBean.setSuspended(SqlUtil.getBoolean(resultSet, 7));
                graphScheduleBean.setTimeout(resultSet.getInt("TIMEOUT_C"));
                GraphScheduleBean graphScheduleBean2 = graphScheduleBean;
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
                return graphScheduleBean2;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        }
        catch (Exception exception) {
            _logger.error((Object)"getScheduleDataById", (Throwable)exception);
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        }
        return graphScheduleBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeTargetInfo(GraphScheduleBean graphScheduleBean) {
        Connection connection = DefaultConnection.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        int n2 = graphScheduleBean.getScheduleId();
        try {
            _logger.info((Object)"insert into graph_schedule......");
            String string = "INSERT INTO  TOPO_GRAPH_SCHEDULE (SCHEDULE_ID_C,SCHEDULE_NAME_C,START_DATE_TIME_C,END_DATE_TIME_C,PERIOD_C,REPETITIONS_C,IS_SUSPENDED_C,TIMEOUT_C , RETRIES_C) VALUES(?,?,?,?,?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setObject(1, (Object)Integer.toString(n2), 4);
            preparedStatement.setObject(2, graphScheduleBean.getScheduleName());
            preparedStatement.setObject(3, (Object)Long.toString(graphScheduleBean.getStartDateTime()), -5);
            preparedStatement.setObject(4, (Object)Long.toString(graphScheduleBean.getEndDateTime()), -5);
            preparedStatement.setObject(5, (Object)Long.toString(graphScheduleBean.getPeriod()), -5);
            preparedStatement.setObject(6, (Object)Integer.toString(graphScheduleBean.getRepetitions()), 4);
            SqlUtil.setBoolean(preparedStatement, 7, graphScheduleBean.isSuspended());
            preparedStatement.setObject(8, (Object)Integer.toString(graphScheduleBean.getTimeout()), 4);
            preparedStatement.setObject(9, (Object)Integer.toString(graphScheduleBean.getRetries()), 4);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            boolean bl2;
            try {
                _logger.error((Object)"storeTargetInfo", (Throwable)exception);
                bl2 = false;
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
                throw throwable;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            return bl2;
        }
        DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        return true;
    }
}

