/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.discovery.DeviceOption;
import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.discovery.MediationData;
import com.sysuptime.common.discovery.NodeOption;
import com.sysuptime.common.discovery.StatisticData;
import com.sysuptime.common.discovery.VlanData;
import com.sysuptime.common.graph.GrantedView;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IconJarData;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.TopologyChange$GraphChange;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.callback.ICallbackClient;
import com.sysuptime.server.discovery.DeviceUpdater;
import com.sysuptime.server.discovery.Discovery;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.DiscoveryStatistic;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.discovery.GraphDataProxy;
import com.sysuptime.server.discovery.MediationProxy;
import com.sysuptime.server.discovery.NodeUpdater;
import com.sysuptime.server.discovery.SubnetUpdater;
import com.sysuptime.server.discovery.TopoDiscoveryMBean;
import com.sysuptime.server.discovery.TopologyComparator;
import com.sysuptime.server.discovery.VlanProxy;
import com.sysuptime.server.graphtodb.GraphScheduleExecutorProxy;
import com.sysuptime.server.login.OrgViewRelationDao;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.SystemStatus;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;

public class TopoDiscovery
implements TopoDiscoveryMBean {
    private static Logger log = Logger.getLogger((String)TopoDiscovery.class.getName());

    @Override
    public RmiResponse discovery(ICallbackClient iCallbackClient) {
        boolean bl2 = Discovery.getInstance().discover(iCallbackClient);
        return new RmiResponse(Boolean.valueOf(bl2));
    }

    @Override
    public boolean saveDiscoveryOptions(DiscoveryOptionsData discoveryOptionsData) {
        return DiscoveryOptions.getInstance().saveDiscoveryOptions(null, discoveryOptionsData);
    }

    @Override
    public void stopDiscovery() {
        Discovery.getInstance().stop();
    }

    @Override
    public String getServerTopoTimeStamp() {
        return GraphDataProxy.getInstance().getServerTopoTimeStamp();
    }

    @Override
    public boolean graphDataChanged(String string) {
        return GraphDataProxy.getInstance().graphDataChanged(string);
    }

    @Override
    public IconJarData getIconJarData(String string) {
        IconJarData iconJarData = GraphDataProxy.getInstance().getIconJarData(string);
        return iconJarData;
    }

    @Override
    public void addIconFiles(Map map) {
        GraphDataProxy.getInstance().addIconFiles(map);
    }

    @Override
    public VlanData getVlanData() {
        return VlanProxy.getInstance().getVlanData();
    }

    @Override
    public StatisticData getStatisticData() {
        return DiscoveryStatistic.getInstance().getData();
    }

    @Override
    public StatisticData getLastStatisticData() {
        return DiscoveryStatistic.getInstance().getLastData();
    }

    @Override
    public List getOldMediation() {
        return MediationProxy.getInstance().getOldMedediation();
    }

    @Override
    public List getExtMediation() {
        return MediationProxy.getInstance().getExtMediation();
    }

    @Override
    public List getMediation() {
        return MediationProxy.getInstance().getMediation();
    }

    @Override
    public int getOldMediationLength() {
        return MediationProxy.getInstance().getOldMediationLength();
    }

    @Override
    public boolean addMediation(MediationData mediationData) {
        return MediationProxy.getInstance().addMediation(mediationData);
    }

    @Override
    public boolean modifyMediation(MediationData mediationData) {
        return MediationProxy.getInstance().modifyMediation(mediationData);
    }

    @Override
    public boolean deleteMediation(String string, String string2) {
        return MediationProxy.getInstance().deleteMediation(string, string2);
    }

    @Override
    public MediationData getMediation(String string, String string2) {
        return MediationProxy.getInstance().getMediation(string, string2);
    }

    @Override
    public List getAllViewIDs() {
        return GraphDao.getAllViewIDs();
    }

    @Override
    public List getAllGrantedViews() {
        return GraphDao.getAllGrantedViews();
    }

    @Override
    public boolean deleteView(GraphID graphID) {
        return GraphDao.delete(graphID);
    }

    @Override
    public boolean deleteByViewID(String string) {
        return OrgViewRelationDao.deleteByViewID(string);
    }

    @Override
    public boolean modifyGrantedView(GrantedView grantedView) {
        return OrgViewRelationDao.modifyGrantedView(grantedView);
    }

    @Override
    public List scanServices(NetworkNodeBean networkNodeBean) {
        return Discovery.getInstance().getFactory().scanServices(networkNodeBean, networkNodeBean.getScanServices());
    }

    @Override
    public boolean shouldConfirmFirstDiscovery() {
        boolean bl2 = Boolean.TRUE.toString().equals(ServerConfig.getProperty("discovered"));
        return !bl2 && !SystemStatus.isDiscovering();
    }

    @Override
    public boolean getDiscovered() {
        return "true".equals(ServerConfig.getProperty("discovered"));
    }

    @Override
    public void setDiscovered(boolean bl2) {
        ServerConfig.updateProperty("discovered", Boolean.toString(bl2));
    }

    @Override
    public List getCustomerIDs() {
        return GraphDao.getCustomerIDs();
    }

    @Override
    public boolean updateNode(NodeOption nodeOption) {
        try {
            log.info((Object)("in TopoDiscovery: updateNode:" + nodeOption));
            GraphScheduleExecutorProxy.getInstance().clearPingFailedBeans(true);
            NodeUpdater nodeUpdater = null;
            nodeUpdater = nodeOption instanceof DeviceOption ? new DeviceUpdater() : new SubnetUpdater();
            return nodeUpdater.update(nodeOption);
        }
        catch (Throwable throwable) {
            log.error((Object)"Error in TopoDiscovery.updateNode", throwable);
            return false;
        }
    }

    @Override
    public void setTopoBaseline() {
        GraphDao.setAsBaseLine();
    }

    @Override
    public RmiResponse compareTopology() throws JRException {
        RmiResponse rmiResponse = new RmiResponse();
        try {
            Map<GraphID, NetworkGraphModel> map = GraphDao.getBaselineGraphs();
            if (map.isEmpty()) {
                rmiResponse.setErrorMessage("no baseline");
                return rmiResponse;
            }
            TopologyComparator topologyComparator = new TopologyComparator();
            topologyComparator.setOldGraphs(map);
            topologyComparator.setNewGraphs(GraphDao.getGraphs());
            Map<GraphID, TopologyChange$GraphChange> map2 = topologyComparator.getChange();
            if (map2.isEmpty()) {
                return rmiResponse;
            }
            String string = AppUtil.getAppServerHomeDirectory() + "/conf/report";
            HashMap<String, CallSite> hashMap = new HashMap<String, CallSite>();
            hashMap.put("SUBREPORT_DIR", (CallSite)((Object)string));
            JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(map2.values());
            rmiResponse.setValue((Serializable)JasperFillManager.fillReport((String)(string + "/TopologyChange.jasper"), hashMap, (JRDataSource)jRBeanCollectionDataSource));
            return rmiResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            rmiResponse.setErrorMessage("exception");
            return rmiResponse;
        }
    }

    @Override
    public int getWebPort() throws Exception {
        return -1;
    }
}

