/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.discovery.StatisticData;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Router;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.VirtualEthernetInterface;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.discovery.ActiveDeviceChecker;
import com.sysuptime.server.discovery.AreaWithDevices;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.DiscoveryUtil;
import com.sysuptime.server.discovery.Topology;
import com.sysuptime.server.msp.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wbem.cim.CIMException;
import org.apache.log4j.Logger;

public final class DiscoveryData {
    private static final Logger _logger = Logger.getLogger((String)DiscoveryData.class.getName());
    private Map<String, NetworkNodeBean> _discoveredNodes = new Hashtable<String, NetworkNodeBean>();
    private List _connections = new ArrayList();
    private Set _ipsShouldBeRouter = new HashSet();
    private Map _areaMap = new Hashtable();
    private Set _normalPingedIps = Collections.synchronizedSet(new HashSet());
    private Set _mustPingedIps = Collections.synchronizedSet(new HashSet());
    private Set _unwantedIps = Collections.synchronizedSet(new HashSet());
    private Set _filteredNodes = Collections.synchronizedSet(new HashSet());
    private StatisticData _statisticData = new StatisticData();
    private int _deviceCount;

    public synchronized NetworkNodeBean addDiscoveredNode(NetworkNodeBean networkNodeBean) {
        if (!this.contains(networkNodeBean)) {
            this._discoveredNodes.put(networkNodeBean.getID(), networkNodeBean);
            ++this._deviceCount;
            try {
                this._statisticData.increaseDiscoveredNodes(networkNodeBean.getDedicated());
            }
            catch (CIMException cIMException) {
                _logger.error((Object)"", (Throwable)cIMException);
            }
        }
        return this.getNode(networkNodeBean.getID());
    }

    public synchronized NetworkNodeBean getNode(String string) {
        return this._discoveredNodes.get(string);
    }

    public synchronized boolean contains(NetworkNodeBean networkNodeBean) {
        return this._discoveredNodes.containsKey(networkNodeBean.getID());
    }

    public synchronized NetworkNodeBean isDiscovered(String string) {
        Iterator<NetworkNodeBean> iterator = this._discoveredNodes.values().iterator();
        boolean bl2 = DiscoveryOptions.d();
        while (iterator.hasNext()) {
            NetworkNodeBean networkNodeBean = iterator.next();
            NetworkInterface networkInterface = networkNodeBean.getInterfaceByIP(string);
            if (networkInterface != null) {
                return networkNodeBean;
            }
            if (!bl2) continue;
        }
        return null;
    }

    public synchronized boolean addPingedIp(String string, boolean bl2) {
        block3: {
            block2: {
                boolean bl3 = DiscoveryOptions.d();
                if (!bl2) break block2;
                this._mustPingedIps.add(string);
                if (!bl3) break block3;
            }
            this._normalPingedIps.add(string);
        }
        return true;
    }

    public synchronized boolean isPinged(String string, boolean bl2) {
        return bl2 ? this._mustPingedIps.contains(string) : this._normalPingedIps.contains(string);
    }

    public synchronized int getDiscoveredNodesSize() {
        return this._discoveredNodes.size();
    }

    public synchronized void addConnection(NetworkConnection networkConnection) {
        if (!this._connections.contains(networkConnection)) {
            this._connections.add(networkConnection);
        }
    }

    public synchronized void addUnwantedIp(String string) {
        this._unwantedIps.add(string);
    }

    public synchronized boolean isUnwantedIp(String string) {
        return this._unwantedIps.contains(string);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void printResult() {
        block16: {
            block15: {
                block14: {
                    block13: {
                        v0 = DiscoveryOptions.c();
                        DiscoveryData._logger.info((Object)"================Print Result==================");
                        var2_1 = this._discoveredNodes.values().iterator();
                        var1_2 = v0;
                        block0: while (true) {
                            v1 = var2_1.hasNext();
                            block1: while (v1) {
                                var3_3 = var2_1.next();
                                DiscoveryData._logger.info((Object)"---------------node----------------");
                                DiscoveryData._logger.info((Object)("ID = " + var3_3.getID()));
                                var4_4 = var3_3.getInterfaces();
                                v2 /* !! */  = var4_4;
                                if (!var1_2) ** GOTO lbl40
                                if (v2 /* !! */  == null) continue block0;
                                for (var5_5 = 0; var5_5 < ((Object)var4_4).length; ++var5_5) {
                                    v1 = var4_4[var5_5] instanceof EthernetInterface;
                                    if (!var1_2) continue block1;
                                    if (!v1) continue;
                                    var6_10 = (String[])var4_4[var5_5];
                                    DiscoveryData._logger.info((Object)(var6_10.getIpAddress() + ":" + var6_10.getIfIndex() + ":" + var6_10.getMacAddress()));
                                    if (var1_2) continue;
                                }
                                if (var1_2) continue block0;
                            }
                            break;
                        }
                        var2_1 = this._connections.iterator();
                        while (var2_1.hasNext()) {
                            var3_3 = var2_1.next();
                            DiscoveryData._logger.info((Object)"-------------connection--------------");
                            var4_4 = (NetworkConnection)var3_3;
                            DiscoveryData._logger.info((Object)(var4_4.getNetworkInterface1() + " --- " + var4_4.getNetworkInterface2()));
                            if (var1_2) {
                                if (var1_2) continue;
                            }
                            break block13;
                        }
                        var2_1 = this._filteredNodes.iterator();
                    }
                    block4: while (true) {
                        v3 = var2_1.hasNext();
                        block5: while (v3) {
                            var3_3 = var2_1.next();
                            DiscoveryData._logger.info((Object)"------------filtered nodes------------");
                            v2 /* !! */  = var3_3;
lbl40:
                            // 2 sources

                            var4_4 = (NetworkNodeBean)v2 /* !! */ ;
                            var5_7 = var4_4.getInterfaces();
                            if (!var1_2) break block14;
                            if (var5_7 == null) continue block4;
                            for (var6_11 = 0; var6_11 < var5_7.length; ++var6_11) {
                                v3 = var5_7[var6_11] instanceof EthernetInterface;
                                if (!var1_2) continue block5;
                                if (!v3) continue;
                                var7_12 = (EthernetInterface)var5_7[var6_11];
                                DiscoveryData._logger.info((Object)(var7_12.getIpAddress() + ":" + var7_12.getIfIndex()));
                                if (var1_2) continue;
                            }
                            if (var1_2) continue block4;
                        }
                        break;
                    }
                    DiscoveryData._logger.info((Object)"================== statistic ==================");
                    DiscoveryData._logger.info((Object)"discovered nodes: ---------------");
                }
                var2_1 = this._statisticData.getDiscoveredNode();
                var3_3 = var2_1.entrySet().iterator();
                DiscoveryData._logger.info((Object)"type\tnumber   ");
                while (var3_3.hasNext()) {
                    var4_4 = (Map.Entry)var3_3.next();
                    var5_8 = (String[])var4_4.getKey();
                    DiscoveryData._logger.info((Object)(var5_8[0] + "\t" + var4_4.getValue()));
                    if (var1_2) {
                        if (var1_2) continue;
                    }
                    break block15;
                }
                DiscoveryData._logger.info((Object)"filtered nodes: ------------------");
            }
            var4_4 = this._statisticData.getFilteredNodes();
            var3_3 = var4_4.entrySet().iterator();
            DiscoveryData._logger.info((Object)"type\tnumber");
            while (var3_3.hasNext()) {
                var5_9 = var3_3.next();
                var6_10 = (String[])var5_9.getKey();
                DiscoveryData._logger.info((Object)(var6_10[0] + "\t" + var5_9.getValue()));
                if (var1_2) {
                    if (var1_2) continue;
                }
                break block16;
            }
            DiscoveryData._logger.info((Object)"ping: ------------------");
            DiscoveryData._logger.info((Object)("count = " + this._statisticData.getPingCount()));
            DiscoveryData._logger.info((Object)("success = " + this._statisticData.getPingSuccessCount()));
            DiscoveryData._logger.info((Object)"snmp query: -------------------");
            DiscoveryData._logger.info((Object)("success = " + this._statisticData.getSnmpQuerySuccessCount()));
        }
        if (Command.b() != null) {
            DiscoveryOptions.b(var1_2 == false);
        }
    }

    public void increasePingCount() {
        this._statisticData.increasePingCount();
    }

    public void increasePingSuccessCount() {
        this._statisticData.increasePingSuccessCount();
    }

    public void increaseSnmpQuerySuccessCount() {
        this._statisticData.increaseSnmpQuerySuccessCount();
    }

    public void increaseFilteredNodes(String[] stringArray) {
        this._statisticData.increaseFilteredNodes(stringArray);
    }

    public void decreaseFilteredNodes(String[] stringArray) {
        this._statisticData.decreaseFilteredNodes(stringArray);
    }

    public void addFilteredNode(NetworkNodeBean networkNodeBean) {
        this._filteredNodes.add(networkNodeBean);
    }

    public boolean isFiltered(NetworkNode networkNode) {
        return this._filteredNodes.contains(networkNode);
    }

    public StatisticData getStatisticData() {
        return this._statisticData;
    }

    public void createAppendSubnet() {
        block4: {
            Iterator<NetworkNodeBean> iterator = this._discoveredNodes.values().iterator();
            Hashtable<Subnet, Subnet> hashtable = new Hashtable<Subnet, Subnet>();
            boolean bl2 = DiscoveryOptions.d();
            block0: while (true) {
                boolean bl3 = iterator.hasNext();
                block1: while (bl3) {
                    NetworkInterface[] networkInterfaceArray;
                    NetworkNodeBean networkNodeBean = iterator.next();
                    if (bl2) break block4;
                    if (ModelUtil.isRouter(networkNodeBean) || ModelUtil.isSubnet(networkNodeBean) || (networkInterfaceArray = networkNodeBean.getInterfaces()) == null) continue block0;
                    for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                        Subnet subnet;
                        EthernetInterface ethernetInterface;
                        String string;
                        bl3 = networkInterfaceArray[i2] instanceof EthernetInterface;
                        if (bl2) continue block1;
                        if (!bl3 || (string = (ethernetInterface = (EthernetInterface)networkInterfaceArray[i2]).getIpAddress()) == null || string.length() == 0 || (subnet = ModelUtil.getSubnetByHostIP(this._discoveredNodes.values(), string)) != null) continue;
                        int n2 = string.lastIndexOf(46);
                        String string2 = string.substring(n2 + 1);
                        String string3 = string.substring(0, n2 + 1) + "0";
                        subnet = new Subnet(string3);
                        VirtualEthernetInterface virtualEthernetInterface = new VirtualEthernetInterface(subnet, string3, Integer.parseInt(string2));
                        subnet.addInterface(virtualEthernetInterface);
                        NetworkConnection networkConnection = DiscoveryUtil.createConnection(virtualEthernetInterface, networkNodeBean, string);
                        if (networkConnection != null) {
                            this.addConnection(networkConnection);
                        }
                        if (hashtable.containsKey(subnet)) continue;
                        hashtable.put(subnet, subnet);
                        this._statisticData.increaseDiscoveredNodes(Subnet.DEDICATED);
                        if (!bl2) continue;
                    }
                    if (!bl2) continue block0;
                }
                break;
            }
            this._discoveredNodes.putAll(hashtable);
        }
    }

    public void completeMac(ActiveDeviceChecker activeDeviceChecker) {
        Iterator<NetworkNodeBean> iterator = this._discoveredNodes.values().iterator();
        boolean bl2 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            NetworkNodeBean networkNodeBean;
            NetworkNodeBean networkNodeBean2 = networkNodeBean = iterator.next();
            activeDeviceChecker.completeMac(networkNodeBean2);
            if (bl2) continue;
        }
    }

    private void a() {
        NetworkNodeBean networkNodeBean = this.isDiscovered(NetworkUtils.getDefaultGateway());
        if (networkNodeBean != null && !ModelUtil.isRouter(networkNodeBean)) {
            Router router = new Router();
            router.setInterfaces(networkNodeBean.getInterfaces());
            router.getOtherProperties().putAll(networkNodeBean.getOtherProperties());
            router.setSysObjectIdValue(networkNodeBean.getSysObjectIdValue());
            router.setReadCommunity(networkNodeBean.getReadCommunity());
            if (!networkNodeBean.isSnmpEnabled()) {
                String string = router.getFirstIp();
                String string2 = NetworkUtils.getSubnet(string);
                NetworkNodeBean networkNodeBean2 = this.isDiscovered(string2);
                Subnet subnet = null;
                if (networkNodeBean2 instanceof Subnet) {
                    subnet = (Subnet)networkNodeBean2;
                } else {
                    this._discoveredNodes.remove(string2);
                }
                if (subnet != null) {
                    int n2 = Integer.parseInt(string.substring(string.lastIndexOf(46) + 1));
                    VirtualEthernetInterface virtualEthernetInterface = new VirtualEthernetInterface(subnet, subnet.getIpAddress(), n2);
                    subnet.addInterface(virtualEthernetInterface);
                    NetworkConnection networkConnection = DiscoveryUtil.createConnection(virtualEthernetInterface, router, string);
                    if (networkConnection != null) {
                        this.addConnection(networkConnection);
                    }
                }
            }
            this._discoveredNodes.put(networkNodeBean.getID(), router);
        }
    }

    public synchronized int getDeviceCount() {
        return this._deviceCount;
    }

    public synchronized int getNextCount() {
        return this._deviceCount + 1;
    }

    public synchronized void addIpShouldBeRouter(String string) {
        this._ipsShouldBeRouter.add(string);
    }

    public void addArea(String string) {
        if (!this._areaMap.containsKey(string)) {
            this._areaMap.put(string, new AreaWithDevices(string));
        }
    }

    private void b() {
        Iterator<NetworkNodeBean> iterator = this._discoveredNodes.values().iterator();
        boolean bl2 = DiscoveryOptions.d();
        while (iterator.hasNext()) {
            block3: {
                NetworkNodeBean networkNodeBean;
                NetworkInterface[] networkInterfaceArray;
                Object object = iterator.next();
                block1: while ((networkInterfaceArray = (networkNodeBean = object).getInterfaces()) != null) {
                    for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                        AreaWithDevices areaWithDevices;
                        String string = ((EthernetInterface)networkInterfaceArray[i2]).getIpAddress();
                        String string2 = NetworkUtils.getSubnet(string);
                        object = string2;
                        if (bl2) continue block1;
                        if (object == null || (areaWithDevices = (AreaWithDevices)this._areaMap.get(string2)) == null) continue;
                        areaWithDevices.addDevice(networkNodeBean);
                        if (!bl2) continue;
                    }
                    if (!bl2) break block3;
                }
                _logger.error((Object)("!!!!!!!!!!!!!!! Device has no interfaces: " + networkNodeBean));
            }
            if (!bl2) continue;
        }
    }

    private void c() {
        Iterator iterator = this._areaMap.values().iterator();
        boolean bl2 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            AreaWithDevices areaWithDevices = (AreaWithDevices)iterator.next();
            List list = areaWithDevices.connect();
            this._connections.addAll(list);
            if (bl2) continue;
        }
    }

    public Topology createTopology() {
        this.d();
        this.e();
        this.g();
        this.h();
        this.a();
        this.b();
        this.c();
        this.f();
        this.printResult();
        return new Topology(this._connections, this._areaMap);
    }

    private void d() {
        ArrayList<NetworkNodeBean> arrayList = new ArrayList<NetworkNodeBean>(this._discoveredNodes.values());
        this._discoveredNodes = new Hashtable<String, NetworkNodeBean>();
        Iterator iterator = arrayList.iterator();
        boolean bl2 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            NetworkNodeBean networkNodeBean = (NetworkNodeBean)iterator.next();
            this._discoveredNodes.put(networkNodeBean.getID(), networkNodeBean);
            if (bl2) continue;
        }
    }

    private void e() {
        Hashtable<String, NetworkNodeBean> hashtable = new Hashtable<String, NetworkNodeBean>(this._discoveredNodes);
        HashMap<String, NetworkNodeBean> hashMap = new HashMap<String, NetworkNodeBean>();
        Iterator iterator = hashtable.values().iterator();
        boolean bl2 = DiscoveryOptions.c();
        block0: while (true) {
            boolean bl3 = iterator.hasNext();
            block1: while (bl3) {
                Object v2 = iterator.next();
                NetworkNodeBean networkNodeBean = (NetworkNodeBean)v2;
                String[] stringArray = networkNodeBean.getAllIpAddress();
                if (stringArray == null) continue block0;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    block7: {
                        block9: {
                            block8: {
                                bl3 = hashMap.containsKey(stringArray[i2]);
                                if (!bl2) continue block1;
                                if (!bl3) break block7;
                                NetworkNodeBean networkNodeBean2 = (NetworkNodeBean)hashMap.get(stringArray[i2]);
                                if (networkNodeBean2.isSnmpEnabled()) break block8;
                                this._discoveredNodes.remove(networkNodeBean2.getID());
                                if (bl2) break block9;
                            }
                            if (!networkNodeBean.isSnmpEnabled()) {
                                this._discoveredNodes.remove(networkNodeBean.getID());
                            }
                        }
                        if (bl2) continue;
                    }
                    hashMap.put(stringArray[i2], networkNodeBean);
                    if (bl2) continue;
                }
                if (bl2) continue block0;
            }
            break;
        }
    }

    private void f() {
        Iterator iterator = this._connections.iterator();
        boolean bl2 = DiscoveryOptions.d();
        while (iterator.hasNext()) {
            AreaWithDevices areaWithDevices;
            String string;
            String string2;
            NetworkConnection networkConnection = (NetworkConnection)iterator.next();
            NetworkInterface networkInterface = networkConnection.getNetworkInterface1();
            NetworkInterface networkInterface2 = networkConnection.getNetworkInterface2();
            if (networkInterface.getHostNode() instanceof Router && networkInterface2.getHostNode() instanceof Router && StringUtil.inSameSubnet2(string2 = ((EthernetInterface)networkInterface).getIpAddress(), string = ((EthernetInterface)networkInterface2).getIpAddress()) && (areaWithDevices = (AreaWithDevices)this._areaMap.get(NetworkUtils.getSubnet(string2))) != null && areaWithDevices.hasSubnet()) {
                iterator.remove();
            }
            if (!bl2) continue;
        }
    }

    private void g() {
        Iterator iterator = this._ipsShouldBeRouter.iterator();
        boolean bl2 = DiscoveryOptions.c();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NetworkNodeBean networkNodeBean = this.isDiscovered(string);
            if (networkNodeBean != null && !(networkNodeBean instanceof Router)) {
                Router router = new Router(networkNodeBean);
                this._discoveredNodes.put(router.getID(), router);
            }
            if (bl2) continue;
        }
    }

    private void h() {
        Iterator<NetworkNodeBean> iterator = this._discoveredNodes.values().iterator();
        boolean bl2 = DiscoveryOptions.d();
        while (iterator.hasNext()) {
            NetworkNodeBean networkNodeBean = iterator.next();
            if (networkNodeBean instanceof Router) {
                Router router = (Router)networkNodeBean;
                router.setRouting(this.a(router));
            }
            if (!bl2) continue;
        }
    }

    private boolean a(Router router) {
        boolean bl2;
        block2: {
            String[] stringArray = router.getAllIpAddress();
            boolean bl3 = DiscoveryOptions.c();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                bl2 = this._ipsShouldBeRouter.contains(stringArray[i2]);
                if (bl3) {
                    if (!bl2) continue;
                    return true;
                }
                break block2;
            }
            bl2 = false;
        }
        return bl2;
    }
}

