/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.m;
import com.sysuptime.common.discovery.IPRange;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.model.GenericNode;
import com.sysuptime.common.model.Host;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.SnmpOidAction;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.common.util.callback.ICallbackClient;
import com.sysuptime.common.util.net.NetworkUtils;
import com.sysuptime.server.discovery.ActiveDeviceChecker;
import com.sysuptime.server.discovery.DeviceInfoParse;
import com.sysuptime.server.discovery.Discovery$DiscoveryHostThread;
import com.sysuptime.server.discovery.DiscoveryData;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.DiscoveryStatistic;
import com.sysuptime.server.discovery.DiscoveryStatus;
import com.sysuptime.server.discovery.DiscoveryUtil;
import com.sysuptime.server.discovery.GraphDataProxy;
import com.sysuptime.server.discovery.Hops;
import com.sysuptime.server.discovery.NetworkNodeFactory;
import com.sysuptime.server.discovery.VlanProxy;
import com.sysuptime.server.graphtodb.GraphScheduleExecutorProxy;
import com.sysuptime.server.util.SystemStatus;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import javax.wbem.cim.CIMException;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class Discovery {
    private static final Logger _logger = Logger.getLogger((String)Discovery.class.getName());
    public static final int DEFAULT_SNMP_PORT = 161;
    private static final Discovery _instance = new Discovery();
    private PooledExecutor _pooledExecutor;
    private boolean _isEnd;
    private ICallbackClient _client;
    private int _hopsCount = 0;
    private DiscoveryOptions _options = DiscoveryOptions.getInstance();
    private SynchronizedInt _jobCount;
    private NetworkNodeFactory _factory;
    private DiscoveryData _data;
    private Hops _hops;
    private DiscoveryStatus _status;
    private ActiveDeviceChecker _activeChecker;

    private Discovery() {
    }

    private void a() {
        this._client = null;
        this._data = new DiscoveryData();
        DeviceInfoParse.getInstance().parseDataFile();
        this._isEnd = false;
        this._options.synchronize();
        _logger.info((Object)this._options);
        this._pooledExecutor = new PooledExecutor(this._options.getThreads());
        this._pooledExecutor.waitWhenBlocked();
        this._pooledExecutor.setKeepAliveTime(0L);
        this._jobCount = new SynchronizedInt(0);
        this._hopsCount = 0;
        VlanProxy.getInstance().init();
        GraphScheduleExecutorProxy.getInstance().clearPingFailedBeans(true);
        this._factory = new NetworkNodeFactory(this._options);
        this._hops = new Hops();
        this._status = new DiscoveryStatus();
        this._activeChecker = new ActiveDeviceChecker();
    }

    private void b() {
        this._data = null;
        this._client = null;
        this._pooledExecutor = null;
        this._activeChecker = null;
    }

    public static Discovery getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean discover(ICallbackClient iCallbackClient) {
        try {
            block14: {
                NetworkNodeBean networkNodeBean;
                String string;
                block16: {
                    block13: {
                        this.a();
                        this._client = iCallbackClient;
                        string = this.c();
                        try {
                            if (NetworkUtils.isActiveIp(string) && this._options.isValid(string, "", null, "", false)) break block13;
                        }
                        catch (Throwable throwable) {
                            throw Discovery.a(throwable);
                        }
                        string = NetworkUtils.getSubnet(string);
                    }
                    _logger.info((Object)("seed = " + string));
                    networkNodeBean = this.a(string, false);
                    if (networkNodeBean == null) break block14;
                    if (networkNodeBean instanceof Subnet) break block14;
                    break block16;
                    catch (Throwable throwable) {
                        throw Discovery.a(throwable);
                    }
                }
                try {
                    block17: {
                        if (networkNodeBean.isSnmpEnabled()) break block14;
                        break block17;
                        catch (Throwable throwable) {
                            throw Discovery.a(throwable);
                        }
                    }
                    this.a(NetworkUtils.getSubnet(string), false);
                }
                catch (Throwable throwable) {
                    throw Discovery.a(throwable);
                }
            }
            this.d();
            this.f();
            this._data.printResult();
            this.d(NbBundle.getMessage(Discovery.class, (String)"Message_updating_topology_data"));
            GraphDataProxy.getInstance().updateGraphData(this._options.cleanDiscovery(), this._data);
            GraphDataProxy.getInstance().updateIconJar();
            CallbackServer.getInstance().notifyAllClients(this._client, "GraphLoaderProxy", "askToLoadNewData", null, null);
            this._status.setEnd(true);
        }
        catch (Throwable throwable) {
            _logger.error((Object)"discovery", throwable);
            this._status.setError(true);
            this._status.setEnd(true);
            boolean bl2 = false;
            return bl2;
        }
        finally {
            this.b();
        }
        return true;
    }

    public ICallbackClient getCallbackClient() {
        return this._client;
    }

    private String c() {
        String string;
        block7: {
            string = this._options.getSeed();
            try {
                if (string != null && string.length() != 0) break block7;
            }
            catch (UnknownHostException unknownHostException) {
                throw Discovery.a(unknownHostException);
            }
            string = NetworkUtils.getDefaultGateway();
        }
        try {
            if (StringUtil.isIp(string)) {
                return string;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw Discovery.a(unknownHostException);
        }
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            _logger.error((Object)"", (Throwable)unknownHostException);
            return NetworkUtils.getDefaultGateway();
        }
    }

    private void d() {
        block6: {
            boolean bl2 = DiscoveryOptions.d();
            while (this._jobCount.compareTo(0) != 0) {
                try {
                    Thread.sleep(1000L);
                    if (!bl2) {
                        continue;
                    }
                    break block6;
                }
                catch (InterruptedException interruptedException) {
                    _logger.error((Object)"sleep", (Throwable)interruptedException);
                    if (!bl2) continue;
                }
            }
            this._pooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
            try {
                this._pooledExecutor.awaitTerminationAfterShutdown();
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)"await", (Throwable)interruptedException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private NetworkNodeBean a(String var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private void a(NetworkNodeBean var1_1, SnmpSession var2_2) throws IOException {
        block53: {
            var3_3 = DiscoveryOptions.c();
            if (var2_2 == null) break block53;
            var4_4 = var2_2.snmpGetTable("ipRouteTable");
            var5_5 = var2_2.snmpGetTable("ipAddrTable");
            try {
                try {
                    try {
                        if (var4_4 != null && var4_4.getRowCount() > 0) {
                        }
                        ** GOTO lbl156
                    }
                    catch (IOException v0) {
                        throw Discovery.a(v0);
                    }
                    if (var5_5 != null) {
                    }
                    ** GOTO lbl156
                }
                catch (IOException v1) {
                    throw Discovery.a(v1);
                }
                if (var5_5.getRowCount() > 0) {
                }
                ** GOTO lbl156
            }
            catch (IOException v2) {
                throw Discovery.a(v2);
            }
            var6_6 = var4_4.getColumn(0);
            var7_7 = var4_4.getColumn(1);
            var8_8 = var4_4.getColumn(6);
            var9_9 = var4_4.getColumn(7);
            var10_10 = var4_4.getColumn(8);
            var11_11 = var5_5.getColumn(0);
            var12_12 = var5_5.getColumn(1);
            var13_13 = var4_4.getRowCount();
            for (var14_14 = 0; var14_14 < var13_13; ++var14_14) {
                block56: {
                    block55: {
                        block54: {
                            var15_15 = ModelUtil.varBind2String(var6_6[var14_14]);
                            var16_16 = ModelUtil.varBind2String(var8_8[var14_14]);
                            var17_17 = ModelUtil.varBind2String(var9_9[var14_14]);
                            var18_18 = ModelUtil.varBind2String(var7_7[var14_14]);
                            var19_19 = 4;
                            var20_20 = ModelUtil.varBind2String(var10_10[var14_14]);
                            try {
                                if (!var3_3) break block53;
                                if (!StringUtil.isDigit(var20_20)) break block54;
                            }
                            catch (IOException v3) {
                                throw Discovery.a(v3);
                            }
                            var19_19 = Integer.parseInt(var20_20);
                        }
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    Discovery._logger.info((Object)"--------------------------");
                                                    Discovery._logger.info((Object)("dest = " + var15_15));
                                                    Discovery._logger.info((Object)("nextHop = " + var16_16));
                                                    Discovery._logger.info((Object)("type = " + var17_17));
                                                    Discovery._logger.info((Object)("index = " + var18_18));
                                                    if (var15_15 == null || var16_16 == null) continue;
                                                }
                                                catch (IOException v4) {
                                                    throw Discovery.a(v4);
                                                }
                                                if (var17_17 == null) continue;
                                            }
                                            catch (IOException v5) {
                                                throw Discovery.a(v5);
                                            }
                                            if (var18_18 == null) continue;
                                        }
                                        catch (IOException v6) {
                                            throw Discovery.a(v6);
                                        }
                                        if (!NetworkUtils.isArbitraryAddress(var15_15)) break block55;
                                    }
                                    catch (IOException v7) {
                                        throw Discovery.a(v7);
                                    }
                                    this._data.addIpShouldBeRouter(var16_16);
                                    if (var1_1.getInterfaceByIP(this._hops.getCurrentHop()) == null) break block55;
                                }
                                catch (IOException v8) {
                                    throw Discovery.a(v8);
                                }
                                if (this._hops.hopsCount() >= this._options.getHops()) break block55;
                            }
                            catch (IOException v9) {
                                throw Discovery.a(v9);
                            }
                            this._hops.addHop(var16_16);
                        }
                        catch (IOException v10) {
                            throw Discovery.a(v10);
                        }
                    }
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        if (NetworkUtils.isLoopbackAddress(var15_15) || NetworkUtils.isBroadcastAddress(var15_15)) continue;
                                    }
                                    catch (IOException v11) {
                                        throw Discovery.a(v11);
                                    }
                                    if (NetworkUtils.isMulticastAddress(var15_15)) continue;
                                }
                                catch (IOException v12) {
                                    throw Discovery.a(v12);
                                }
                                if (NetworkUtils.isLoopbackAddress(var16_16)) continue;
                            }
                            catch (IOException v13) {
                                throw Discovery.a(v13);
                            }
                            if ("direct".equals(SnmpOidAction.ROUTE_TYPE_MAP.getProperty((Comparable)var17_17))) {
                            }
                            ** GOTO lbl130
                        }
                        catch (IOException v14) {
                            throw Discovery.a(v14);
                        }
                        if (NetworkUtils.isArbitraryAddress(var15_15)) continue;
                    }
                    catch (IOException v15) {
                        throw Discovery.a(v15);
                    }
                    var21_21 = this.a(var15_15, false);
                    if (var21_21 != null) {
                        var22_22 = this.a(var18_18, var11_11, var12_12);
                        Discovery._logger.info((Object)("source = " + var22_22));
                        if (var22_22 != null) {
                            var23_23 = DiscoveryUtil.createConnection(var1_1, var22_22, var21_21, var15_15);
                            try {
                                if (var23_23 != null) {
                                    this._data.addConnection(var23_23);
                                }
                            }
                            catch (IOException v16) {
                                throw Discovery.a(v16);
                            }
                        }
                    }
                    try {
                        try {
                            try {
                                if (var3_3) continue;
lbl130:
                                // 2 sources

                                if (!"indirect".equals(SnmpOidAction.ROUTE_TYPE_MAP.getProperty((Comparable)var17_17))) continue;
                            }
                            catch (IOException v17) {
                                throw Discovery.a(v17);
                            }
                            if (var19_19 == 4) break block56;
                        }
                        catch (IOException v18) {
                            throw Discovery.a(v18);
                        }
                        this._data.addIpShouldBeRouter(var16_16);
                    }
                    catch (IOException v19) {
                        throw Discovery.a(v19);
                    }
                }
                if ((var21_21 = this.a(var16_16, false)) == null) continue;
                var22_22 = this.a(var18_18, var11_11, var12_12);
                Discovery._logger.info((Object)("source = " + var22_22));
                if (var22_22 == null) continue;
                var23_23 = DiscoveryUtil.createConnection(var1_1, var22_22, var21_21, var16_16);
                try {
                    if (var23_23 == null) continue;
                    this._data.addConnection(var23_23);
                    continue;
                }
                catch (IOException v20) {
                    throw Discovery.a(v20);
                }
            }
            try {
                if (var3_3) break block53;
lbl156:
                // 4 sources

                this.b(NetworkUtils.getSubnet(var2_2.getTarget().getHost()), false);
            }
            catch (IOException v21) {
                throw Discovery.a(v21);
            }
        }
    }

    private SnmpSession a(String string) {
        SnmpSession snmpSession;
        block4: {
            snmpSession = null;
            m m2 = new m(string, 161);
            try {
                snmpSession = new SnmpSession(m2);
                snmpSession.setRetries(0);
                snmpSession.setTimeout(this._options.getTimeout());
                ReadCommunity readCommunity = (ReadCommunity)this._options.getIpCommunities().get(string);
                try {
                    if (readCommunity == null) break block4;
                    ((m)snmpSession.getTarget()).setReadCommunity(readCommunity.getCommunity());
                    snmpSession.setVersion(readCommunity.getVersion());
                    if (readCommunity.getVersion() != 3) break block4;
                }
                catch (IOException iOException) {
                    throw Discovery.a(iOException);
                }
                V3Params v3Params = readCommunity.getV3Params();
                snmpSession.setV3Params(v3Params.getUserName(), v3Params.getAuthProtocol(), v3Params.getAuthPassword(), v3Params.getPrivProtocol(), v3Params.getPrivPassword());
            }
            catch (IOException iOException) {
                _logger.error((Object)"discovery 2", (Throwable)iOException);
            }
        }
        return snmpSession;
    }

    private boolean b(String string) {
        return this._options.isDiscoveryPublic() || NetworkUtils.isPrivateAddress(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean c(String string) {
        if (this._hops.isHop(string)) {
            Discovery discovery = this;
            synchronized (discovery) {
                if (++this._hopsCount > this._options.getHops()) {
                    return false;
                }
            }
        }
        return true;
    }

    private void b(String string, boolean bl2) {
        long l2 = System.currentTimeMillis();
        boolean bl3 = DiscoveryOptions.d();
        try {
            if (string == null) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            throw Discovery.a(interruptedException);
        }
        this._data.addPingedIp(string, bl2);
        IPRange iPRange = new IPRange();
        iPRange.addExpression(string);
        Iterator iterator = iPRange.iterator();
        for (int i2 = 0; i2 < this._options.getThreads(); ++i2) {
            Discovery$DiscoveryHostThread discovery$DiscoveryHostThread = new Discovery$DiscoveryHostThread(iterator, bl2);
            try {
                this._pooledExecutor.execute((Runnable)discovery$DiscoveryHostThread);
                continue;
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)"discoverSubnet", (Throwable)interruptedException);
            }
            if (!bl3) continue;
        }
    }

    private boolean a(NetworkNodeBean networkNodeBean) {
        block9: {
            try {
                if (networkNodeBean == null) {
                    return false;
                }
            }
            catch (CIMException cIMException) {
                throw Discovery.a(cIMException);
            }
            String[] stringArray = null;
            try {
                stringArray = networkNodeBean.getDedicated();
            }
            catch (CIMException cIMException) {
                _logger.error((Object)"checkIgnoreNonSnmp", (Throwable)cIMException);
            }
            try {
                try {
                    if (!this._options.ignoreNonSnmp() || networkNodeBean.isSnmpEnabled()) break block9;
                }
                catch (CIMException cIMException) {
                    throw Discovery.a(cIMException);
                }
                this._data.increaseFilteredNodes(stringArray);
                this._data.addFilteredNode(networkNodeBean);
                return false;
            }
            catch (CIMException cIMException) {
                throw Discovery.a(cIMException);
            }
        }
        return true;
    }

    private boolean a(String string, NetworkNodeBean networkNodeBean, boolean bl2) {
        String[] stringArray = null;
        try {
            stringArray = networkNodeBean.getDedicated();
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"checkFilters", (Throwable)cIMException);
        }
        String string2 = networkNodeBean.getOtherProperty("SysName");
        String string3 = networkNodeBean.getOtherProperty("SysDescr");
        try {
            if (!this._options.isValid(string, string2, stringArray, string3, bl2)) {
                _logger.info((Object)("not valid: " + string + ", isMust = " + bl2));
                this._data.increaseFilteredNodes(stringArray);
                this._data.addFilteredNode(networkNodeBean);
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw Discovery.a(cIMException);
        }
        return true;
    }

    private boolean c(String string, boolean bl2) {
        if (this._data.isPinged(string, bl2)) {
            return false;
        }
        this._data.increasePingCount();
        boolean bl3 = this._activeChecker.isActive(string, this._options.getTimeout());
        if (bl3) {
            this._data.increasePingSuccessCount();
            this._data.addPingedIp(string, bl2);
        }
        return bl3;
    }

    private void b(NetworkNodeBean networkNodeBean) {
        block10: {
            String string;
            Object[] objectArray;
            block9: {
                this._status.addNode(networkNodeBean);
                objectArray = new Object[4];
                try {
                    objectArray[0] = networkNodeBean.getFirstIp();
                    objectArray[1] = networkNodeBean.getOtherProperty("SysName");
                    if (!(networkNodeBean instanceof Host) && !(networkNodeBean instanceof GenericNode)) break block9;
                }
                catch (Exception exception) {
                    throw Discovery.a(exception);
                }
                string = networkNodeBean.getNetBiosName();
                try {
                    if (string != null) {
                        objectArray[1] = string;
                    }
                }
                catch (Exception exception) {
                    throw Discovery.a(exception);
                }
            }
            string = networkNodeBean.getClass().toString();
            try {
                objectArray[2] = string.substring(string.lastIndexOf(46) + 1);
                objectArray[3] = networkNodeBean.isSnmpEnabled();
                if (this._client == null || this._client == SystemStatus.VIRTUALCLIENT) break block10;
            }
            catch (Exception exception) {
                throw Discovery.a(exception);
            }
            try {
                Class[] classArray = new Class[]{objectArray.getClass()};
                Object[] objectArray2 = new Object[]{objectArray};
                this._client.sendNotify("DiscoveryMessageCallback", "addRow", classArray, objectArray2);
            }
            catch (Exception exception) {
                _logger.error((Object)"addResultToClient", (Throwable)exception);
                this._client = null;
            }
        }
    }

    private void d(String string) {
        block4: {
            try {
                if (this._client == null || this._client == SystemStatus.VIRTUALCLIENT) break block4;
            }
            catch (Exception exception) {
                throw Discovery.a(exception);
            }
            try {
                Class[] classArray = new Class[]{string.getClass()};
                Object[] objectArray = new Object[]{string};
                this._client.sendNotify("DiscoveryMessageCallback", "showMessage", classArray, objectArray);
            }
            catch (Exception exception) {
                this._client = null;
            }
        }
    }

    private void e() {
        block4: {
            try {
                if (this._client == null || this._client == SystemStatus.VIRTUALCLIENT) break block4;
            }
            catch (Exception exception) {
                throw Discovery.a(exception);
            }
            try {
                this._client.sendNotify("DiscoveryMessageCallback", "showExceedLicense", null, null);
            }
            catch (Exception exception) {
                _logger.error((Object)"showExceedLicense", (Throwable)exception);
                this._client = null;
            }
        }
    }

    private String a(String string, SnmpVarBind[] snmpVarBindArray, SnmpVarBind[] snmpVarBindArray2) {
        boolean bl2 = DiscoveryOptions.d();
        for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
            String string2;
            if (!ModelUtil.varBind2String(snmpVarBindArray[i2]).equals(string) || NetworkUtils.isLoopbackAddress(string2 = ModelUtil.varBind2String(snmpVarBindArray2[i2]))) continue;
            return string2;
        }
        return null;
    }

    private void f() {
        this.d(NbBundle.getMessage(Discovery.class, (String)"Message_posting_discovery"));
        this.g();
        DiscoveryStatistic.getInstance().save(this._data.getStatisticData());
        this._data.completeMac(this._activeChecker);
    }

    private void g() {
        block4: {
            this._pooledExecutor = new PooledExecutor(this._options.getThreads());
            this._pooledExecutor.setKeepAliveTime(0L);
            IPRange iPRange = this._options.getMustIpRange();
            Iterator iterator = iPRange.iterator();
            boolean bl2 = DiscoveryOptions.c();
            for (int i2 = 0; i2 < this._options.getThreads(); ++i2) {
                try {
                    this._pooledExecutor.execute((Runnable)new Discovery$DiscoveryHostThread(iterator, true));
                    if (bl2) {
                        continue;
                    }
                    break block4;
                }
                catch (InterruptedException interruptedException) {
                    _logger.error((Object)"discoverMustNodes", (Throwable)interruptedException);
                }
                if (bl2) continue;
            }
            this.d();
        }
    }

    public void stop() {
        _logger.info((Object)"************** Stopping discovery *****************");
        this._isEnd = true;
    }

    public boolean isEnd() {
        return this._isEnd;
    }

    public int getJobCount() {
        return this._jobCount.get();
    }

    public void incrementJobCount() {
        this._jobCount.increment();
    }

    public void decrementJobCount() {
        this._jobCount.decrement();
    }

    public NetworkNodeFactory getFactory() {
        if (this._factory == null) {
            this._options.synchronize();
            this._factory = new NetworkNodeFactory(this._options);
        }
        return this._factory;
    }

    public DiscoveryData getData() {
        return this._data;
    }

    public DiscoveryStatus getStatus() {
        return this._status;
    }

    public void clearStatus() {
        this._status = null;
    }

    static {
        SnmpSession.setToUseJCE(true);
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

