/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.model.NodeSnmpOidInfo;
import com.sysuptime.common.model.SnmpOidAction;
import com.sysuptime.common.model.SnmpOidGetAction;
import com.sysuptime.common.model.SnmpOidGetNextAction;
import com.sysuptime.common.model.SnmpOidGetSubtreeAction;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.CompactProperties;
import com.sysuptime.common.util.DataFile;
import com.sysuptime.server.discovery.DiscoveryOptions;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DeviceInfoParse
implements Serializable {
    private static final Logger _logger = Logger.getLogger((String)DeviceInfoParse.class.getName());
    private static final String PATH = AppUtil.getAppHomeDirectory();
    private static final String COMMONFILEPATH = File.separator + "data" + File.separator + "device" + File.separator;
    private static final String EXTFILEPATH = COMMONFILEPATH + "ext" + File.separator;
    private static DeviceInfoParse _instance = new DeviceInfoParse();
    private static boolean _firstParse = true;
    private static Hashtable<String, Class> _map = new Hashtable();
    private static long _parseTime = 0L;

    private static Class a(String string) {
        return _map.get(string);
    }

    private DeviceInfoParse() {
    }

    public static DeviceInfoParse getInstance() {
        return _instance;
    }

    private ArrayList a() {
        File file;
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl2 = DiscoveryOptions.d();
        File[] fileArray = new File(PATH + COMMONFILEPATH).listFiles();
        File file2 = new File(PATH + EXTFILEPATH);
        if (fileArray != null && fileArray.length > 0) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                file = fileArray[i2];
                if (!bl2) {
                    if (file.isDirectory() || !fileArray[i2].getName().equals("mediation.xml")) continue;
                    arrayList.add(fileArray[i2]);
                    if (!bl2) continue;
                }
                break;
            }
        } else {
            file = file2;
        }
        if (file != null) {
            this.a(file2, arrayList);
        }
        return arrayList;
    }

    private void a(File file, ArrayList arrayList) {
        File[] fileArray;
        boolean bl2 = DiscoveryOptions.c();
        if (file.isDirectory() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].isFile() || !fileArray[i2].getName().equals("extension.xml")) continue;
                arrayList.add(fileArray[i2]);
                if (bl2) continue;
            }
        }
    }

    public void parseDataFile() {
        block5: {
            int n2;
            ArrayList<File> arrayList;
            block4: {
                boolean bl2;
                ArrayList arrayList2;
                block6: {
                    arrayList2 = this.a();
                    bl2 = DiscoveryOptions.c();
                    if (arrayList2.isEmpty()) break block5;
                    if (!_firstParse) break block6;
                    _firstParse = false;
                    this.a(arrayList2);
                    if (bl2) break block5;
                }
                arrayList = new ArrayList<File>();
                for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                    File file = (File)arrayList2.get(i2);
                    long l2 = file.lastModified() - _parseTime;
                    n2 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                    if (bl2) {
                        if (n2 <= 0) continue;
                        arrayList.add(file);
                        if (bl2) continue;
                    }
                    break block4;
                }
                n2 = arrayList.isEmpty();
            }
            if (n2 == 0) {
                this.a(arrayList);
            }
        }
    }

    private void a(ArrayList arrayList) {
        block5: {
            _parseTime = System.currentTimeMillis();
            Object[] objectArray = arrayList.toArray();
            boolean bl2 = DiscoveryOptions.d();
            try {
                if (objectArray == null || objectArray.length <= 0) break block5;
            }
            catch (DocumentException documentException) {
                throw DeviceInfoParse.a((Exception)((Object)documentException));
            }
            SAXReader sAXReader = new SAXReader();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                File file = (File)objectArray[i2];
                try {
                    Document document = sAXReader.read((Reader)DataFile.getContentAsReader(file.getAbsolutePath()));
                    this.a(document, (File)objectArray[i2]);
                    continue;
                }
                catch (DocumentException documentException) {
                    _logger.info((Object)("Cannot parse:" + file.getAbsolutePath() + ". Error:" + documentException));
                }
                if (!bl2) continue;
            }
        }
    }

    private void a(Document document, File file) {
        boolean bl2 = DiscoveryOptions.c();
        if (!document.getRootElement().getName().equals("Devices")) {
            _logger.error((Object)("No root element 'Devices' for file : " + file.getAbsolutePath()));
            return;
        }
        boolean bl3 = false;
        if (file.getName().equals("mediation.xml")) {
            bl3 = true;
        }
        Iterator iterator = document.getRootElement().elementIterator();
        while (iterator.hasNext()) {
            this.a(iterator.next(), bl3);
            if (bl2) continue;
        }
    }

    private void a(Object object, boolean bl2) {
        Element element = (Element)object;
        int n2 = element.attributeCount();
        boolean bl3 = DiscoveryOptions.c();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                NodeSnmpOidInfo nodeSnmpOidInfo;
                block9: {
                    Object object2;
                    CompactProperties compactProperties;
                    String string2;
                    block8: {
                        if (!element.attribute(i2).getName().equals("sysObjectIdValue") || (string2 = element.attribute(i2).getValue()) == null) continue;
                        nodeSnmpOidInfo = new NodeSnmpOidInfo();
                        CompactProperties compactProperties2 = new CompactProperties();
                        compactProperties = new CompactProperties();
                        Iterator iterator = element.elementIterator();
                        while (iterator.hasNext()) {
                            object2 = (Element)iterator.next();
                            this.a(nodeSnmpOidInfo, (Element)object2, compactProperties2, compactProperties);
                            if (bl3) {
                                if (bl3) continue;
                            }
                            break block8;
                        }
                        if (compactProperties2.size() > 0) {
                            object2 = NodeSnmpOidInfo.getMethod("setOtherProperties");
                            this.a((Method)object2, new Object[]{compactProperties2}, nodeSnmpOidInfo);
                        }
                    }
                    if (compactProperties.size() > 0) {
                        object2 = NodeSnmpOidInfo.getMethod("setOtherOids");
                        this.a((Method)object2, new Object[]{compactProperties}, nodeSnmpOidInfo);
                    }
                    for (int i3 = i2; i3 < n2; ++i3) {
                        string = element.attribute(i3).getName();
                        if (bl3) {
                            String string3;
                            if (!string.equals("description") || (string3 = element.attribute(i3).getValue()) == null) continue;
                            nodeSnmpOidInfo.setDescriptionCondition(string3);
                            if (bl3) continue;
                        }
                        break block9;
                    }
                    string = string2;
                }
                NodeSnmpOidInfo.addToMap(string, nodeSnmpOidInfo, bl2);
                if (bl3) break;
                if (bl3) continue;
            }
        }
    }

    private void a(NodeSnmpOidInfo nodeSnmpOidInfo, Element element, CompactProperties compactProperties, CompactProperties compactProperties2) {
        block20: {
            String string;
            Method method;
            block22: {
                Class<?>[] classArray;
                boolean bl2;
                block21: {
                    block17: {
                        block19: {
                            Object[] objectArray;
                            block18: {
                                block16: {
                                    method = NodeSnmpOidInfo.getMethod("set" + element.getName());
                                    bl2 = DiscoveryOptions.c();
                                    if (method != null) break block17;
                                    if (element.getName().endsWith("Oid")) break block18;
                                    objectArray = null;
                                    Object[] objectArray2 = element.elements().toArray();
                                    if (objectArray2 != null && objectArray2.length > 0) {
                                        objectArray = new String[objectArray2.length];
                                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                                            objectArray[i2] = ((Element)objectArray2[i2]).getTextTrim();
                                            if (bl2) {
                                                if (bl2) continue;
                                            }
                                            break block16;
                                        }
                                        compactProperties.put((Comparable)((Object)element.getName()), objectArray);
                                    } else {
                                        compactProperties.put((Comparable)((Object)element.getName()), element.getTextTrim());
                                    }
                                }
                                if (bl2) break block19;
                            }
                            if (element.getName().endsWith("Oid")) {
                                objectArray = this.a(element);
                                compactProperties2.put((Comparable)((Object)element.getName()), objectArray[0]);
                            }
                        }
                        return;
                    }
                    classArray = method.getParameterTypes();
                    if (classArray.length != 1) break block20;
                    string = classArray[0].getName().trim();
                    if (!string.endsWith("SnmpOidAction")) break block21;
                    if (this.a(element) == null) break block20;
                    this.a(method, this.a(element), nodeSnmpOidInfo);
                    if (bl2) break block20;
                }
                if (!string.endsWith("Table")) break block22;
                this.a(method, this.a(element, classArray[0].getName()), nodeSnmpOidInfo);
                if (bl2) break block20;
            }
            if (string.endsWith("String")) {
                this.a(method, new Object[]{element.getTextTrim()}, nodeSnmpOidInfo);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object[] a(Element element) {
        Object object;
        Object object2;
        CompactProperties compactProperties;
        block20: {
            String string;
            String string2;
            boolean bl2;
            Class clazz;
            block22: {
                int n2;
                int n3;
                block19: {
                    block23: {
                        block18: {
                            block17: {
                                clazz = null;
                                bl2 = DiscoveryOptions.d();
                                compactProperties = null;
                                string2 = null;
                                string = element.getTextTrim();
                                if (string == null) return null;
                                try {
                                    if (!string.equals("")) break block17;
                                    return null;
                                    catch (ParseException parseException) {
                                        throw DeviceInfoParse.a(parseException);
                                    }
                                }
                                catch (ParseException parseException) {
                                    throw DeviceInfoParse.a(parseException);
                                }
                            }
                            if (element.attributes().size() >= 1) break block18;
                            clazz = DeviceInfoParse.a("SnmpOidGetAction");
                            break block22;
                        }
                        if (element.attribute(0).getValue().trim().indexOf("getnext") < 0) break block23;
                        clazz = DeviceInfoParse.a("SnmpOidGetNextAction");
                        break block22;
                    }
                    if (element.attribute(0).getValue().trim().indexOf("getsubtree") < 0) break block22;
                    clazz = DeviceInfoParse.a("SnmpOidGetSubtreeAction");
                    n3 = element.attribute(0).getValue().trim().indexOf("(") + 1;
                    if (n3 <= 0) break block22;
                    n2 = element.attribute(0).getValue().trim().indexOf(")");
                    try {
                        if (n2 >= 0 && n2 >= n3) break block19;
                    }
                    catch (ParseException parseException) {
                        throw DeviceInfoParse.a(parseException);
                    }
                    string2 = null;
                    if (!bl2) break block22;
                }
                string2 = element.attribute(0).getValue().trim().substring(n3, n2);
            }
            object2 = this.a(clazz);
            SnmpOidAction snmpOidAction = (SnmpOidAction)object2;
            snmpOidAction.setOid(string);
            this.a(snmpOidAction, element);
            if (string2 != null) {
                try {
                    ((SnmpOidGetSubtreeAction)object2).setIndice(string2);
                }
                catch (ParseException parseException) {
                    _logger.error((Object)parseException);
                }
                string2 = null;
            }
            try {
                if (element.isTextOnly() || element.elements() == null) return new Object[]{object2};
            }
            catch (ParseException parseException) {
                throw DeviceInfoParse.a(parseException);
            }
            Iterator iterator = element.elementIterator("Mapping");
            compactProperties = new CompactProperties();
            while (iterator.hasNext()) {
                block21: {
                    Element element2 = (Element)iterator.next();
                    try {
                        object = element2.attributes();
                        if (bl2) break block20;
                        if (object == null) break block21;
                    }
                    catch (ParseException parseException) {
                        throw DeviceInfoParse.a(parseException);
                    }
                    String string3 = element2.attribute(0).getValue();
                    String string4 = element2.attribute(1).getValue();
                    compactProperties.put((Comparable)((Object)string3), string4);
                }
                if (!bl2) continue;
            }
            object = object2;
        }
        ((SnmpOidAction)object).setMapping(compactProperties);
        return new Object[]{object2};
    }

    private void a(SnmpOidAction snmpOidAction, Element element) {
        block6: {
            String string;
            boolean bl2;
            block5: {
                Element element2 = element.element("ProcessValue");
                boolean bl3 = DiscoveryOptions.d();
                if (element2 == null) {
                    return;
                }
                bl2 = true;
                Attribute attribute = element2.attribute("isVarbindName");
                if (attribute != null) {
                    string = attribute.getValue();
                    boolean bl4 = bl2 = (string = string.toUpperCase()).equals("YES") || string.equals("TRUE");
                }
                if ((string = element.attribute("index")) != null) break block5;
                _logger.error((Object)("index has to be present in ProcessValue node:" + element.getName()));
                if (!bl3) break block6;
            }
            snmpOidAction.setProcessValue(bl2, string.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] a(Element element, String string) {
        Object[] objectArray;
        block18: {
            Object object;
            block17: {
                Class<?> clazz = null;
                boolean bl2 = DiscoveryOptions.c();
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                object = this.a(clazz);
                Method[] methodArray = clazz.getMethods();
                Iterator iterator = element.elementIterator();
                try {
                    if (iterator == null) break block17;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw DeviceInfoParse.a(classNotFoundException);
                }
                block14: while (true) {
                    boolean bl3 = iterator.hasNext();
                    block15: while (bl3) {
                        Element element2 = (Element)iterator.next();
                        try {
                            try {
                                objectArray = methodArray;
                                if (!bl2) break block18;
                                if (objectArray == null) continue block14;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw DeviceInfoParse.a(classNotFoundException);
                            }
                            if (methodArray.length <= 0) continue block14;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw DeviceInfoParse.a(classNotFoundException);
                        }
                        for (int i2 = 0; i2 < methodArray.length; ++i2) {
                            bl3 = methodArray[i2].getName().equalsIgnoreCase("set" + element2.getName());
                            if (!bl2) continue block15;
                            try {
                                try {
                                    try {
                                        if (!bl3 || methodArray[i2].getParameterTypes()[0].getName().indexOf("SnmpOidAction") <= 0) continue;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw DeviceInfoParse.a(classNotFoundException);
                                    }
                                    if (this.a(element2) == null) continue block14;
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw DeviceInfoParse.a(classNotFoundException);
                                }
                                this.a(methodArray[i2], this.a(element2), object);
                                continue;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw DeviceInfoParse.a(classNotFoundException);
                            }
                        }
                        if (bl2) continue block14;
                    }
                    break;
                }
            }
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        }
        return objectArray;
    }

    private void a(Method method, Object[] objectArray, Object object) {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.error((Object)illegalAccessException.toString(), (Throwable)illegalAccessException);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            _logger.error((Object)invocationTargetException.toString(), (Throwable)invocationTargetException);
            return;
        }
    }

    private Object a(Class clazz) {
        Object var2_2 = null;
        try {
            var2_2 = clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.error((Object)illegalAccessException.toString(), (Throwable)illegalAccessException);
            return null;
        }
        catch (InstantiationException instantiationException) {
            _logger.error((Object)instantiationException.toString(), (Throwable)instantiationException);
            return null;
        }
        return var2_2;
    }

    static {
        _map.put("SnmpOidGetAction", SnmpOidGetAction.class);
        _map.put("SnmpOidGetNextAction", SnmpOidGetNextAction.class);
        _map.put("SnmpOidGetSubtreeAction", SnmpOidGetSubtreeAction.class);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

