/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Router;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.DiscoveryUtil;
import com.sysuptime.server.util.ServerConfig;
import java.util.ArrayList;
import java.util.List;

public class AreaWithDevices {
    private String _subnetIP;
    private Subnet _subnet;
    private List _topDevices = new ArrayList();
    private List _subDevices = new ArrayList();

    public AreaWithDevices(String string) {
        this._subnetIP = string;
    }

    public void addDevice(NetworkNodeBean networkNodeBean) {
        block5: {
            block4: {
                boolean bl2 = DiscoveryOptions.c();
                if (!(networkNodeBean instanceof Router) || !((Router)networkNodeBean).isRouting()) break block4;
                this._topDevices.add(networkNodeBean);
                networkNodeBean.addTopoGraph(new GraphID(ServerConfig.getCustomerID(), "customer"));
                if (bl2) break block5;
            }
            this._subDevices.add(networkNodeBean);
        }
        networkNodeBean.addTopoGraph(new GraphID(ServerConfig.getCustomerID(), this._subnetIP));
        if (this.hasSubnet()) {
            Subnet subnet = this.getSubnet();
            subnet.addSubId(networkNodeBean.getID());
        }
    }

    public boolean hasSubnet() {
        return !this._subDevices.isEmpty();
    }

    public Subnet getSubnet() {
        if (this._subnet == null && this.hasSubnet()) {
            this._subnet = new Subnet(this._subnetIP);
            this._subnet.addTopoGraph(new GraphID(ServerConfig.getCustomerID(), "customer"));
        }
        return this._subnet;
    }

    public List getSubDevices() {
        return this._subDevices;
    }

    public List getAllDevices() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._topDevices);
        arrayList.addAll(this._subDevices);
        return arrayList;
    }

    public List getTopDevices() {
        return this._topDevices;
    }

    public List connect() {
        ArrayList<NetworkConnection> arrayList = new ArrayList<NetworkConnection>();
        boolean bl2 = DiscoveryOptions.d();
        if (this.hasSubnet()) {
            Subnet subnet = this.getSubnet();
            int n2 = this._topDevices.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                NetworkNodeBean networkNodeBean = (NetworkNodeBean)this._topDevices.get(i2);
                NetworkConnection networkConnection = DiscoveryUtil.createConnection(networkNodeBean, string = networkNodeBean.getIPInSubnet(this._subnetIP), subnet, this._subnetIP);
                if (networkConnection == null) continue;
                arrayList.add(networkConnection);
                if (!bl2) continue;
            }
        }
        return arrayList;
    }

    public String toString() {
        return this._subnetIP;
    }
}

