/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server;

import com.sysuptime.common.util.schedule.RealSchedule;
import com.sysuptime.server.DailyJob;
import com.sysuptime.server.MonitorJob;
import com.sysuptime.server.performance.MonitorReader;
import com.sysuptime.server.util.MBeanManager;
import java.util.Date;
import java.util.Hashtable;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class Scheduler {
    private static Logger _logger = Logger.getLogger((String)Scheduler.class.getName());
    private static org.quartz.Scheduler _scheduler;
    private static Scheduler _instance;
    private static Hashtable _scheduleIDs;
    private static int _maxID;
    private static int[] a;

    private Scheduler() {
    }

    public static Scheduler getInstance() {
        if (_instance != null) {
            return _instance;
        }
        _instance = new Scheduler();
        int n2 = MonitorReader.getMaxScheduleID();
        if (n2 == 0) {
            n2 += 10;
        }
        _maxID = n2;
        _logger.info((Object)("MaxScheduleID: " + _maxID));
        return _instance;
    }

    public static void start() {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        try {
            _scheduler = stdSchedulerFactory.getScheduler();
            _scheduler.start();
            MBeanManager.getInstance().invoke(new ObjectName("nMaster:service=PMDBSingletonScheduleProvider"), "startProviding", null, null);
            Scheduler.a();
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    public int getNextScheduleID() {
        return this.b();
    }

    private static void a() {
        _logger.info((Object)"To start db clearing schedule");
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("daily").startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(24).repeatForever()).build();
        JobDetail jobDetail = JobBuilder.newJob(DailyJob.class).withIdentity("daily").build();
        try {
            _scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            _logger.error((Object)schedulerException);
        }
    }

    public int addScheduleJob(RealSchedule realSchedule) {
        boolean bl2 = false;
        int n2 = realSchedule.getScheduleId();
        if (n2 <= 0) {
            n2 = this.b();
            bl2 = true;
        }
        String string = String.valueOf(n2);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(string).startAt(new Date(realSchedule.getStartDateTime())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds((int)(realSchedule.getPeriod() / 1000L)).repeatForever()).build();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("monitor", (Object)realSchedule);
        JobDetail jobDetail = JobBuilder.newJob(MonitorJob.class).withIdentity(string).usingJobData(jobDataMap).build();
        try {
            try {
                if (bl2) {
                    realSchedule.setScheduleId(n2);
                }
            }
            catch (SchedulerException schedulerException) {
                throw Scheduler.a(schedulerException);
            }
            _scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException schedulerException) {
            _logger.error((Object)schedulerException);
        }
        return n2;
    }

    public void removeSchedule(int n2) {
        String string = String.valueOf(n2);
        try {
            _scheduler.unscheduleJob(TriggerKey.triggerKey((String)string));
        }
        catch (SchedulerException schedulerException) {
            _logger.error((Object)schedulerException);
        }
    }

    private int b() {
        int n2;
        block2: {
            n2 = _maxID + 1;
            int[] nArray = Scheduler.c();
            while (_scheduleIDs.contains(n2)) {
                n2 = ++_maxID;
                if (nArray != null) {
                    if (nArray != null) continue;
                }
                break block2;
            }
            _maxID = n2;
            _logger.info((Object)("Scheduler.getNextID:" + n2));
        }
        return n2;
    }

    static {
        _scheduleIDs = new Hashtable();
        Scheduler.b(new int[2]);
    }

    public static void b(int[] nArray) {
        a = nArray;
    }

    public static int[] c() {
        return a;
    }

    private static SchedulerException a(SchedulerException schedulerException) {
        return schedulerException;
    }
}

