/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.tree;

import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.ViewGraphModel;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.mainframe.nodes.DeviceTreeNode;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.tree.StructuralTreeManager;
import com.sysuptime.mainframe.tree.TreeManager;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.openide.nodes.Node;

public class ViewTreeManager
extends StructuralTreeManager {
    private ViewGraphModel _model;
    private Map<String, TreeNode> _id2TreeNodeMap = new Hashtable<String, TreeNode>();

    public ViewTreeManager(TreeNode treeNode, ViewGraphModel viewGraphModel) {
        super(treeNode);
        this._model = viewGraphModel;
    }

    @Override
    public void createTree() {
        boolean bl2 = TreeManager.b();
        this._id2TreeNodeMap.clear();
        List list = this._model.getBeans();
        boolean bl3 = bl2;
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DeviceBean deviceBean = (DeviceBean)list.get(i2);
            DeviceNode deviceNode = new DeviceNode(deviceBean);
            DeviceTreeNode deviceTreeNode = new DeviceTreeNode(deviceNode, this._model.getID());
            this._root.getChildren().add(new Node[]{deviceTreeNode});
            this._id2TreeNodeMap.put(deviceBean.getID(), deviceTreeNode);
            if (bl3) continue;
        }
    }

    @Override
    public TreeNode getTreeNode(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        NetworkNodeBean networkNodeBean = networkNode.getBean();
        return this._id2TreeNodeMap.get(networkNodeBean.getID());
    }

    @Override
    public void insert(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        DeviceBean deviceBean = (DeviceBean)networkNode.getBean();
        DeviceTreeNode deviceTreeNode = new DeviceTreeNode(new DeviceNode(deviceBean), networkGraphModel.getID());
        this._id2TreeNodeMap.put(deviceBean.getID(), deviceTreeNode);
        this._root.getChildren().add(new Node[]{deviceTreeNode});
    }

    @Override
    public void remove(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        TreeNode treeNode = this._id2TreeNodeMap.remove(networkNode.getBeanID());
        this._root.getChildren().remove(new Node[]{treeNode});
    }
}

