/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.ireasoning.protocol.snmp.MibUtil;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.alarm.TrapAlarm;
import com.sysuptime.common.trapreceiver.CategoryObject;
import com.sysuptime.common.trapreceiver.EnterpriseObject;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.trapreceiver.MessageUtil;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapIpInfo;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.mainframe.AlarmViewController;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.BooleanRenderer;
import com.sysuptime.mainframe.trapreceiver.EventTree;
import com.sysuptime.mainframe.trapreceiver.FilterFrame;
import com.sysuptime.mainframe.trapreceiver.MailDialog;
import com.sysuptime.mainframe.trapreceiver.RmiHelper;
import com.sysuptime.mainframe.trapreceiver.SeverityCellRenderer;
import com.sysuptime.mainframe.trapreceiver.TimeColumn;
import com.sysuptime.mainframe.trapreceiver.TimePickerDialog;
import com.sysuptime.mainframe.trapreceiver.TrapCallbackClient;
import com.sysuptime.mainframe.trapreceiver.TrapModel;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame$1;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame$2;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame$3;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame$TrapTableMouseListener;
import com.sysuptime.mainframe.trapreceiver.TrapTableSorter;
import com.sysuptime.mainframe.trapreceiver.Util;
import com.sysuptime.mainframe.util.AntiAliasEditorPane;
import com.sysuptime.mainframe.util.ClientConfig;
import com.sysuptime.mainframe.util.FunctionManager;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.PingOrTraceDialog;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.msp.Command;
import com.ultraswing.aR;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TrapReceiverFrame
extends TopComponent
implements ListSelectionListener {
    private static final Logger _logger = Logger.getLogger((String)TrapReceiverFrame.class.getName());
    private static TrapReceiverFrame _instance;
    public static final int MAX_NUM_OF_ROWS = 1500;
    private transient TrapCallbackClient _callbackClient;
    private static int _series;
    private TrapModel _trapModel;
    private JTabbedPane _catalogTabbedPane = new JTabbedPane(3);
    private ArrayList _catalogNames;
    private FilterFrame _filterFrame;
    private JEditorPane _message = new AntiAliasEditorPane();
    private JTable _table;
    private int[] _severity = new int[]{0, 0, 0, 0, 0};
    private JLabel _totalLabel = new JLabel();
    private JLabel _trapReceiverStatusLabel = new JLabel();
    private JLabel[] _numericLabel = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
    private TrapTableSorter _sorter;
    private String _dialogType;
    public static Map _serviceStatusMap;

    public TrapReceiverFrame(String string, JEditorPane jEditorPane) {
        this._message = jEditorPane;
        this._dialogType = string;
        this.a();
    }

    public TrapReceiverFrame() {
        this.a();
        _instance = this;
    }

    private void a() {
        block5: {
            RmiResponse rmiResponse;
            block4: {
                Command[] commandArray = AlarmActionsDialog.A();
                this.setLayout(new BorderLayout());
                Command[] commandArray2 = commandArray;
                rmiResponse = RmiHelper.rmiHelperForTrapReceiverHelper("getAlarmCatalogs", null, null);
                if (!rmiResponse.getValue().equals(Boolean.FALSE)) break block4;
                _logger.error((Object)rmiResponse.getErrorMessage());
                JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage());
                if (commandArray2 == null) break block5;
            }
            this._catalogNames = (ArrayList)rmiResponse.getValue();
        }
        this._trapModel = new TrapModel(this);
        this._filterFrame = new FilterFrame(this);
        this._message.setEditable(false);
        this.b();
        if (this.isOnUI()) {
            this.connect();
        }
    }

    public boolean isOnUI() {
        return Boolean.toString(true).equals(ClientConfig.getProperty("trapReceiverOpened"));
    }

    private void a(boolean bl2) {
        ClientConfig.setProperty("trapReceiverOpened", Boolean.toString(bl2));
    }

    /*
     * Unable to fully structure code
     */
    public boolean connect() {
        block9: {
            var1_1 = AlarmActionsDialog.A();
            if (this._callbackClient != null) break block9;
            try {
                if (this._dialogType == null) ** GOTO lbl12
                try {
                    block10: {
                        this._callbackClient = new TrapCallbackClient(this, this._dialogType);
                        if (var1_1 == null) break block9;
                        break block10;
                        catch (Exception v0) {
                            throw TrapReceiverFrame.a(v0);
                        }
                    }
                    this._callbackClient = new TrapCallbackClient(this);
                }
                catch (Exception v1) {
                    throw TrapReceiverFrame.a(v1);
                }
            }
            catch (Exception var2_2) {
                TrapReceiverFrame._logger.error((Object)"connect", (Throwable)var2_2);
                return false;
            }
        }
        try {
            if (!this._callbackClient.isConnected()) {
                this._callbackClient.connectToAllServers(TrapCallbackClient.OBJECT_NAME, JNDIClient.getAllRMIAdaptors());
            }
        }
        catch (Exception v2) {
            throw TrapReceiverFrame.a(v2);
        }
        return true;
    }

    public void disconnect() {
        this._callbackClient.disconnectFromServers();
    }

    public boolean isConnected() {
        return this._callbackClient != null && this._callbackClient.isConnected();
    }

    public static synchronized TrapReceiverFrame getInstance() {
        if (_instance == null) {
            try {
                TopComponent topComponent = WindowManager.getDefault().findTopComponent("TRAPRECEIVERFRAME");
                try {
                    if (topComponent != null) {
                        _instance = (TrapReceiverFrame)topComponent;
                    }
                }
                catch (Exception exception) {
                    throw TrapReceiverFrame.a(exception);
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"findTopComponent", (Throwable)exception);
            }
        }
        try {
            if (_instance == null) {
                _instance = new TrapReceiverFrame();
            }
        }
        catch (Exception exception) {
            throw TrapReceiverFrame.a(exception);
        }
        return _instance;
    }

    public int getPersistenceType() {
        return 1;
    }

    protected String preferredID() {
        return "TRAPRECEIVERFRAME";
    }

    public void open() {
        super.open();
        this.setDisplayName(NbBundle.getMessage(TrapReceiverFrame.class, (String)"AlarmBrowser_title"));
        FunctionManager.getInstance().manageSelectionTrapMenu(true, this._table.getSelectedRowCount());
        this.a(true);
    }

    protected void componentClosed() {
        FunctionManager.getInstance().manageSelectionTrapMenu(false, this._table.getSelectedRowCount());
        this.a(false);
    }

    private void b() {
        this.add(this.c(), "Center");
        this.add(this.g(), "South");
    }

    private JComponent c() {
        aR aR2 = new aR(false);
        aR2.setPreferredSize(new Dimension(900, 600));
        aR2.setDividerSize(5);
        this.d();
        this.e();
        aR2.addFirst(this.f(), 6.0f);
        aR2.addLast(new JScrollPane(this._message), 4.0f);
        return aR2;
    }

    private void d() {
        this._sorter = new TrapTableSorter(this._trapModel);
        int n2 = 4;
        if (Startup.isMspEdition()) {
            n2 = 5;
        }
        this._sorter.setSortingStatus(n2, -1);
        this._table = SwingUtil.createJTable(this._sorter);
        this.initTable(this._table);
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        this._table.setShowGrid(false);
        this._table.addMouseListener(new TrapReceiverFrame$TrapTableMouseListener(this));
    }

    public void initTable(JTable jTable) {
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        jTable.setDefaultRenderer(String.class, new SeverityCellRenderer());
        jTable.setDefaultRenderer(TimeColumn.class, new SeverityCellRenderer());
        jTable.setRowHeight(25);
        jTable.setSelectionMode(2);
    }

    public void initTableColumn(JTable jTable) {
        block3: {
            block2: {
                Command[] commandArray = AlarmActionsDialog.A();
                jTable.getColumnModel().getColumn(0).setPreferredWidth(40);
                jTable.getColumnModel().getColumn(1).setPreferredWidth(40);
                Command[] commandArray2 = commandArray;
                jTable.getColumnModel().getColumn(2).setPreferredWidth(80);
                jTable.getColumnModel().getColumn(3).setPreferredWidth(100);
                if (!Startup.isMspEdition()) break block2;
                jTable.getColumnModel().getColumn(4).setPreferredWidth(100);
                jTable.getColumnModel().getColumn(5).setPreferredWidth(170);
                jTable.getColumnModel().getColumn(6).setPreferredWidth(420);
                if (commandArray2 == null) break block3;
            }
            jTable.getColumnModel().getColumn(4).setPreferredWidth(170);
            jTable.getColumnModel().getColumn(5).setPreferredWidth(520);
        }
    }

    private void e() {
        this._message.setContentType("text/html");
        this._message.setPreferredSize(new Dimension(850, 200));
        this._message.setMinimumSize(new Dimension(850, 0));
    }

    private JComponent f() {
        Command[] commandArray = AlarmActionsDialog.A();
        this._catalogTabbedPane.addTab(NbBundle.getMessage(TrapReceiverFrame.class, (String)"TABBEDPANE_catalog_alarm_all"), this.createCatalogTabbedPanel(0));
        Command[] commandArray2 = commandArray;
        if (this._catalogNames != null) {
            for (Object e10 : this._catalogNames) {
                CategoryObject categoryObject = (CategoryObject)e10;
                String string = categoryObject.getCategoryName();
                this._catalogTabbedPane.addTab(string, null);
                if (commandArray2 == null) {
                    if (commandArray2 == null) continue;
                }
                break;
            }
        } else {
            this._catalogTabbedPane.addChangeListener(new TrapReceiverFrame$1(this));
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.setMinimumSize(new Dimension(900, 0));
        jPanel.setPreferredSize(new Dimension(900, 400));
        jPanel.add(this._catalogTabbedPane);
        return jPanel;
    }

    public void addCategoryTab(String string) {
        this._catalogTabbedPane.addTab(string, null);
    }

    public void modifyCategoryTabName(String string, String string2) {
        int n2 = this._catalogTabbedPane.indexOfTab(string);
        this._catalogTabbedPane.setTitleAt(n2, string2);
    }

    public void deleteCategoryTab(String string) {
        int n2 = this._catalogTabbedPane.indexOfTab(string);
        this._catalogTabbedPane.removeTabAt(n2);
    }

    public JPanel createCatalogTabbedPanel(Integer n2) {
        Serializable serializable;
        int n3 = n2;
        FunctionManager.getInstance().manageTrapTableRelatedMenu(false);
        this._trapModel.setCatalogId(n2);
        Command[] commandArray = AlarmActionsDialog.A();
        this._trapModel.getAllTrapObjects().clear();
        this.h();
        Command[] commandArray2 = commandArray;
        for (Object e10 : this._trapModel.getAllTraps()) {
            block7: {
                int n4;
                TrapEventObject trapEventObject;
                block6: {
                    serializable = (TrapObject)e10;
                    if (n3 != 0) break block6;
                    this.filter((TrapObject)serializable);
                    if (commandArray2 == null) break block7;
                }
                if ((trapEventObject = ((TrapObject)serializable).getEvent()) != null && n3 == (n4 = trapEventObject.getCategoryId())) {
                    this.filter((TrapObject)serializable);
                }
            }
            if (commandArray2 == null) continue;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._sorter = new TrapTableSorter(this._trapModel);
        int n5 = 4;
        if (Startup.isMspEdition()) {
            n5 = 5;
        }
        this._sorter.setSortingStatus(n5, -1);
        this._sorter.setTableHeader(this._table.getTableHeader());
        this._table.setModel(this._sorter);
        this.initTableColumn(this._table);
        serializable = new JScrollPane(this._table);
        ((JComponent)serializable).setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)serializable, "Center");
        this.setSeverityNumicalLabel();
        return jPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        block7: {
            ListSelectionModel listSelectionModel;
            block6: {
                Command[] commandArray = AlarmActionsDialog.A();
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) break block6;
                FunctionManager.getInstance().manageSelectionTrapMenu(true, this._table.getSelectedRowCount());
                if (commandArray == null) break block7;
            }
            if (this._table.getSelectedRowCount() > 1) {
                FunctionManager.getInstance().manageSelectionTrapMenu(true, this._table.getSelectedRowCount());
                this.a(null, this._message);
            }
            if (this._table.getSelectedRowCount() == 1) {
                FunctionManager.getInstance().manageSelectionTrapMenu(true, this._table.getSelectedRowCount());
                int n2 = listSelectionModel.getMinSelectionIndex();
                int n3 = this._sorter.modelIndex(n2);
                TrapObject trapObject = (TrapObject)this._trapModel.getAllTrapObjects().get(n3);
                this.a(trapObject, this._message);
            }
        }
    }

    public void updateFilter(String string) {
        this._filterFrame.updateFilter(string);
    }

    public void addTraps(TrapObject trapObject, boolean bl2) {
        trapObject.setSeries(_series);
        ++_series;
        Util.setPerformanceText(trapObject);
        if (this._trapModel.getRowCount() >= 1500) {
            SwingUtilities.invokeLater(new TrapReceiverFrame$2(this));
        }
        SwingUtilities.invokeLater(new TrapReceiverFrame$3(this, trapObject, bl2));
    }

    private JPanel g() {
        PanelBuilder panelBuilder;
        block2: {
            FormLayout formLayout = new FormLayout("FILL:10PX:NONE,FILL:50PX:NONE,FILL:10DLU:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:30PX:NONE,FILL:DEFAULT:NONE,FILL:10PX:NONE", "CENTER:DEFAULT:NONE,FILL:17PX:NONE");
            Command[] commandArray = AlarmActionsDialog.A();
            panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)new JLabel(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_catalog_total") + ":"), cellConstraints.xy(2, 2));
            this._totalLabel.setText(String.valueOf(this._severity[0] + this._severity[1] + this._severity[2] + this._severity[3] + this._severity[4]));
            panelBuilder.add((Component)this._totalLabel, cellConstraints.xy(4, 2));
            for (int i2 = 0; i2 < this._numericLabel.length; ++i2) {
                this._numericLabel[i2].setText(String.valueOf(this._severity[i2]));
                panelBuilder.addLabel(ITrapConstants.SEVERITY_STRINGS[i2] + ":", cellConstraints.xy(22 - 4 * i2, 2));
                panelBuilder.add((Component)this._numericLabel[i2], cellConstraints.xy(24 - 4 * i2, 2));
                if (commandArray == null) {
                    if (commandArray == null) continue;
                }
                break block2;
            }
            panelBuilder.addLabel(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_numeric_label") + ":", cellConstraints.xy(26, 2));
            this.setTrapReceiverStatus();
            panelBuilder.add((Component)this._trapReceiverStatusLabel, cellConstraints.xy(28, 2));
        }
        return panelBuilder.getPanel();
    }

    public void setEvent() {
        block12: {
            Command[] commandArray = AlarmActionsDialog.A();
            try {
                Object object;
                String string;
                EventTree eventTree;
                block14: {
                    int n2;
                    EnterpriseObject enterpriseObject;
                    TrapEventObject trapEventObject;
                    block13: {
                        RmiResponse rmiResponse;
                        block11: {
                            rmiResponse = ClientProxy.getInstance().getEnterprises();
                            try {
                                if (!rmiResponse.getValue().equals(Boolean.FALSE)) break block11;
                                _logger.error((Object)rmiResponse.getErrorMessage());
                                JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage());
                                if (commandArray == null) break block12;
                            }
                            catch (Exception exception) {
                                throw TrapReceiverFrame.a(exception);
                            }
                        }
                        ArrayList arrayList = (ArrayList)rmiResponse.getValue();
                        eventTree = new EventTree(arrayList);
                        TrapObject trapObject = this.i();
                        string = trapObject.getTrapOid();
                        int n3 = 0;
                        trapEventObject = null;
                        enterpriseObject = null;
                        object = arrayList.iterator();
                        block8: while (true) {
                            boolean bl2 = object.hasNext();
                            block9: while (bl2) {
                                Object e10 = object.next();
                                enterpriseObject = (EnterpriseObject)e10;
                                Object[] objectArray = enterpriseObject.getEvents();
                                n2 = 0;
                                if (commandArray != null) break block13;
                                for (int i2 = v971275; i2 < objectArray.length; ++i2) {
                                    trapEventObject = (TrapEventObject)objectArray[i2];
                                    bl2 = string.equals(trapEventObject.getEventOid());
                                    if (commandArray != null) continue block9;
                                    if (!bl2) continue;
                                    n3 = 1;
                                    try {
                                        if (commandArray == null) break block8;
                                        if (commandArray == null) continue;
                                        continue block8;
                                    }
                                    catch (Exception exception) {
                                        throw TrapReceiverFrame.a(exception);
                                    }
                                }
                                if (commandArray == null) continue block8;
                            }
                            break;
                        }
                        n2 = n3;
                    }
                    try {
                        if (n2 == 0) break block14;
                        EventTree.doModifyEvent(enterpriseObject, trapEventObject, eventTree);
                        if (commandArray == null) break block12;
                    }
                    catch (Exception exception) {
                        throw TrapReceiverFrame.a(exception);
                    }
                }
                object = MibUtil.translateOID(string, false);
                EventTree.doAddEvent(null, eventTree, (String)object, string);
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
            }
        }
    }

    public void createFilterFrame() {
        this._filterFrame.showFilterFrame();
        SwingUtil.centerOnFrame(Startup.getFrame(), this._filterFrame);
        this._filterFrame.setVisible(true);
        this.a(null, this._message);
    }

    public void computeSeverityNumber(int n2, boolean bl2) {
        block3: {
            block2: {
                Command[] commandArray = AlarmActionsDialog.A();
                if (!bl2) break block2;
                int n3 = n2;
                this._severity[n3] = this._severity[n3] + 1;
                if (commandArray == null) break block3;
            }
            int n4 = n2;
            this._severity[n4] = this._severity[n4] - 1;
        }
    }

    public void setSeverityNumicalLabel() {
        block2: {
            Command[] commandArray = AlarmActionsDialog.A();
            this._totalLabel.setText(String.valueOf(this._severity[0] + this._severity[1] + this._severity[2] + this._severity[3] + this._severity[4]));
            Command[] commandArray2 = commandArray;
            for (int i2 = 0; i2 < this._numericLabel.length; ++i2) {
                this._numericLabel[i2].setText(String.valueOf(this._severity[i2]));
                if (commandArray2 == null) {
                    if (commandArray2 == null) continue;
                }
                break block2;
            }
            this.setTrapReceiverStatus();
        }
    }

    public void setTrapReceiverStatus() {
        Command[] commandArray = AlarmActionsDialog.A();
        if (_serviceStatusMap.size() == 0) {
            block5: {
                RmiResponse[] rmiResponseArray = RmiHelper.rmiHelperForAllTrapReceiverConfig("trapReceiverStatus", null, null);
                if (rmiResponseArray == null) {
                    return;
                }
                for (int i2 = 0; i2 < rmiResponseArray.length; ++i2) {
                    if (commandArray == null) {
                        if (rmiResponseArray[i2] == null || !rmiResponseArray[i2].getValue().equals(Boolean.TRUE)) continue;
                        this._trapReceiverStatusLabel.setText(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_trapreceiver_start"));
                        return;
                    }
                    break block5;
                }
                this._trapReceiverStatusLabel.setText(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_trapreceiver_stop"));
            }
            return;
        }
        if (!_serviceStatusMap.containsValue(true) && _serviceStatusMap.containsValue(Boolean.FALSE)) {
            this._trapReceiverStatusLabel.setText(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_trapreceiver_stop"));
            return;
        }
        this._trapReceiverStatusLabel.setText(NbBundle.getMessage(TrapReceiverFrame.class, (String)"LABEL_trapreceiver_start"));
    }

    private void h() {
        this._severity = new int[]{0, 0, 0, 0, 0};
    }

    public void filter(TrapObject trapObject) {
        if (this.filtered(trapObject)) {
            return;
        }
        this._trapModel.addNewTrapObject(trapObject);
        this.computeSeverityNumber(trapObject.getSeverity(), true);
    }

    public boolean filtered(TrapObject trapObject) {
        String string;
        String[] stringArray;
        int n2;
        short s2 = trapObject.getSeverity();
        String string2 = trapObject.getIpAddress();
        String string3 = trapObject.getMessage();
        Boolean bl2 = trapObject.getAcked();
        Boolean bl3 = trapObject.getClearing();
        long l2 = trapObject.getOccurTime();
        if (this._filterFrame.getFilter() == null) {
            this._filterFrame.initFilterData();
        }
        if (this._filterFrame.getSeverityList().contains(s2)) {
            return true;
        }
        if (!this._filterFrame.getSourceList().isEmpty() && !this._filterFrame.getSourceList().contains(string2)) {
            return true;
        }
        String string4 = this._filterFrame.getkeywordInMessage();
        if (string4 != null && string4.trim().length() > 0 && (n2 = (stringArray = string3.toUpperCase()).indexOf(string = string4.toUpperCase())) < 0) {
            return true;
        }
        if (!(this._filterFrame.getAcknowledgement().equals("all") || this._filterFrame.getAcknowledgement().equals("ac") && bl2.booleanValue() || this._filterFrame.getAcknowledgement().equals("unAc") && !bl2.booleanValue())) {
            return true;
        }
        if (!(this._filterFrame.getClear().equals("all") || this._filterFrame.getClear().equals("ac") && bl3.booleanValue() || this._filterFrame.getClear().equals("unAc") && !bl3.booleanValue())) {
            return true;
        }
        stringArray = this._filterFrame.TIME_CONDITIONS;
        int n3 = this._filterFrame.getTimeCondition();
        return !stringArray[n3].equals(this._filterFrame.TIME_CONDITION_ALL) && (stringArray[n3].equals(this._filterFrame.TIME_CONDITION_AFTER) ? l2 <= this._filterFrame.getDateInLong() : (stringArray[n3].equals(this._filterFrame.TIME_CONDITION_BEFORE) ? l2 >= this._filterFrame.getDateInLong() : (stringArray[n3].equals(this._filterFrame.TIME_CONDITION_ONORAFTER) ? l2 < this._filterFrame.getDateInLong() : (stringArray[n3].equals(this._filterFrame.TIME_CONDITION_ONORBEFORE) ? l2 > this._filterFrame.getDateInLong() : (stringArray[n3].equals(this._filterFrame.TIME_CONDITION_ON) ? l2 != this._filterFrame.getDateInLong() : stringArray[n3].equals(this._filterFrame.TIME_CONDITION_NOTON) && l2 == this._filterFrame.getDateInLong())))));
    }

    public void changeSeverity() {
        Command[] commandArray = AlarmActionsDialog.A();
        try {
            short s2;
            short s3;
            short s4;
            TrapObject trapObject;
            block13: {
                trapObject = this.i();
                if (trapObject == null) {
                    return;
                }
                s4 = 0;
                String string = (String)JOptionPane.showInputDialog((Component)((Object)this), NbBundle.getMessage(TrapReceiverFrame.class, (String)"MESSAGE_catalog_severity_dialog"), NbBundle.getMessage(TrapReceiverFrame.class, (String)"DIALOG_catalog_severity_dialog"), -1, null, ITrapConstants.SEVERITY_STRINGS, null);
                if (string == null) {
                    return;
                }
                for (s3 = 0; s3 < ITrapConstants.SEVERITY_STRINGS.length; ++s3) {
                    try {
                        s2 = ITrapConstants.SEVERITY_STRINGS[s3].equals(string);
                        if (commandArray != null) break block13;
                        if (s2 == 0) continue;
                    }
                    catch (Exception exception) {
                        throw TrapReceiverFrame.a(exception);
                    }
                    s4 = s3;
                    try {
                        if (commandArray == null) break;
                        if (commandArray == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        throw TrapReceiverFrame.a(exception);
                    }
                }
                s3 = trapObject.getSeverity();
                s2 = s4;
            }
            if (s2 == s3) {
                return;
            }
            RmiResponse rmiResponse = ClientProxy.getInstance().setSeverityInTrap(trapObject, new Short(s4));
            try {
                if (Boolean.FALSE.equals(rmiResponse.getValue())) {
                    _logger.error((Object)rmiResponse.getErrorMessage());
                    JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage());
                }
            }
            catch (Exception exception) {
                throw TrapReceiverFrame.a(exception);
            }
            this.repaint();
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public void hideTrap() {
        int[] nArray = this._table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        this._sorter.removeRows(nArray);
        this.setSeverityNumicalLabel();
        this.a(null, this._message);
        FunctionManager.getInstance().manageSelectionTrapMenu(true, -1);
    }

    private void a(TrapObject trapObject) {
        String string = trapObject.getTrapIpInfo().getIp();
        if (trapObject.getBeanId() != null) {
            String string2 = trapObject.getBeanId();
            TrapAlarm trapAlarm = new TrapAlarm(String.valueOf(trapObject.getProbeID()), trapObject.getTrapId(), string2, string, System.currentTimeMillis());
            AlarmViewController.INSTANCE.removeTrapAlarm(trapAlarm);
            ConsoleComponent.getInstance().updateStatus();
        }
    }

    public void deleteTrap() {
        block11: {
            Command[] commandArray = AlarmActionsDialog.A();
            try {
                int[] nArray = this._table.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                Object[] objectArray = new String[]{ICommonBundle.YES, ICommonBundle.NO};
                int n2 = JOptionPane.showOptionDialog((Component)((Object)this), NbBundle.getMessage(TrapReceiverFrame.class, (String)"Trap_message_delete_traps"), "", 0, 2, null, objectArray, objectArray[0]);
                if (n2 != 0) {
                    return;
                }
                ArrayList<TrapObject> arrayList = new ArrayList<TrapObject>();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    int n3 = this._sorter.modelIndex(nArray[i2]);
                    TrapObject trapObject = (TrapObject)this._trapModel.getAllTrapObjects().get(n3);
                    try {
                        arrayList.add(trapObject);
                        if (commandArray == null) {
                            if (commandArray == null) continue;
                            break;
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        throw TrapReceiverFrame.a(exception);
                    }
                }
                RmiResponse rmiResponse = ClientProxy.getInstance().removeTraps(arrayList);
                try {
                    if (Boolean.FALSE.equals(rmiResponse.getValue())) {
                        _logger.error((Object)rmiResponse.getErrorMessage());
                        JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage());
                    }
                }
                catch (Exception exception) {
                    throw TrapReceiverFrame.a(exception);
                }
                this.a(null, this._message);
                FunctionManager.getInstance().manageSelectionTrapMenu(true, -1);
            }
            catch (Exception exception) {
                _logger.error((Object)"", (Throwable)exception);
            }
        }
    }

    public void removeTrapsFromModel(List list) {
        block2: {
            Command[] commandArray = AlarmActionsDialog.A();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TrapObject trapObject = (TrapObject)list.get(i2);
                this._trapModel.removeTrapObject(trapObject, true);
                if (commandArray == null) {
                    TrapIpInfo trapIpInfo;
                    if (trapObject.getClearing().booleanValue() || trapObject.getTrapIpInfo().isClear() || (trapIpInfo = trapObject.getTrapIpInfo()) == null || trapIpInfo.isClear()) continue;
                    this.a(trapObject);
                    if (commandArray == null) continue;
                }
                break block2;
            }
            this.setSeverityNumicalLabel();
        }
    }

    public void hideAll() {
        int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), NbBundle.getMessage(TrapReceiverFrame.class, (String)"MSG_delete_all"), ICommonBundle.CONFIRM, 0);
        if (n2 == 0) {
            this._trapModel.removeAllTrapObjects();
            this.h();
            this.setSeverityNumicalLabel();
            this.a(null, this._message);
            FunctionManager.getInstance().manageSelectionTrapMenu(true, -1);
        }
    }

    public void resetFilters() {
        this._filterFrame.clearFilter();
        int n2 = this._catalogTabbedPane.getSelectedIndex();
        this._catalogTabbedPane.setComponentAt(n2, this.createCatalogTabbedPanel(n2));
        this._catalogTabbedPane.repaint();
        this.a(null, this._message);
    }

    public void ping() {
        TrapObject trapObject = this.i();
        if (trapObject == null) {
            return;
        }
        PingOrTraceDialog pingOrTraceDialog = new PingOrTraceDialog(Startup.getFrame(), "Ping", Startup.getGlobalCallbackClient(), trapObject.getProbeID());
        pingOrTraceDialog.setSize(400, 300);
        SwingUtil.centerOnFrame(Startup.getFrame(), pingOrTraceDialog);
        pingOrTraceDialog.setVisible(true);
        pingOrTraceDialog.setAddress(trapObject.getIpAddress());
        pingOrTraceDialog.perform();
    }

    public void traceRoute() {
        TrapObject trapObject = this.i();
        if (trapObject == null) {
            return;
        }
        PingOrTraceDialog pingOrTraceDialog = new PingOrTraceDialog(Startup.getFrame(), "Trace Route", Startup.getGlobalCallbackClient(), trapObject.getProbeID());
        pingOrTraceDialog.setSize(400, 300);
        SwingUtil.centerOnFrame(Startup.getFrame(), pingOrTraceDialog);
        pingOrTraceDialog.setVisible(true);
        pingOrTraceDialog.setAddress(trapObject.getIpAddress());
        pingOrTraceDialog.perform();
    }

    public void clearSelectedTraps() {
        block6: {
            int[] nArray;
            block5: {
                nArray = this._table.getSelectedRows();
                Command[] commandArray = AlarmActionsDialog.A();
                if (nArray.length != 1) break block5;
                int n2 = this._sorter.modelIndex(nArray[0]);
                Boolean bl2 = (Boolean)this._trapModel.getValueAt(n2, 1);
                if (bl2.equals(Boolean.FALSE)) {
                    this._trapModel.setValueAt(Boolean.TRUE, n2, 1);
                }
                if (commandArray == null) break block6;
            }
            if (nArray.length > 1) {
                this._trapModel.setRowsClear(this._sorter, nArray, 1);
            }
        }
    }

    public void sendMail() {
        try {
            RmiResponse rmiResponse = ClientProxy.getInstance().isSmtpServerConfigured();
            if (Boolean.FALSE.equals(rmiResponse.getValue())) {
                JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage(), NbBundle.getMessage(MailDialog.class, (String)"TITLE_error_information"), 0);
                return;
            }
            TrapObject trapObject = this.i();
            if (trapObject == null) {
                return;
            }
            String string = ICommonBundle.SEVERITY_COLON + ITrapConstants.SEVERITY_STRINGS[trapObject.getSeverity()] + ". ";
            string = string + TrapModel.getMessage(trapObject);
            MailDialog mailDialog = new MailDialog(Startup.getFrame(), true, MessageUtil.getMessageInHtml(trapObject, Startup.isMspEdition()), string);
            mailDialog.pack();
            SwingUtil.centerOnFrame(Startup.getFrame(), mailDialog);
            mailDialog.setVisible(true);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public void showHistoricalTraps() {
        TimePickerDialog timePickerDialog = new TimePickerDialog(Startup.getFrame(), true, NbBundle.getMessage(TrapReceiverFrame.class, (String)"TITLE_catalog_table_tick_time"));
        timePickerDialog.setSize(500, 300);
        SwingUtil.centerOnFrame(Startup.getFrame(), timePickerDialog);
        timePickerDialog.setVisible(true);
        if (timePickerDialog.getFlag()) {
            Cursor cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            this._trapModel.removeAllTrapObjects();
            SwingUtilities.invokeLater(() -> {
                block7: {
                    Command[] commandArray = AlarmActionsDialog.A();
                    try {
                        Object[] objectArray = new Object[]{false, null, null, null, timePickerDialog.getFrom(), timePickerDialog.getTo(), new Integer(1500)};
                        String[] stringArray = new String[]{"java.lang.Boolean", String[].class.getName(), "java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Long", "java.lang.Integer"};
                        RmiResponse rmiResponse = RmiHelper.rmiHelperForTrapReceiverHelper("getTraps", objectArray, stringArray);
                        if (rmiResponse.getValue().equals(Boolean.FALSE)) {
                            _logger.error((Object)rmiResponse.getErrorMessage());
                            JOptionPane.showMessageDialog((Component)((Object)this), rmiResponse.getErrorMessage());
                            return;
                        }
                        ArrayList arrayList = (ArrayList)rmiResponse.getValue();
                        for (Object e10 : arrayList) {
                            TrapObject trapObject = (TrapObject)e10;
                            this.addTraps(trapObject, false);
                            if (commandArray == null) {
                                if (commandArray == null) continue;
                            }
                            break block7;
                        }
                        this._trapModel.fireTableDataChanged();
                    }
                    finally {
                        this.setCursor(cursor);
                    }
                }
            });
        }
    }

    public JTabbedPane getCatalogTabbedPane() {
        return this._catalogTabbedPane;
    }

    TrapObject i() {
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        int n2 = listSelectionModel.getMinSelectionIndex();
        if (n2 < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(TrapReceiverFrame.class, (String)"MESSAGE_select_a_trap"), NbBundle.getMessage(TrapReceiverFrame.class, (String)"TITLE_select_a_trap"), 2);
            return null;
        }
        return this._sorter.getTrap(n2);
    }

    public TrapModel getModel() {
        return this._trapModel;
    }

    public TrapTableSorter getTableSorter() {
        return this._sorter;
    }

    public JTable getTrapTable() {
        return this._table;
    }

    void a(TrapObject trapObject, JEditorPane jEditorPane) {
        boolean bl2;
        boolean bl3 = bl2 = trapObject != null && this.filtered(trapObject);
        if (jEditorPane != null) {
            jEditorPane.setText(MessageUtil.getMessageInHtml(bl2 ? null : trapObject, Startup.isMspEdition()));
            jEditorPane.setCaretPosition(0);
        }
        if (bl2) {
            this._trapModel.removeTrapObject(trapObject, true);
        }
    }

    public JEditorPane getMessagePanel() {
        return this._message;
    }

    public void setServiceStatus(String string, Boolean bl2) {
        if (_serviceStatusMap.containsKey(string)) {
            _serviceStatusMap.remove(string);
        }
        _serviceStatusMap.put(string, bl2);
    }

    static {
        _series = 0;
        _serviceStatusMap = new HashMap();
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

