/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.trapreceiver;

import com.sysuptime.common.trapreceiver.ClearInfo;
import com.sysuptime.common.trapreceiver.MessageHelper;
import com.sysuptime.common.trapreceiver.MessageUtil;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.trapreceiver.RmiHelper;
import com.sysuptime.mainframe.trapreceiver.TimeColumn;
import com.sysuptime.mainframe.trapreceiver.TrapReceiverFrame;
import com.sysuptime.mainframe.trapreceiver.TrapTableSorter;
import com.sysuptime.server.msp.Command;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class TrapModel
extends AbstractTableModel {
    private static final Logger _logger = Logger.getLogger((String)TrapModel.class.getName());
    private Vector _receivedTraps = new Vector();
    private Hashtable _trapsID = new Hashtable();
    private Integer _categoryId;
    private static String[] TITLE = new String[]{NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_acknowledgement"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_clear"), ICommonBundle.SEVERITY, NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_source"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_time"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_message")};
    private static Class[] TYPE = new Class[]{Boolean.class, Boolean.class, String.class, String.class, TimeColumn.class, String.class};
    private TrapReceiverFrame _trapreceiverFrame;
    static String _unknownMessageFormat;

    public TrapModel(TrapReceiverFrame trapReceiverFrame) {
        this._trapreceiverFrame = trapReceiverFrame;
    }

    @Override
    public String getColumnName(int n2) {
        return TITLE[n2];
    }

    public Class getColumnClass(int n2) {
        return TYPE[n2];
    }

    @Override
    public int getRowCount() {
        return this._receivedTraps.size();
    }

    @Override
    public int getColumnCount() {
        return TITLE.length;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        block20: {
            TrapObject trapObject;
            block19: {
                trapObject = (TrapObject)this._receivedTraps.get(n2);
                Command[] commandArray = AlarmActionsDialog.A();
                if (!Startup.isMspEdition()) break block19;
                switch (n3) {
                    case 0: {
                        return trapObject.getAcked();
                    }
                    case 1: {
                        return trapObject.getClearing();
                    }
                    case 2: {
                        return trapObject.getSeverityInInteger();
                    }
                    case 3: {
                        return trapObject.getCustomerName();
                    }
                    case 4: {
                        return trapObject.getIpAddress();
                    }
                    case 5: {
                        return new TimeColumn(trapObject.getOccurTime());
                    }
                    case 6: {
                        return TrapModel.getMessage(trapObject);
                    }
                }
                if (commandArray == null) break block20;
            }
            switch (n3) {
                case 0: {
                    return trapObject.getAcked();
                }
                case 1: {
                    return trapObject.getClearing();
                }
                case 2: {
                    return trapObject.getSeverityInInteger();
                }
                case 3: {
                    return trapObject.getIpAddress();
                }
                case 4: {
                    return new TimeColumn(trapObject.getOccurTime());
                }
                case 5: {
                    return TrapModel.getMessage(trapObject);
                }
            }
        }
        return null;
    }

    public static String getMessage(TrapObject trapObject) {
        String string;
        Object object = null;
        TrapEventObject trapEventObject = trapObject.getEvent();
        object = trapEventObject != null ? trapEventObject.getMessage(trapObject) : new MessageHelper(_unknownMessageFormat).toString(trapObject);
        Object object2 = object = object == null ? trapObject.getTrapOid() : object;
        if (trapObject.getVersionNumber().equals("1") && (string = MessageUtil.getSnmpV1TrapName(trapObject)) != null) {
            object = "[" + string + "] " + (String)object;
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return n3 == 0 || n3 == 1;
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        Boolean bl2;
        TrapObject trapObject = (TrapObject)this._receivedTraps.get(n2);
        double d10 = trapObject.getTrapId();
        String string = "";
        String string2 = Startup.getCurrentUserName();
        Timestamp timestamp = null;
        if (n3 == 0) {
            bl2 = (Boolean)object;
            if (bl2.equals(Boolean.TRUE)) {
                string = JOptionPane.showInputDialog((Component)((Object)this._trapreceiverFrame), NbBundle.getMessage(TrapModel.class, (String)"MESSAGE_trap_model_comment"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_trap_model_acknowledgement_comment"), 1);
                if (string == null) {
                    return;
                }
                if (string.length() > 80) {
                    JOptionPane.showMessageDialog((Component)((Object)this._trapreceiverFrame), NbBundle.getMessage(TrapModel.class, (String)"TrapMessage_ackfailed"));
                    return;
                }
                timestamp = new Timestamp(System.currentTimeMillis());
            }
            if (bl2.equals(Boolean.FALSE)) {
                if (!Startup.isUserAdmin() && !string2.equals(trapObject.getAckUser())) {
                    return;
                }
                string2 = null;
            }
            this.b(trapObject.getProbeID(), d10, string, string2, bl2, timestamp);
        }
        if (n3 == 1) {
            bl2 = (Boolean)object;
            string = "";
            timestamp = null;
            if (bl2.booleanValue()) {
                string = JOptionPane.showInputDialog((Component)((Object)this._trapreceiverFrame), NbBundle.getMessage(TrapModel.class, (String)"MESSAGE_trap_model_comment"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_trap_model_clear_comment"), 1);
                if (string == null) {
                    return;
                }
                if (string.length() > 80) {
                    JOptionPane.showMessageDialog((Component)((Object)this._trapreceiverFrame), NbBundle.getMessage(TrapModel.class, (String)"TrapMessage_clearfailed"));
                    return;
                }
                timestamp = new Timestamp(System.currentTimeMillis());
            }
            if (!bl2.booleanValue()) {
                if (!Startup.isUserAdmin() && !string2.equals(trapObject.getAckUser())) {
                    return;
                }
                string2 = null;
            }
            this.a(trapObject.getProbeID(), d10, string, string2, bl2, timestamp);
        }
    }

    public void setRowsClear(TrapTableSorter trapTableSorter, int[] nArray, int n2) {
        String string = "";
        Command[] commandArray = AlarmActionsDialog.A();
        String string2 = Startup.getCurrentUserName();
        Timestamp timestamp = null;
        string = JOptionPane.showInputDialog((Component)((Object)this._trapreceiverFrame), NbBundle.getMessage(TrapModel.class, (String)"MESSAGE_trap_model_comment"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_trap_model_clear_comment"), 1);
        if (string == null) {
            return;
        }
        timestamp = new Timestamp(System.currentTimeMillis());
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = trapTableSorter.modelIndex(nArray[i2]);
            TrapObject trapObject = (TrapObject)this._receivedTraps.get(n3);
            double d10 = trapObject.getTrapId();
            Boolean bl2 = (Boolean)this.getValueAt(n3, 1);
            if (!bl2.equals(Boolean.FALSE)) continue;
            this.a(trapObject.getProbeID(), d10, string, string2, Boolean.TRUE, timestamp);
            if (commandArray == null) continue;
        }
    }

    public void addTrap(TrapObject trapObject) {
        this.addTrap(trapObject, true);
    }

    public void addTrap(TrapObject trapObject, boolean bl2) {
        Double d10 = new Double(trapObject.getTrapId());
        if (this._trapsID.containsKey(d10)) {
            return;
        }
        this._trapsID.put(d10, trapObject);
        TrapEventObject trapEventObject = trapObject.getEvent();
        int n2 = 0;
        if (trapEventObject != null) {
            n2 = trapEventObject.getCategoryId();
        }
        if (this._categoryId == 0 || this._categoryId == n2) {
            this._trapreceiverFrame.filter(trapObject);
            this._trapreceiverFrame.setSeverityNumicalLabel();
        }
        if (bl2) {
            this.fireTableDataChanged();
        }
    }

    public void setCatalogId(Integer n2) {
        this._categoryId = n2;
    }

    public Integer getCatalogId() {
        return this._categoryId;
    }

    public TrapObject getTrapByID(Double d10) {
        return (TrapObject)this._trapsID.get(d10);
    }

    public Vector getAllTrapObjects() {
        return this._receivedTraps;
    }

    public TrapObject getTrapObject(int n2) {
        return (TrapObject)this._receivedTraps.get(n2);
    }

    public synchronized void removeTrapObject(int n2) {
        this.removeTrapObject(n2, true);
    }

    public synchronized void removeTrapObject(TrapObject trapObject, boolean bl2) {
        this._receivedTraps.remove(trapObject);
        if (bl2) {
            this.fireTableDataChanged();
        }
    }

    public synchronized void removeTrapObject(int n2, boolean bl2) {
        TrapObject trapObject = (TrapObject)this._receivedTraps.get(n2);
        double d10 = trapObject.getTrapId();
        this._trapsID.remove(new Double(d10));
        this._receivedTraps.remove(n2);
        short s2 = trapObject.getSeverity();
        this._trapreceiverFrame.computeSeverityNumber(s2, false);
        if (bl2) {
            this.fireTableDataChanged();
        }
    }

    public synchronized void removeTrapObject(Object object, boolean bl2) {
        TrapObject trapObject = (TrapObject)object;
        double d10 = trapObject.getTrapId();
        this._trapsID.remove(new Double(d10));
        this._receivedTraps.remove(object);
        short s2 = trapObject.getSeverity();
        this._trapreceiverFrame.computeSeverityNumber(s2, false);
        if (bl2) {
            this.fireTableDataChanged();
        }
    }

    public synchronized void addNewTrapObject(TrapObject trapObject) {
        this._receivedTraps.add(0, trapObject);
    }

    public synchronized void removeOldestTrapObject() {
        this.removeTrapObject(this._receivedTraps.size() - 1);
    }

    public synchronized void removeTrapObjects(int[] nArray) {
        block5: {
            int n2;
            Command[] commandArray;
            Object[] objectArray;
            block4: {
                int n3 = nArray.length;
                objectArray = new Object[nArray.length];
                commandArray = AlarmActionsDialog.A();
                for (n2 = 0; n2 < n3; ++n2) {
                    objectArray[n2] = this._receivedTraps.get(nArray[n2]);
                    if (commandArray == null) {
                        if (commandArray == null) continue;
                    }
                    break block4;
                }
                n2 = 0;
            }
            while (n2 < objectArray.length) {
                this.removeTrapObject(objectArray[n2], false);
                ++n2;
                if (commandArray == null) {
                    if (commandArray == null) continue;
                }
                break block5;
            }
            this.fireTableDataChanged();
        }
    }

    public synchronized void removeAllTrapObjects() {
        this._receivedTraps.clear();
        this._trapsID.clear();
        this.fireTableDataChanged();
    }

    public Collection getAllTraps() {
        return this._trapsID.values();
    }

    private void a(long l2, double d10, String string, String string2, Boolean bl2, Timestamp timestamp) {
        String string3;
        try {
            string3 = bl2 != false ? "Y" : "N";
        }
        catch (Exception exception) {
            throw TrapModel.a(exception);
        }
        String string4 = string3;
        ClearInfo clearInfo = new ClearInfo();
        clearInfo.setTrapID(d10);
        clearInfo.setComment(string);
        clearInfo.setClearing(string4);
        clearInfo.setProbeID(l2);
        clearInfo.setTime(timestamp);
        clearInfo.setUser(string2);
        RmiResponse rmiResponse = RmiResponse.FALSE;
        try {
            rmiResponse = ClientProxy.getInstance().clear(clearInfo);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        try {
            if (Boolean.FALSE.equals(rmiResponse.getValue())) {
                _logger.error((Object)rmiResponse.getErrorMessage());
            }
        }
        catch (Exception exception) {
            throw TrapModel.a(exception);
        }
    }

    private void b(long l2, double d10, String string, String string2, Boolean bl2, Timestamp timestamp) {
        String string3;
        try {
            string3 = bl2 != false ? "Y" : "N";
        }
        catch (Exception exception) {
            throw TrapModel.a(exception);
        }
        String string4 = string3;
        ClearInfo clearInfo = new ClearInfo();
        clearInfo.setTrapID(d10);
        clearInfo.setComment(string);
        clearInfo.setClearing(string4);
        clearInfo.setProbeID(l2);
        clearInfo.setTime(timestamp);
        clearInfo.setUser(string2);
        RmiResponse rmiResponse = RmiResponse.FALSE;
        try {
            rmiResponse = ClientProxy.getInstance().acknowledge(clearInfo);
        }
        catch (Exception exception) {
            _logger.error((Object)"acknowledge", (Throwable)exception);
        }
        try {
            if (Boolean.FALSE.equals(rmiResponse.getValue())) {
                _logger.error((Object)rmiResponse.getErrorMessage());
            }
        }
        catch (Exception exception) {
            throw TrapModel.a(exception);
        }
    }

    static {
        if (Startup.isMspEdition()) {
            TITLE = new String[]{NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_acknowledgement"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_clear"), ICommonBundle.SEVERITY, NbBundle.getMessage(TrapModel.class, (String)"TITLE_probe"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_source"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_time"), NbBundle.getMessage(TrapModel.class, (String)"TITLE_catalog_table_message")};
            TYPE = new Class[]{Boolean.class, Boolean.class, String.class, String.class, String.class, TimeColumn.class, String.class};
        }
        _unknownMessageFormat = "$oid";
        Properties properties = null;
        RmiResponse rmiResponse = RmiHelper.rmiHelperForTrapReceiverConfig("getConfig", null, null);
        if (rmiResponse.getValue() != null) {
            properties = (Properties)rmiResponse.getValue();
            _unknownMessageFormat = properties.getProperty("unknownTrapsMessage");
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

