/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.performance.TimebucketItem;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.LengthValidator;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonScheduleBroker;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TimebucketFormatter;
import com.sysuptime.mainframe.performance.TimebucketListTableCell;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class TimebucketDialog
extends OperationDialog {
    private static final String[] COLUMNS = new String[]{DialogConstants.LABEL_START_TIME, DialogConstants.LABEL_END_TIME};
    private static final String MESSAGE_DEFAULT_NAME = _bundle.getString("message_defaultname");
    private ReadOnlyTableModel _timebucketModel;
    private int _nonComparedIndex;
    private JTable _timebucketTable;
    private Timebucket _timebucket;
    private String _checkedTimebucketName;
    private JTextField _timebucketName;
    private ReadOnlyTableModel _timebucketListModel;
    private String _lastTimebucketName;
    private int TIMEBUCKET_LENGTH = 50;
    private boolean _isChanged;
    private Map _timebucketNameToObject = MonitorBroker.getTimebucketNameToObject();

    public TimebucketDialog(Dialog dialog, String string, boolean bl2, ReadOnlyTableModel readOnlyTableModel, int n2) {
        super(dialog, string, bl2);
        this.initTimebucket(readOnlyTableModel, n2);
        this.initComponents();
        this.initUserData();
    }

    private void initTimebucket(ReadOnlyTableModel readOnlyTableModel, int n2) {
        this._timebucketListModel = readOnlyTableModel;
        this._nonComparedIndex = n2;
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getOperationPanel(false, false), "East");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("l:p,3dlu,p,3dlu,p:g", "p,5dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(DialogConstants.LABEL_NAME, cellConstraints.xy(1, 1));
        this._timebucketName = new JTextField();
        this._timebucketName.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._timebucketName, cellConstraints.xy(3, 1));
        this._timebucketModel = new ReadOnlyTableModel(null, COLUMNS);
        this._timebucketTable = SwingUtil.createJTable(this._timebucketModel);
        this._timebucketTable.getTableHeader().setReorderingAllowed(false);
        this._timebucketTable.setSelectionMode(0);
        this._timebucketTable.setPreferredScrollableViewportSize(new Dimension(300, 120));
        JScrollPane jScrollPane = new JScrollPane(this._timebucketTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xyw(1, 3, 5));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        this.initTable();
        this.initButtons();
    }

    private void initTable() {
        if (this._nonComparedIndex != -1) {
            String string;
            TimebucketListTableCell timebucketListTableCell = (TimebucketListTableCell)this._timebucketListModel.getValueAt(this._nonComparedIndex, 0);
            Timebucket timebucket = timebucketListTableCell.getTimebucket();
            try {
                this._timebucket = (Timebucket)timebucket.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this._logger.error((Object)cloneNotSupportedException);
            }
            this._lastTimebucketName = string = this._timebucket.getTimebucketName();
            this._timebucketName.setText(string);
            if ("7*24".equalsIgnoreCase(string)) {
                this._timebucketName.setEditable(false);
            }
            int n2 = this._timebucket.getTimebucketItemListSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                TimebucketItem timebucketItem = this._timebucket.getTimebucketItem(i2);
                short s2 = timebucketItem.getStartDayId();
                int n3 = timebucketItem.getStartTime();
                String string2 = this.getFormatedTime(s2, n3);
                short s3 = timebucketItem.getEndDayId();
                int n4 = timebucketItem.getEndTime();
                String string3 = this.getFormatedTime(s3, n4);
                this._timebucketModel.addRow(new String[]{string2, string3});
            }
        } else {
            this._timebucket = TargetFactory.getTimebucket();
        }
    }

    private void initButtons() {
        String string;
        if (this._nonComparedIndex != -1 && (string = (String)this._timebucketListModel.getValueAt(this._nonComparedIndex, 1)).equals(ICommonBundle.YES)) {
            this.getAddButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
            this.getModifyButton().setEnabled(false);
        }
    }

    private String getFormatedTime(int n2, int n3) {
        int n4 = n3 / 3600;
        int n5 = n3 % 3600 / 60;
        String string = DialogConstants.COMBOBOX_DAY[n2 - 1];
        return TimebucketFormatter.getTime(string, n4, n5);
    }

    @Override
    protected void addItem() {
        boolean bl2 = DialogProvider.createTimebucketItemDialog(this, DialogConstants.BUTTON_NEW, this._timebucket, this._timebucketModel, -1);
        if (bl2) {
            this._isChanged = true;
        }
    }

    @Override
    protected void removeItem() {
        int n2 = this._timebucketTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            this.removeRow(n2);
            this._timebucket.removeTimebucketItem(n2);
            this._isChanged = true;
        }
    }

    private void removeRow(int n2) {
        PerformanceUIUtil.removeRow(this._timebucketTable, this._timebucketModel, n2);
    }

    @Override
    protected void modifyItem() {
        boolean bl2;
        int n2 = this._timebucketTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null && (bl2 = DialogProvider.createTimebucketItemDialog(this, DialogConstants.BUTTON_MODIFY, this._timebucket, this._timebucketModel, n2))) {
            this._isChanged = true;
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkTimebucket()) {
            this.setTimebucket();
            this.operateTimebucket();
            this.dispose();
        }
    }

    private boolean checkTimebucket() {
        String string = this._timebucketName.getText();
        if (string.equalsIgnoreCase("default")) {
            JOptionPane.showMessageDialog(this, MESSAGE_DEFAULT_NAME);
            return false;
        }
        this._checkedTimebucketName = (String)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_NAME, string, LengthValidator.CLASS, this.TIMEBUCKET_LENGTH);
        if (this._checkedTimebucketName == null) {
            return false;
        }
        this._checkedTimebucketName = this._checkedTimebucketName.toLowerCase();
        if (this.isNullTable()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_NULL_RECORD);
            return false;
        }
        if (this.isLapped()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_TIMEBUCKET_LAP);
            return false;
        }
        return true;
    }

    private boolean isNullTable() {
        int n2 = this._timebucketTable.getRowCount();
        return n2 == 0;
    }

    private boolean isLapped() {
        TimebucketListTableCell timebucketListTableCell;
        Timebucket timebucket;
        Object object;
        if (this._nonComparedIndex != -1 && this._checkedTimebucketName.equalsIgnoreCase((String)(object = (timebucket = (timebucketListTableCell = (TimebucketListTableCell)this._timebucketListModel.getValueAt(this._nonComparedIndex, 0)).getTimebucket()).getTimebucketName()))) {
            return false;
        }
        if (this._timebucketListModel != null) {
            int n2 = this._timebucketListModel.getRowCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = (TimebucketListTableCell)this._timebucketListModel.getValueAt(i2, 0);
                Timebucket timebucket2 = ((TimebucketListTableCell)object).getTimebucket();
                String string = timebucket2.getTimebucketName();
                if (!this._checkedTimebucketName.equalsIgnoreCase(string)) continue;
                return true;
            }
        } else if (this._timebucketNameToObject.get(this._checkedTimebucketName) != null) {
            return true;
        }
        return false;
    }

    private void setTimebucket() {
        this._timebucket.setTimebucketName(this._checkedTimebucketName);
    }

    public Timebucket getNewTimebucket() {
        return this._timebucket;
    }

    private void operateTimebucket() {
        if (this._timebucketListModel != null) {
            if (this._nonComparedIndex != -1) {
                String string = (String)this._timebucketListModel.getValueAt(this._nonComparedIndex, 1);
                TimebucketListTableCell timebucketListTableCell = (TimebucketListTableCell)this._timebucketListModel.getValueAt(this._nonComparedIndex, 0);
                if (!this._checkedTimebucketName.equals(this._lastTimebucketName)) {
                    this._isChanged = true;
                }
                Object[] objectArray = new Object[]{new TimebucketListTableCell(this._timebucket, timebucketListTableCell.isExisted(), this._isChanged), string};
                int n2 = this._timebucketListModel.getColumnCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this._timebucketListModel.setValueAt(objectArray[i2], this._nonComparedIndex, i2);
                }
            } else {
                Object[] objectArray = new Object[]{new TimebucketListTableCell(this._timebucket, false, false), ICommonBundle.NO};
                this._timebucketListModel.addRow(objectArray);
            }
        } else {
            SingletonScheduleBroker.addTimebucket(this._timebucket);
        }
    }
}

