/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.util.AgentProperties;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.SNMPWizardMonitorUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.MonitorCheckBox;
import com.sysuptime.mainframe.performance.PagesPrintedPane;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public class StatusOfPrinterPane
extends SnmpDevicesMonitorPane {
    private String _status;
    private String[] _statuses = new String[]{StatusOfPrinterPane.fromBundle("Status_of_printer_1"), StatusOfPrinterPane.fromBundle("Status_of_printer_2"), StatusOfPrinterPane.fromBundle("Status_of_printer_3"), StatusOfPrinterPane.fromBundle("Status_of_printer_4"), StatusOfPrinterPane.fromBundle("Status_of_printer_5")};

    public StatusOfPrinterPane(AgentProperties agentProperties) throws Exception {
        this.initComponent(agentProperties);
    }

    public static String doStatusOfPrinterSessionValid(AgentProperties agentProperties) throws Exception {
        SnmpPdu snmpPdu = ClientProxy.getInstance().snmpGetRequest(agentProperties, SNMPWizardMonitorUtil.HR_DEVICE_STATUS_OID);
        if (snmpPdu != null) {
            return snmpPdu.getVarBind(0).getValue().toString();
        }
        return null;
    }

    public void initComponent(AgentProperties agentProperties) throws Exception {
        this._status = StatusOfPrinterPane.doStatusOfPrinterSessionValid(agentProperties);
        if (this._status == null) {
            throw new Exception(NbBundle.getMessage(PagesPrintedPane.class, (String)"MSG_get_data_error"));
        }
        HashMap hashMap = new HashMap();
        this.createComponent(hashMap);
    }

    @Override
    protected JPanel initDevicesPane(Map map) {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = StatusOfPrinterPane.fromBundle("Label_status_of_printer");
        MonitorCheckBox monitorCheckBox = new MonitorCheckBox(1, string);
        monitorCheckBox.setSelected(true);
        JLabel jLabel = new JLabel("       ( " + StatusOfPrinterPane.fromBundle("current_value") + ": " + this._status + " )");
        jPanel.add((Component)monitorCheckBox, "West");
        jPanel.add((Component)jLabel, "Center");
        JPanel jPanel2 = this.createStatusPanel();
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createStatusPanel() {
        FormLayout formLayout = new FormLayout("default,20px,default", "default,15px,default,15px,default,15px,default,15px,default");
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        for (int i2 = 1; i2 <= this._statuses.length; ++i2) {
            jPanel.add((Component)new JLabel(String.valueOf(i2)), cellConstraints.xy(1, i2));
            jPanel.add((Component)new JLabel(this._statuses[i2 - 1]), cellConstraints.xy(3, i2));
        }
        return jPanel;
    }

    @Override
    protected String getTitleBorderText() {
        return StatusOfPrinterPane.fromBundle("Title_printer");
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(StatusOfPrinterPane.class, (String)string);
    }
}

