/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.ScheduledDownTime;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.trapreceiver.CalendarDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ScheduledDownTimeDialog
extends JDialog
implements ActionListener {
    private static final Logger _logger = Logger.getLogger((String)ScheduledDownTimeDialog.class.getName());
    private static final ResourceBundle _bundle = NbBundle.getBundle(ScheduledDownTimeDialog.class);
    private JTextField _fromText = new JTextField();
    private JTextField _toText = new JTextField();
    private JCheckBox _enable = new JCheckBox(_bundle.getString("LABLE_enable_scheduleddown"));
    private JButton _fromBtn;
    private JButton _toBtn;
    private static ScheduledDownTime _scheduledDown = null;

    public ScheduledDownTimeDialog(Frame frame, boolean bl2) {
        super(frame, bl2);
        this.setTitle(_bundle.getString("TITLE_scheduleddown_dialog"));
        this.initData();
        this.initComponent();
    }

    public ScheduledDownTimeDialog(JDialog jDialog, boolean bl2) {
        super((Dialog)jDialog, bl2);
        this.setTitle(_bundle.getString("TITLE_scheduleddown_dialog"));
        this.initData();
        this.initComponent();
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.createPanel(), "Center");
        if (_scheduledDown != null) {
            this._enable.setSelected(_scheduledDown.isEnabled());
            this._fromText.setText(CommonUtil.getDateFormat().format(new Date(_scheduledDown.getStartTime())));
            this._toText.setText(CommonUtil.getDateFormat().format(new Date(_scheduledDown.getEndTime())));
            if (this._enable.isSelected()) {
                this._fromBtn.setEnabled(true);
                this._toBtn.setEnabled(true);
            }
        }
    }

    private void initData() {
        try {
            _scheduledDown = ClientProxy.getInstance().getScheduledDownTime();
        }
        catch (Exception exception) {
            _scheduledDown = new ScheduledDownTime();
            _logger.error((Object)"get schedule down time", (Throwable)exception);
        }
    }

    public JPanel createPanel() {
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:30PX:NONE,FILL:40PX:NONE,FILL:30PX:NONE,FILL:30PX:NONE,FILL:40PX:NONE,FILL:30PX:NONE,FILL:30PX:NONE,FILL:40PX:NONE,FILL:30PX:NONE,FILL:30PX:NONE,FILL:30PX:NONE", "CENTER:20PX:NONE,CENTER:20PX:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE,CENTER:20PX:NONE,CENTER:DEFAULT:NONE,CENTER:20PX:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        jPanel.add((Component)this._enable, cellConstraints.xywh(2, 3, 7, 1));
        this.addAction(this._enable, "enable");
        this._fromBtn = new JButton(SwingUtil.getImage("jdaychoosercolor16.gif"));
        this._toBtn = new JButton(SwingUtil.getImage("jdaychoosercolor16.gif"));
        this._fromBtn.setBorder(BorderFactory.createEtchedBorder(0));
        this._toBtn.setBorder(BorderFactory.createEtchedBorder(0));
        this._fromBtn.setEnabled(false);
        this._toBtn.setEnabled(false);
        this.addAction(this._fromBtn, "from");
        this.addAction(this._toBtn, "to");
        jPanel.add((Component)this._fromBtn, cellConstraints.xy(10, 4));
        jPanel.add((Component)this._toBtn, cellConstraints.xy(10, 5));
        JButton jButton = new JButton(ICommonBundle.CANCEL);
        jPanel.add((Component)jButton, cellConstraints.xywh(7, 8, 2, 1));
        this.addAction(jButton, "cancel");
        JButton jButton2 = new JButton(ICommonBundle.OK);
        jPanel.add((Component)jButton2, cellConstraints.xywh(4, 8, 2, 1));
        this.addAction(jButton2, "ok");
        this._fromText.setEnabled(false);
        this._toText.setEnabled(false);
        jPanel.add((Component)this._fromText, cellConstraints.xywh(3, 4, 7, 1));
        jPanel.add((Component)this._toText, cellConstraints.xywh(3, 5, 7, 1));
        JLabel jLabel = new JLabel(_bundle.getString("TimePeriodDialog_label_from"));
        jPanel.add((Component)jLabel, cellConstraints.xy(2, 4));
        JLabel jLabel2 = new JLabel(_bundle.getString("TimePeriodDialog_label_to"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 5));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        return jPanel;
    }

    private void addAction(AbstractButton abstractButton, String string) {
        abstractButton.addActionListener(this);
        abstractButton.setActionCommand(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("from".equals(string)) {
            CalendarDialog calendarDialog = new CalendarDialog(this, true);
            SwingUtil.centerOnScreen(calendarDialog);
            calendarDialog.setVisible(true);
            if (calendarDialog.getFlag()) {
                this._fromText.setText(CommonUtil.getDateFormat().format(calendarDialog.getDate()));
                _scheduledDown.setStartTime(calendarDialog.getDate().getTime());
            }
        } else if ("to".equals(string)) {
            CalendarDialog calendarDialog = new CalendarDialog(this, true);
            SwingUtil.centerOnScreen(calendarDialog);
            calendarDialog.setVisible(true);
            if (calendarDialog.getFlag()) {
                this._toText.setText(CommonUtil.getDateFormat().format(calendarDialog.getDate()));
                _scheduledDown.setEndTime(calendarDialog.getDate().getTime());
            }
        } else if ("cancel".equals(string)) {
            this.dispose();
        } else if ("ok".equals(string)) {
            this.updateScheduledDownTime();
        } else if ("enable".equals(string)) {
            this._fromBtn.setEnabled(this._enable.isSelected());
            this._toBtn.setEnabled(this._enable.isSelected());
            _scheduledDown.setEnabled(this._enable.isSelected());
        }
    }

    private void updateScheduledDownTime() {
        if (!this.checkData()) {
            return;
        }
        if (!ClientProxy.getInstance().updateScheduledDownTime(_scheduledDown)) {
            JOptionPane.showMessageDialog(this, _bundle.getString("failed_update_scheduled"));
            return;
        }
        this.dispose();
    }

    private boolean checkData() {
        if (_scheduledDown.getStartTime() >= _scheduledDown.getEndTime()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("TIME_start_less_than_end"));
            return false;
        }
        if (_scheduledDown.getEndTime() < System.currentTimeMillis()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("TIME_future_as_scheduled"));
            return false;
        }
        return true;
    }
}

