/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.performance.CalendarDialog;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ResumeTimeDialog
extends ConfirmDialog {
    private static final String TITLE = _bundle.getString("title_issuspended");
    private static final String RESUME_TIME = _bundle.getString("label_resumetime");
    private static final String ENABLE_RUN = _bundle.getString("label_enablerun");
    private static final String MESSAGE_RESUME_TIME = _bundle.getString("message_resumetime");
    private JCheckBox _enableTime;
    private JTextField _resumeTime;
    private long _checkedResumeTime;
    private JButton _importTime;

    public ResumeTimeDialog(JDialog jDialog, boolean bl2) {
        super(jDialog, TITLE, bl2);
        this.initComponents();
    }

    public void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p,3dlu,p", "p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        this._enableTime = new JCheckBox(ENABLE_RUN);
        this._enableTime.addItemListener(new EnableTimeItem());
        panelBuilder.add((Component)this._enableTime, cellConstraints.xyw(1, 1, 5));
        panelBuilder.addLabel(RESUME_TIME, cellConstraints.xy(1, 3));
        this._resumeTime = new JTextField();
        this._resumeTime.setEditable(false);
        this._resumeTime.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._resumeTime, cellConstraints.xy(3, 3));
        ImageIcon imageIcon = SwingUtil.getImage("jdaychoosercolor16.gif");
        this._importTime = new JButton(imageIcon);
        this._importTime.setEnabled(false);
        this._importTime.addActionListener(new CalendarAction());
        panelBuilder.add((Component)this._importTime, cellConstraints.xy(5, 3));
        return panelBuilder.getPanel();
    }

    public String getResumeTimeText() {
        if (this._enableTime.isSelected()) {
            return this._resumeTime.getText();
        }
        return "";
    }

    public long getResumeTime() {
        if (this._enableTime.isSelected()) {
            return this._checkedResumeTime;
        }
        return 0L;
    }

    @Override
    protected void okDialog() {
        if (this._enableTime.isSelected() && this._resumeTime.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, MESSAGE_RESUME_TIME);
            return;
        }
        this.dispose();
    }

    private class EnableTimeItem
    implements ItemListener {
        private EnableTimeItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable.equals(ResumeTimeDialog.this._enableTime)) {
                if (ResumeTimeDialog.this._enableTime.isSelected()) {
                    ResumeTimeDialog.this._importTime.setEnabled(true);
                } else {
                    ResumeTimeDialog.this._importTime.setEnabled(false);
                }
            }
        }
    }

    private class CalendarAction
    implements ActionListener {
        private CalendarAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CalendarDialog calendarDialog;
            Object object = actionEvent.getSource();
            if (object.equals(ResumeTimeDialog.this._importTime) && (calendarDialog = (CalendarDialog)DialogProvider.createCalendarDialog(ResumeTimeDialog.this)).isPut()) {
                Date date = calendarDialog.getDate();
                SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
                String string = simpleDateFormat.format(date);
                ResumeTimeDialog.this._resumeTime.setText(string);
                ResumeTimeDialog.this._checkedResumeTime = date.getTime();
            }
        }
    }
}

