/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.openapi.performance.DefaultProtocolDialog;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.performance.ComponentElement;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.HostDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class RemoteProtocolDialog
extends DefaultProtocolDialog {
    private JComboBox _comboParaComponent;
    private DefaultComboBoxModel _comboParaModel;
    private Map _keyToId;
    private int _preSelectedIndex;
    private long _probeID;
    private static final String HOST = "remote_host";
    private static final String LABEL_NEW_REMOTE_HOST = _bundle.getString("label_newremotehost");
    private static final String MESSAGE_SELECT_REMOTE_HOST = _bundle.getString("message_selectremotehost");

    public RemoteProtocolDialog(JDialog jDialog, String string, boolean bl2, long l2) {
        super(jDialog, string, bl2);
        this._probeID = l2;
    }

    public long getProbeID() {
        return this._probeID;
    }

    @Override
    protected void initBeforeUserData() {
        super.initBeforeUserData();
        ArrayList arrayList = new ArrayList();
        this.initNameProtocols(arrayList);
        this._comboParaComponent = (JComboBox)this.getComponent(HOST);
        this._comboParaModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._comboParaComponent.setModel(this._comboParaModel);
        this._comboParaComponent.setRenderer(new RemoteHostRenderer());
    }

    protected abstract int getRemoteProtocol();

    private void initNameProtocols(List list) {
        List list2 = null;
        try {
            list2 = ProxyMBeanInvoker.INSTANCE.getRemoteHosts(this.getRemoteProtocol(), this.getProbeID());
        }
        catch (Exception exception) {
            this._logger.error((Object)"RemoteProtocolDialog get remote hosts", (Throwable)exception);
        }
        if (list2 != null) {
            int n2 = list2.size();
            this._keyToId = new HashMap(n2);
            list.add(" ");
            for (int i2 = 0; i2 < n2; ++i2) {
                RemoteHost remoteHost = (RemoteHost)list2.get(i2);
                RemoteHostKey remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), this.getRemoteProtocol(), remoteHost.getUser());
                this._keyToId.put(remoteHostKey, remoteHost.getHostId());
                list.add(remoteHostKey);
            }
        }
        list.add(LABEL_NEW_REMOTE_HOST);
    }

    @Override
    protected void initAfterUserData() {
        super.initAfterUserData();
        this._comboParaComponent.addItemListener(new HostItem());
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        Object[] objectArray = this.getParameterValue().toArray();
        this._comboParaComponent.setSelectedItem(this.getSelectedHost(PerformanceUIUtil.getHostId(queryParameter)));
        this._preSelectedIndex = this._comboParaComponent.getSelectedIndex();
        int n2 = objectArray.length;
        int n3 = queryParameter.size();
        int n4 = n2 <= n3 ? n2 : n3;
        for (int i2 = 1; i2 < n4; ++i2) {
            ComponentElement componentElement = (ComponentElement)objectArray[i2];
            if (this.isIgnoredInitPara(componentElement)) continue;
            JComponent jComponent = componentElement.getComponent();
            String string = queryParameter.get(i2).toString();
            this.getComponentProvider().setInput(jComponent, componentElement.getName(), string);
        }
    }

    protected boolean isIgnoredInitPara(ComponentElement componentElement) {
        return false;
    }

    private RemoteHostKey getSelectedHost(Object object) {
        for (Map.Entry entry : this._keyToId.entrySet()) {
            if (!entry.getValue().equals(object)) continue;
            return (RemoteHostKey)entry.getKey();
        }
        return null;
    }

    @Override
    protected boolean checkParameter() {
        return this.checkRemoteHost();
    }

    protected boolean checkRemoteHost() {
        this._tmpParameters.clear();
        if (this._comboParaComponent.getSelectedIndex() <= 0) {
            JOptionPane.showMessageDialog(this, MESSAGE_SELECT_REMOTE_HOST);
            return false;
        }
        List list = this.getValidatedParametersValues(1);
        if (list == null) {
            return false;
        }
        Object v2 = this._keyToId.get(this._comboParaComponent.getSelectedItem());
        this._tmpParameters.add(v2);
        this._tmpParameters.addAll(list);
        return true;
    }

    protected JComboBox getComboParaComponent() {
        return this._comboParaComponent;
    }

    protected Long getRemoteHostId() {
        return (Long)this._keyToId.get(this._comboParaComponent.getSelectedItem());
    }

    private class RemoteHostRenderer
    extends JLabel
    implements ListCellRenderer {
        public RemoteHostRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof RemoteHostKey) {
                RemoteHostKey remoteHostKey = (RemoteHostKey)object;
                this.setText(remoteHostKey.getHost() + " ( " + remoteHostKey.getUser() + " )");
            } else if (object != null) {
                this.setText(object.toString());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }

    private class HostItem
    implements ItemListener {
        private HostItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(RemoteProtocolDialog.this._comboParaComponent)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n2 = RemoteProtocolDialog.this._comboParaModel.getSize() - 1;
                        int n3 = RemoteProtocolDialog.this._comboParaComponent.getSelectedIndex();
                        if (n3 != n2) {
                            RemoteProtocolDialog.this._preSelectedIndex = n3;
                            return;
                        }
                        FlagedRemoteHost flagedRemoteHost = TargetFactory.getFlagedRemoteHost();
                        flagedRemoteHost.setProtocol(RemoteProtocolDialog.this.getRemoteProtocol());
                        HostDialog hostDialog = DialogProvider.createHostDialog(RemoteProtocolDialog.this, DialogConstants.BUTTON_NEW, RemoteProtocolDialog.this._keyToId.keySet(), true, flagedRemoteHost, RemoteProtocolDialog.this.getProbeID());
                        if (hostDialog.isPut()) {
                            FlagedRemoteHost flagedRemoteHost2 = hostDialog.getRemoteHost();
                            RemoteHostKey remoteHostKey = new RemoteHostKey(flagedRemoteHost2.getHostName(), flagedRemoteHost2.getProtocol(), flagedRemoteHost2.getUser());
                            RemoteProtocolDialog.this._keyToId.put(remoteHostKey, flagedRemoteHost2.getHostId());
                            RemoteProtocolDialog.this._comboParaModel.insertElementAt(remoteHostKey, n2);
                            RemoteProtocolDialog.this._comboParaComponent.setSelectedIndex(n2);
                            RemoteProtocolDialog.this._preSelectedIndex = n2;
                        } else {
                            RemoteProtocolDialog.this._comboParaComponent.setSelectedIndex(RemoteProtocolDialog.this._preSelectedIndex);
                        }
                    }
                });
            }
        }
    }
}

