/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.performance.AlarmRemoteHostDialog;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class RemoteHostComboBox
extends JComboBox {
    private Map _keyToId;
    private DefaultComboBoxModel _model;
    private static final String TELNET = "TELNET";
    private static final String SSH = "SSH";
    private static final String RPC = "RPC";
    private static final int TELNET_ID = MonitorHelper.getConstantId("TELNET");
    private static final int SSH_ID = MonitorHelper.getConstantId("SSH");
    private static final int RPC_ID = MonitorHelper.getConstantId("RPC");
    private int _preSelected = 0;
    private long _probeID = 0L;
    private List<RemoteHost> _remoteHosts = null;
    private static final Logger _logger = Logger.getLogger((String)RemoteHostComboBox.class.getName());

    public RemoteHostComboBox(long l2) {
        this._probeID = l2;
        this.initBeforeUserData();
        this.initAfterUserData();
    }

    public RemoteHostComboBox(long l2, List<RemoteHost> list) {
        this._probeID = l2;
        this._remoteHosts = list;
        this.initBeforeUserData();
        this.initAfterUserData();
    }

    private void initBeforeUserData() {
        ArrayList arrayList = new ArrayList();
        this.initNameProtocols(arrayList);
        this._model = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.setModel(this._model);
        this.setRenderer(new RemoteHostRenderer());
    }

    private void initNameProtocols(List list) {
        List list2 = new ArrayList<RemoteHost>();
        try {
            if (this._remoteHosts == null) {
                list2 = ProxyMBeanInvoker.INSTANCE.getRemoteHosts(TELNET_ID, this._probeID);
                list2.addAll(ProxyMBeanInvoker.INSTANCE.getRemoteHosts(SSH_ID, this._probeID));
                list2.addAll(ProxyMBeanInvoker.INSTANCE.getRemoteHosts(RPC_ID, this._probeID));
            } else {
                list2.addAll(this._remoteHosts);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"get remote host Error:", (Throwable)exception);
        }
        int n2 = list2.size();
        this._keyToId = new HashMap(n2);
        list.add(" ");
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteHost remoteHost = (RemoteHost)list2.get(i2);
            RemoteHostKey remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
            this._keyToId.put(remoteHostKey, remoteHost.getHostId());
            list.add(remoteHostKey);
        }
        list.add(RemoteHostComboBox.fromBundle("label_newremotehost"));
    }

    private void initAfterUserData() {
        this.addItemListener(new HostItem());
        this.addPopupMenuListener(new ComboBoxListener());
    }

    public String getSelectedRemoteHostID() {
        Object object = this._model.getSelectedItem();
        if (object instanceof RemoteHostKey) {
            RemoteHostKey remoteHostKey = (RemoteHostKey)object;
            return String.valueOf(this._keyToId.get(remoteHostKey));
        }
        return null;
    }

    public void selectByRemoteHostID(String string) {
        Long l2 = Long.valueOf(string);
        for (Map.Entry entry : this._keyToId.entrySet()) {
            Map.Entry entry2 = entry;
            if (!entry2.getValue().equals(l2)) continue;
            this.setSelectedItem(entry2.getKey());
        }
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(RemoteHostComboBox.class, (String)string);
    }

    private class RemoteHostRenderer
    extends JLabel
    implements ListCellRenderer {
        public RemoteHostRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof RemoteHostKey) {
                RemoteHostKey remoteHostKey = (RemoteHostKey)object;
                String string = remoteHostKey.getHost() + " ( " + remoteHostKey.getUser() + " )";
                this.setText(string);
                this.setToolTipText(string);
            } else if (object != null) {
                this.setText(object.toString());
                this.setToolTipText(object.toString());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }

    private class HostItem
    implements ItemListener {
        private HostItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n2 = RemoteHostComboBox.this._model.getSize() - 1;
                        int n3 = RemoteHostComboBox.this.getSelectedIndex();
                        if (n3 != n2) {
                            RemoteHostComboBox.this._preSelected = n3;
                            return;
                        }
                        AlarmRemoteHostDialog alarmRemoteHostDialog = new AlarmRemoteHostDialog(Startup.getFrame(), true, true, RemoteHostComboBox.this._probeID);
                        if (alarmRemoteHostDialog.isOK()) {
                            FlagedRemoteHost flagedRemoteHost = alarmRemoteHostDialog.getRemoteHost();
                            RemoteHostKey remoteHostKey = new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser());
                            RemoteHostComboBox.this._keyToId.put(remoteHostKey, flagedRemoteHost.getHostId());
                            RemoteHostComboBox.this._model.insertElementAt(remoteHostKey, n2);
                            RemoteHostComboBox.this.setSelectedIndex(n2);
                            RemoteHostComboBox.this._preSelected = n2;
                        } else {
                            RemoteHostComboBox.this.setSelectedIndex(RemoteHostComboBox.this._preSelected);
                        }
                    }
                });
            }
        }
    }

    private class ComboBoxListener
    implements PopupMenuListener {
        private ComboBoxListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            RemoteHostComboBox.this.initBeforeUserData();
            RemoteHostComboBox.this.setSelectedIndex(RemoteHostComboBox.this._preSelected);
        }
    }
}

