/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.protocol.snmp.SnmpPdu;
import com.ireasoning.util.AgentProperties;
import com.sysuptime.common.util.SNMPWizardMonitorUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.MonitorCheckBox;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public class PagesPrintedPane
extends SnmpDevicesMonitorPane {
    private String _pageCount;

    public PagesPrintedPane(AgentProperties agentProperties) throws Exception {
        this.initComponent(agentProperties);
    }

    public static String doPagesPrintedSessionValid(AgentProperties agentProperties) throws Exception {
        SnmpPdu snmpPdu = ClientProxy.getInstance().snmpGetRequest(agentProperties, SNMPWizardMonitorUtil.PRT_MARKER_LIFE_COUNT_OID);
        if (snmpPdu != null) {
            return snmpPdu.getVarBind(0).getValue().toString();
        }
        return null;
    }

    public void initComponent(AgentProperties agentProperties) throws Exception {
        this._pageCount = PagesPrintedPane.doPagesPrintedSessionValid(agentProperties);
        if (this._pageCount == null) {
            throw new Exception(NbBundle.getMessage(PagesPrintedPane.class, (String)"MSG_get_data_error"));
        }
        HashMap hashMap = new HashMap();
        this.createComponent(hashMap);
    }

    @Override
    protected JPanel initDevicesPane(Map map) {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = PagesPrintedPane.fromBundle("Label_pages_printed");
        MonitorCheckBox monitorCheckBox = new MonitorCheckBox(0, string);
        monitorCheckBox.setSelected(true);
        JLabel jLabel = new JLabel("       ( " + PagesPrintedPane.fromBundle("current_value") + ": " + this._pageCount + " )");
        jPanel.add((Component)monitorCheckBox, "West");
        jPanel.add((Component)jLabel, "Center");
        return jPanel;
    }

    @Override
    protected String getTitleBorderText() {
        return PagesPrintedPane.fromBundle("Title_printer");
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(PagesPrintedPane.class, (String)string);
    }
}

