/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.google.gson.GsonBuilder;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.QueryParameter$QueryParameterDeserializer;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.common.util.Tokenizer;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MonitorImporterDialog
extends ConfirmDialog {
    private static final String MESSAGE_XML_NOT_FOUND = _bundle.getString("message_xmlnotfound");
    private boolean _isOk;
    private JList _fileList;
    private String _fileName;
    private JTextArea _textArea = new JTextArea();

    public MonitorImporterDialog(JDialog jDialog, boolean bl2) {
        super(jDialog, "Templates", bl2);
        this.initComponents();
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JSplitPane getBodyPanel() {
        Object object;
        File file = new File(AppUtil.getClientSpecificDirectory("templates"));
        Vector<String> vector = new Vector<String>();
        for (File serializable2 : file.listFiles()) {
            object = serializable2.getName();
            if (!((String)object).endsWith(".template")) continue;
            object = ((String)object).substring(0, ((String)object).length() - 9);
            vector.add((String)object);
        }
        Collections.sort(vector);
        JList jList = new JList(vector);
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object = (String)MonitorImporterDialog.this._fileList.getSelectedValue();
                if (object == null) {
                    return;
                }
                object = (String)object + ".template";
                File file = new File(AppUtil.getClientSpecificDirectory("templates") + (String)object);
                if (!file.exists()) {
                    return;
                }
                String string = "";
                try {
                    string = MonitorImporterDialog.getComment(file);
                    MonitorImporterDialog.this._textArea.setText(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (mouseEvent.getClickCount() == 2) {
                    MonitorImporterDialog.this.okDialog();
                }
            }
        });
        this._fileList = jList;
        jList.setPreferredSize(new Dimension(590, 390));
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(600, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(jScrollPane);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setDividerLocation(410);
        jSplitPane.add(jPanel);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        this._textArea.setLineWrap(true);
        this._textArea.setToolTipText("Comments of selected template");
        ((Container)object).add((Component)new JScrollPane(this._textArea), "Center");
        JButton jButton = new JButton("Update");
        jButton.setToolTipText("Save modified comments of the template");
        jButton.setMaximumSize(new Dimension(100, 28));
        jButton.addActionListener(actionEvent -> this.updateTemplateComment(this._textArea.getText().trim()));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        ((Container)object).add((Component)jPanel2, "East");
        this._textArea.setPreferredSize(new Dimension(480, 200));
        this._textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        jSplitPane.add((Component)object);
        return jSplitPane;
    }

    private void updateTemplateComment(String string) {
        Object object = (String)this._fileList.getSelectedValue();
        if (object == null) {
            return;
        }
        object = (String)object + ".template";
        File file = new File(AppUtil.getClientSpecificDirectory("templates") + (String)object);
        if (!file.exists()) {
            return;
        }
        try {
            String[] stringArray = Tokenizer.parse(string, '\n', false, false);
            String string2 = FileUtil.readFile(file.getAbsolutePath());
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : stringArray) {
                stringBuffer.append("//").append(string3).append('\n');
            }
            stringBuffer.append(string2);
            FileUtil.writeFile(file.getAbsolutePath(), stringBuffer.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getComment(File file) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null && string != null) {
            if (!(string = string.trim()).startsWith("//")) continue;
            stringBuffer.append(string.substring(2));
            stringBuffer.append("\n");
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static Monitor getMonitorFromFile(String string) {
        String string2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = new BufferedReader(new FileReader(string));
            while ((string2 = ((BufferedReader)object).readLine()) != null && string2 != null) {
                if ((string2 = string2.trim()).startsWith("//")) continue;
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            return null;
        }
        object = stringBuffer.toString();
        string2 = new GsonBuilder();
        string2.registerTypeAdapter(QueryParameter.class, (Object)new QueryParameter$QueryParameterDeserializer());
        Monitor monitor = (Monitor)string2.create().fromJson((String)object, Monitor.class);
        return monitor;
    }

    public String getFileName() {
        return this._fileName;
    }

    @Override
    protected void okDialog() {
        Object object = (String)this._fileList.getSelectedValue();
        if (object == null) {
            return;
        }
        object = (String)object + ".template";
        File file = new File(AppUtil.getClientSpecificDirectory("templates") + (String)object);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, MESSAGE_XML_NOT_FOUND);
            return;
        }
        this._isOk = true;
        this._fileName = file.getAbsolutePath();
        this.dispose();
    }

    public boolean isOk() {
        return this._isOk;
    }
}

