/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.CloserThreshold;
import com.sysuptime.common.performance.IGraphQueryInfo;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.ProtocolQueryResult;
import com.sysuptime.common.performance.SinglePerformance;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.callback.CallbackClient;
import com.sysuptime.common.util.callback.DefaultListener;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.performance.GraphMonitorMBeanInvoker;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.TimePeriodDialog;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.TableUtil;
import com.ultraswing.ToolBarButton;
import com.ultraswing.ToolBarToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ShapeUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class MonitorGraphComponent
extends TopComponent
implements ActionListener {
    private static final Logger _logger = Logger.getLogger((String)MonitorGraphComponent.class.getName());
    private static final String SEPARATOR = ": ";
    private static final String[] _tableTitles = new String[]{MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_variable"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_current"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_max"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_min"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_average"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_total"), MonitorGraphComponent.fromBundle("MonitorGraphDialog_tableTitle_stddev")};
    private static CallbackClient _client;
    public static final int MAX_DATA_COUNT = 1500;
    private static final List _openedMonitorIds;
    private ToolBarButton _importBtn;
    private ToolBarButton _exportBtn;
    private ToolBarButton _restartBtn;
    private ToolBarButton _pauseBtn;
    private ToolBarToggleButton _traceBtn;
    private ToolBarToggleButton _gridBtn;
    private ToolBarButton _saveAsPngBtn;
    private ToolBarButton _printBtn = null;
    private ToolBarToggleButton _thresholdButton;
    private ChartPane _chartPanel;
    private JTable _table = null;
    private GraphListener _listener;
    private boolean _isPaused = false;
    private int _scheduleID;
    private List _singlePerformanceList;

    public MonitorGraphComponent(Monitor monitor, List list) {
        this.setLayout(new BorderLayout());
        SinglePerformance singlePerformance = (SinglePerformance)list.get(0);
        String string = monitor.getScheduleName();
        String string2 = singlePerformance.getIpAddress();
        this.setDisplayName(MonitorGraphComponent.fromBundle("MonitorGraphDialog_title") + " - " + string + "@" + string2);
        this._scheduleID = monitor.getScheduleId();
        this._singlePerformanceList = list;
        this.initChart(string);
        this.initTable();
        this.initContentPane();
        this.initListener(this._scheduleID, list);
        SwingUtilities.invokeLater(() -> this.load(0L, 0L, 100));
    }

    private JToolBar createToolBar() {
        this._importBtn = new ToolBarButton(SwingUtil.getImage("import.gif"));
        this._exportBtn = new ToolBarButton(SwingUtil.getImage("export.gif"));
        this._pauseBtn = new ToolBarButton(SwingUtil.getImage("pause.gif"));
        this._restartBtn = new ToolBarButton(SwingUtil.getImage("restart.gif"));
        this._saveAsPngBtn = new ToolBarButton(SwingUtil.getImage("save.gif"));
        this._printBtn = new ToolBarButton(SwingUtil.getImage("print.gif"));
        this._traceBtn = new ToolBarToggleButton(null, SwingUtil.getImage("trace.gif"));
        this._gridBtn = new ToolBarToggleButton(null, SwingUtil.getImage("grid.gif"), true);
        this._thresholdButton = new ToolBarToggleButton(null, SwingUtil.getImage("threshold.gif"), true);
        this._importBtn.addActionListener(this);
        this._exportBtn.addActionListener(this);
        this._pauseBtn.addActionListener(this);
        this._restartBtn.addActionListener(this);
        this._saveAsPngBtn.addActionListener(this);
        this._printBtn.addActionListener(this);
        this._traceBtn.addActionListener(this);
        this._gridBtn.addActionListener(this);
        this._thresholdButton.addActionListener(this);
        this._importBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_import"));
        this._exportBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_export"));
        this._pauseBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_pause"));
        this._restartBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_restart"));
        this._saveAsPngBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_save"));
        this._printBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_print"));
        this._traceBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_trace"));
        this._gridBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_grid"));
        this._thresholdButton.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_threshold"));
        this._gridBtn.setState(false);
        this._thresholdButton.setState(true);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this._importBtn);
        jToolBar.add(this._exportBtn);
        jToolBar.add(this._saveAsPngBtn);
        jToolBar.add(this._printBtn);
        jToolBar.addSeparator();
        jToolBar.add(this._restartBtn);
        jToolBar.add(this._pauseBtn);
        jToolBar.add(this._traceBtn);
        jToolBar.add(this._gridBtn);
        jToolBar.add(this._thresholdButton);
        return jToolBar;
    }

    private boolean isStat() {
        SinglePerformance singlePerformance = (SinglePerformance)this._singlePerformanceList.get(0);
        return singlePerformance.isStat();
    }

    private void initChart(String string) {
        this._chartPanel = new ChartPane(string, this._singlePerformanceList, false);
        this._chartPanel.setPreferredSize(new Dimension(500, 270));
    }

    private void initListener(int n2, List list) {
        String string = this.generateID(n2, list);
        _client = new CallbackClient(string);
        this._listener = new GraphListener(string, n2, list);
        _client.addListener(this._listener);
        GraphMonitorMBeanInvoker.addListener(_client, this._listener.getID(), this._listener.getGraphQueryInfo());
        Startup.getGlobalCallbackClient().addListener(new GraphListener(string, n2, list));
    }

    private String generateID(int n2, List list) {
        return "" + n2 + list.hashCode();
    }

    protected void componentOpened() {
        _openedMonitorIds.add(this._scheduleID);
    }

    protected void componentClosed() {
        _openedMonitorIds.remove((Object)this._scheduleID);
        GraphMonitorMBeanInvoker.removeListener(_client, this._listener.getID());
        _client.removeListener(this._listener);
    }

    public int getPersistenceType() {
        return 2;
    }

    public String preferredID() {
        return "monitorGraph";
    }

    private void initTable() {
        Object object;
        int n2 = this._singlePerformanceList.size();
        String[] stringArray = new String[n2];
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            SinglePerformance singlePerformance = (SinglePerformance)this._singlePerformanceList.get(i2);
            object = MonitorHelper.getConstantLocaleName(singlePerformance.getResultType());
            String string = singlePerformance.getMetricsHost((String)object);
            stringArray[i2] = string + SEPARATOR + (String)object;
            blArray[i2] = singlePerformance.isStat();
        }
        StatisticTableModel statisticTableModel = new StatisticTableModel(stringArray, blArray);
        this._table = SwingUtil.createJTable(statisticTableModel);
        int n3 = this._table.getRowCount();
        switch (n3) {
            case 1: {
                this._table.setPreferredScrollableViewportSize(new Dimension(500, 16));
                break;
            }
            case 2: {
                this._table.setPreferredScrollableViewportSize(new Dimension(500, 32));
                break;
            }
            default: {
                this._table.setPreferredScrollableViewportSize(new Dimension(500, 48));
            }
        }
        object = this._table.getColumnModel().getColumn(0);
        ((TableColumn)object).setCellRenderer(new StatisticTableCellRenderer(this._chartPanel.getItemPaints()));
        TableUtil.packColumn(this._table, 0, 1);
    }

    private void initContentPane() {
        this.add(this.createToolBar(), "North");
        this.add(this._chartPanel, "Center");
        this.add(new JScrollPane(this._table), "South");
    }

    public ChartPane getChartPane() {
        return this._chartPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._importBtn) {
            this.doImport();
        } else if (object == this._pauseBtn) {
            this.doPause();
        } else if (object == this._restartBtn) {
            this.doRestart();
        } else if (object == this._exportBtn) {
            this.doExport();
        } else if (object == this._saveAsPngBtn) {
            this.doSaveAsPng();
        } else if (object == this._printBtn) {
            this.doPrint();
        } else if (object == this._traceBtn) {
            this.doTrace();
        } else if (object == this._gridBtn) {
            this.doGrid();
        } else if (object == this._thresholdButton) {
            this.doThreshold();
        }
    }

    private void doImport() {
        TimePeriodDialog timePeriodDialog = new TimePeriodDialog(Startup.getFrame(), MonitorGraphComponent.fromBundle("TimePeriodDialog_title"), true);
        timePeriodDialog.showOut();
        if (timePeriodDialog.isOK()) {
            long l2 = timePeriodDialog.getFromTime();
            long l3 = timePeriodDialog.getToTime();
            this.load(l2, l3, -1);
        }
    }

    public void load(long l2, long l3, int n2) {
        this._chartPanel._max = n2;
        this.doRestart();
        int n3 = this._singlePerformanceList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            SinglePerformance singlePerformance = (SinglePerformance)this._singlePerformanceList.get(i2);
            List list = MonitorBroker.getQueryResult(this._scheduleID, singlePerformance.getHostId(), singlePerformance.getResultType(), l2, l3, n2);
            if (list == null) continue;
            n2 = list.size();
            int n4 = 0;
            if (n2 > 1500) {
                JOptionPane.showMessageDialog((Component)((Object)this), NbBundle.getMessage(MonitorGraphComponent.class, (String)"warning_too_many_data", (Object)"1500", (Object)("" + n2)));
                n4 = n2 - 1500;
            }
            for (int i3 = n4; i3 < n2; ++i3) {
                ProtocolQueryResult protocolQueryResult = (ProtocolQueryResult)list.get(i3);
                this.updateGraph(protocolQueryResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean bl2 = false;
                try {
                    bl2 = file.getName().endsWith(".CSV");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MonitorGraphComponent.this.getRootPane().getParent(), exception);
                }
                return bl2;
            }

            @Override
            public String getDescription() {
                return "CSV File";
            }
        };
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setSelectedFile(new File("*.CSV"));
        jFileChooser.setFileFilter(fileFilter);
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            FileWriter fileWriter = null;
            try {
                int n2;
                fileWriter = new FileWriter(jFileChooser.getSelectedFile().getPath());
                List list = this._chartPanel.getDataset().getSeries();
                int n3 = list.size();
                TimeSeries[] timeSeriesArray = new TimeSeries[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    timeSeriesArray[n2] = (TimeSeries)list.get(n2);
                }
                fileWriter.write("Date/Time");
                for (n2 = 0; n2 < n3; ++n2) {
                    fileWriter.write("," + timeSeriesArray[n2].getKey());
                }
                fileWriter.write("\r\n");
                SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
                for (int i2 = 0; i2 < timeSeriesArray[0].getItemCount(); ++i2) {
                    fileWriter.write(simpleDateFormat.format(timeSeriesArray[0].getTimePeriod(i2).getStart()));
                    for (int i3 = 0; i3 < n3; ++i3) {
                        fileWriter.write("," + timeSeriesArray[i3].getValue(i2));
                    }
                    fileWriter.write("\r\n");
                }
                fileWriter.flush();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog((Component)((Object)this), iOException);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void doSaveAsPng() {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean bl2 = false;
                try {
                    bl2 = file.getName().endsWith(".png");
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(MonitorGraphComponent.this.getRootPane().getParent(), exception);
                }
                return bl2;
            }

            @Override
            public String getDescription() {
                return ".png";
            }
        };
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File("*.png"));
        jFileChooser.setFileFilter(fileFilter);
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            try {
                ChartUtilities.saveChartAsPNG((File)new File(string), (JFreeChart)this._chartPanel.getChart(), (int)this._chartPanel.getWidth(), (int)this._chartPanel.getHeight());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog((Component)((Object)this), iOException);
            }
        }
    }

    private void doPause() {
        if (!this._isPaused) {
            this._pauseBtn.setIcon(SwingUtil.getImage("continue.gif"));
            this._pauseBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_continue"));
            this._isPaused = true;
        } else {
            this._pauseBtn.setIcon(SwingUtil.getImage("pause.gif"));
            this._pauseBtn.setToolTipText(MonitorGraphComponent.fromBundle("MonitorGraphDialog_toolTip_pause"));
            this._isPaused = false;
        }
        this._chartPanel.setPaused(this._isPaused);
        ((StatisticTableModel)this._table.getModel()).setPaused(this._isPaused);
    }

    private void doGrid() {
        XYPlot xYPlot = this._chartPanel.getChart().getXYPlot();
        if (this._gridBtn.getState()) {
            xYPlot.setDomainGridlinesVisible(false);
            xYPlot.setRangeGridlinesVisible(false);
        } else {
            xYPlot.setDomainGridlinesVisible(true);
            xYPlot.setRangeGridlinesVisible(true);
        }
    }

    private void doThreshold() {
        this._chartPanel.showThreshold(!this._thresholdButton.getState());
    }

    private void doPrint() {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
        if (pageFormat2 != pageFormat) {
            printerJob.setPrintable((Printable)this._chartPanel.getChartPanel(), pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog((Component)((Object)this), printerException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRestart() {
        List list = this._chartPanel.getDataset().getSeries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TimeSeries timeSeries;
            TimeSeries timeSeries2 = timeSeries = (TimeSeries)iterator.next();
            synchronized (timeSeries2) {
                timeSeries.clear();
            }
        }
        ((StatisticTableModel)this._table.getModel()).reset();
    }

    private void doTrace() {
        if (this._traceBtn.getState()) {
            this._chartPanel.getChartPanel().setHorizontalAxisTrace(false);
            this._chartPanel.getChartPanel().setVerticalAxisTrace(false);
        } else {
            this._chartPanel.getChartPanel().setHorizontalAxisTrace(true);
            this._chartPanel.getChartPanel().setVerticalAxisTrace(true);
        }
    }

    public void updateGraph(ProtocolQueryResult protocolQueryResult) {
        long l2 = protocolQueryResult.getScheduleHostId();
        int n2 = protocolQueryResult.getResultTypeId();
        String string = this.getVarName(l2, n2);
        long l3 = protocolQueryResult.getRunDateTime();
        double d10 = protocolQueryResult.getResultValue();
        String string2 = protocolQueryResult.getThresholdState();
        TypedNumber typedNumber = new TypedNumber(d10, protocolQueryResult.getResultState(), protocolQueryResult.getErrorCodeText(), string2, protocolQueryResult.getPeriodIndex());
        TypedNumber typedNumber2 = new TypedNumber(protocolQueryResult.getStddev(), protocolQueryResult.getResultState(), protocolQueryResult.getErrorCodeText(), string2, protocolQueryResult.getPeriodIndex());
        CloserThreshold closerThreshold = protocolQueryResult.getCloserThreshold();
        this._chartPanel.update(string, (RegularTimePeriod)new Millisecond(new Date(l3)), typedNumber, closerThreshold);
        ((StatisticTableModel)this._table.getModel()).update(string, typedNumber, typedNumber2);
    }

    public String getVarName(long l2, int n2) {
        for (int i2 = 0; i2 < this._singlePerformanceList.size(); ++i2) {
            SinglePerformance singlePerformance = (SinglePerformance)this._singlePerformanceList.get(i2);
            long l3 = singlePerformance.getHostId();
            int n3 = singlePerformance.getResultType();
            if (l3 != l2 || n3 != n2) continue;
            String string = MonitorHelper.getConstantLocaleName(n2);
            String string2 = singlePerformance.getMetricsHost(string);
            return string2 + SEPARATOR + string;
        }
        return null;
    }

    public static synchronized boolean opened(int n2) {
        return _openedMonitorIds.contains(n2);
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(MonitorGraphComponent.class, (String)string);
    }

    static {
        _openedMonitorIds = new ArrayList();
    }

    private static class ChartPane
    extends JPanel {
        private static final Shape NORMAL_SHAPE = new Ellipse2D.Float(-2.5f, -2.5f, 5.0f, 5.0f);
        private static final Shape ALARM_SHAPE = ShapeUtilities.createUpTriangle((float)3.0f);
        private static final Shape BETWEEN_ALARM_AND_REARM_SHAPE = new Rectangle2D.Float(-2.5f, -2.5f, 5.0f, 5.0f);
        private static final Shape REARM_SHAPE = ShapeUtilities.createDownTriangle((float)3.0f);
        private static final Shape UNAVAILABLE_SHAPE = ShapeUtilities.createDiamond((float)3.0f);
        private static final Shape ERROR_SHAPE = ShapeUtilities.createDiagonalCross((float)3.0f, (float)1.0f);
        private Paint[] _itemPaints;
        private String _name;
        private TimeSeriesCollection _dataset;
        private TimeSeriesCollection _thresholdDataset;
        private JFreeChart _chart;
        private ChartPanel _panel;
        private boolean _isPaused;
        int _max = -1;

        public ChartPane(String string, List list, boolean bl2) {
            super(new BorderLayout());
            this._name = string;
            this._dataset = new TimeSeriesCollection();
            int n2 = list.size();
            TimeSeries[] timeSeriesArray = new TimeSeries[n2];
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                SinglePerformance singlePerformance = (SinglePerformance)list.get(i2);
                String string2 = MonitorHelper.getConstantLocaleName(singlePerformance.getResultType());
                String string3 = singlePerformance.getMetricsHost(string2);
                stringArray[i2] = string3 + MonitorGraphComponent.SEPARATOR + string2;
                timeSeriesArray[i2] = new TimeSeries((Comparable)((Object)stringArray[i2]), Millisecond.class);
                timeSeriesArray[i2].setMaximumItemCount(1500);
                this._dataset.addSeries(timeSeriesArray[i2]);
            }
            this._chart = this.createChart((XYDataset)this._dataset);
            this._panel = new ChartPanel(this._chart, true);
            this._panel.setBackground(Color.GREEN);
            this.add((Component)this._panel);
            this.showThreshold(bl2);
        }

        private JFreeChart createChart(XYDataset xYDataset) {
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart((String)this._name, (String)MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_time"), (String)ICommonBundle.VALUE, (XYDataset)xYDataset, (boolean)true, (boolean)true, (boolean)false);
            jFreeChart.setBackgroundPaint((Paint)this.getBackground());
            XYPlot xYPlot = jFreeChart.getXYPlot();
            NumberAxis numberAxis = new NumberAxis(ICommonBundle.VALUE);
            numberAxis.setAutoRangeIncludesZero(false);
            xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
            xYPlot.setRangeAxis((ValueAxis)numberAxis);
            xYPlot.setBackgroundPaint((Paint)Color.DARK_GRAY);
            xYPlot.setDomainGridlinePaint((Paint)Color.GREEN);
            xYPlot.setRangeGridlinePaint((Paint)Color.GREEN);
            ValueRelatedRenderer valueRelatedRenderer = new ValueRelatedRenderer();
            valueRelatedRenderer.setToolTipGenerator((XYToolTipGenerator)new ErrorToolTipGenerator());
            xYPlot.setRenderer((XYItemRenderer)valueRelatedRenderer);
            this._itemPaints = new Paint[xYDataset.getSeriesCount()];
            for (int i2 = 0; i2 < this._itemPaints.length; ++i2) {
                this._itemPaints[i2] = valueRelatedRenderer.getSeriesPaint(i2);
            }
            xYPlot.setFixedLegendItems(this.createLegendItems());
            LegendTitle legendTitle = jFreeChart.getLegend();
            legendTitle.setBackgroundPaint((Paint)Color.DARK_GRAY);
            legendTitle.setItemPaint((Paint)Color.GREEN);
            TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"threshold"), Millisecond.class);
            timeSeries.setMaximumItemCount(1500);
            this._thresholdDataset = new TimeSeriesCollection(timeSeries);
            xYPlot.setDataset(1, (XYDataset)this._thresholdDataset);
            ThresholdRenderer thresholdRenderer = new ThresholdRenderer();
            thresholdRenderer.setBaseLinesVisible(false);
            xYPlot.setRenderer(1, (XYItemRenderer)thresholdRenderer);
            return jFreeChart;
        }

        private LegendItemCollection createLegendItems() {
            LegendItemCollection legendItemCollection = new LegendItemCollection();
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_normal"), "", null, null, (Shape)new Ellipse2D.Float(-4.0f, -4.0f, 8.0f, 8.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_alarm"), "", null, null, ShapeUtilities.createUpTriangle((float)4.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_between"), "", null, null, (Shape)new Rectangle2D.Float(-4.0f, -4.0f, 8.0f, 8.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_rearm"), "", null, null, ShapeUtilities.createDownTriangle((float)4.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_unavailable"), "", null, null, ShapeUtilities.createDiamond((float)4.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_error"), "", null, null, ShapeUtilities.createDiagonalCross((float)4.0f, (float)1.0f), (Paint)Color.GREEN));
            legendItemCollection.add(new LegendItem(MonitorGraphComponent.fromBundle("MonitorGraphDialog_chart_legend_threshold"), "", null, null, ShapeUtilities.createLineRegion((Line2D)new Line2D.Float(-5.0f, 0.0f, 5.0f, 0.0f), (float)1.5f), (Paint)Color.GREEN));
            return legendItemCollection;
        }

        public void showThreshold(boolean bl2) {
            XYPlot xYPlot = this._chart.getXYPlot();
            if (bl2) {
                xYPlot.setDataset(1, (XYDataset)this._thresholdDataset);
            } else {
                xYPlot.setDataset(1, null);
            }
        }

        public TimeSeriesCollection getDataset() {
            return this._dataset;
        }

        public JFreeChart getChart() {
            return this._chart;
        }

        public ChartPanel getChartPanel() {
            return this._panel;
        }

        public Paint[] getItemPaints() {
            return this._itemPaints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(String string, RegularTimePeriod regularTimePeriod, TypedNumber typedNumber, CloserThreshold closerThreshold) {
            if (this._isPaused) {
                return;
            }
            TimeSeries timeSeries = this._dataset.getSeries((Comparable)((Object)string));
            String string2 = typedNumber.getType();
            if (string2.equals("E") || string2.equals("U")) {
                int n2 = timeSeries.getItemCount();
                if (n2 == 0) {
                    typedNumber.setValue(0.0);
                } else {
                    double d10 = timeSeries.getValue(n2 - 1).doubleValue();
                    typedNumber.setValue(d10);
                }
            }
            TimeSeries timeSeries2 = timeSeries;
            synchronized (timeSeries2) {
                if (this._max > 0) {
                    timeSeries.setMaximumItemCount(this._max);
                }
                timeSeries.add(regularTimePeriod, (Number)typedNumber);
                if (closerThreshold != null) {
                    TimeSeries timeSeries3 = this._thresholdDataset.getSeries((Comparable)((Object)"threshold"));
                    timeSeries3.addOrUpdate(regularTimePeriod, closerThreshold.getThreshold());
                }
            }
        }

        public void setPaused(boolean bl2) {
            this._isPaused = bl2;
        }

        private class ValueRelatedRenderer
        extends XYLineAndShapeRenderer {
            private ValueRelatedRenderer() {
            }

            public Shape getItemShape(int n2, int n3) {
                TimeSeries timeSeries = ChartPane.this._dataset.getSeries(n2);
                TypedNumber typedNumber = (TypedNumber)timeSeries.getValue(n3);
                String string = typedNumber.getType();
                String string2 = typedNumber.getThresholdState();
                if ("U".equals(string)) {
                    return UNAVAILABLE_SHAPE;
                }
                if ("E".equals(string)) {
                    return ERROR_SHAPE;
                }
                if ("A".equals(string2)) {
                    return ALARM_SHAPE;
                }
                if ("B".equals(string2)) {
                    return BETWEEN_ALARM_AND_REARM_SHAPE;
                }
                if ("R".equals(string2)) {
                    return REARM_SHAPE;
                }
                return NORMAL_SHAPE;
            }
        }

        private static class ErrorToolTipGenerator
        extends StandardXYToolTipGenerator {
            public ErrorToolTipGenerator() {
                super("{0}: ({1}, {2})", DateFormat.getInstance(), NumberFormat.getInstance());
            }

            public String generateToolTip(XYDataset xYDataset, int n2, int n3) {
                TypedNumber typedNumber = (TypedNumber)xYDataset.getY(n2, n3);
                String string = typedNumber.getType();
                if ("U".equals(string)) {
                    return typedNumber.getErrorText();
                }
                if ("E".equals(string)) {
                    return typedNumber.getErrorText();
                }
                return super.generateToolTip(xYDataset, n2, n3);
            }
        }
    }

    public class GraphListener
    extends DefaultListener {
        private IGraphQueryInfo _graphQueryInfo;

        public GraphListener(String string, int n2, List list) {
            super(string);
            this._graphQueryInfo = new GraphQueryInfo(n2, list);
        }

        public IGraphQueryInfo getGraphQueryInfo() {
            return this._graphQueryInfo;
        }

        public void updateGraph(ProtocolQueryResult protocolQueryResult) {
            SwingUtilities.invokeLater(() -> MonitorGraphComponent.this.updateGraph(protocolQueryResult));
        }
    }

    private static class StatisticTableModel
    extends AbstractTableModel {
        private String[] _varNames;
        private TypedNumber[] _lastValue;
        private TypedNumber[] _max;
        private TypedNumber[] _min;
        private TypedNumber[] _total;
        private TypedNumber[] _average;
        private TypedNumber[] _stddev;
        private boolean[] _hasStddev;
        private int[] _itemCount;
        boolean _isPaused;

        public StatisticTableModel(String[] stringArray, boolean[] blArray) {
            this._varNames = stringArray;
            this._lastValue = new TypedNumber[stringArray.length];
            this._max = new TypedNumber[stringArray.length];
            this._min = new TypedNumber[stringArray.length];
            this._total = new TypedNumber[stringArray.length];
            this._average = new TypedNumber[stringArray.length];
            this._stddev = new TypedNumber[stringArray.length];
            this._hasStddev = blArray;
            this._itemCount = new int[stringArray.length];
            this.reset();
        }

        public void reset() {
            for (int i2 = 0; i2 < this._varNames.length; ++i2) {
                this._lastValue[i2] = TypedNumber.getZero();
                this._max[i2] = new TypedNumber(-1.7976931348623157E308, "U", null, null, -1);
                this._min[i2] = new TypedNumber(Double.MAX_VALUE, "U", null, null, -1);
                this._total[i2] = TypedNumber.getZero();
                this._average[i2] = TypedNumber.getZero();
                this._stddev[i2] = TypedNumber.getZero();
                this._itemCount[i2] = 0;
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this._varNames.length;
        }

        @Override
        public int getColumnCount() {
            return _tableTitles.length;
        }

        @Override
        public String getColumnName(int n2) {
            return _tableTitles[n2];
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            switch (n3) {
                case 0: {
                    return this._varNames[n2];
                }
                case 1: {
                    return this._lastValue[n2].getValue();
                }
                case 2: {
                    return this._max[n2].getValue();
                }
                case 3: {
                    return this._min[n2].getValue();
                }
                case 4: {
                    return this._average[n2].getValue();
                }
                case 5: {
                    return this._total[n2].getValue();
                }
                case 6: {
                    return this.getStddevValue(n2);
                }
            }
            return new Double(0.0);
        }

        private Object getStddevValue(int n2) {
            return this._hasStddev[n2] && this._stddev[n2].isStddevAvailable() ? this._stddev[n2].getValue() : "N/A";
        }

        public synchronized void update(String string, TypedNumber typedNumber, TypedNumber typedNumber2) {
            if (this._isPaused) {
                return;
            }
            for (int i2 = 0; i2 < this._varNames.length; ++i2) {
                if (!this._varNames[i2].equals(string)) continue;
                this._lastValue[i2] = typedNumber;
                this._stddev[i2] = typedNumber2;
                if (!typedNumber.getType().equals("N")) continue;
                int n2 = i2;
                this._itemCount[n2] = this._itemCount[n2] + 1;
                if (this._lastValue[i2].largerThan(this._max[i2])) {
                    this._max[i2] = this._lastValue[i2];
                }
                if (this._lastValue[i2].smallerThan(this._min[i2])) {
                    this._min[i2] = this._lastValue[i2];
                }
                this._total[i2].setType("N");
                this._average[i2].setType("N");
                this._total[i2].add(this._lastValue[i2]);
                this._average[i2] = this._total[i2].divide(this._itemCount[i2]);
            }
            this.fireTableDataChanged();
        }

        public void update(String[] stringArray, TypedNumber[] typedNumberArray, TypedNumber[] typedNumberArray2) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.update(stringArray[i2], typedNumberArray[i2], typedNumberArray2[i2]);
            }
        }

        public void setPaused(boolean bl2) {
            this._isPaused = bl2;
        }
    }

    private static class StatisticTableCellRenderer
    extends DefaultTableCellRenderer {
        private Paint[] _paints;

        public StatisticTableCellRenderer(Paint[] paintArray) {
            this._paints = paintArray;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            component.setBackground((Color)this._paints[n2]);
            if (bl2 || bl3) {
                component.setForeground(Color.BLACK);
            } else {
                component.setForeground(Color.WHITE);
            }
            return component;
        }
    }

    private static class TypedNumber
    extends Number {
        public static final String NON_NUMBER = "N/A";
        private static final NumberFormat _format = NumberFormat.getNumberInstance();
        private Double _value;
        private String _type;
        private String _errorText;
        private String _thresholdState;
        private int _periodIndex = -1;

        public TypedNumber(double d10, String string, String string2, String string3, int n2) {
            this._value = new Double(d10);
            this._type = string;
            this._errorText = string2;
            this._thresholdState = string3;
            this._periodIndex = n2;
        }

        public static TypedNumber getZero() {
            return new TypedNumber(0.0, "U", null, null, -1);
        }

        @Override
        public double doubleValue() {
            return this._value;
        }

        @Override
        public float floatValue() {
            return this._value.floatValue();
        }

        @Override
        public int intValue() {
            return this._value.intValue();
        }

        @Override
        public long longValue() {
            return this._value.longValue();
        }

        public boolean largerThan(TypedNumber typedNumber) {
            return this._value > typedNumber.doubleValue();
        }

        public boolean smallerThan(TypedNumber typedNumber) {
            return this._value < typedNumber.doubleValue();
        }

        public void add(TypedNumber typedNumber) {
            this._value = new Double(this._value + typedNumber.doubleValue());
        }

        public TypedNumber divide(int n2) {
            return new TypedNumber(this._value / (double)n2, "N", this._errorText, this._thresholdState, this._periodIndex);
        }

        public String getType() {
            return this._type;
        }

        public void setType(String string) {
            this._type = string;
        }

        public String getErrorText() {
            return this._errorText;
        }

        public void setValue(double d10) {
            this._value = new Double(d10);
        }

        public String getValue() {
            if (this._type.equals("N")) {
                return _format.format(this.doubleValue());
            }
            return NON_NUMBER;
        }

        public String getThresholdState() {
            return this._thresholdState;
        }

        public boolean isStddevAvailable() {
            if (this._periodIndex == -1) {
                return false;
            }
            return "N".equals(this._type);
        }

        public String toString() {
            return this.getValue();
        }

        static {
            _format.setMaximumFractionDigits(3);
            _format.setGroupingUsed(false);
        }
    }

    private static class ThresholdRenderer
    extends XYLineAndShapeRenderer {
        private ThresholdRenderer() {
        }

        public Shape getItemShape(int n2, int n3) {
            Line2D.Float float_ = new Line2D.Float(-5.0f, 0.0f, 5.0f, 0.0f);
            return ShapeUtilities.createLineRegion((Line2D)float_, (float)1.0f);
        }

        public Paint getItemPaint(int n2, int n3) {
            return Color.RED;
        }
    }

    private static class GraphQueryInfo
    implements IGraphQueryInfo {
        private int _scheduleID;
        private List _singlePerformanceList;

        public GraphQueryInfo(int n2, List list) {
            this._scheduleID = n2;
            this._singlePerformanceList = list;
        }

        @Override
        public int getScheduleID() {
            return this._scheduleID;
        }

        @Override
        public List getSinglePerformanceList() {
            return this._singlePerformanceList;
        }
    }
}

