/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FixedThreshold;
import com.sysuptime.common.performance.MetricsTimebucket;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.MetricsTimebucketTableCell;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MetricsTimebucketDialog
extends OperationDialog {
    private String[] _columns;
    private JTable _metricsTimebucketTable;
    private ReadOnlyTableModel _metricsTimebucketModel;
    private String _localeMetrics;
    private boolean _isClearAlarm;
    private List _metricsTimebucketList;
    private String _unit;

    public MetricsTimebucketDialog(Dialog dialog, String string, boolean bl2, List list, String string2, String string3, boolean bl3) {
        super(dialog, string, bl2);
        this.initMetricsTimebucket(list, string2, string3, bl3);
        this.initComponents();
        this.initUserData();
    }

    private void initMetricsTimebucket(List list, String string, String string2, boolean bl2) {
        this._metricsTimebucketList = list;
        this._localeMetrics = string;
        this._isClearAlarm = bl2;
        this._unit = string2;
        this._columns = !this._isClearAlarm ? this.getArmColumns() : this.getRearmColumns();
    }

    private String[] getArmColumns() {
        String[] stringArray = new String[6];
        stringArray[0] = DialogConstants.LABEL_NAME;
        for (int i2 = 1; i2 <= 5; ++i2) {
            stringArray[i2] = ITrapConstants.SEVERITY_STRINGS[i2 - 1];
        }
        return stringArray;
    }

    private String[] getRearmColumns() {
        return new String[]{DialogConstants.LABEL_NAME, DialogConstants.LABEL_THRESHOLD};
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getOperationPanel(false, false), "East");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._metricsTimebucketModel = new ReadOnlyTableModel(null, this._columns);
        this._metricsTimebucketTable = SwingUtil.createJTable(this._metricsTimebucketModel);
        PerformanceUIUtil.setGraceHeader(this._metricsTimebucketTable);
        this._metricsTimebucketTable.setSelectionMode(0);
        this._metricsTimebucketTable.setPreferredScrollableViewportSize(new Dimension(500, 100));
        int n2 = this._columns.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            this._metricsTimebucketTable.getColumnModel().getColumn(i2).setCellRenderer(new ThresholdRenderer());
        }
        JScrollPane jScrollPane = new JScrollPane(this._metricsTimebucketTable);
        panelBuilder.add((Component)jScrollPane, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        this.initTable();
        this.initButtons();
    }

    private void initTable() {
        int n2 = this._metricsTimebucketList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MetricsTimebucket metricsTimebucket = (MetricsTimebucket)this._metricsTimebucketList.get(i2);
            Object[] objectArray = new Object[this._columns.length];
            objectArray[0] = metricsTimebucket.getTimebucketName();
            int n3 = metricsTimebucket.getThresholdListSize();
            for (int i3 = 0; i3 < n3; ++i3) {
                FixedThreshold fixedThreshold = metricsTimebucket.getThreshold(i3);
                short s2 = fixedThreshold.getSeverityId();
                if (this._isClearAlarm != fixedThreshold.isClearAlarm()) continue;
                short s3 = fixedThreshold.getFixedConditionId();
                MetricsTimebucketTableCell metricsTimebucketTableCell = new MetricsTimebucketTableCell(s3, DialogConstants.COMBOBOX_FIXED_CONDITION[s3], fixedThreshold.getFixedThreshold());
                objectArray[s2 + 1] = metricsTimebucketTableCell;
            }
            this._metricsTimebucketModel.addRow(objectArray);
        }
    }

    private void initButtons() {
        if (this._isClearAlarm) {
            this.getAddButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
        }
    }

    @Override
    protected void addItem() {
        DialogProvider.createFixedThresholdDialog(this, DialogConstants.BUTTON_NEW, this._metricsTimebucketModel, -1, this._localeMetrics, this._unit, this._isClearAlarm);
    }

    @Override
    protected void removeItem() {
        int n2 = this._metricsTimebucketTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            this.removeRow(n2);
        }
    }

    private void removeRow(int n2) {
        PerformanceUIUtil.removeRow(this._metricsTimebucketTable, this._metricsTimebucketModel, n2);
    }

    @Override
    protected void modifyItem() {
        int n2 = this._metricsTimebucketTable.getSelectedRow();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.MESSAGE_ONE_ROW, n2, SelectionValidator.CLASS);
        if (object != null) {
            DialogProvider.createFixedThresholdDialog(this, DialogConstants.BUTTON_MODIFY, this._metricsTimebucketModel, n2, this._localeMetrics, this._unit, this._isClearAlarm);
        }
    }

    @Override
    protected void okDialog() {
        this.resetMetricsTimebucket();
        this.dispose();
    }

    private void resetMetricsTimebucket() {
        if (!this._isClearAlarm) {
            this._metricsTimebucketList.clear();
        } else {
            this.removeRearmTimebucket();
        }
        this.addNewTimebucketList();
    }

    private void removeRearmTimebucket() {
        int n2 = this._metricsTimebucketList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MetricsTimebucket metricsTimebucket = (MetricsTimebucket)this._metricsTimebucketList.get(i2);
            metricsTimebucket.removeThresholds(true);
        }
    }

    private void addNewTimebucketList() {
        Hashtable hashtable = MonitorBroker.getTimebucketNameToObject();
        int n2 = this._metricsTimebucketList.size();
        int n3 = this._metricsTimebucketModel.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            MetricsTimebucket metricsTimebucket = null;
            metricsTimebucket = n2 == 0 ? TargetFactory.getMetricsTimebucket() : (MetricsTimebucket)this._metricsTimebucketList.get(i2);
            String string = (String)this._metricsTimebucketModel.getValueAt(i2, 0);
            metricsTimebucket.setTimebucketName(string);
            metricsTimebucket.setTimebucketId(((Timebucket)hashtable.get(string)).getTimebucketId());
            for (int i3 = 1; i3 < this._columns.length; ++i3) {
                Object object = this._metricsTimebucketModel.getValueAt(i2, i3);
                if (!(object instanceof MetricsTimebucketTableCell)) continue;
                FixedThreshold fixedThreshold = TargetFactory.getFixedThreshold();
                MetricsTimebucketTableCell metricsTimebucketTableCell = (MetricsTimebucketTableCell)object;
                fixedThreshold.setFixedConditionId(metricsTimebucketTableCell.getConditionId());
                fixedThreshold.setFixedThreshold(metricsTimebucketTableCell.getThreshold());
                fixedThreshold.setClearAlarm(this._isClearAlarm);
                fixedThreshold.setSeverityId((short)(i3 - 1));
                metricsTimebucket.addThreshold(fixedThreshold);
            }
            if (n2 != 0) continue;
            this._metricsTimebucketList.add(metricsTimebucket);
        }
    }

    private class ThresholdRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (object instanceof MetricsTimebucketTableCell) {
                MetricsTimebucketTableCell metricsTimebucketTableCell = (MetricsTimebucketTableCell)object;
                StringBuffer stringBuffer = new StringBuffer(metricsTimebucketTableCell.getCondition());
                stringBuffer.append(" '").append(metricsTimebucketTableCell.getThreshold()).append("'");
                this.setText(stringBuffer.toString());
            } else {
                this.setText("");
            }
            this.setOpaque(true);
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }
}

