/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.PerformanceGraph;
import com.sysuptime.common.performance.PerformanceGraph$ResultType;
import com.sysuptime.common.performance.SinglePerformance;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.performance.MonitorGraphComponent;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.openide.util.NbBundle;

public class MetricsChooser
extends JDialog
implements ActionListener {
    private Monitor _monitor;
    private PerformanceGraph _scheduleInfo;
    private JTree _metricTree;
    private JButton _okButton;
    private JButton _cancelButton;

    public MetricsChooser(JDialog jDialog, PerformanceGraph performanceGraph, Monitor monitor) {
        super(jDialog, NbBundle.getMessage(MetricsChooser.class, (String)"MetricsChooser_title"), true);
        this._monitor = monitor;
        this._scheduleInfo = performanceGraph;
        this.init();
    }

    public void init() {
        Container container = this.getContentPane();
        container.add((Component)this.createTreePanel(), "Center");
        container.add((Component)this.createOKPanel(), "South");
    }

    public JScrollPane createTreePanel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(NbBundle.getMessage(MetricsChooser.class, (String)"MetricsChooser_treeRoot"));
        List list = this._scheduleInfo.getHosts();
        List list2 = this._scheduleInfo.getResultTypes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MonitorHost monitorHost = (MonitorHost)list.get(i2);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new Host(monitorHost));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                PerformanceGraph$ResultType performanceGraph$ResultType = (PerformanceGraph$ResultType)list2.get(i3);
                int n2 = performanceGraph$ResultType.getResultType();
                boolean bl2 = performanceGraph$ResultType.hasStddev();
                String string = MonitorHelper.getConstantLocaleName(n2);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new Type(n2, bl2, string));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        this._metricTree = SwingUtil.createJTree(defaultMutableTreeNode);
        SwingUtil.setTreeLeafIcon(this._metricTree);
        SwingUtil.expandAllJTree(this._metricTree, true);
        TreeSelectionModel treeSelectionModel = this._metricTree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(new MetricsTreeSelectionListener(treeSelectionModel));
        return new JScrollPane(this._metricTree);
    }

    public JPanel createOKPanel() {
        this._okButton = new JButton(ICommonBundle.OK);
        this._cancelButton = new JButton(ICommonBundle.CANCEL);
        this._okButton.setPreferredSize(new Dimension(70, 25));
        this._cancelButton.setPreferredSize(new Dimension(70, 25));
        this._okButton.addActionListener(this);
        this._cancelButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        return jPanel;
    }

    public void showOut() {
        this.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._okButton) {
            this.doOk();
        } else if (object == this._cancelButton) {
            this.dispose();
        }
    }

    private void doOk() {
        List list = this.getSelectedMetrics();
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(this, NbBundle.getMessage(this.getClass(), (String)"MetricsChooser_selectionPrompt"));
            return;
        }
        MonitorGraphComponent monitorGraphComponent = new MonitorGraphComponent(this._monitor, list);
        Startup.addGraphTab(monitorGraphComponent);
        this.dispose();
    }

    public List getSelectedMetrics() {
        ArrayList<SinglePerformance> arrayList = new ArrayList<SinglePerformance>();
        TreePath[] treePathArray = this._metricTree.getSelectionPaths();
        if (treePathArray != null) {
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i2].getLastPathComponent();
                if (!defaultMutableTreeNode.isLeaf()) continue;
                Type type = (Type)defaultMutableTreeNode.getUserObject();
                int n2 = type.getResultType();
                boolean bl2 = type.hasStddev();
                Host host = (Host)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject();
                arrayList.add(new SinglePerformance(host.getMonitorHost(), new PerformanceGraph$ResultType(n2, bl2)));
            }
        }
        return arrayList;
    }

    private static class Host {
        private MonitorHost _monitorHost;

        public Host(MonitorHost monitorHost) {
            this._monitorHost = monitorHost;
        }

        public MonitorHost getMonitorHost() {
            return this._monitorHost;
        }

        public String toString() {
            return this._monitorHost.getIpAddress();
        }
    }

    private class Type {
        private int _resultType;
        private boolean _hasStddev;
        private String _typeString;

        public Type(int n2, boolean bl2, String string) {
            this._resultType = n2;
            this._hasStddev = bl2;
            this._typeString = string;
        }

        public int getResultType() {
            return this._resultType;
        }

        public boolean hasStddev() {
            return this._hasStddev;
        }

        public String toString() {
            return this._typeString;
        }
    }

    private static class MetricsTreeSelectionListener
    implements TreeSelectionListener {
        private TreeSelectionModel _model;

        public MetricsTreeSelectionListener(TreeSelectionModel treeSelectionModel) {
            this._model = treeSelectionModel;
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = treeSelectionEvent.getPaths();
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                TreeNode treeNode;
                if (!treeSelectionEvent.isAddedPath(i2) || (treeNode = (TreeNode)treePathArray[i2].getLastPathComponent()).isLeaf()) continue;
                this._model.removeSelectionPath(treePathArray[i2]);
            }
        }
    }
}

