/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.graph.SelectIpDialog;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConciseMonitorCreatorFactory;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.ITreeElement;
import com.sysuptime.mainframe.performance.MonitorDialog;
import com.sysuptime.mainframe.performance.MonitorWizardElement;
import com.sysuptime.mainframe.performance.TreeElementDelegate;
import com.sysuptime.mainframe.performance.XmlNodeElement;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public class GraphMonitorUtil {
    private static Map _serviceMap = null;
    private static Map _wizardMonitorMap = null;

    private static boolean isSnmpMonitor(ServiceNameElement serviceNameElement) {
        String string = "";
        if (serviceNameElement != null) {
            string = (String)_serviceMap.get(serviceNameElement.getLocale());
        }
        return "SNMP".equalsIgnoreCase(string);
    }

    public static void createNewScheduleDialog(ServiceNameElement serviceNameElement, String string, ReadCommunity readCommunity) {
        Monitor monitor = TargetFactory.getSchedule();
        MonitorDialog monitorDialog = new MonitorDialog(DialogConstants.BUTTON_NEW + serviceNameElement.getLocale(), serviceNameElement, monitor, string, readCommunity);
        SwingUtil.centerOnScreen(monitorDialog);
        monitorDialog.setVisible(true);
    }

    public static JMenu getPopupMonitorMenu(String string, NetworkNodeBean networkNodeBean) {
        JMenu jMenu = (JMenu)new PopupMonitorMenu(networkNodeBean).getRootNode();
        GraphMonitorUtil.addConciseMonitorMenu(jMenu, networkNodeBean);
        jMenu.setText(string);
        return jMenu;
    }

    private static void addConciseMonitorMenu(JMenu jMenu, NetworkNodeBean networkNodeBean) {
        int n2 = 0;
        for (Object v2 : _wizardMonitorMap.values()) {
            MonitorWizardElement monitorWizardElement = (MonitorWizardElement)v2;
            List list = monitorWizardElement.getAllDeviceName();
            Collections.sort(list);
            JMenu jMenu2 = new JMenu(Snippet.getBundledString(monitorWizardElement.getServiceName()));
            int n3 = list.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                String string = (String)list.get(i2);
                String string2 = monitorWizardElement.getClassName(string);
                JMenuItem jMenuItem = new JMenuItem(new WizardMonitorAction(networkNodeBean, string2));
                jMenuItem.setText(Snippet.getBundledString(string));
                jMenu2.add(jMenuItem);
            }
            jMenu.add((Component)jMenu2, n2++);
        }
        jMenu.add((Component)new JSeparator(), n2++);
    }

    static {
        _serviceMap = MonitorHelper.getServiceLocaleToName();
        _wizardMonitorMap = MonitorHelper.getWizardMonitorMap();
    }

    private static class PopupMonitorMenu
    implements ITreeElement {
        private NetworkNodeBean _bean;
        private List _wizardMonitorServiceFamilyList;

        public PopupMonitorMenu(NetworkNodeBean networkNodeBean) {
            this._bean = networkNodeBean;
            this._wizardMonitorServiceFamilyList = new ArrayList();
            for (Object v2 : _wizardMonitorMap.values()) {
                MonitorWizardElement monitorWizardElement = (MonitorWizardElement)v2;
                this._wizardMonitorServiceFamilyList.add(Snippet.getBundledString(monitorWizardElement.getServiceName()));
            }
        }

        @Override
        public Object getLeafNode(ServiceNameElement serviceNameElement) {
            MonitorAction monitorAction = new MonitorAction(serviceNameElement, this._bean);
            if (GraphMonitorUtil.isSnmpMonitor(serviceNameElement)) {
                monitorAction.setEnabled(this._bean.isSnmpEnabled());
            }
            return new JMenuItem(monitorAction);
        }

        @Override
        public void addNode(Object object, Object object2) {
            String string = ((JMenuItem)object2).getText();
            if (this._wizardMonitorServiceFamilyList.contains(string)) {
                return;
            }
            ((JMenu)object).add((JMenuItem)object2);
        }

        @Override
        public Object getNode(XmlNodeElement xmlNodeElement) {
            return new JMenu(xmlNodeElement.toString());
        }

        @Override
        public Object getRootNode() {
            return new TreeElementDelegate(this).getRootNode();
        }
    }

    private static class WizardMonitorAction
    extends AbstractAction {
        private String _className;
        private NetworkNodeBean _node;

        public WizardMonitorAction(NetworkNodeBean networkNodeBean, String string) {
            this._node = networkNodeBean;
            this._className = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l2 = Long.parseLong(this._node.getCustomerID());
            if (!ClientProxy.getInstance().isActive(l2)) {
                return;
            }
            try {
                ConciseMonitorCreatorFactory.getInstance().createConciseMonitor(this._node, this._className);
            }
            catch (Exception exception) {
                Logger.getLogger(WizardMonitorAction.class).error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private static class MonitorAction
    extends AbstractAction {
        private ServiceNameElement _element;
        private NetworkNodeBean _bean;

        public MonitorAction(ServiceNameElement serviceNameElement, NetworkNodeBean networkNodeBean) {
            super(serviceNameElement.getLocale());
            this._element = serviceNameElement;
            this._bean = networkNodeBean;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l2 = Long.parseLong(this._bean.getCustomerID());
            if (!ClientProxy.getInstance().isActive(l2)) {
                return;
            }
            if (Startup.isMaster()) {
                ClientProxy.getInstance().setProbe(Startup.getProbeById(l2));
            }
            String[] stringArray = this._bean.getAllIpAddress();
            ReadCommunity readCommunity = this._bean.getReadCommunity();
            if (stringArray != null) {
                if (stringArray.length == 1 || MonitorHelper.isLocalSingleHost(this._element)) {
                    GraphMonitorUtil.createNewScheduleDialog(this._element, stringArray[0], readCommunity);
                } else if (stringArray.length > 1) {
                    SelectIpDialog selectIpDialog = new SelectIpDialog(this._element, readCommunity, stringArray);
                    selectIpDialog.showOut();
                }
            }
        }
    }
}

