/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FormImportDialog
extends ConfirmDialog {
    private static final String TITLE = _bundle.getString("title_formimport");
    private static final String LABEL_ACTION = _bundle.getString("label_action");
    private static final String LABEL_FILE = _bundle.getString("label_file");
    private static final String MESSAGE_FILE_NOT_FOUND = _bundle.getString("message_filenotfound");
    private JTextField _action;
    private JTextField _file;
    private JButton _browse;

    public FormImportDialog(JDialog jDialog, boolean bl2) {
        super(jDialog, TITLE, bl2);
        this.initComponent();
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g,3dlu,p", "p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(LABEL_ACTION, cellConstraints.xy(1, 1));
        this._action = new JTextField();
        this._action.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._action, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(LABEL_FILE, cellConstraints.xy(1, 3));
        this._file = new JTextField();
        this._file.setPreferredSize(DialogConstants.URL_SIZE);
        panelBuilder.add((Component)this._file, cellConstraints.xy(3, 3));
        this._browse = new JButton(DialogConstants.BUTTON_IMPORT);
        this._browse.addActionListener(new BrowseAction());
        panelBuilder.add((Component)this._browse, cellConstraints.xy(5, 3));
        return panelBuilder.getPanel();
    }

    private void doBrowse() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        if (jFileChooser.showOpenDialog(this) == 0) {
            this._file.setText(jFileChooser.getSelectedFile().getPath());
        }
    }

    public String getAction() {
        return this._action.getText();
    }

    public String getFilePath() {
        return this._file.getText();
    }

    @Override
    protected void okDialog() {
        Object object = SingletonValidator.checkAllDialog(this, LABEL_ACTION, this._action.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, LABEL_FILE, this._file.getText(), NonNullValidator.CLASS);
        if (object2 == null) {
            return;
        }
        File file = new File(this._file.getText());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, MESSAGE_FILE_NOT_FOUND);
            return;
        }
        this.dispose();
    }

    private class BrowseAction
    implements ActionListener {
        private BrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(FormImportDialog.this._browse)) {
                FormImportDialog.this.doBrowse();
            }
        }
    }
}

