/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.MessageParser;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.CommandVarProcessor;
import com.openapi.performance.DefaultProtocolDialog;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.DialogConstants;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class DirectoryDialog
extends DefaultProtocolDialog {
    private JTextField _dirComponent;
    private JButton _validator;
    private JLabel _checkMetricsLabel;
    private JComboBox _checkChangesBox;
    private JComboBox _checkMetricsBox;

    public DirectoryDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
        if (string.equalsIgnoreCase("directory")) {
            this.appendValidator(defaultFormBuilder, jComponent, string2);
        } else {
            JLabel jLabel = new JLabel(string2);
            if (string.equalsIgnoreCase("check_dir_changes")) {
                this._checkChangesBox = (JComboBox)jComponent;
                this._checkChangesBox.addItemListener(new CheckChangesItem());
            } else if (string.equalsIgnoreCase("check_metrics")) {
                this._checkMetricsLabel = jLabel;
                this._checkMetricsBox = (JComboBox)jComponent;
                this.setVisibleChanges(false);
            }
            defaultFormBuilder.append((Component)jLabel);
            defaultFormBuilder.append((Component)jComponent);
            defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
        }
        return n2;
    }

    private void appendValidator(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        this._dirComponent = (JTextField)jComponent;
        defaultFormBuilder.append(string);
        defaultFormBuilder.append((Component)this._dirComponent);
        this._validator = new JButton(_bundle.getString("checkpath"));
        this._validator.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._validator.addActionListener(new BrowseAction());
        defaultFormBuilder.append((Component)this._validator);
    }

    private void validatePath() {
        File file = new File(MessageParser.parseMessage(this._dirComponent.getText(), CommandVarProcessor.getVars()));
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_filedirexist"));
        } else {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_filedirnotexist"), "", 2);
        }
    }

    private void setVisibleChanges(boolean bl2) {
        this._checkMetricsLabel.setVisible(bl2);
        this._checkMetricsBox.setVisible(bl2);
    }

    private class CheckChangesItem
    implements ItemListener {
        private CheckChangesItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(DirectoryDialog.this._checkChangesBox)) {
                DirectoryDialog.this.setVisibleChanges(DirectoryDialog.this._checkChangesBox.getSelectedIndex() != 0);
            }
        }
    }

    private class BrowseAction
    implements ActionListener {
        private BrowseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(DirectoryDialog.this._validator)) {
                DirectoryDialog.this.validatePath();
            }
        }
    }
}

