/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.expression.Expression;
import com.sysuptime.common.expression.VarInfo;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.mainframe.expression.SnmpExpressionDialog;
import com.sysuptime.mainframe.performance.AbstractParameterDialog;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.LineTokenCell;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.RepetitionValidator;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.SwingUtil;
import gnu.jel.CompilationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.openide.util.NbBundle;

public class ContentMatchParameterDialog
extends AbstractParameterDialog {
    private QueryParameter _tmpParameters;
    private JComboBox _matchBox;
    private Expr _expr;
    private MultiCondition _multi;
    private SimpleContentMatch _simple;
    private static final int MULTI_VALUE = 0;
    private static final int MULTI_RELATION = 1;
    private static final int EXPR_VAR = 0;
    private static final int EXPR_VALUE = 1;
    private final String LINE = _bundle.getString("single_line");
    private final String TOKEN = _bundle.getString("token");
    private boolean _isStatus;
    private JCheckBox _isNumeric = new JCheckBox("Value is numeric");

    public ContentMatchParameterDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
    }

    public boolean isNumeric() {
        return this._isNumeric.isSelected();
    }

    @Override
    public void initParameter(int n2, QueryParameter queryParameter, ServiceNameElement serviceNameElement, String string, String string2) {
        this.initXmlData(n2, string2);
        this.initComponents();
        this.initBeforeUserData(serviceNameElement, string, string2);
        this.initUserData(queryParameter);
    }

    private void initXmlData(int n2, String string) {
        try {
            this._tmpParameters = MonitorHelper.getConfigThresholdParameterClass(n2, string);
        }
        catch (Exception exception) {
            this._logger.error((Object)("Can't find parameter by protocol id " + exception));
        }
    }

    private void initComponents() {
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 15, 1, 15));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._isNumeric, "West");
        container.add((Component)jPanel, "North");
        this._isNumeric.setSelected(true);
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g", "p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._matchBox = new JComboBox<String>(new String[]{_bundle.getString("jcombobox_simplecontentmatch"), _bundle.getString("jcomobobox_multicondition"), _bundle.getString("jcombobox_expression")});
        this._matchBox.setPreferredSize(DialogConstants.LONG_SIZE);
        this._matchBox.addItemListener(new ChangesItem());
        panelBuilder.add((Component)this._matchBox, cellConstraints.xy(1, 1));
        this._simple = new SimpleContentMatch();
        panelBuilder.add((Component)this._simple._panel, cellConstraints.xy(1, 3));
        this._multi = new MultiCondition();
        panelBuilder.add((Component)this._multi._panel, cellConstraints.xy(1, 5));
        this._expr = new Expr();
        panelBuilder.add((Component)this._expr._panel, cellConstraints.xy(1, 7));
        return panelBuilder.getPanel();
    }

    public LineTokenCell getMultiSelectedLineToken() {
        int n2 = this._multi._multiTable.getSelectedRow();
        return (LineTokenCell)this._multi._multiTable.getValueAt(n2, 0);
    }

    public Object[] getExprSelectedLineToken() {
        int n2 = this._expr._exprTable.getSelectedRow();
        return new Object[]{this._expr._exprTable.getValueAt(n2, 0), this._expr._exprTable.getValueAt(n2, 1)};
    }

    public void operateMulti(LineTokenCell lineTokenCell, boolean bl2) {
        if (bl2) {
            this._multi._multiModel.addRow(new Object[]{lineTokenCell, "0"});
        } else {
            int n2 = this._multi._multiTable.getSelectedRow();
            this._multi._multiModel.setValueAt(lineTokenCell, n2, 0);
        }
    }

    public void operateExpr(LineTokenCell lineTokenCell, String string, boolean bl2) {
        if (bl2) {
            this._expr._exprModel.addRow(new Object[]{string, lineTokenCell});
        } else {
            int n2 = this._expr._exprTable.getSelectedRow();
            this._expr._exprModel.setValueAt(lineTokenCell, n2, 1);
            this._expr._exprModel.setValueAt(string, n2, 0);
        }
    }

    public boolean isLappedExpr(String string, boolean bl2) {
        int n2;
        String string2;
        if (!bl2 && (string2 = (String)this._expr._exprTable.getValueAt(n2 = this._expr._exprTable.getSelectedRow(), 0)).equals(string)) {
            return false;
        }
        int n3 = this._expr._exprModel.getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!string.equals(this._expr._exprTable.getValueAt(n2, 0))) continue;
            return true;
        }
        return false;
    }

    private void initBeforeUserData(ServiceNameElement serviceNameElement, String string, String string2) {
    }

    private void initUserData(QueryParameter queryParameter) {
        if (queryParameter != null && queryParameter.getList().size() != 0) {
            int n2 = Integer.parseInt(ContentMatchParameterDialog.getParameterElement(queryParameter, 0, 0));
            this._matchBox.setSelectedIndex(n2);
            String string = ContentMatchParameterDialog.getParameterElement(queryParameter, 0, 1);
            this._isNumeric.setSelected("1".equals(string));
            if (n2 == 0) {
                int n3 = Integer.parseInt(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 0));
                if (n3 == 0) {
                    this._simple._lineRadio.setSelected(true);
                    this._simple._line.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 1));
                    this._simple._token.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 2));
                    this._simple._delimiter.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 3));
                } else if (n3 == 1) {
                    this._simple._wholeRadio.setSelected(true);
                } else if (n3 == 2) {
                    this._simple._lineContainsRadio.setSelected(true);
                    this._simple._lineContains.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 1));
                    this._simple._tokenContains.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 2));
                    this._simple._delimiterContains.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 3));
                } else if (n3 == 3) {
                    this._simple._jsonRadio.setSelected(true);
                    this._simple._jsonNodeName.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 1));
                    this._simple._jsonNodeValue.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 2));
                    this._simple._jsonTargetNode.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 3));
                } else if (n3 == 4) {
                    this._simple._htmlRadio.setSelected(true);
                    this._simple._htmlNodeName.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 1));
                    this._simple._htmlNodeValue.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 2));
                    this._simple._htmlNodeAttrName.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 3));
                    this._simple._htmlNodeAttrValue.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 4));
                    this._simple._htmlTargetNode.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 5));
                    this._simple._htmlTargetNodeAttrName.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 6));
                    this._simple._htmlTargetNodeAttrValue.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, 1, 7));
                }
            } else if (n2 == 1) {
                int n4 = queryParameter.size();
                for (int i2 = 1; i2 < n4; ++i2) {
                    List list = (List)queryParameter.get(i2);
                    this._multi._multiModel.addRow(new Object[]{new LineTokenCell(list.get(0).toString(), list.get(1).toString(), list.get(2).toString(), Integer.parseInt(list.get(3).toString()), list.get(4).toString()), Integer.valueOf(list.get(5).toString())});
                }
            } else {
                int n5 = queryParameter.size();
                for (int i3 = 1; i3 < n5 - 1; ++i3) {
                    List list = (List)queryParameter.get(i3);
                    this._expr._exprModel.addRow(new Object[]{list.get(0).toString(), new LineTokenCell(list.get(1).toString(), list.get(2).toString(), list.get(3).toString(), 0, null)});
                }
                this._expr._exprText.setText(ContentMatchParameterDialog.getParameterElement(queryParameter, n5 - 1, 0));
            }
        }
    }

    private static String getParameterElement(QueryParameter queryParameter, int n2, int n3) {
        List list = (List)queryParameter.get(n2);
        if (list.size() > n3) {
            return list.get(n3).toString();
        }
        return null;
    }

    @Override
    public QueryParameter getParameter() {
        return this._tmpParameters;
    }

    @Override
    protected void okDialog() {
        if (!this.checkContentMatch()) {
            return;
        }
        this.setContentMatch();
        this.dispose();
    }

    private void setContentMatch() {
        this._tmpParameters.clear();
        int n2 = this._matchBox.getSelectedIndex();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(n2));
        arrayList.add(this._isNumeric.isSelected() ? "1" : "0");
        this._tmpParameters.add(arrayList);
        if (n2 == 0) {
            if (this._simple._lineRadio.isSelected()) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(String.valueOf(0));
                arrayList2.add(this._simple._line.getText());
                arrayList2.add(this._simple._token.getText());
                arrayList2.add(this._simple._delimiter.getText());
                this._tmpParameters.add(arrayList2);
            } else if (this._simple._lineContainsRadio.isSelected()) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(String.valueOf(2));
                arrayList3.add(this._simple._lineContains.getText());
                arrayList3.add(this._simple._tokenContains.getText());
                arrayList3.add(this._simple._delimiterContains.getText());
                this._tmpParameters.add(arrayList3);
            } else if (this._simple._wholeRadio.isSelected()) {
                ArrayList<String> arrayList4 = new ArrayList<String>(1);
                arrayList4.add(String.valueOf(1));
                this._tmpParameters.add(arrayList4);
            } else if (this._simple._jsonRadio.isSelected()) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                arrayList5.add(String.valueOf(3));
                arrayList5.add(this._simple._jsonNodeName.getText().trim());
                arrayList5.add(this._simple._jsonNodeValue.getText().trim());
                arrayList5.add(this._simple._jsonTargetNode.getText().trim());
                this._tmpParameters.add(arrayList5);
            } else if (this._simple._htmlRadio.isSelected()) {
                ArrayList<String> arrayList6 = new ArrayList<String>();
                arrayList6.add(String.valueOf(4));
                arrayList6.add(this._simple._htmlNodeName.getText().trim());
                arrayList6.add(this._simple._htmlNodeValue.getText().trim());
                arrayList6.add(this._simple._htmlNodeAttrName.getText().trim());
                arrayList6.add(this._simple._htmlNodeAttrValue.getText().trim());
                arrayList6.add(this._simple._htmlTargetNode.getText().trim());
                arrayList6.add(this._simple._htmlTargetNodeAttrName.getText().trim());
                arrayList6.add(this._simple._htmlTargetNodeAttrValue.getText().trim());
                this._tmpParameters.add(arrayList6);
            }
        } else if (n2 == 1) {
            this._isStatus = true;
            int n3 = this._multi._multiModel.getRowCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                ArrayList<String> arrayList7 = new ArrayList<String>();
                LineTokenCell lineTokenCell = (LineTokenCell)this._multi._multiTable.getValueAt(i2, 0);
                arrayList7.add(lineTokenCell.getLine());
                arrayList7.add(lineTokenCell.getToken());
                arrayList7.add(lineTokenCell.getDelimiter());
                arrayList7.add(String.valueOf(lineTokenCell.getCondition()));
                arrayList7.add(lineTokenCell.getThreshold());
                arrayList7.add(String.valueOf(this._multi._multiTable.getValueAt(i2, 1)));
                this._tmpParameters.add(arrayList7);
            }
        } else {
            int n4 = this._expr._exprModel.getRowCount();
            for (int i3 = 0; i3 < n4; ++i3) {
                ArrayList<Object> arrayList8 = new ArrayList<Object>();
                arrayList8.add(this._expr._exprTable.getValueAt(i3, 0));
                LineTokenCell lineTokenCell = (LineTokenCell)this._expr._exprTable.getValueAt(i3, 1);
                arrayList8.add(lineTokenCell.getLine());
                arrayList8.add(lineTokenCell.getToken());
                arrayList8.add(lineTokenCell.getDelimiter());
                this._tmpParameters.add(arrayList8);
            }
            ArrayList<String> arrayList9 = new ArrayList<String>(1);
            arrayList9.add(this._expr._exprText.getText());
            this._tmpParameters.add(arrayList9);
        }
    }

    private boolean checkContentMatch() {
        int n2 = this._matchBox.getSelectedIndex();
        if (n2 == 0) {
            if (this._simple._lineRadio.isSelected()) {
                Object object = SingletonValidator.checkAllDialog(this, this.LINE, this._simple._line.getText(), RepetitionValidator.CLASS);
                if (object == null) {
                    return false;
                }
                Object object2 = SingletonValidator.checkAllDialog(this, this.TOKEN, this._simple._token.getText(), RepetitionValidator.CLASS);
                if (object2 == null) {
                    return false;
                }
            }
        } else if (n2 == 1) {
            if (this._multi._multiModel.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, _bundle.getString("message_nonnullmultitable"));
                return false;
            }
        } else {
            if (this._expr._exprModel.getRowCount() == 0) {
                JOptionPane.showMessageDialog(this, _bundle.getString("message_nonnullexprtable"));
                return false;
            }
            Object object = SingletonValidator.checkAllDialog(this, _bundle.getString("label_expression"), this._expr._exprText.getText(), NonNullValidator.CLASS);
            if (object == null) {
                return false;
            }
            Expression expression = new Expression("", this._expr._exprText.getText(), "");
            int n3 = this._expr._exprModel.getRowCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                VarInfo varInfo = new VarInfo((String)this._expr._exprTable.getValueAt(i2, 0), "");
                varInfo.setOidValue(1.0);
                expression.addVar(varInfo);
            }
            try {
                expression.getResult();
            }
            catch (CompilationException compilationException) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(SnmpExpressionDialog.class, (String)"MSG_varinfo_syntax_error") + "\n" + compilationException.getMessage());
                return false;
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, NbBundle.getMessage(SnmpExpressionDialog.class, (String)"MSG_varinfo_syntax_error"));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isStatus() {
        return this._isStatus;
    }

    private class ChangesItem
    implements ItemListener {
        private ChangesItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(ContentMatchParameterDialog.this._matchBox)) {
                int n2 = ContentMatchParameterDialog.this._matchBox.getSelectedIndex();
                if (n2 == 0) {
                    ContentMatchParameterDialog.this._simple._panel.setVisible(true);
                    ContentMatchParameterDialog.this._multi._panel.setVisible(false);
                    ContentMatchParameterDialog.this._expr._panel.setVisible(false);
                } else if (n2 == 1) {
                    ContentMatchParameterDialog.this._simple._panel.setVisible(false);
                    ContentMatchParameterDialog.this._multi._panel.setVisible(true);
                    ContentMatchParameterDialog.this._expr._panel.setVisible(false);
                } else {
                    ContentMatchParameterDialog.this._simple._panel.setVisible(false);
                    ContentMatchParameterDialog.this._multi._panel.setVisible(false);
                    ContentMatchParameterDialog.this._expr._panel.setVisible(true);
                }
                ContentMatchParameterDialog.this.setSize(ContentMatchParameterDialog.this.getPreferredSize());
            }
        }
    }

    private class SimpleContentMatch {
        JPanel _panel;
        JRadioButton _wholeRadio;
        JRadioButton _lineRadio;
        JRadioButton _jsonRadio;
        JRadioButton _lineContainsRadio;
        JRadioButton _htmlRadio;
        JTextField _line;
        JTextField _token;
        JTextField _delimiter;
        JTextField _lineContains = new JTextField();
        JTextField _tokenContains = new JTextField("-1");
        JTextField _delimiterContains = new JTextField("$whitespace");
        JTextField _jsonNodeName = new JTextField();
        JTextField _jsonNodeValue = new JTextField();
        JTextField _jsonTargetNode = new JTextField();
        JTextField _htmlNodeName = new JTextField();
        JTextField _htmlNodeValue = new JTextField();
        JTextField _htmlNodeAttrName = new JTextField();
        JTextField _htmlNodeAttrValue = new JTextField();
        JTextField _htmlTargetNode = new JTextField();
        JTextField _htmlTargetNodeAttrName = new JTextField();
        JTextField _htmlTargetNodeAttrValue = new JTextField();

        public SimpleContentMatch() {
            FormLayout formLayout = new FormLayout("p,3dlu,p,3dlu,p,3dlu,FILL:80DLU:GROW,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(null);
            CellConstraints cellConstraints = new CellConstraints();
            this._wholeRadio = new JRadioButton("<html><b>" + ConfirmDialog._bundle.getString("jradiobutton_wholecontent") + "</b></html>", true);
            panelBuilder.add((Component)this._wholeRadio, cellConstraints.xy(1, 1));
            panelBuilder.addSeparator("", cellConstraints.xywh(3, 1, 5, 1));
            this._lineRadio = new JRadioButton("<html><b>Line number:</b></html>");
            ButtonGroup buttonGroup = new ButtonGroup();
            this._jsonRadio = new JRadioButton("<html><b>JSON format</b></html>");
            this._htmlRadio = new JRadioButton("<html><b>HTML/XML format</b></html>");
            this._lineContainsRadio = new JRadioButton("<html><b>Line contains:</b></html>");
            buttonGroup.add(this._wholeRadio);
            buttonGroup.add(this._lineRadio);
            buttonGroup.add(this._jsonRadio);
            buttonGroup.add(this._lineContainsRadio);
            buttonGroup.add(this._htmlRadio);
            panelBuilder.add((Component)this._lineRadio, cellConstraints.xy(1, 3));
            this._line = new JTextField("-1");
            this._line.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_line_tooltip"));
            this._line.setPreferredSize(DialogConstants.LONG_SIZE);
            panelBuilder.add((Component)this._line, cellConstraints.xy(3, 3));
            panelBuilder.addSeparator("", cellConstraints.xywh(5, 3, 3, 1));
            panelBuilder.addLabel(ConfirmDialog._bundle.getString("token") + DialogConstants.LABEL_ISOPTIONAL, cellConstraints.xy(1, 5));
            this._token = new JTextField("-1");
            this._token.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_token_tooltip"));
            this._token.setPreferredSize(DialogConstants.LONG_SIZE);
            panelBuilder.add((Component)this._token, cellConstraints.xy(3, 5));
            panelBuilder.addLabel(ConfirmDialog._bundle.getString("delimiter"), cellConstraints.xy(1, 7));
            this._delimiter = new JTextField("$whitespace");
            this._delimiter.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
            this._delimiter.setPreferredSize(DialogConstants.LONG_SIZE);
            this._delimiter.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
            panelBuilder.add((Component)this._delimiter, cellConstraints.xy(3, 7));
            panelBuilder.add((Component)this._lineContainsRadio, cellConstraints.xy(1, 9));
            this._lineContains.setToolTipText("Enter the string the line must contain");
            this._lineContains.setPreferredSize(DialogConstants.LONG_SIZE);
            panelBuilder.add((Component)this._lineContains, cellConstraints.xy(3, 9));
            panelBuilder.addSeparator("", cellConstraints.xywh(5, 9, 3, 1));
            panelBuilder.addLabel(ConfirmDialog._bundle.getString("token") + DialogConstants.LABEL_ISOPTIONAL, cellConstraints.xy(1, 11));
            this._tokenContains.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_token_tooltip"));
            this._tokenContains.setPreferredSize(DialogConstants.LONG_SIZE);
            panelBuilder.add((Component)this._tokenContains, cellConstraints.xy(3, 11));
            panelBuilder.addLabel(ConfirmDialog._bundle.getString("delimiter"), cellConstraints.xy(1, 13));
            this._delimiterContains.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
            this._delimiterContains.setPreferredSize(DialogConstants.LONG_SIZE);
            this._delimiterContains.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
            panelBuilder.add((Component)this._delimiterContains, cellConstraints.xy(3, 13));
            panelBuilder.add((Component)this._jsonRadio, cellConstraints.xy(1, 15));
            panelBuilder.addSeparator("", cellConstraints.xywh(3, 15, 5, 1));
            panelBuilder.addLabel("After node with name:", cellConstraints.xy(1, 17));
            panelBuilder.add((Component)this._jsonNodeName, cellConstraints.xy(3, 17));
            panelBuilder.addLabel("and value:", cellConstraints.xy(5, 17));
            panelBuilder.add((Component)this._jsonNodeValue, cellConstraints.xy(7, 17));
            panelBuilder.addLabel("Use value of node with name:", cellConstraints.xy(1, 19));
            panelBuilder.add((Component)this._jsonTargetNode, cellConstraints.xy(3, 19));
            panelBuilder.add((Component)this._htmlRadio, cellConstraints.xy(1, 21));
            panelBuilder.addSeparator("", cellConstraints.xywh(3, 21, 5, 1));
            panelBuilder.addLabel("After node with name:", cellConstraints.xy(1, 23));
            panelBuilder.add((Component)this._htmlNodeName, cellConstraints.xy(3, 23));
            panelBuilder.addLabel("and value:", cellConstraints.xy(5, 23));
            panelBuilder.add((Component)this._htmlNodeValue, cellConstraints.xy(7, 23));
            panelBuilder.addLabel("and attribute name:", cellConstraints.xy(1, 25));
            panelBuilder.add((Component)this._htmlNodeAttrName, cellConstraints.xy(3, 25));
            panelBuilder.addLabel("attribute value:", cellConstraints.xy(5, 25));
            panelBuilder.add((Component)this._htmlNodeAttrValue, cellConstraints.xy(7, 25));
            panelBuilder.addLabel("Use value of node with name:", cellConstraints.xy(1, 27));
            panelBuilder.add((Component)this._htmlTargetNode, cellConstraints.xy(3, 27));
            panelBuilder.addLabel("and attribute name:", cellConstraints.xy(1, 29));
            panelBuilder.add((Component)this._htmlTargetNodeAttrName, cellConstraints.xy(3, 29));
            panelBuilder.addLabel("attribute value:", cellConstraints.xy(5, 29));
            panelBuilder.add((Component)this._htmlTargetNodeAttrValue, cellConstraints.xy(7, 29));
            this._panel = panelBuilder.getPanel();
        }

        public void setVisible(boolean bl2) {
            this._panel.setVisible(bl2);
        }
    }

    private class MultiCondition
    implements ActionListener {
        JPanel _panel;
        ReadOnlyTableModel _multiModel;
        JTable _multiTable;
        JButton _add;
        JButton _modify;
        JButton _remove;

        public MultiCondition() {
            FormLayout formLayout = new FormLayout("p:g,3dlu,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p:g");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(null);
            CellConstraints cellConstraints = new CellConstraints();
            this._multiModel = new ReadOnlyTableModel(null, new String[]{ConfirmDialog._bundle.getString("column_value"), ConfirmDialog._bundle.getString("column_relation")}){

                @Override
                public boolean isCellEditable(int n2, int n3) {
                    return n3 != 0;
                }
            };
            this._multiTable = SwingUtil.createJTable(this._multiModel);
            TableColumnModel tableColumnModel = this._multiTable.getColumnModel();
            tableColumnModel.getColumn(0).setCellRenderer(new LineTokenRenderer());
            tableColumnModel.getColumn(1).setCellRenderer(new RelationRenderer(new String[]{ConfirmDialog._bundle.getString("and"), ConfirmDialog._bundle.getString("or")}));
            tableColumnModel.getColumn(1).setCellEditor(new RelationEditor(new String[]{ConfirmDialog._bundle.getString("and"), ConfirmDialog._bundle.getString("or")}));
            PerformanceUIUtil.setGraceHeader(this._multiTable);
            this._multiTable.setSelectionMode(0);
            this._multiTable.setMinimumSize(DialogConstants.VIEW_XLONG_SIZE);
            this._multiTable.setPreferredScrollableViewportSize(DialogConstants.VIEW_XLONG_SIZE);
            panelBuilder.add((Component)new JLabel(ConfirmDialog._bundle.getString("generate_alarm_multi")), cellConstraints.xy(1, 1));
            JScrollPane jScrollPane = new JScrollPane(this._multiTable);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 3, 1, 7));
            this._add = new JButton(DialogConstants.BUTTON_NEW);
            this._add.addActionListener(this);
            panelBuilder.add((Component)this._add, cellConstraints.xy(3, 3));
            this._modify = new JButton(DialogConstants.BUTTON_MODIFY);
            this._modify.addActionListener(this);
            panelBuilder.add((Component)this._modify, cellConstraints.xy(3, 5));
            this._remove = new JButton(DialogConstants.BUTTON_REMOVE);
            this._remove.addActionListener(this);
            panelBuilder.add((Component)this._remove, cellConstraints.xy(3, 7));
            this._panel = panelBuilder.getPanel();
            this._panel.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            Object object;
            Object object2 = actionEvent.getSource();
            if (object2.equals(this._add)) {
                DialogProvider.createMultiConditionDialog(ContentMatchParameterDialog.this, DialogConstants.BUTTON_NEW, true);
            } else if (object2.equals(this._modify)) {
                int n3 = this._multiTable.getSelectedRow();
                Object object3 = SingletonValidator.checkAllDialog(ContentMatchParameterDialog.this, DialogConstants.MESSAGE_ONE_ROW, n3, SelectionValidator.CLASS);
                if (object3 != null) {
                    DialogProvider.createMultiConditionDialog(ContentMatchParameterDialog.this, DialogConstants.BUTTON_MODIFY, false);
                }
            } else if (object2.equals(this._remove) && (object = SingletonValidator.checkAllDialog(ContentMatchParameterDialog.this, DialogConstants.MESSAGE_ONE_ROW, n2 = this._multiTable.getSelectedRow(), SelectionValidator.CLASS)) != null) {
                PerformanceUIUtil.removeRow(this._multiTable, this._multiModel, n2);
            }
        }

        public void setVisible(boolean bl2) {
            this._panel.setVisible(bl2);
        }
    }

    private class Expr
    implements ActionListener {
        JPanel _panel;
        ReadOnlyTableModel _exprModel;
        JTable _exprTable;
        JButton _add;
        JButton _modify;
        JButton _remove;
        JTextField _exprText;

        public Expr() {
            FormLayout formLayout = new FormLayout("p,3dlu,p:g,3dlu,p", "p,3dlu,p,3dlu,p,3dlu,p:g,3dlu,p");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setBorder(null);
            CellConstraints cellConstraints = new CellConstraints();
            this._exprModel = new ReadOnlyTableModel(null, new String[]{ConfirmDialog._bundle.getString("column_variable"), ConfirmDialog._bundle.getString("column_value")});
            this._exprTable = SwingUtil.createJTable(this._exprModel);
            TableColumnModel tableColumnModel = this._exprTable.getColumnModel();
            tableColumnModel.getColumn(1).setCellRenderer(new LineTokenRenderer());
            PerformanceUIUtil.setGraceHeader(this._exprTable);
            this._exprTable.setSelectionMode(0);
            this._exprTable.setMinimumSize(DialogConstants.VIEW_XLONG_SIZE);
            this._exprTable.setPreferredScrollableViewportSize(DialogConstants.VIEW_XLONG_SIZE);
            JScrollPane jScrollPane = new JScrollPane(this._exprTable);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 3, 7));
            this._add = new JButton(DialogConstants.BUTTON_NEW);
            this._add.addActionListener(this);
            panelBuilder.add((Component)this._add, cellConstraints.xy(5, 1));
            this._modify = new JButton(DialogConstants.BUTTON_MODIFY);
            this._modify.addActionListener(this);
            panelBuilder.add((Component)this._modify, cellConstraints.xy(5, 3));
            this._remove = new JButton(DialogConstants.BUTTON_REMOVE);
            this._remove.addActionListener(this);
            panelBuilder.add((Component)this._remove, cellConstraints.xy(5, 5));
            panelBuilder.addLabel(ConfirmDialog._bundle.getString("label_expression"), cellConstraints.xy(1, 9));
            this._exprText = new JTextField();
            this._exprText.setPreferredSize(DialogConstants.LONG_SIZE);
            panelBuilder.add((Component)this._exprText, cellConstraints.xy(3, 9));
            this._panel = panelBuilder.getPanel();
            this._panel.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            Object object;
            Object object2 = actionEvent.getSource();
            if (object2.equals(this._add)) {
                DialogProvider.createLineTokenDialog(ContentMatchParameterDialog.this, DialogConstants.BUTTON_NEW, true);
            } else if (object2.equals(this._modify)) {
                int n3 = this._exprTable.getSelectedRow();
                Object object3 = SingletonValidator.checkAllDialog(ContentMatchParameterDialog.this, DialogConstants.MESSAGE_ONE_ROW, n3, SelectionValidator.CLASS);
                if (object3 != null) {
                    DialogProvider.createLineTokenDialog(ContentMatchParameterDialog.this, DialogConstants.BUTTON_MODIFY, false);
                }
            } else if (object2.equals(this._remove) && (object = SingletonValidator.checkAllDialog(ContentMatchParameterDialog.this, DialogConstants.MESSAGE_ONE_ROW, n2 = this._exprTable.getSelectedRow(), SelectionValidator.CLASS)) != null) {
                PerformanceUIUtil.removeRow(this._exprTable, this._exprModel, n2);
            }
        }

        public void setVisible(boolean bl2) {
            this._panel.setVisible(bl2);
        }
    }

    private class RelationEditor
    extends DefaultCellEditor {
        String[] _items;

        public RelationEditor(String[] stringArray) {
            super(new JComboBox<String>(stringArray));
            this._items = stringArray;
        }

        @Override
        public Object getCellEditorValue() {
            Object object = super.getCellEditorValue();
            int n2 = this._items.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!object.equals(this._items[i2])) continue;
                return i2;
            }
            return 0;
        }
    }

    private class RelationRenderer
    extends JComboBox
    implements TableCellRenderer {
        public RelationRenderer(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this.setSelectedIndex(Integer.parseInt(String.valueOf(object)));
            if (bl2) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    private class LineTokenRenderer
    extends JLabel
    implements TableCellRenderer {
        public LineTokenRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            LineTokenCell lineTokenCell = (LineTokenCell)object;
            StringBuffer stringBuffer = new StringBuffer(ContentMatchParameterDialog.this.LINE);
            stringBuffer.append(" ").append(lineTokenCell.getLine()).append(", ").append(ContentMatchParameterDialog.this.TOKEN).append(" ").append(lineTokenCell.getToken());
            this.setText(stringBuffer.toString());
            if (bl2) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }
}

