/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.mainframe.performance.DialogConstants;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConfirmDialog
extends JDialog {
    protected static final ResourceBundle _bundle = NbBundle.getBundle(ConfirmDialog.class);
    protected Logger _logger = Logger.getLogger((String)this.getClass().getName());
    protected JButton _ok = new JButton(DialogConstants.BUTTON_OK);
    private JButton _cancel = new JButton(DialogConstants.BUTTON_CANCEL);
    private JButton _close = new JButton(DialogConstants.BUTTON_CLOSE);
    private JButton _default = new JButton(DialogConstants.BUTTON_DEFAULT);
    private JButton _refresh = new JButton(DialogConstants.BUTTON_REFRESH);
    private ConfirmClickAction _clickAction = new ConfirmClickAction();
    private boolean _isPut;

    public ConfirmDialog() {
        this.initConfirmDialog();
    }

    public ConfirmDialog(Frame frame, String string, boolean bl2) {
        super(frame, string, bl2);
        this.initConfirmDialog();
    }

    public ConfirmDialog(Dialog dialog, String string, boolean bl2) {
        super(dialog, string, bl2);
        this.initConfirmDialog();
    }

    private void initConfirmDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConfirmDialog.this.doCancel();
            }
        });
    }

    public ConfirmDialog(Dialog dialog, boolean bl2) {
        this(dialog, "", bl2);
    }

    protected JButton getOkButton() {
        return this._ok;
    }

    protected JButton getCancelButton() {
        return this._cancel;
    }

    protected JButton getCloseButton() {
        return this._close;
    }

    protected JButton getDefaultButton() {
        return this._default;
    }

    protected JButton getRefreshButton() {
        return this._refresh;
    }

    protected JPanel getConfirmPanel() {
        JPanel jPanel = new JPanel();
        this._ok.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        jPanel.add(this._ok);
        this._ok.addActionListener(this._clickAction);
        this._cancel.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        jPanel.add(this._cancel);
        this._cancel.addActionListener(this._clickAction);
        this.getRootPane().setDefaultButton(this._ok);
        return jPanel;
    }

    protected JPanel getRefreshPanel() {
        JPanel jPanel = this.getConfirmPanel();
        this._refresh.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        this._refresh.addActionListener(this._clickAction);
        return jPanel;
    }

    protected JPanel getDefaultPanel() {
        JPanel jPanel = this.getConfirmPanel();
        this._default.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        jPanel.add(this._default);
        this._default.addActionListener(this._clickAction);
        return jPanel;
    }

    protected JPanel getClosePanel() {
        JPanel jPanel = new JPanel();
        this._close.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        jPanel.add(this._close);
        this._close.addActionListener(this._clickAction);
        this.getRootPane().setDefaultButton(this._close);
        return jPanel;
    }

    private void doOk() {
        this.okDialog();
        this.setPut(true);
    }

    private void doCancel() {
        this.dispose();
        this.setPut(false);
    }

    protected void okDialog() {
        this.dispose();
    }

    private void setPut(boolean bl2) {
        this._isPut = bl2;
    }

    public boolean isPut() {
        return this._isPut;
    }

    protected void doDefault() {
    }

    protected void doRefresh() {
    }

    private class ConfirmClickAction
    implements ActionListener {
        private ConfirmClickAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(ConfirmDialog.this._ok)) {
                ConfirmDialog.this.doOk();
            } else if (object.equals(ConfirmDialog.this._cancel) || object.equals(ConfirmDialog.this._close)) {
                ConfirmDialog.this.doCancel();
            } else if (object.equals(ConfirmDialog.this._default)) {
                ConfirmDialog.this.doDefault();
            } else if (object.equals(ConfirmDialog.this._refresh)) {
                ConfirmDialog.this.doRefresh();
            }
        }
    }
}

