/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.NameValuePair;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.AddMonitorDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.util.ServerBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseSshMonitorFirstDialog
extends JDialog {
    private static final String SSH = "SSH";
    private static final int SSH_ID = MonitorHelper.getConstantId("SSH");
    private static final String PORT_NUMBER_LABEL = ConciseSshMonitorFirstDialog.fromBundle("Label_port_number");
    private static final String MONITOR_NAME_LABEL = ConciseSshMonitorFirstDialog.fromBundle("Label_monitor_name");
    private static final String TIME_OUT_LABEL = ConciseSshMonitorFirstDialog.fromBundle("timeout");
    private static final String DEFAULT_TIME_OUT = "30";
    private static final String DEFAULT_PORT_NUMBER = "22";
    private static final String COMBOBOX_LINUX = ConciseSshMonitorFirstDialog.fromBundle("ComboBox_linux");
    private static final String COMBOBOX_SOLARIS = ConciseSshMonitorFirstDialog.fromBundle("ComboBox_solaris");
    private static final Logger _logger = Logger.getLogger((String)ConciseSshMonitorFirstDialog.class.getName());
    private JPanel _mainPanel;
    private JPanel _advPanel;
    private JTextField _monitorNameField;
    private JTextField _timeoutField;
    private JTextField _hostNameField;
    private JTextField _userNameField;
    private JPasswordField _passwordField;
    private JPasswordField _confirmPasswordField;
    private JTextField _portNumberField;
    private DefaultComboBoxModel _comboBoxModel;
    private Map _key2Host;
    private DefaultTableModel _tableModel;
    private JComboBox _remoteHostComboBox;
    private JComboBox _serverComboBox;
    private NameValuePair _server2command = new NameValuePair(COMBOBOX_LINUX, "");
    private String _sshMonitorType = this.getSshMonitorType();
    private boolean _isOneProcess = Pattern.compile("_process").matcher(this._sshMonitorType).find();
    private boolean _isProcess = Pattern.compile("process").matcher(this._sshMonitorType).find();
    public static final String USER = "(User:";
    public static final String PID = "PID:";
    public static final String DELIMITER = ";";

    public ConciseSshMonitorFirstDialog(DefaultTableModel defaultTableModel) {
        this();
        this._tableModel = defaultTableModel;
    }

    public ConciseSshMonitorFirstDialog() {
        super((Dialog)AddMonitorDialog.getAddMonitorDialog(), true);
        this.initComponent();
        this.initData();
        this.showDialog();
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.initRemoteHostPane(), "Center");
        container.add((Component)this.getConfirmPane(), "South");
    }

    private JPanel initRemoteHostPane() {
        this._mainPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        this._mainPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(MONITOR_NAME_LABEL);
        this._mainPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._monitorNameField = new JTextField();
        this._mainPanel.add((Component)this._monitorNameField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel(TIME_OUT_LABEL);
        this._mainPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._timeoutField = new JTextField();
        this._timeoutField.setText(DEFAULT_TIME_OUT);
        this._mainPanel.add((Component)this._timeoutField, cellConstraints.xy(4, 4));
        JLabel jLabel3 = new JLabel(ConciseSshMonitorFirstDialog.fromBundle("Label_second_unit"));
        this._mainPanel.add((Component)jLabel3, cellConstraints.xy(6, 4));
        JLabel jLabel4 = new JLabel(ConciseSshMonitorFirstDialog.fromBundle("Label_server"));
        this._mainPanel.add((Component)jLabel4, cellConstraints.xy(2, 6));
        String[] stringArray = new String[]{COMBOBOX_LINUX, COMBOBOX_SOLARIS};
        this._serverComboBox = new JComboBox<String>(stringArray);
        this._mainPanel.add((Component)this._serverComboBox, cellConstraints.xy(4, 6));
        this._serverComboBox.setSelectedItem(COMBOBOX_LINUX);
        this._serverComboBox.addItemListener(new ServerItem());
        JLabel jLabel5 = new JLabel(ConciseSshMonitorFirstDialog.fromBundle("remote_host"));
        this._mainPanel.add((Component)jLabel5, cellConstraints.xy(2, 8));
        this._remoteHostComboBox = new JComboBox();
        this._mainPanel.add((Component)this._remoteHostComboBox, cellConstraints.xy(4, 8));
        this._advPanel = this.initAdvPane();
        FormUtils.addFillComponents(this._mainPanel, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return this._mainPanel;
    }

    private JPanel initAdvPane() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(DialogConstants.LABEL_HOST);
        this._hostNameField = new JTextField();
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 2));
        jPanel.add((Component)this._hostNameField, cellConstraints.xy(3, 2));
        JLabel jLabel2 = new JLabel(DialogConstants.LABEL_USER_NAME);
        this._userNameField = new JTextField();
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 4));
        jPanel.add((Component)this._userNameField, cellConstraints.xy(3, 4));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 4));
        JLabel jLabel3 = new JLabel(DialogConstants.LABEL_PASSWORD);
        this._passwordField = new JPasswordField();
        jPanel.add((Component)jLabel3, cellConstraints.xy(1, 6));
        jPanel.add((Component)this._passwordField, cellConstraints.xy(3, 6));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 6));
        JLabel jLabel4 = new JLabel(DialogConstants.LABEL_CONFIRM_PASSWORD);
        this._confirmPasswordField = new JPasswordField();
        jPanel.add((Component)jLabel4, cellConstraints.xy(1, 8));
        jPanel.add((Component)this._confirmPasswordField, cellConstraints.xy(3, 8));
        JLabel jLabel5 = new JLabel(PORT_NUMBER_LABEL);
        this._portNumberField = new JTextField();
        jPanel.add((Component)jLabel5, cellConstraints.xy(1, 10));
        jPanel.add((Component)this._portNumberField, cellConstraints.xy(3, 10));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 10));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    private void initData() {
        this._key2Host = new HashMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = new ArrayList();
        try {
            list = ClientProxy.getInstance().getRemoteHosts(SSH_ID);
        }
        catch (Exception exception) {
            _logger.error((Object)"get remote hosts Error:", (Throwable)exception);
        }
        arrayList.add(" ");
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RemoteHost remoteHost = (RemoteHost)list.get(i2);
            RemoteHostKey remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
            this._key2Host.put(remoteHostKey, remoteHost);
            arrayList.add(remoteHostKey);
        }
        arrayList.add(ConciseSshMonitorFirstDialog.fromBundle("label_newremotehost"));
        this._comboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._remoteHostComboBox.setModel(this._comboBoxModel);
        this._remoteHostComboBox.setRenderer(new RemoteHostRenderer());
        this._remoteHostComboBox.addItemListener(new HostItem());
    }

    private JPanel getConfirmPane() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(ICommonBundle.NEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseSshMonitorFirstDialog.this.check()) {
                    ConciseSshMonitorFirstDialog.this.doNext();
                }
            }
        });
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseSshMonitorFirstDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSshMonitorFirstDialog.class, (String)string);
    }

    private void showDialog() {
        this.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
    }

    private boolean check() {
        Object object = SingletonValidator.checkAllDialog(this, MONITOR_NAME_LABEL, this._monitorNameField.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return false;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, TIME_OUT_LABEL, this._timeoutField.getText(), NumberValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        if (this._remoteHostComboBox.getSelectedIndex() <= 0) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("message_selectremotehost"));
            return false;
        }
        Object object3 = SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOST, this._hostNameField.getText(), NonNullValidator.CLASS);
        if (object3 == null) {
            return false;
        }
        Object object4 = SingletonValidator.checkAllDialog(this, PORT_NUMBER_LABEL, this._portNumberField.getText(), NumberValidator.CLASS);
        if (object4 == null) {
            return false;
        }
        String string = this._userNameField.getText().trim();
        String string2 = String.valueOf(this._passwordField.getPassword());
        String string3 = String.valueOf(this._confirmPasswordField.getPassword());
        if (string.length() == 0 && string2.length() != 0) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("message_inputusername"));
            return false;
        }
        if (string.length() != 0 && string2.length() == 0) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("message_needpassword"));
            return false;
        }
        if (string.length() != 0 && string2.length() != 0 && !string2.equals(string3)) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("message_invalidpassword"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNext() {
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        try {
            SSHWaitDialog sSHWaitDialog = new SSHWaitDialog(Startup.getFrame(), true);
            Integer n2 = Integer.parseInt(this._timeoutField.getText().trim()) * 1000;
            String string = this._isOneProcess ? (this._server2command.getName() == COMBOBOX_LINUX ? "/bin/ps aux|/bin/grep -v \"ps aux\"|grep -v \"COMMAND\"" : "/usr/bin/ps -ef|/usr/bin/grep -v \"ps -ef\"|/usr/bin/grep -v \"CMD\"") : this.getSshCommand(this._server2command);
            SwingUtilities.invokeLater(() -> {
                Long l2 = null;
                ResultValue resultValue = null;
                RemoteHost remoteHost = null;
                try {
                    if (this._remoteHostComboBox.getSelectedIndex() == this._remoteHostComboBox.getItemCount() - 1) {
                        remoteHost = this.createNewRemoteHost();
                    } else if (this._remoteHostComboBox.getSelectedIndex() != 0) {
                        remoteHost = this.modifyRemoteHost();
                    }
                    if (remoteHost == null) {
                        return;
                    }
                    l2 = remoteHost.getHostId();
                    resultValue = ClientProxy.getInstance().testConnection(string, l2, n2);
                }
                catch (Exception exception) {
                    _logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    sSHWaitDialog.dispose();
                }
                if (this.checkResult(resultValue)) {
                    this.dispose();
                    String string2 = this.analyseResult((String)resultValue.getValue());
                    WmiDevicesMonitorPane wmiDevicesMonitorPane = this.initDevicesMonitorPane(string2);
                    this.createNextDialog(this._tableModel, wmiDevicesMonitorPane, l2, this.getTimeout(), this.getMonitorName(), this._server2command);
                }
            });
            sSHWaitDialog.showCenterOnOwner();
        }
        finally {
            this.setCursor(cursor);
        }
    }

    protected abstract String getSshMonitorType();

    protected abstract String getSshCommand(NameValuePair var1);

    public abstract void createNextDialog(DefaultTableModel var1, WmiDevicesMonitorPane var2, long var3, int var5, String var6, NameValuePair var7);

    public abstract WmiDevicesMonitorPane initDevicesMonitorPane(String var1);

    public String getMonitorName() {
        return this._monitorNameField.getText().trim();
    }

    private RemoteHost createNewRemoteHost() {
        FlagedRemoteHost flagedRemoteHost = TargetFactory.getFlagedRemoteHost();
        this.setRemoteHostParameter(flagedRemoteHost);
        RemoteHostKey remoteHostKey = new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser());
        if (this._key2Host.keySet().contains(remoteHostKey)) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("MSG_ADD_REMOTE_HOST_FAILED"));
            return null;
        }
        if (this.putRemoteHost(flagedRemoteHost)) {
            this.initData();
            this._comboBoxModel.setSelectedItem(remoteHostKey);
            return flagedRemoteHost;
        }
        JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
        return null;
    }

    private void setRemoteHostParameter(RemoteHost remoteHost) {
        String string = this.getRemoteHostName();
        remoteHost.setHostName(string);
        remoteHost.setProtocol(SSH_ID);
        remoteHost.setUser(this._userNameField.getText().trim());
        List list = this.getParameterName();
        List list2 = this.getParameter();
        int n2 = list.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            remoteHost.put(list.get(i2), list2.get(i2));
        }
    }

    private String getRemoteHostName() {
        String string = this._hostNameField.getText().trim();
        String string2 = StringUtil.checkIpAddress(this._hostNameField.getText().trim());
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    private List getParameterName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("host_name");
        arrayList.add("user_name");
        arrayList.add("password");
        arrayList.add("confirm_password");
        arrayList.add("port_number");
        return arrayList;
    }

    private List getParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this._hostNameField.getText().trim());
        arrayList.add(1, this._userNameField.getText().trim());
        arrayList.add(2, String.valueOf(this._passwordField.getPassword()));
        arrayList.add(3, String.valueOf(this._confirmPasswordField.getPassword()));
        arrayList.add(4, this._portNumberField.getText().trim());
        return arrayList;
    }

    private boolean putRemoteHost(FlagedRemoteHost flagedRemoteHost) {
        long l2 = -1L;
        try {
            l2 = ClientProxy.getInstance().storeRemoteHost(flagedRemoteHost);
        }
        catch (Exception exception) {
            _logger.error((Object)"store remote host Error:", (Throwable)exception);
        }
        flagedRemoteHost.setHostId(l2);
        return l2 != -1L;
    }

    private RemoteHost modifyRemoteHost() {
        RemoteHostKey remoteHostKey = (RemoteHostKey)this._remoteHostComboBox.getSelectedItem();
        RemoteHost remoteHost = (RemoteHost)this._key2Host.get(remoteHostKey);
        this.setRemoteHostParameter(remoteHost);
        try {
            if (!ClientProxy.getInstance().modifyRemoteHost(remoteHost)) {
                this.initData();
                remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
                this._remoteHostComboBox.setSelectedItem(remoteHostKey);
                JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
                return null;
            }
            return remoteHost;
        }
        catch (Exception exception) {
            _logger.error((Object)"modify remote host Error:", (Throwable)exception);
            return null;
        }
    }

    public boolean checkResult(ResultValue resultValue) {
        if (resultValue == null) {
            JOptionPane.showMessageDialog(this, ConciseSshMonitorFirstDialog.fromBundle("MSG_connect_error"));
            return false;
        }
        if (!resultValue.isNormal()) {
            String string = String.valueOf(resultValue.getValue());
            String string2 = ServerBundle.getMessage(string);
            JOptionPane.showMessageDialog(this, string2);
            return false;
        }
        return true;
    }

    public int getTimeout() {
        return Integer.parseInt(this._timeoutField.getText().trim()) * 1000;
    }

    protected String analyseResult(String string) {
        if (this._isProcess) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            Object object = "";
            int n2 = COMBOBOX_LINUX.equals(this._server2command.getName()) ? 10 : 7;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                List list = this.analyseTokenStr(string2, n2);
                if (this._isOneProcess) {
                    object = (String)object + list.get(n2) + "  (User: " + list.get(0) + "  ; PID: " + list.get(1) + ")\n";
                    continue;
                }
                object = (String)object + list.get(n2) + "\n";
            }
            object = ((String)object).trim();
            return object;
        }
        return string;
    }

    protected List analyseTokenStr(String string, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.indexOf(" ");
            String string2 = string.substring(0, n3);
            arrayList.add(string2);
            string = string.substring(n3).trim();
        }
        arrayList.add(string);
        return arrayList;
    }

    private class ServerItem
    implements ItemListener {
        private ServerItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string = (String)ConciseSshMonitorFirstDialog.this._serverComboBox.getSelectedItem();
                if (COMBOBOX_LINUX.equals(string)) {
                    ConciseSshMonitorFirstDialog.this._server2command = new NameValuePair(COMBOBOX_LINUX, "");
                }
                if (COMBOBOX_SOLARIS.equals(string)) {
                    ConciseSshMonitorFirstDialog.this._server2command = new NameValuePair(COMBOBOX_SOLARIS, "");
                }
            }
        }
    }

    private class RemoteHostRenderer
    extends JLabel
    implements ListCellRenderer {
        public RemoteHostRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof RemoteHostKey) {
                RemoteHostKey remoteHostKey = (RemoteHostKey)object;
                String string = remoteHostKey.getHost() + " ( " + remoteHostKey.getUser() + " )";
                this.setText(string);
                this.setToolTipText(string);
            } else if (object != null) {
                this.setText(object.toString());
                this.setToolTipText(object.toString());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }

    private class HostItem
    implements ItemListener {
        private HostItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                final int n2 = ConciseSshMonitorFirstDialog.this._remoteHostComboBox.getSelectedIndex();
                ConciseSshMonitorFirstDialog.this._remoteHostComboBox.setSelectedIndex(n2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        if (n2 == 0) {
                            ConciseSshMonitorFirstDialog.this._mainPanel.remove(ConciseSshMonitorFirstDialog.this._advPanel);
                        } else {
                            object = new CellConstraints();
                            ConciseSshMonitorFirstDialog.this._mainPanel.add((Component)ConciseSshMonitorFirstDialog.this._advPanel, object.xywh(2, 10, 5, 1));
                        }
                        ConciseSshMonitorFirstDialog.this._mainPanel.updateUI();
                        ConciseSshMonitorFirstDialog.this.pack();
                        if (n2 == ConciseSshMonitorFirstDialog.this._remoteHostComboBox.getItemCount() - 1) {
                            object = ConciseSshMonitorFirstDialog.fromBundle("tip_localhost_empty_user");
                            ConciseSshMonitorFirstDialog.this._hostNameField.setText("");
                            ConciseSshMonitorFirstDialog.this._hostNameField.setToolTipText((String)object);
                            ConciseSshMonitorFirstDialog.this._userNameField.setToolTipText((String)object);
                            ConciseSshMonitorFirstDialog.this._userNameField.setText("");
                            ConciseSshMonitorFirstDialog.this._passwordField.setText("");
                            ConciseSshMonitorFirstDialog.this._passwordField.setToolTipText((String)object);
                            ConciseSshMonitorFirstDialog.this._confirmPasswordField.setText("");
                            ConciseSshMonitorFirstDialog.this._confirmPasswordField.setToolTipText((String)object);
                            ConciseSshMonitorFirstDialog.this._portNumberField.setText(ConciseSshMonitorFirstDialog.DEFAULT_PORT_NUMBER);
                        } else if (n2 != 0) {
                            object = (RemoteHostKey)ConciseSshMonitorFirstDialog.this._remoteHostComboBox.getSelectedItem();
                            RemoteHost remoteHost = (RemoteHost)ConciseSshMonitorFirstDialog.this._key2Host.get(object);
                            ConciseSshMonitorFirstDialog.this._hostNameField.setText(remoteHost.getHostName());
                            String string = remoteHost.getUser();
                            if (string != null && string.trim().length() != 0) {
                                ConciseSshMonitorFirstDialog.this._userNameField.setText(string);
                            } else {
                                ConciseSshMonitorFirstDialog.this._userNameField.setText("");
                            }
                            String string2 = (String)remoteHost.getValue("password");
                            if (string2 != null && string2.trim().length() != 0) {
                                ConciseSshMonitorFirstDialog.this._passwordField.setText(string2);
                                ConciseSshMonitorFirstDialog.this._confirmPasswordField.setText(string2);
                            } else {
                                ConciseSshMonitorFirstDialog.this._passwordField.setText("");
                                ConciseSshMonitorFirstDialog.this._confirmPasswordField.setText("");
                            }
                            String string3 = (String)remoteHost.getValue("port_number");
                            if (string3 != null && string3.trim().length() != 0) {
                                ConciseSshMonitorFirstDialog.this._portNumberField.setText(string3);
                            } else {
                                ConciseSshMonitorFirstDialog.this._portNumberField.setText("");
                            }
                        }
                    }
                });
            }
        }
    }

    private class SSHWaitDialog
    extends JDialog
    implements ActionListener {
        public SSHWaitDialog(Frame frame, boolean bl2) {
            super(frame, bl2);
            this.setTitle(ConciseSshMonitorFirstDialog.fromBundle("Title_Pleaset_Wait"));
            this.init();
        }

        private void init() {
            Container container = this.getContentPane();
            JComponent jComponent = this.createCenterComponent();
            container.add((Component)jComponent, "Center");
            container.add((Component)this.createSouthComponent(), "South");
        }

        private JComponent createCenterComponent() {
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            jProgressBar.setPreferredSize(new Dimension(300, 30));
            return jProgressBar;
        }

        private JComponent createSouthComponent() {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ICommonBundle.CLOSE);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            return jPanel;
        }

        public void showCenterOnOwner() {
            this.pack();
            SwingUtil.centerOnFrame(this.getOwner(), this);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.sshWaitDialogDispose();
        }

        public void sshWaitDialogDispose() {
            this.dispose();
        }
    }
}

