/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.util.NameValuePair;
import com.sysuptime.mainframe.performance.ConciseSshMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.SshDiskMonitorPane;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseSshDiskMonitorSecondDialog
extends ConciseSshMonitorSecondDialog {
    private SshDiskMonitorPane _diskMonitorPane;
    private String _monitor;
    private HashMap _specialDisk2printNum = new HashMap();
    private String _mountOn;
    private String _fileSystem;

    public ConciseSshDiskMonitorSecondDialog(boolean bl2, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel, long l2, int n2, String string, NameValuePair nameValuePair, HashMap hashMap) {
        super(bl2, ConciseSshDiskMonitorSecondDialog.fromBundle("Title_ssh_cpu_process_util"), devicesMonitorPane, defaultTableModel, l2, n2, string, nameValuePair);
        this._diskMonitorPane = (SshDiskMonitorPane)devicesMonitorPane;
        this._monitor = (String)nameValuePair.getName();
        this._specialDisk2printNum = hashMap;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSshDiskMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected String getQueryResultString() {
        return ConciseSshDiskMonitorSecondDialog.fromBundle("disk_utilization_result");
    }

    @Override
    protected boolean check() {
        String string;
        String string2 = this._diskMonitorPane.getFileSystem();
        if (string2 == null) {
            JOptionPane.showMessageDialog(null, ConciseSshDiskMonitorSecondDialog.fromBundle("MSG_choose_disk_error"));
            return false;
        }
        int n2 = string2.indexOf(" ");
        this._fileSystem = string2.substring(0, n2).trim();
        int n3 = string2.indexOf("(mounted on:") + 12;
        int n4 = string2.indexOf(")", n3);
        this._mountOn = string2.substring(n3, n4).trim();
        if (Pattern.compile("Linux").matcher(this._monitor).find()) {
            boolean bl2 = this._specialDisk2printNum.containsKey(this._mountOn);
            String string3 = "$5";
            if (bl2) {
                string3 = (String)this._specialDisk2printNum.get(this._mountOn);
            }
            string = "df " + this._mountOn + "|grep -v 'Filesystem'|grep '%'|awk '{print " + string3 + "}'|awk -F% '{print $1}'";
        } else {
            string = "/usr/bin/df -k " + this._mountOn + "|/usr/bin/grep -v 'Filesystem'|/usr/bin/grep '%'|/usr/bin/awk '{print $5}'|/usr/bin/awk -F% '{print $1}'";
        }
        this.setSshCommand(string);
        return super.check();
    }

    @Override
    protected int getMonitorType() {
        return this.DISK_TYPE;
    }
}

