/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.protocol.TimeoutException;
import com.ireasoning.util.AgentProperties;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.performance.AddMonitorDialog;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseSnmpMonitorFirstDialog
extends JDialog {
    private static final Logger _logger = Logger.getLogger((String)ConciseSnmpMonitorFirstDialog.class.getName());
    private JTextField _hostNameField;
    private JPasswordField _communityField;
    protected JCheckBox _advCheckBox;
    private JTextField _portNumberField;
    private JTextField _timeoutField;
    private JTextField _retriesField;
    private JComboBox _versionComboBox;
    private JTextField _usmUserField;
    private JComboBox _authAlgorithComboBox;
    private JPasswordField _authPasswordField;
    private JComboBox _privacyAlgorithmComboBox;
    private JPasswordField _privacyPasswordField;
    private JPanel _advPanel;
    private JPanel _mainPanel;
    private ReadCommunity _readCommunity;
    private DefaultTableModel _scheduleListModel;
    private static int DEFAULT_TIMEOUT_TIME = 5000;
    private static int DEFAULT_RETRIES_TIMES = 1;
    private static int DEFAULT_PORT_NUMBER = 161;
    private static String DEFAULT_READ_COMMUNITY = "public";
    private static String DEFAULT_VERSION = "1";
    private static String DEFAULT_AUTH_ALGORITH = "MD5";
    private static String DEFAULT_PRIVACY_ALGORITH = "DES";
    private static String VERSION_3 = "3";
    private static String[] VERSION = new String[]{"1", "2", "3"};
    private static String[] AUTH_ALGORITH = new String[]{"MD5", "SHA"};
    private static String[] PRIVACY_ALGORITH = new String[]{"AES", "DES"};
    private static String LABEL_HOST_NAME = ConciseSnmpMonitorFirstDialog.fromBundle("Label_host_name");
    private static String LABEL_READ_COMMUNITY = ConciseSnmpMonitorFirstDialog.fromBundle("Label_read_community");
    private static String LABEL_PORT_NUMBER = ConciseSnmpMonitorFirstDialog.fromBundle("Label_port_number");
    private static String LABEL_TIME_OUT = ConciseSnmpMonitorFirstDialog.fromBundle("Label_time_out");
    private static String LABEL_RETIRES = ConciseSnmpMonitorFirstDialog.fromBundle("Label_retries");
    private static String LABEL_VERSION = ConciseSnmpMonitorFirstDialog.fromBundle("Label_version");
    private static String LABEL_USM_USER = ConciseSnmpMonitorFirstDialog.fromBundle("Label_usm_user");
    private static String LABEL_AUTH_ALGORITHM = ConciseSnmpMonitorFirstDialog.fromBundle("Label_auth_algorithm");
    private static String LABEL_AUTH_PASSWORD = ConciseSnmpMonitorFirstDialog.fromBundle("Label_auth_password");
    private static String LABEL_PRIVACY_ALGORITHM = ConciseSnmpMonitorFirstDialog.fromBundle("Label_privacy_algorithm");
    private static String LABEL_PRIVACY_PASSWORD = ConciseSnmpMonitorFirstDialog.fromBundle("Label_privacy_password");

    public ConciseSnmpMonitorFirstDialog(String string, DefaultTableModel defaultTableModel) {
        super(AddMonitorDialog.getAddMonitorDialog(), string, true);
        this._scheduleListModel = defaultTableModel;
        this.initMainPanel();
        this.initData(null, null);
        this.showDialog();
    }

    public ConciseSnmpMonitorFirstDialog(String string, NetworkNodeBean networkNodeBean) {
        super(Startup.getFrame(), string, true);
        String string2 = ConsoleComponent.getInstance().getCurrentGraph().getGraphID().getGraphName();
        String string3 = networkNodeBean.getIPInSubnet(string2);
        this.initMainPanel();
        this.initData(string3, networkNodeBean.getReadCommunity());
        this.showDialog();
    }

    private void showDialog() {
        this.getContentPane().add((Component)this._mainPanel, "Center");
        this.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), this);
    }

    private void initData(String string, ReadCommunity readCommunity) {
        this._timeoutField.setText(String.valueOf(DEFAULT_TIMEOUT_TIME));
        this._retriesField.setText(String.valueOf(DEFAULT_RETRIES_TIMES));
        if (string != null) {
            this._hostNameField.setText(string);
        }
        if (readCommunity != null) {
            this._communityField.setText(readCommunity.getCommunity());
            this._portNumberField.setText(String.valueOf(readCommunity.getPort()));
            this._versionComboBox.setSelectedItem(readCommunity.getVersionString());
            if (readCommunity.getVersionString().equals("3")) {
                V3Params v3Params = readCommunity.getV3Params();
                this._usmUserField.setText(v3Params.getUserName());
                this._authAlgorithComboBox.setSelectedItem(v3Params.getAuthProtocol());
                this._authPasswordField.setText(v3Params.getAuthPassword());
                this._privacyAlgorithmComboBox.setSelectedItem(v3Params.getPrivProtocolView());
                this._privacyPasswordField.setText(v3Params.getPrivPassword());
            }
        } else if (string == null && readCommunity == null) {
            this.setDefaultData();
        }
    }

    private void setDefaultData() {
        this._communityField.setText(DEFAULT_READ_COMMUNITY);
        this._portNumberField.setText(String.valueOf(DEFAULT_PORT_NUMBER));
        this._versionComboBox.setSelectedItem(DEFAULT_VERSION);
        this._authAlgorithComboBox.setSelectedItem(DEFAULT_AUTH_ALGORITH);
        this._privacyAlgorithmComboBox.setSelectedItem(DEFAULT_PRIVACY_ALGORITH);
    }

    private void initMainPanel() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:170PX:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        this._mainPanel = new JPanel((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(LABEL_HOST_NAME);
        this._mainPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._hostNameField = new JTextField();
        this._mainPanel.add((Component)this._hostNameField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LABEL_READ_COMMUNITY);
        this._mainPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._communityField = new JPasswordField();
        this._mainPanel.add((Component)this._communityField, cellConstraints.xy(4, 4));
        this._advCheckBox = new JCheckBox(ConciseSnmpMonitorFirstDialog.fromBundle("Label_advance"));
        this._advCheckBox.addItemListener(new AdvanceListener());
        this._mainPanel.add((Component)this._advCheckBox, cellConstraints.xy(2, 6));
        this._advPanel = this.initAdvancePanel();
        this._mainPanel.add((Component)this.initConfirmPanel(), cellConstraints.xywh(2, 10, 3, 1));
        FormUtils.addFillComponents(this._mainPanel, new int[]{1, 2, 3, 4, 5}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
    }

    private JPanel initAdvancePanel() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:150PX:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE");
        final CellConstraints cellConstraints = new CellConstraints();
        final JPanel jPanel = new JPanel((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(LABEL_PORT_NUMBER);
        jPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._portNumberField = new JTextField();
        jPanel.add((Component)this._portNumberField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LABEL_TIME_OUT);
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._timeoutField = new JTextField();
        jPanel.add((Component)this._timeoutField, cellConstraints.xy(4, 4));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(LABEL_RETIRES);
        jPanel.add((Component)jLabel3, cellConstraints.xy(2, 6));
        this._retriesField = new JTextField();
        jPanel.add((Component)this._retriesField, cellConstraints.xy(4, 6));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(LABEL_VERSION);
        jPanel.add((Component)jLabel4, cellConstraints.xy(2, 8));
        this._versionComboBox = new JComboBox<String>(VERSION);
        jPanel.add((Component)this._versionComboBox, cellConstraints.xy(4, 8));
        final JPanel jPanel2 = this.initV3ParagramsPanel();
        this._versionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseSnmpMonitorFirstDialog.this._versionComboBox.getSelectedItem().equals(VERSION_3)) {
                    jPanel.add((Component)jPanel2, cellConstraints.xywh(2, 10, 3, 1));
                    ConciseSnmpMonitorFirstDialog.this._communityField.setText("");
                    ConciseSnmpMonitorFirstDialog.this._communityField.setEnabled(false);
                } else {
                    jPanel.remove(jPanel2);
                    ConciseSnmpMonitorFirstDialog.this._communityField.setText(DEFAULT_READ_COMMUNITY);
                    ConciseSnmpMonitorFirstDialog.this._communityField.setEnabled(true);
                }
                jPanel.updateUI();
                ConciseSnmpMonitorFirstDialog.this.pack();
            }
        });
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    private JPanel initV3ParagramsPanel() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:110PX:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        jPanel.setBorder(new TitledBorder(ConciseSnmpMonitorFirstDialog.fromBundle("V3_params_title")));
        JLabel jLabel = new JLabel();
        jLabel.setText(LABEL_USM_USER);
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 2));
        this._usmUserField = new JTextField();
        jPanel.add((Component)this._usmUserField, cellConstraints.xy(3, 2));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(LABEL_AUTH_ALGORITHM);
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 4));
        this._authAlgorithComboBox = new JComboBox<String>(AUTH_ALGORITH);
        jPanel.add((Component)this._authAlgorithComboBox, cellConstraints.xy(3, 4));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(LABEL_AUTH_PASSWORD);
        jPanel.add((Component)jLabel3, cellConstraints.xy(1, 6));
        this._authPasswordField = new JPasswordField();
        jPanel.add((Component)this._authPasswordField, cellConstraints.xy(3, 6));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(LABEL_PRIVACY_ALGORITHM);
        jPanel.add((Component)jLabel4, cellConstraints.xy(1, 8));
        this._privacyAlgorithmComboBox = new JComboBox<String>(PRIVACY_ALGORITH);
        jPanel.add((Component)this._privacyAlgorithmComboBox, cellConstraints.xy(3, 8));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(LABEL_PRIVACY_PASSWORD);
        jPanel.add((Component)jLabel5, cellConstraints.xy(1, 10));
        this._privacyPasswordField = new JPasswordField();
        jPanel.add((Component)this._privacyPasswordField, cellConstraints.xy(3, 10));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    private void doNext() {
        if (this.check()) {
            Object object;
            Object object2;
            V3Params v3Params = null;
            String string = this._hostNameField.getText().trim();
            String string2 = String.valueOf(this._communityField.getPassword()).trim();
            int n2 = Integer.parseInt(this._portNumberField.getText().trim());
            int n3 = Integer.parseInt(String.valueOf(this._versionComboBox.getSelectedItem()));
            if (String.valueOf(n3).equals(VERSION_3)) {
                object2 = this._usmUserField.getText().trim();
                object = String.valueOf(this._authAlgorithComboBox.getSelectedItem());
                String string3 = String.valueOf(this._authPasswordField.getPassword());
                String string4 = String.valueOf(this._privacyAlgorithmComboBox.getSelectedItem());
                String string5 = String.valueOf(this._privacyPasswordField.getPassword());
                v3Params = new V3Params((String)object2, (String)object, string3, V3Params.getPrivProtocol(string4), string5);
            } else {
                --n3;
            }
            this._readCommunity = new ReadCommunity(string, string2, n3, v3Params, n2);
            this.dispose();
            object2 = this.getAgentProperties(string, this._readCommunity);
            object = new SnmpWaitDialog(Startup.getFrame(), true);
            SwingUtilities.invokeLater(() -> this.lambda$doNext$0((AgentProperties)object2, (SnmpWaitDialog)object));
            ((SnmpWaitDialog)object).showCenterOnOwner();
        }
    }

    private JPanel initConfirmPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(ICommonBundle.NEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseSnmpMonitorFirstDialog.this.doNext();
            }
        });
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseSnmpMonitorFirstDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private boolean check() {
        Object object = SingletonValidator.checkAllDialog(this, LABEL_HOST_NAME, this._hostNameField.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return false;
        }
        if (this._advCheckBox.isSelected()) {
            Object object2 = SingletonValidator.checkAllDialog(this, LABEL_PORT_NUMBER, this._portNumberField.getText(), NumberValidator.CLASS);
            if (object2 == null) {
                return false;
            }
            Object object3 = SingletonValidator.checkAllDialog(this, LABEL_TIME_OUT, this._timeoutField.getText(), NumberValidator.CLASS);
            if (object3 == null) {
                return false;
            }
            Object object4 = SingletonValidator.checkAllDialog(this, LABEL_RETIRES, this._retriesField.getText(), NumberValidator.CLASS);
            if (object4 == null) {
                return false;
            }
            if (this._versionComboBox.getSelectedItem().equals(VERSION_3)) {
                Object object5 = SingletonValidator.checkAllDialog(this, LABEL_USM_USER, this._usmUserField.getText(), NonNullValidator.CLASS);
                if (object5 == null) {
                    return false;
                }
                Object object6 = SingletonValidator.checkAllDialog(this, LABEL_AUTH_PASSWORD, new String(this._authPasswordField.getPassword()), NonNullValidator.CLASS);
                if (object6 == null) {
                    return false;
                }
                Object object7 = SingletonValidator.checkAllDialog(this, LABEL_PRIVACY_PASSWORD, new String(this._privacyPasswordField.getPassword()), NonNullValidator.CLASS);
                if (object7 == null) {
                    return false;
                }
            }
        }
        return true;
    }

    public abstract SnmpDevicesMonitorPane initDevicesMonitorPane(AgentProperties var1) throws Exception;

    public abstract void createNextStepDialog(AgentProperties var1, SnmpDevicesMonitorPane var2, DefaultTableModel var3);

    public ReadCommunity getReadCommunity() {
        return this._readCommunity;
    }

    public long getTimeout() {
        return Long.parseLong(this._timeoutField.getText().trim());
    }

    public int getRetries() {
        return Integer.parseInt(this._retriesField.getText().trim());
    }

    private AgentProperties getAgentProperties(String string, ReadCommunity readCommunity) {
        int n2 = readCommunity.getVersion();
        switch (n2) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        AgentProperties agentProperties = new AgentProperties(string, readCommunity.getPort(), n2, readCommunity.getCommunity(), "");
        if (readCommunity.getVersion() == 3) {
            V3Params v3Params = readCommunity.getV3Params();
            agentProperties.setV3Params(v3Params.getUserName(), v3Params.getAuthProtocol(), v3Params.getAuthPassword(), v3Params.getPrivProtocolView(), v3Params.getPrivPassword(), "");
        }
        return agentProperties;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSnmpMonitorFirstDialog.class, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doNext$0(AgentProperties agentProperties, SnmpWaitDialog snmpWaitDialog) {
        SnmpDevicesMonitorPane snmpDevicesMonitorPane = null;
        try {
            snmpDevicesMonitorPane = this.initDevicesMonitorPane(agentProperties);
        }
        catch (TimeoutException timeoutException) {
            JOptionPane.showMessageDialog(this, ConciseSnmpMonitorFirstDialog.fromBundle("MSG_time_out_error"));
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, ConciseSnmpMonitorFirstDialog.fromBundle("MSG_connect_snmp_agent_error"));
            return;
        }
        catch (Exception exception) {
            _logger.error((Object)"create snmp session", (Throwable)exception);
            JOptionPane.showMessageDialog(this, ConciseSnmpMonitorFirstDialog.fromBundle("MSG_get_data_error"));
            return;
        }
        finally {
            snmpWaitDialog.dispose();
        }
        this.createNextStepDialog(agentProperties, snmpDevicesMonitorPane, this._scheduleListModel);
    }

    private class AdvanceListener
    implements ItemListener {
        private AdvanceListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() instanceof JCheckBox) {
                if (itemEvent.getStateChange() == 1) {
                    CellConstraints cellConstraints = new CellConstraints();
                    ConciseSnmpMonitorFirstDialog.this._mainPanel.add((Component)ConciseSnmpMonitorFirstDialog.this._advPanel, cellConstraints.xywh(2, 8, 3, 1));
                    ConciseSnmpMonitorFirstDialog.this._mainPanel.updateUI();
                } else {
                    ConciseSnmpMonitorFirstDialog.this._mainPanel.remove(ConciseSnmpMonitorFirstDialog.this._advPanel);
                    ConciseSnmpMonitorFirstDialog.this._mainPanel.updateUI();
                }
                ConciseSnmpMonitorFirstDialog.this.pack();
            }
        }
    }

    private class SnmpWaitDialog
    extends JDialog
    implements ActionListener {
        public SnmpWaitDialog(Frame frame, boolean bl2) {
            super(frame, bl2);
            this.setTitle(ConciseSnmpMonitorFirstDialog.fromBundle("Title_Pleaset_Wait"));
            this.init();
        }

        private void init() {
            Container container = this.getContentPane();
            JComponent jComponent = this.createCenterComponent();
            container.add((Component)jComponent, "Center");
            container.add((Component)this.createSouthComponent(), "South");
        }

        private JComponent createCenterComponent() {
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            jProgressBar.setPreferredSize(new Dimension(300, 30));
            return jProgressBar;
        }

        private JComponent createSouthComponent() {
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ICommonBundle.CLOSE);
            jButton.addActionListener(this);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            return jPanel;
        }

        public void showCenterOnOwner() {
            this.pack();
            SwingUtil.centerOnFrame(this.getOwner(), this);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.snmpWaitDialogDispose();
        }

        public void snmpWaitDialogDispose() {
            this.dispose();
        }
    }
}

