/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BaselineDialog
extends ConfirmDialog {
    private static final String TITLE = _bundle.getString("label_baseline");
    private static final String BASELINE = _bundle.getString("label_expected");
    private Baseline _baseline;
    private String _unit;
    private JComboBox _conditionBox;
    private JTextField _threshold;
    private double _checkedThreshold;

    public BaselineDialog(JDialog jDialog, boolean bl2, Baseline baseline, String string) {
        super(jDialog, TITLE, bl2);
        this.initBaseline(baseline, string);
        this.initComponents();
        this.initUserData();
    }

    private void initBaseline(Baseline baseline, String string) {
        this._baseline = baseline;
        this._unit = string;
    }

    private void initComponents() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("l:p,3dlu,p,3dlu,p,3dlu,p", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(BASELINE, cellConstraints.xy(1, 1));
        this._conditionBox = new JComboBox<String>(DialogConstants.COMBOBOX_BASELINE_CONDITION);
        this._conditionBox.setPreferredSize(DialogConstants.SHORT_SIZE);
        panelBuilder.add((Component)this._conditionBox, cellConstraints.xy(3, 1));
        this._threshold = new JTextField();
        this._threshold.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._threshold, cellConstraints.xy(5, 1));
        panelBuilder.addLabel(this._unit, cellConstraints.xy(7, 1));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        short s2 = this._baseline.getBaselineConditionId();
        if (s2 != -1) {
            this._conditionBox.setSelectedIndex(s2);
            this._threshold.setText(String.valueOf(this._baseline.getBaselineThreshold()));
        } else {
            this._conditionBox.setSelectedIndex(-1);
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkBaseline()) {
            short s2 = (short)this._conditionBox.getSelectedIndex();
            this._baseline.setBaselineConditionId(s2);
            this._baseline.setBaselineThreshold(this._checkedThreshold);
            this.dispose();
        }
    }

    private boolean checkBaseline() {
        Object object = SingletonValidator.checkAllDialog(this, BASELINE, this._conditionBox.getSelectedIndex(), SelectionValidator.CLASS);
        if (object == null) {
            return false;
        }
        Double d10 = (Double)SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_THRESHOLD, this._threshold.getText(), NumberValidator.CLASS);
        if (d10 == null) {
            return false;
        }
        this._checkedThreshold = d10;
        return true;
    }
}

