/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class AlarmRemoteHostDialog
extends ConfirmDialog
implements ActionListener {
    private static final ResourceBundle _bundle = NbBundle.getBundle(AlarmRemoteHostDialog.class);
    private static final String TELNET = "TELNET";
    private static final String SSH = "SSH";
    private static final String RPC = "RPC";
    private static final int TELNET_ID = MonitorHelper.getConstantId("TELNET");
    private static final int SSH_ID = MonitorHelper.getConstantId("SSH");
    private static final int RPC_ID = MonitorHelper.getConstantId("RPC");
    private static final int TELNET_PORT_NUMBER = 23;
    private static final int SSH_PORT_NUMBER = 22;
    private static final String PROMPT = "#";
    private JLabel _promptLabel = new JLabel();
    private JTextField _hostName = new JTextField();
    private JTextField _userName = new JTextField();
    private JPasswordField _password = new JPasswordField();
    private JPasswordField _confirmPassword = new JPasswordField();
    private JTextField _promptField = new JTextField();
    private JComboBox _protocolType = new JComboBox();
    private JButton _ok = new JButton(DialogConstants.BUTTON_OK);
    private JButton _cancel = new JButton(DialogConstants.BUTTON_CANCEL);
    private FlagedRemoteHost _newHost;
    private boolean _isOK = false;
    private boolean _isAdded;
    private long _probeID = 0L;

    public AlarmRemoteHostDialog(Frame frame, boolean bl2, boolean bl3, long l2) {
        super(frame, _bundle.getString("AlarmRemoteHostDialog_title"), bl2);
        this._isAdded = bl3;
        this._probeID = l2;
        this.initComponent();
        this.initXmlData();
        SwingUtil.centerOnFrame(frame, this);
        this.setVisible(true);
    }

    private void initXmlData() {
        this._newHost = TargetFactory.getFlagedRemoteHost();
    }

    private void initComponent() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getClosePanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:53PX:NONE,FILL:67PX:NONE,FILL:92PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:DEFAULT:NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:DEFAULT:NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:DEFAULT:NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:DEFAULT:NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:MAX(0PX;DEFAULT):NONE,CENTER:MAX(0PX;DEFAULT):GROW(0.1),CENTER:MAX(0PX;DEFAULT):NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.addLabel(_bundle.getString("protocol"), cellConstraints.xywh(2, 12, 2, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_CONFIRM_PASSWORD, cellConstraints.xywh(2, 8, 2, 1));
        panelBuilder.add((Component)this._confirmPassword, cellConstraints.xy(4, 8));
        panelBuilder.add((Component)this._password, cellConstraints.xy(4, 6));
        panelBuilder.addLabel(DialogConstants.LABEL_PASSWORD, cellConstraints.xywh(2, 6, 2, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_ISOPTIONAL, cellConstraints.xy(5, 6));
        panelBuilder.add((Component)this._userName, cellConstraints.xy(4, 4));
        panelBuilder.addLabel(DialogConstants.LABEL_USER_NAME, cellConstraints.xywh(2, 4, 2, 1));
        panelBuilder.addLabel(DialogConstants.LABEL_HOST, cellConstraints.xywh(2, 2, 2, 1));
        panelBuilder.add((Component)this._hostName, cellConstraints.xy(4, 2));
        this._promptLabel.setText(_bundle.getString("label_prompt"));
        panelBuilder.add((Component)this._promptLabel, cellConstraints.xyw(2, 10, 2));
        panelBuilder.add((Component)this._promptField, cellConstraints.xy(4, 10));
        this._promptField.setText(PROMPT);
        this._promptLabel.setVisible(false);
        this._promptField.setVisible(false);
        this._protocolType.addItem(_bundle.getString("rpc"));
        this._protocolType.addItem(_bundle.getString("ssh"));
        this._protocolType.addItem(_bundle.getString("telnet"));
        this._protocolType.setSelectedItem(_bundle.getString("rpc"));
        this._protocolType.addActionListener(new ComboBoxListener());
        panelBuilder.add((Component)this._protocolType, cellConstraints.xy(4, 12));
        FormUtils.addFillComponents(panelBuilder.getPanel(), new int[]{1, 2, 3, 4, 5}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
        return panelBuilder.getPanel();
    }

    @Override
    protected JPanel getClosePanel() {
        JPanel jPanel = new JPanel();
        this._cancel.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        this._ok.setPreferredSize(DialogConstants.CONFIRM_SIZE);
        jPanel.add(this._ok);
        jPanel.add(this._cancel);
        this._cancel.addActionListener(this);
        this._ok.addActionListener(this);
        this.getRootPane().setDefaultButton(this._ok);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancel) {
            this.dispose();
        } else if (actionEvent.getSource() == this._ok) {
            this.doOK();
        }
    }

    private boolean checkAll() {
        String string;
        if (this._hostName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_nullhost"));
            return false;
        }
        if (this._userName.getText().trim().length() != 0 && this._password.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_needpassword"));
            return false;
        }
        if (this._userName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_inputusername"));
            return false;
        }
        String string2 = String.valueOf(this._password.getPassword());
        if (!string2.equals(string = String.valueOf(this._confirmPassword.getPassword()))) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_INVALID_PASSWORD);
            return false;
        }
        if (this._promptField.isVisible() && this._promptField.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_inputprompt"));
            return false;
        }
        return true;
    }

    private void doOK() {
        if (this.checkAll()) {
            this._newHost.setProtocol(this.getRemoteHostPrtocol());
            this._newHost.setProtocolName(this.getRemoteHostProtocolName());
            this._newHost.setUser(this._userName.getText().trim());
            this._newHost.setHostName(this._hostName.getText().trim());
            List list = this.getParameterName();
            List list2 = this.getParameter();
            int n2 = list.size();
            for (int i2 = 1; i2 < n2; ++i2) {
                this._newHost.put(list.get(i2), list2.get(i2));
            }
            if (this.putRemoteHost()) {
                this.dispose();
            }
            this._isOK = true;
        }
    }

    private List getParameterName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DialogConstants.LABEL_HOST);
        arrayList.add("user_name");
        arrayList.add("password");
        arrayList.add("confirm_password");
        if (this._newHost.getProtocolName().equalsIgnoreCase(TELNET)) {
            arrayList.add("port_number");
            arrayList.add("prompt");
        } else if (this._newHost.getProtocolName().equalsIgnoreCase(SSH)) {
            arrayList.add("port_number");
        }
        return arrayList;
    }

    private List getParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this._hostName.getText().trim());
        arrayList.add(1, this._userName.getText().trim());
        arrayList.add(2, String.valueOf(this._password.getPassword()));
        arrayList.add(3, String.valueOf(this._confirmPassword.getPassword()));
        if (this._newHost.getProtocolName().equalsIgnoreCase(TELNET)) {
            arrayList.add(4, String.valueOf(23));
            arrayList.add(5, this._promptField.getText().trim());
        } else if (this._newHost.getProtocolName().equalsIgnoreCase(SSH)) {
            arrayList.add(4, String.valueOf(22));
        }
        return arrayList;
    }

    private boolean putRemoteHost() {
        if (this._isAdded) {
            long l2 = -1L;
            try {
                l2 = ProxyMBeanInvoker.INSTANCE.storeRemoteHost(this._newHost, this._probeID);
            }
            catch (Exception exception) {
                this._logger.error((Object)"store alarm remote host Error:", (Throwable)exception);
            }
            this._newHost.setHostId(l2);
            return l2 != -1L;
        }
        try {
            return ProxyMBeanInvoker.INSTANCE.modifyRemoteHost(this._newHost, this._probeID);
        }
        catch (Exception exception) {
            this._logger.error((Object)"modify alarm remote host Error", (Throwable)exception);
            return false;
        }
    }

    public boolean isOK() {
        return this._isOK;
    }

    public int getRemoteHostPrtocol() {
        if (String.valueOf(this._protocolType.getSelectedItem()).equalsIgnoreCase(TELNET)) {
            return TELNET_ID;
        }
        if (String.valueOf(this._protocolType.getSelectedItem()).equalsIgnoreCase(SSH)) {
            return SSH_ID;
        }
        return RPC_ID;
    }

    public String getRemoteHostProtocolName() {
        return (String)this._protocolType.getSelectedItem();
    }

    public FlagedRemoteHost getRemoteHost() {
        return this._newHost;
    }

    private class ComboBoxListener
    implements ActionListener {
        private ComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AlarmRemoteHostDialog.this._protocolType) {
                String string = (String)AlarmRemoteHostDialog.this._protocolType.getSelectedItem();
                if (string.equals(_bundle.getString("telnet"))) {
                    AlarmRemoteHostDialog.this._promptLabel.setVisible(true);
                    AlarmRemoteHostDialog.this._promptField.setVisible(true);
                    AlarmRemoteHostDialog.this.pack();
                } else {
                    AlarmRemoteHostDialog.this._promptLabel.setVisible(false);
                    AlarmRemoteHostDialog.this._promptField.setVisible(false);
                    AlarmRemoteHostDialog.this.pack();
                }
            }
        }
    }
}

