/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.sysuptime.common.graph.GraphScheduleBean;
import com.sysuptime.common.graph.PortScheduleBean;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.server.util.MBeanUtil;
import java.util.List;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class GraphScheduleProviderInvoker {
    private static final Logger _logger = Logger.getLogger((String)GraphScheduleProviderInvoker.class.getName());
    private static final ObjectName _objectName = MBeanUtil.create("nMaster:service=GraphScheduleProvider");
    private RMIAdaptor _adaptor;
    private static final GraphScheduleProviderInvoker INSTANCE = new GraphScheduleProviderInvoker();

    private GraphScheduleProviderInvoker() {
        try {
            this._adaptor = JNDIClient.getSingletonRMIAdaptor();
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    public static GraphScheduleProviderInvoker getInstance() {
        return INSTANCE;
    }

    public ObjectName getObjectName() {
        return _objectName;
    }

    public RMIAdaptor getRMIAdaptor() {
        return this._adaptor;
    }

    public void updatePingSchedule(GraphScheduleBean graphScheduleBean) {
        Object[] objectArray = new Object[]{graphScheduleBean};
        String[] stringArray = new String[]{GraphScheduleBean.class.getName()};
        try {
            this._adaptor.invoke(_objectName, "updatePingSchedule", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public void updatePortSchedule(PortScheduleBean portScheduleBean) {
        Object[] objectArray = new Object[]{portScheduleBean};
        String[] stringArray = new String[]{PortScheduleBean.class.getName()};
        try {
            this._adaptor.invoke(_objectName, "updatePortSchedule", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
    }

    public GraphScheduleBean getPingSchedule() {
        GraphScheduleBean graphScheduleBean = null;
        try {
            graphScheduleBean = (GraphScheduleBean)this._adaptor.invoke(_objectName, "getPingSchedule", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
        }
        return graphScheduleBean;
    }

    public PortScheduleBean getPortSchedule() {
        return null;
    }

    public long getServerTime() {
        try {
            return ((Number)this._adaptor.invoke(_objectName, "getServerCurrentTime", null, null)).longValue();
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getCause(), (Throwable)exception);
            return 0L;
        }
    }

    public List getPingFailedBeans() {
        try {
            return (List)this._adaptor.invoke(_objectName, "getPingFailedBeans", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getCause(), (Throwable)exception);
            return null;
        }
    }

    public List getPortUtilizationAlarms() {
        try {
            return (List)this._adaptor.invoke(_objectName, "getPortUtilizationAlarms", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getCause(), (Throwable)exception);
            return null;
        }
    }
}

