/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.sysuptime.common.graph.PadGraph;
import com.sysuptime.mainframe.graph.GPOverviewPanel$PannerViewfinder;
import com.sysuptime.mainframe.graph.GPOverviewPanel$ViewRedirector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import org.jgraph.JGraph;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;

public class GPOverviewPanel
extends JPanel
implements ComponentListener,
GraphModelListener,
GraphLayoutCacheListener,
PropertyChangeListener {
    protected PadGraph graph;
    protected JGraph originalGraph;
    protected GPOverviewPanel$PannerViewfinder v;
    protected Rectangle r;
    double graphWindowToPannerScale = 0.5;

    protected GPOverviewPanel(JGraph jGraph, JScrollPane jScrollPane) {
        this.originalGraph = jGraph;
        this.v = new GPOverviewPanel$PannerViewfinder(this, this, jScrollPane.getViewport());
        GPOverviewPanel$ViewRedirector gPOverviewPanel$ViewRedirector = new GPOverviewPanel$ViewRedirector(jGraph.getGraphLayoutCache());
        this.graph = new PadGraph(jGraph.getModel(), gPOverviewPanel$ViewRedirector);
        this.graph.setAntiAliased(true);
        this.graph.getModel().addGraphModelListener((GraphModelListener)this);
        this.graph.setEnabled(false);
        this.graph.addMouseListener(this.v);
        this.graph.addMouseMotionListener(this.v);
        jGraph.addPropertyChangeListener("scale", (PropertyChangeListener)this);
        this.addComponentListener(this);
        jGraph.getGraphLayoutCache().addGraphLayoutCacheListener((GraphLayoutCacheListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.graph), "Center");
    }

    public static JPanel createOverviewPanel(JGraph jGraph, JScrollPane jScrollPane) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE));
        jPanel.add((Component)new GPOverviewPanel(jGraph, jScrollPane), "Center");
        return jPanel;
    }

    @Override
    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.v.update(graphics);
    }

    public void graphLayoutCacheChanged(GraphLayoutCacheEvent graphLayoutCacheEvent) {
        this.componentResized(null);
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        this.componentResized(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        double d10 = (Double)propertyChangeEvent.getNewValue();
        this.v.scaleChanged(d10);
        this.componentResized(null);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.v.getViewport().getView().getSize();
        dimension.setSize((double)(dimension.width * 1) / this.v.zoomScale, (double)(dimension.height * 1) / this.v.zoomScale);
        Dimension dimension2 = this.getSize();
        double d10 = dimension2.getWidth() / dimension.getWidth();
        double d11 = dimension2.getHeight() / dimension.getHeight();
        this.graphWindowToPannerScale = Math.min(d10, d11);
        this.graph.setScale(this.graphWindowToPannerScale);
        this.v.synchViewportWithPanner();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.componentResized(componentEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }
}

