/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.discovery;

import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.discovery.MediationData;
import com.sysuptime.common.discovery.NodeOption;
import com.sysuptime.common.discovery.StatisticData;
import com.sysuptime.common.discovery.VlanData;
import com.sysuptime.common.graph.GrantedView;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IconJarData;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.callback.ICallbackClient;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class TopoDiscoveryMBeanInvoker {
    private static final Logger _logger = Logger.getLogger((String)TopoDiscoveryMBeanInvoker.class.getName());
    private static RMIAdaptor _adaptor;
    private static ObjectName _objectName;

    private TopoDiscoveryMBeanInvoker() {
    }

    public static void checkServer() {
        if (_adaptor == null) {
            try {
                _adaptor = JNDIClient.getSingletonRMIAdaptor();
                if (_objectName == null) {
                    _objectName = new ObjectName("nMaster:service=TopoDiscovery");
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"isServerReachable", (Throwable)exception);
            }
        }
    }

    public static ObjectName getObjectName() {
        TopoDiscoveryMBeanInvoker.checkServer();
        return _objectName;
    }

    public static RMIAdaptor getRMIAdaptor() {
        TopoDiscoveryMBeanInvoker.checkServer();
        return _adaptor;
    }

    public static RmiResponse discovery(ICallbackClient iCallbackClient) throws Exception {
        String[] stringArray = new String[]{ICallbackClient.class.getName()};
        Object[] objectArray = new Object[]{iCallbackClient};
        return (RmiResponse)_adaptor.invoke(_objectName, "discovery", objectArray, stringArray);
    }

    public static String getServerTopoTimeStamp() throws Exception {
        return (String)_adaptor.invoke(_objectName, "getServerTopoTimeStamp", null, null);
    }

    public static boolean graphDataChanged(String string) throws Exception {
        boolean bl2;
        block5: {
            block4: {
                String[] stringArray = new String[]{String.class.getName()};
                Object[] objectArray = new Object[]{string};
                try {
                    try {
                        if (_adaptor == null || !((Boolean)_adaptor.invoke(_objectName, "graphDataChanged", objectArray, stringArray)).booleanValue()) break block4;
                    }
                    catch (Exception exception) {
                        throw TopoDiscoveryMBeanInvoker.a(exception);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (Exception exception) {
                    throw TopoDiscoveryMBeanInvoker.a(exception);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static IconJarData getIconJarData(String string) throws Exception {
        String[] stringArray = new String[]{String.class.getName()};
        Object[] objectArray = new Object[]{string};
        try {
            if (_adaptor != null) {
                return (IconJarData)_adaptor.invoke(_objectName, "getIconJarData", objectArray, stringArray);
            }
        }
        catch (Exception exception) {
            throw TopoDiscoveryMBeanInvoker.a(exception);
        }
        return null;
    }

    public static void addIconFiles(Map map) throws Exception {
        String[] stringArray = new String[]{Map.class.getName()};
        Object[] objectArray = new Object[]{map};
        _adaptor.invoke(_objectName, "addIconFiles", objectArray, stringArray);
    }

    public static void notifyAllClients(ICallbackClient iCallbackClient, String string, Class[] classArray, Object[] objectArray) throws Exception {
        String[] stringArray = new String[]{ICallbackClient.class.getName(), string.getClass().getName(), Class[].class.getName(), Object[].class.getName()};
        Object[] objectArray2 = new Object[]{iCallbackClient, string, classArray, objectArray};
        _adaptor.invoke(_objectName, "notifyAllClients", objectArray2, stringArray);
    }

    public static void stopDiscovery() throws Exception {
        _adaptor.invoke(_objectName, "stopDiscovery", null, null);
    }

    public static boolean saveDiscoveryOptions(DiscoveryOptionsData discoveryOptionsData) throws Exception {
        String[] stringArray = new String[]{DiscoveryOptionsData.class.getName()};
        Object[] objectArray = new Object[]{discoveryOptionsData};
        return (Boolean)_adaptor.invoke(_objectName, "saveDiscoveryOptions", objectArray, stringArray);
    }

    public static DiscoveryOptionsData getDiscoveryOptionsData() throws Exception {
        return (DiscoveryOptionsData)_adaptor.invoke(_objectName, "getDiscoveryOptionsData", null, null);
    }

    public static VlanData getVlanData() throws Exception {
        return (VlanData)_adaptor.invoke(_objectName, "getVlanData", null, null);
    }

    public static StatisticData getStatisticData() throws Exception {
        return (StatisticData)_adaptor.invoke(_objectName, "getStatisticData", null, null);
    }

    public static StatisticData getLastStatisticData() throws Exception {
        return (StatisticData)_adaptor.invoke(_objectName, "getLastStatisticData", null, null);
    }

    public static List getMediation() throws Exception {
        return (List)_adaptor.invoke(_objectName, "getMediation", null, null);
    }

    public static List getOldMediation() throws Exception {
        return (List)_adaptor.invoke(_objectName, "getOldMediation", null, null);
    }

    public static int getOldMediationLength() throws Exception {
        return (Integer)_adaptor.invoke(_objectName, "getOldMediationLength", null, null);
    }

    public static boolean addMediation(MediationData mediationData) throws Exception {
        String[] stringArray = new String[]{mediationData.getClass().getName()};
        Object[] objectArray = new Object[]{mediationData};
        return (Boolean)_adaptor.invoke(_objectName, "addMediation", objectArray, stringArray);
    }

    public static boolean deleteMediation(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string.getClass().getName(), string2.getClass().getName()};
        Object[] objectArray = new Object[]{string, string2};
        return (Boolean)_adaptor.invoke(_objectName, "deleteMediation", objectArray, stringArray);
    }

    public static boolean modifyMediation(MediationData mediationData) throws Exception {
        String[] stringArray = new String[]{mediationData.getClass().getName()};
        Object[] objectArray = new Object[]{mediationData};
        return (Boolean)_adaptor.invoke(_objectName, "modifyMediation", objectArray, stringArray);
    }

    public static MediationData getMediation(String string, String string2) throws Exception {
        String[] stringArray = new String[]{string.getClass().getName(), string2.getClass().getName()};
        Object[] objectArray = new Object[]{string, string2};
        return (MediationData)_adaptor.invoke(_objectName, "getMediation", objectArray, stringArray);
    }

    public static List getAllViewIDs() {
        Object object = null;
        try {
            object = _adaptor.invoke(_objectName, "getAllViewIDs", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return (List)object;
    }

    public static List getAllGrantedViews() {
        Object object = null;
        try {
            object = _adaptor.invoke(_objectName, "getAllGrantedViews", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return (List)object;
    }

    public static boolean deleteView(GraphID graphID) {
        String[] stringArray = new String[]{GraphID.class.getName()};
        Object[] objectArray = new Object[]{graphID};
        try {
            return (Boolean)_adaptor.invoke(_objectName, "deleteView", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public static boolean deleteByViewID(String string) {
        String[] stringArray = new String[]{String.class.getName()};
        Object[] objectArray = new Object[]{string};
        try {
            return (Boolean)_adaptor.invoke(_objectName, "deleteByViewID", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public static boolean modifyGrantedView(GrantedView grantedView) {
        String[] stringArray = new String[]{GrantedView.class.getName()};
        Object[] objectArray = new Object[]{grantedView};
        try {
            return (Boolean)_adaptor.invoke(_objectName, "modifyGrantedView", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public static List scanServices(NetworkNodeBean networkNodeBean) {
        String[] stringArray = new String[]{NetworkNodeBean.class.getName()};
        Object[] objectArray = new Object[]{networkNodeBean};
        try {
            return (List)_adaptor.invoke(_objectName, "scanServices", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static boolean shouldConfirmFirstDiscovery() {
        try {
            return (Boolean)_adaptor.invoke(_objectName, "shouldConfirmFirstDiscovery", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return true;
        }
    }

    public static void setDiscovered(boolean bl2) {
        String[] stringArray = new String[]{"boolean"};
        Object[] objectArray = new Object[]{bl2};
        try {
            _adaptor.invoke(_objectName, "setDiscovered", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public static List getCustomerIDs() {
        try {
            return (List)_adaptor.invoke(_objectName, "getCustomerIDs", null, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static boolean updateNode(NodeOption nodeOption) {
        String[] stringArray = new String[]{NodeOption.class.getName()};
        Object[] objectArray = new Object[]{nodeOption};
        try {
            return (Boolean)_adaptor.invoke(_objectName, "updateNode", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return true;
        }
    }

    public static void setTopoBaseline() throws Exception {
        _adaptor.invoke(_objectName, "setTopoBaseline", null, null);
    }

    public static RmiResponse compareTopology() throws Exception {
        return (RmiResponse)_adaptor.invoke(_objectName, "compareTopology", null, null);
    }

    static {
        try {
            _adaptor = JNDIClient.getSingletonRMIAdaptor();
            _objectName = new ObjectName("nMaster:service=TopoDiscovery");
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

