/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.actions;

import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.ViewComponent;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.graph.customview.CustomViewDialog;
import com.sysuptime.mainframe.login.LoginMBeanInvoker;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class CustomViewAction
extends SystemAction
implements Presenter.Menu {
    public String getName() {
        return CustomViewAction.a("actions_graphview_customview");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        NetworkGraphModel networkGraphModel;
        if (GraphLoader.getInstance().isEmpty()) {
            JOptionPane.showMessageDialog(Startup.getFrame(), CustomViewAction.a("action_customview_msg_noTopology"));
            return;
        }
        CustomViewDialog customViewDialog = new CustomViewDialog(Startup.getFrame(), true);
        customViewDialog.pack();
        SwingUtil.centerOnFrame(Startup.getFrame(), customViewDialog);
        customViewDialog.setVisible(true);
        if (customViewDialog.isOK() && (networkGraphModel = customViewDialog.getGraphModel()) != null) {
            List list;
            ViewComponent viewComponent = new ViewComponent(networkGraphModel);
            viewComponent.open();
            viewComponent.requestActive();
            if (!GraphLoader.save2Local(new NetworkGraph(networkGraphModel))) {
                JOptionPane.showMessageDialog(customViewDialog, CustomViewAction.a("msg_failedOnLocal"));
            }
            if (!GraphLoader.save2Server(networkGraphModel, false)) {
                JOptionPane.showMessageDialog(customViewDialog, CustomViewAction.a("msg_failedOnServer"));
            }
            if ((list = customViewDialog.getSelectedOrgs()) != null && !list.isEmpty()) {
                LoginMBeanInvoker.insertOrgViewRelation(list, networkGraphModel.getID().getGraphName());
            }
        }
    }

    public JMenuItem getMenuPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    private static String a(String string) {
        return NbBundle.getMessage(CustomViewAction.class, (String)string);
    }
}

