/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.graph.ViewGraphModel;
import com.sysuptime.mainframe.ComponentUtils;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.ViewID;
import com.sysuptime.mainframe.graph.EditGraphPane;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.util.FunctionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.GraphModel;
import org.openide.windows.TopComponent;

public class ViewComponent
extends TopComponent {
    private static final Logger _logger = Logger.getLogger((String)ViewComponent.class.getName());
    private transient NetworkGraph _graph;
    private transient boolean _isShowing;
    private transient boolean _isToolBoxShowing;
    private int dividerLocation;

    public ViewComponent() {
        this(null);
    }

    public ViewComponent(NetworkGraphModel networkGraphModel) {
        block4: {
            block5: {
                boolean bl2 = Startup.g();
                boolean bl3 = bl2;
                this._isToolBoxShowing = true;
                this.dividerLocation = -1;
                this._graph = new NetworkGraph(networkGraphModel);
                if (networkGraphModel == null) {
                    this._graph.setGraphID(IGraphParameters.MASTER_MASTER);
                }
                JScrollPane jScrollPane = new JScrollPane((Component)((Object)this._graph));
                this.setLayout(new BorderLayout());
                this.add(jScrollPane, "Center");
                if (networkGraphModel == null) break block4;
                if (!(networkGraphModel instanceof TopologyGraphModel)) break block5;
                this.setDisplayName(IGraphParameters.TOPOLOGY_VIEW);
                if (bl3) break block4;
            }
            this.setDisplayName(networkGraphModel.getID().getGraphName());
        }
        this._graph.getModel().addGraphModelListener((GraphModelListener)ConsoleComponent.getInstance().getTreeView());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        GraphID graphID = (GraphID)objectInput.readObject();
        if (graphID == null) {
            graphID = IGraphParameters.MASTER_MASTER;
        }
        this.loadGraph(graphID, GraphLoader.getInstance().isEmpty());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        GraphID graphID = this._graph.getGraphID();
        objectOutput.writeObject(graphID);
    }

    public TopComponent getTopComponent() {
        return this;
    }

    public NetworkGraph getGraph() {
        return this._graph;
    }

    public List getCurrentGraphBeans() {
        return this._graph.getBeans();
    }

    /*
     * Unable to fully structure code
     */
    public void setToolBoxVisible(boolean var1_1) {
        block9: {
            block8: {
                var2_2 = Startup.h();
                try {
                    if (this._graph.getModel() instanceof MasterGraphModel || this._graph.getModel() instanceof ViewGraphModel) break block8;
                }
                catch (Exception v0) {
                    throw ViewComponent.a(v0);
                }
                var3_3 = this._graph.getGraphID().getCustomerID();
                var4_4 = Long.parseLong((String)var3_3);
                try {
                    if (!ProxyMBeanInvoker.INSTANCE.isActive(var4_4)) {
                        var1_1 = false;
                    }
                }
                catch (Exception var6_6) {
                    ViewComponent._logger.error((Object)"", (Throwable)var6_6);
                }
            }
            if (!var1_1) ** GOTO lbl32
            this.removeAll();
            var3_3 = new JScrollPane(EditGraphPane.createEditPane(this._graph));
            var3_3.setToolTipText("To add new device: Drag icon to the left pane. Right click to show more device icons.");
            var4_5 = new JPanel();
            var4_5.setLayout(new BorderLayout());
            var4_5.add((Component)new JScrollPane((Component)this._graph), "Center");
            var5_7 = new JLabel("<html><body> &nbsp;<b><font color=blue>Tip</font></b>: Drag an icon to move it around. Drag an icon from the right toolbox to add new device. Right click on an icon or empty area to show more options.");
            try {
                var5_7.setBorder(new EmptyBorder(4, 8, 4, 8));
                var4_5.add((Component)var5_7, "South");
                var4_5.setBackground(Color.white);
                this.add(var4_5, "Center");
                this.add(new JScrollPane((Component)var3_3), "East");
                this._isToolBoxShowing = true;
                if (!var2_2) break block9;
lbl32:
                // 2 sources

                this.removeAll();
                this.add("Center", new JScrollPane((Component)this._graph));
                this._isToolBoxShowing = false;
            }
            catch (Exception v1) {
                throw ViewComponent.a(v1);
            }
        }
        this.revalidate();
    }

    public boolean getToolBoxVisible() {
        return this._isToolBoxShowing;
    }

    public String getComponentID() {
        return this.getDisplayName();
    }

    public ViewID getViewID() {
        return new ViewID(this.getComponentID(), this._graph.getGraphID());
    }

    public int getPersistenceType() {
        return 1;
    }

    protected String preferredID() {
        return this.getDisplayName();
    }

    protected void componentClosed() {
        super.componentClosed();
        if (ComponentUtils.getOpenedViewCount() == 1) {
            ConsoleComponent.getInstance().clearTree();
        }
    }

    protected void componentShowing() {
        ConsoleComponent.getInstance().setCurrentComponent(this);
        this._isShowing = true;
        this._graph.updateStatus();
    }

    protected void componentActivated() {
        super.componentActivated();
        ConsoleComponent consoleComponent = ConsoleComponent.getInstance();
        if (ComponentUtils.getShowViewCount() > 1 && this._isShowing && this != consoleComponent.getCurrentComponent()) {
            consoleComponent.setCurrentComponent(this);
        }
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
    }

    protected void componentHidden() {
        super.componentHidden();
        this._isShowing = false;
    }

    public boolean loadGraph(GraphID graphID, boolean bl2) {
        NetworkGraphModel networkGraphModel = GraphLoader.loadModel(graphID, bl2);
        if (networkGraphModel != null) {
            this._graph.setModel((GraphModel)networkGraphModel);
            this._graph.getModel().addGraphModelListener((GraphModelListener)ConsoleComponent.getInstance().getTreeView());
            this._graph.discardAllEdits();
            this._graph.updateStatus();
            this.setToolBoxVisible(FunctionManager.getInstance().isEditGraphEnabled());
            return true;
        }
        return false;
    }

    public boolean reloadGraph(boolean bl2) {
        GraphID graphID = this._graph.getGraphID();
        boolean bl3 = this.loadGraph(graphID != null ? graphID : IGraphParameters.MASTER_MASTER, bl2);
        if (!bl3 && this._graph.isSubnet()) {
            bl3 = this.loadGraph(IGraphParameters.MASTER_MASTER, bl2);
        }
        return bl3;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    public void setDividerLocation(int n2) {
        this.dividerLocation = n2;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

