/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe;

import com.sysuptime.common.alarm.Alarm;
import com.sysuptime.common.alarm.AlarmsChange;
import com.sysuptime.common.alarm.BeanAlarms;
import com.sysuptime.common.alarm.PortUtilAlarm;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.PortScheduleBean;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.Layer2Connection;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.ParentNode;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.graph.GraphScheduleProviderInvoker;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.openide.util.NbBundle;

public class AlarmViewController {
    public static final Color COLOR_MINOR = Color.yellow;
    public static final Color COLOR_CRITICAL = Color.red;
    public static final AlarmViewController INSTANCE = new AlarmViewController();
    private Vector _propertyChangeListeners = new Vector();
    private Map _beanAlarms = new Hashtable();
    private PortScheduleBean _portSchedule = GraphScheduleProviderInvoker.getInstance().getPortSchedule();

    private AlarmViewController() {
    }

    private boolean a(String string) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            return beanAlarms.hasPingAlarm();
        }
        return false;
    }

    private boolean b(String string) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            return beanAlarms.hasTrapAlarm();
        }
        return false;
    }

    private boolean a(String string, String string2) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            return beanAlarms.hasPingAlarmInSubnet(string2);
        }
        return false;
    }

    private boolean b(String string, String string2) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            return beanAlarms.hasTrapAlarmInSubnet(string2);
        }
        return false;
    }

    private BeanAlarms c(String string) {
        return (BeanAlarms)this._beanAlarms.get(string);
    }

    public void updateFirstly() {
        List list = GraphScheduleProviderInvoker.getInstance().getPingFailedBeans();
        this.a(list);
        this.a();
    }

    private void a(List list) {
        boolean bl2 = Startup.g();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Alarm alarm = (Alarm)list.get(i2);
                this.a(alarm);
                if (bl2) continue;
            }
        }
    }

    private void b(List list) {
        boolean bl2 = Startup.h();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Alarm alarm = (Alarm)list.get(i2);
                this.c(alarm);
                if (!bl2) continue;
            }
        }
    }

    private void a(Alarm alarm) {
        String string = alarm.getBeanID();
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms == null) {
            beanAlarms = new BeanAlarms();
            this._beanAlarms.put(string, beanAlarms);
        }
        beanAlarms.addPingAlarm(alarm);
    }

    private void b(Alarm alarm) {
        String string = alarm.getBeanID();
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms == null) {
            beanAlarms = new BeanAlarms();
            this._beanAlarms.put(string, beanAlarms);
        }
        beanAlarms.addTrapAlarm(alarm);
    }

    private void c(Alarm alarm) {
        String string = alarm.getBeanID();
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            beanAlarms.removePingAlarm(alarm);
        }
    }

    public void removeTrapAlarm(Alarm alarm) {
        String string = alarm.getBeanID();
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            beanAlarms.removeTrapAlarm(alarm);
        }
    }

    public void addTrapAlarms(List list) {
        boolean bl2 = Startup.g();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Alarm alarm = (Alarm)list.get(i2);
                this.b(alarm);
                if (bl2) continue;
            }
        }
    }

    private void c(List list) {
        boolean bl2 = Startup.h();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Alarm alarm = (Alarm)list.get(i2);
                this.removeTrapAlarm(alarm);
                if (!bl2) continue;
            }
        }
    }

    private void d(List list) {
        boolean bl2 = Startup.h();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                PortUtilAlarm portUtilAlarm = (PortUtilAlarm)list.get(i2);
                this.a(portUtilAlarm);
                if (!bl2) continue;
            }
        }
    }

    private void a(PortUtilAlarm portUtilAlarm) {
        String string = portUtilAlarm.getBeanID();
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms == null) {
            beanAlarms = new BeanAlarms();
            this._beanAlarms.put(string, beanAlarms);
        }
        beanAlarms.addUtilAlarm(portUtilAlarm);
    }

    private void a() {
        this.b();
        ConsoleComponent consoleComponent = ConsoleComponent.getInstance();
        consoleComponent.updateStatus();
    }

    private boolean d(String string) {
        return this.a(string) || this.b(string);
    }

    private boolean c(String string, String string2) {
        return this.a(string, string2) || this.b(string, string2);
    }

    private boolean a(SubnetNode subnetNode) {
        return this.hasPingAlarmInSubnet(subnetNode) || this.hasTrapAlarmInSubnet(subnetNode);
    }

    private boolean a(CustomerNode customerNode) {
        boolean bl2;
        block2: {
            List<TopoNode> list = customerNode.getChildren();
            boolean bl3 = Startup.g();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = list.get(i2);
                bl2 = this.isAlarming(topoNode);
                if (bl3) {
                    if (!bl2) continue;
                    return true;
                }
                break block2;
            }
            bl2 = false;
        }
        return bl2;
    }

    public boolean isAlarming(TopoNode topoNode) {
        if (topoNode instanceof DeviceNode) {
            ParentNode parentNode = topoNode.getParentNode();
            if (parentNode instanceof SubnetNode) {
                String string = ((SubnetNode)parentNode).getIP();
                return this.c(topoNode.getID(), string);
            }
            return this.d(topoNode.getID());
        }
        if (topoNode instanceof SubnetNode) {
            return this.a((SubnetNode)topoNode);
        }
        if (topoNode instanceof CustomerNode) {
            return this.a((CustomerNode)topoNode);
        }
        return false;
    }

    public boolean hasPingAlarmInSubnet(SubnetNode subnetNode) {
        boolean bl2;
        boolean bl3 = Startup.g();
        if (subnetNode.hasChildren()) {
            String string = subnetNode.getPrivateID();
            List<TopoNode> list = subnetNode.getChildren();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = list.get(i2);
                bl2 = this.a(topoNode.getID(), string);
                if (bl3) {
                    if (!bl2) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public boolean hasTrapAlarmInSubnet(SubnetNode subnetNode) {
        boolean bl2;
        boolean bl3 = Startup.h();
        if (subnetNode.hasChildren()) {
            String string = subnetNode.getPrivateID();
            List<TopoNode> list = subnetNode.getChildren();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = list.get(i2);
                bl2 = this.b(topoNode.getID(), string);
                if (!bl3) {
                    if (!bl2) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public boolean hasTrapAlarmInCustomer(CustomerNode customerNode) {
        boolean bl2;
        boolean bl3 = Startup.g();
        if (customerNode.hasChildren()) {
            List<TopoNode> list = customerNode.getChildren();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = list.get(i2);
                bl2 = topoNode instanceof DeviceNode;
                if (bl3) {
                    if (!(bl2 ? this.b(topoNode.getBean().getID()) : topoNode instanceof SubnetNode && this.hasTrapAlarmInSubnet((SubnetNode)topoNode))) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public boolean hasPingAlarmInCustomer(CustomerNode customerNode) {
        boolean bl2;
        boolean bl3 = Startup.g();
        if (customerNode.hasChildren()) {
            List<TopoNode> list = customerNode.getChildren();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = list.get(i2);
                bl2 = topoNode instanceof DeviceNode;
                if (bl3) {
                    if (!(bl2 ? this.a(topoNode.getBean().getID()) : topoNode instanceof SubnetNode && this.hasPingAlarmInSubnet((SubnetNode)topoNode))) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public void clearPingAlarms(String string) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            beanAlarms.clearPingAlarms();
        }
    }

    public void clearTrapAlarms(String string) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            beanAlarms.clearTrapAlarms();
        }
    }

    public void clearAllPingAlarms() {
        Iterator iterator = this._beanAlarms.values().iterator();
        boolean bl2 = Startup.h();
        while (iterator.hasNext()) {
            BeanAlarms beanAlarms = (BeanAlarms)iterator.next();
            beanAlarms.clearPingAlarms();
            if (!bl2) continue;
        }
    }

    public void clearAllAlarms() {
        this._beanAlarms.clear();
    }

    public String getCustomerToolTip(CustomerNode customerNode, String string) {
        StringBuffer stringBuffer;
        block3: {
            block2: {
                stringBuffer = new StringBuffer("<html>");
                boolean bl2 = Startup.g();
                if (!this.a(customerNode)) break block2;
                stringBuffer.append("<strong><font size=3 color=red>");
                stringBuffer.append(string);
                stringBuffer.append(this.b(customerNode));
                if (bl2) break block3;
            }
            stringBuffer.append("<strong><font size=3 color=green>");
            stringBuffer.append(string);
        }
        stringBuffer.append("</font></strong>");
        stringBuffer.append("<html>");
        return stringBuffer.toString();
    }

    private String b(CustomerNode customerNode) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasPingAlarmInCustomer(customerNode)) {
            stringBuffer.append("<br>");
            stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_ping_failed"));
        }
        if (this.hasTrapAlarmInCustomer(customerNode)) {
            stringBuffer.append("<br>");
            stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_snmp_trap"));
        }
        return stringBuffer.toString();
    }

    public String getSubnetToolTip(SubnetNode subnetNode, String string) {
        StringBuffer stringBuffer;
        block3: {
            block2: {
                stringBuffer = new StringBuffer("<html>");
                boolean bl2 = Startup.h();
                if (!this.a(subnetNode)) break block2;
                stringBuffer.append("<strong><font size=3 color=red>");
                stringBuffer.append(string);
                stringBuffer.append(this.b(subnetNode));
                if (!bl2) break block3;
            }
            stringBuffer.append("<strong><font size=3 color=green>");
            stringBuffer.append(string);
        }
        stringBuffer.append("</font></strong>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private String b(SubnetNode subnetNode) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasPingAlarmInSubnet(subnetNode)) {
            stringBuffer.append("<br>");
            stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_ping_failed"));
        }
        if (this.hasTrapAlarmInSubnet(subnetNode)) {
            stringBuffer.append("<br>");
            stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_snmp_trap"));
        }
        return stringBuffer.toString();
    }

    public String getDeviceToolTipContent(DeviceBean deviceBean) {
        StringBuffer stringBuffer;
        block2: {
            stringBuffer = new StringBuffer("<html>");
            NetworkInterface[] networkInterfaceArray = deviceBean.getInterfaces();
            stringBuffer.append(this.a(networkInterfaceArray.length));
            stringBuffer.append("<ol>");
            boolean bl2 = Startup.g();
            for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                stringBuffer.append(this.a(deviceBean, networkInterfaceArray[i2]));
                if (bl2) {
                    if (bl2) continue;
                }
                break block2;
            }
            stringBuffer.append("</ol>");
            stringBuffer.append("</html>");
        }
        return stringBuffer.toString();
    }

    private String a(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<strong><font color=black size=3>");
        stringBuffer.append(ICommonBundle.INTERFACES);
        stringBuffer.append(" [ ");
        stringBuffer.append(n2);
        stringBuffer.append(" ]:");
        stringBuffer.append("</font></strong>");
        return stringBuffer.toString();
    }

    private String a(DeviceBean deviceBean, NetworkInterface networkInterface) {
        BeanAlarms beanAlarms;
        StringBuffer stringBuffer;
        long l2;
        String string;
        String string2;
        String string3;
        block12: {
            block11: {
                EthernetInterface ethernetInterface = (EthernetInterface)networkInterface;
                string3 = ethernetInterface.getIpAddress();
                string2 = ethernetInterface.getMacAddress();
                string = String.valueOf(ethernetInterface.getIfIndex());
                boolean bl2 = Startup.h();
                l2 = ethernetInterface.getIfSpeed();
                stringBuffer = new StringBuffer();
                stringBuffer.append("<li><font size=3 color=");
                beanAlarms = this.c(deviceBean.getID());
                if (beanAlarms == null || !beanAlarms.pingFailed(string3) && !beanAlarms.hasTrapAlarm(string3)) break block11;
                stringBuffer.append("red>");
                if (!bl2) break block12;
            }
            stringBuffer.append("black>");
        }
        if (string3 != null && string3.trim().length() != 0) {
            stringBuffer.append("  ").append("IP:").append(" ");
            stringBuffer.append(string3);
        }
        if (string2 != null && string2.trim().length() != 0 && !string2.equals("00-00-00-00-00-00")) {
            stringBuffer.append("<br>").append("  ").append("MAC:").append(" ");
            stringBuffer.append(string2);
        }
        if (string != null && string.length() != 0 && !string.equals("-1")) {
            stringBuffer.append("<br>").append("  ").append("ifIndex:").append(" ");
            stringBuffer.append(string);
        }
        if (l2 > 0L) {
            stringBuffer.append("<br>").append("  ").append("ifSpeed: ");
            stringBuffer.append(l2).append("Mbps");
        }
        if (beanAlarms != null) {
            Serializable serializable;
            Color color = this.b(beanAlarms.getMaxSeverity(string3));
            String string4 = StringUtil.color2String(color);
            if (beanAlarms.hasUtilization(string3)) {
                stringBuffer.append("<br>");
                stringBuffer.append("  ").append(ICommonBundle.BANDWIDTH_UTILIZATION).append(": ");
                stringBuffer.append("<font color=").append(string4).append(">");
                serializable = NumberFormat.getInstance();
                ((NumberFormat)serializable).setMaximumFractionDigits(3);
                PortUtilAlarm portUtilAlarm = beanAlarms.getPortAlarm(string3);
                stringBuffer.append(((NumberFormat)serializable).format(portUtilAlarm.getPortUtilization())).append("%");
                stringBuffer.append("</font>");
            }
            if (beanAlarms.pingFailed(string3)) {
                serializable = beanAlarms.getPingAlarm(string3);
                stringBuffer.append("<br>");
                long l3 = System.currentTimeMillis() - ((Alarm)serializable).getStartTime();
                stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_ping_failed"));
                stringBuffer.append(" : ");
                stringBuffer.append(StringUtil.getTimeStamp(l3));
            }
            if (beanAlarms.hasTrapAlarm(string3)) {
                serializable = beanAlarms.getLastTrapAlarm(string3);
                stringBuffer.append("<br>");
                long l4 = System.currentTimeMillis() - ((Alarm)serializable).getStartTime();
                stringBuffer.append(NbBundle.getMessage(NetworkNode.class, (String)"MSG_snmp_trap"));
                stringBuffer.append(" : ");
                stringBuffer.append(StringUtil.getTimeStamp(l4));
            }
        }
        stringBuffer.append("</font><br></li>");
        return stringBuffer.toString();
    }

    public void updatePingAlarms(AlarmsChange alarmsChange) {
        this.a(alarmsChange.getAddingAlarms());
        this.b(alarmsChange.getDeletingAlarms());
    }

    public void updateTrapAlarms(AlarmsChange alarmsChange) {
        this.addTrapAlarms(alarmsChange.getAddingAlarms());
        this.c(alarmsChange.getDeletingAlarms());
    }

    public boolean isAlarming(NetworkNodeBean networkNodeBean, NetworkGraphModel networkGraphModel) {
        if (networkGraphModel instanceof TopologyGraphModel) {
            TopoNode topoNode = ((TopologyGraphModel)networkGraphModel).getTopoNode(networkNodeBean);
            return this.isAlarming(topoNode);
        }
        return this.d(networkNodeBean.getID());
    }

    private Color b(int n2) {
        switch (n2) {
            case 2: {
                return COLOR_MINOR;
            }
            case 3: {
                return COLOR_CRITICAL;
            }
        }
        return null;
    }

    public Color getWarningColor(String string) {
        BeanAlarms beanAlarms = this.c(string);
        if (beanAlarms != null) {
            return this.b(beanAlarms.getMaxSeverity());
        }
        return null;
    }

    public void updatePortUtilizationAlarms(List list) {
        this._portSchedule = GraphScheduleProviderInvoker.getInstance().getPortSchedule();
        if (list != null) {
            this.d(list);
        }
        this.a();
    }

    public String getConnectionToolTip(NetworkConnection networkConnection) {
        double d10;
        if (networkConnection instanceof Layer2Connection) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><strong>");
        if (networkConnection.hasSource() && networkConnection.hasTarget()) {
            stringBuffer.append("<font color=blue size=3>");
            stringBuffer.append(networkConnection.getNetworkInterface1()).append(" --- ").append(networkConnection.getNetworkInterface2());
            if (networkConnection.getBandwidth() != -1L) {
                stringBuffer.append("<br>").append(ICommonBundle.BANDWIDTH).append(": ").append(networkConnection.getBandwidth()).append("Mbps");
            }
            stringBuffer.append("</font>");
        }
        if (!networkConnection.hasSource()) {
            stringBuffer.append("<br><font color=red size=3>No source interface</font>");
        }
        if (!networkConnection.hasTarget()) {
            stringBuffer.append("<br><font color=red size=3>No target interface</font>");
        }
        if ((d10 = this.b(networkConnection)) > 0.0) {
            stringBuffer.append("<br><font size=3 color=green>").append(ICommonBundle.BANDWIDTH_UTILIZATION).append(": ");
            int n2 = this._portSchedule.getSeverity(d10);
            stringBuffer.append("<font color=").append(StringUtil.color2String(this.b(n2))).append(">");
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(3);
            stringBuffer.append(numberFormat.format(d10));
            stringBuffer.append("%</font></font>");
        }
        stringBuffer.append("</strong>");
        return stringBuffer.toString();
    }

    private int a(NetworkConnection networkConnection) {
        double d10 = this.b(networkConnection);
        return this._portSchedule.getSeverity(d10);
    }

    public Color getWarningColor(NetworkConnection networkConnection) {
        return this.b(this.a(networkConnection));
    }

    private double b(NetworkConnection networkConnection) {
        double d10 = -1.0;
        EthernetInterface ethernetInterface = (EthernetInterface)networkConnection.getNetworkInterface1();
        if (networkConnection.hasSource()) {
            d10 = this.a(ethernetInterface);
        }
        if (d10 == -1.0 && networkConnection.hasTarget()) {
            d10 = this.a((EthernetInterface)networkConnection.getNetworkInterface2());
        }
        long l2 = networkConnection.getBandwidth();
        if (d10 != -1.0 && l2 > 0L && ethernetInterface != null) {
            long l3 = ethernetInterface.getIfSpeed();
            d10 *= (double)(l3 / l2);
        }
        return d10;
    }

    private double a(EthernetInterface ethernetInterface) {
        String string;
        PortUtilAlarm portUtilAlarm;
        BeanAlarms beanAlarms;
        NetworkNodeBean networkNodeBean = ethernetInterface.getHostNode();
        if (networkNodeBean instanceof DeviceBean && (beanAlarms = this.c(networkNodeBean.getID())) != null && (portUtilAlarm = beanAlarms.getPortAlarm(string = ethernetInterface.getIpAddress())) != null) {
            return portUtilAlarm.getPortUtilization();
        }
        return -1.0;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeListeners.remove(propertyChangeListener);
    }

    private void b() {
        int n2 = this._propertyChangeListeners.size();
        boolean bl2 = Startup.g();
        for (int i2 = 0; i2 < n2; ++i2) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._propertyChangeListeners.get(i2);
            propertyChangeListener.propertyChange(null);
            if (bl2) continue;
        }
    }
}

