/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.msp;

import com.sysuptime.common.discovery.DiscoveryOptionsData;
import com.sysuptime.common.discovery.PortInfo;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.msp.Response;
import com.sysuptime.server.discovery.DiscoveryStatus;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.log4j.Logger;

public class Serializer {
    private static final Logger _logger = Logger.getLogger((String)Serializer.class.getName());
    private XStream _xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
    public static final Serializer INSTANCE = new Serializer();

    private Serializer() {
        this._xStream.alias("response", Response.class);
        this._xStream.alias("discoveryOptionsData", DiscoveryOptionsData.class);
        this._xStream.alias("portInfo", PortInfo.class);
        this._xStream.alias("netIf", NetworkInterface.class);
        this._xStream.omitField(NetworkInterface.class, "_hostNode");
        this._xStream.omitField(NetworkInterface.class, "_hostConnection");
        this._xStream.alias("timebasedObject", DiscoveryStatus.TimeBasedObject.class);
    }

    public void alias(String string, Class clazz) {
        this._xStream.alias(string, clazz);
    }

    public synchronized String toXML(Object object) {
        return this._xStream.toXML(object);
    }

    public synchronized Object fromXML(String string) throws Exception {
        try {
            return this._xStream.fromXML(string);
        }
        catch (StreamException streamException) {
            _logger.error((Object)("XML couldn't be converted to object:[[[\n" + string + "\n]]]"));
            throw streamException;
        }
    }
}

