/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.model;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.ag;
import com.ireasoning.protocol.snmp.aj;
import com.sysuptime.common.graph.CustomerGraphModel;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.model.CIM_UnitaryComputerSystemBeanSupport;
import com.sysuptime.common.model.ClassMap;
import com.sysuptime.common.model.Customer;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.GenericNode;
import com.sysuptime.common.model.Host;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Router;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.model.Switch;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.msp.Command;
import java.util.Collection;
import java.util.Iterator;
import javax.wbem.cim.CIMException;
import org.apache.log4j.Logger;
import org.jgraph.graph.GraphModel;

public final class ModelUtil {
    private static Logger _logger = Logger.getLogger((String)ModelUtil.class.getName());

    public static String varBind2String(SnmpVarBind snmpVarBind) {
        try {
            if (snmpVarBind == null) {
                return "";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        String string = null;
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        if (snmpDataType == null) {
            string = "";
        } else if (snmpVarBind.getType() == 64) {
            byte[] byArray = ((aj)snmpDataType).getValue();
            if (byArray.length > 4) {
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, 0, byArray2, 0, 4);
                string = new aj(byArray2).toString();
            } else {
                string = snmpDataType.toString();
            }
        } else {
            string = snmpDataType.toString();
            string = ModelUtil.hex2Mac(string);
        }
        return string;
    }

    public static String hex2Mac(String string) {
        block9: {
            try {
                if (string == null) {
                    return "";
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ModelUtil.a(illegalArgumentException);
            }
            int n2 = string.length();
            try {
                try {
                    try {
                        if (n2 != 29 && n2 != 39) break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                    if (!string.startsWith("0x")) break block9;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
                if (string.charAt(4) != ' ') break block9;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ModelUtil.a(illegalArgumentException);
            }
            string = string.substring(2);
            string = StringUtil.replaceString(string, "0x", "-");
            return StringUtil.trimAll(string);
        }
        return string;
    }

    public static String octect2String(SnmpVarBind snmpVarBind) {
        try {
            if (snmpVarBind == null) {
                return "";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        String string = null;
        SnmpDataType snmpDataType = snmpVarBind.getValue();
        if (snmpDataType == null) {
            string = "";
        } else {
            ag ag2 = (ag)snmpDataType;
            String string2 = ag2.toHexString();
            string = StringUtil.hex2String(string2);
        }
        return string;
    }

    public static NetworkInterface getInterfaceByIp(NetworkNodeBean networkNodeBean, String string) {
        block13: {
            Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
            try {
                if (networkNodeBean == null) {
                    return null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ModelUtil.a(illegalArgumentException);
            }
            try {
                try {
                    if (string != null && string.length() != 0) break block13;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ModelUtil.a(illegalArgumentException);
            }
        }
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        if (networkInterfaceArray != null) {
            for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                try {
                    try {
                        if (!(networkInterfaceArray[i2] instanceof EthernetInterface) || !((EthernetInterface)networkInterfaceArray[i2]).getIpAddress().equals(string)) continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                    return networkInterfaceArray[i2];
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
            }
        }
        return null;
    }

    public static Subnet getSubnetByHostIP(Collection collection, String string) {
        String string2 = string.substring(0, string.lastIndexOf(46) + 1) + "0";
        Iterator iterator = collection.iterator();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        block2: while (true) {
            boolean bl2 = iterator.hasNext();
            block3: while (bl2) {
                NetworkInterface[] networkInterfaceArray;
                NetworkNodeBean networkNodeBean = (NetworkNodeBean)iterator.next();
                if (!ModelUtil.isSubnet(networkNodeBean) || (networkInterfaceArray = networkNodeBean.getInterfaces()) == null) continue block2;
                for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                    EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
                    bl2 = string2.equals(ethernetInterface.getIpAddress());
                    if (commandArray != null) continue block3;
                    try {
                        if (!bl2) continue;
                        return (Subnet)networkNodeBean;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                }
                if (commandArray == null) continue block2;
            }
            break;
        }
        return null;
    }

    public static boolean isCustomer(NetworkNodeBean networkNodeBean) {
        return networkNodeBean instanceof Customer;
    }

    public static boolean isSubnet(NetworkNodeBean networkNodeBean) {
        try {
            if (networkNodeBean == null) {
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw ModelUtil.a((Exception)((Object)cIMException));
        }
        try {
            if (networkNodeBean.getDedicated() == Subnet.DEDICATED) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            return false;
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"isSubnet", (Throwable)cIMException);
            return false;
        }
    }

    public static boolean isRouter(NetworkNodeBean networkNodeBean) {
        try {
            if (networkNodeBean == null) {
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw ModelUtil.a((Exception)((Object)cIMException));
        }
        try {
            if (networkNodeBean.getDedicated() == Router.DEDICATED) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            return false;
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"isRouter", (Throwable)cIMException);
            return false;
        }
    }

    public static boolean isHost(NetworkNodeBean networkNodeBean) {
        try {
            if (networkNodeBean == null) {
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw ModelUtil.a((Exception)((Object)cIMException));
        }
        try {
            if (networkNodeBean.getDedicated() == Host.DEDICATED) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            return false;
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"isHost", (Throwable)cIMException);
            return false;
        }
    }

    public static boolean isGenericNode(NetworkNodeBean networkNodeBean) {
        try {
            if (networkNodeBean == null) {
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw ModelUtil.a((Exception)((Object)cIMException));
        }
        try {
            if (networkNodeBean.getDedicated() == GenericNode.DEDICATED) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            return false;
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"isGenericNode", (Throwable)cIMException);
            return false;
        }
    }

    public static boolean isSwitch(NetworkNodeBean networkNodeBean) {
        try {
            if (networkNodeBean == null) {
                return false;
            }
        }
        catch (CIMException cIMException) {
            throw ModelUtil.a((Exception)((Object)cIMException));
        }
        try {
            if (networkNodeBean.getDedicated() == Switch.DEDICATED) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            return false;
        }
        catch (CIMException cIMException) {
            _logger.error((Object)"isSwitch", (Throwable)cIMException);
            return false;
        }
    }

    public static boolean isCustomersLevel(NetworkNodeBean networkNodeBean) {
        return ModelUtil.isCustomer(networkNodeBean);
    }

    public static boolean isSubnetsLevel(NetworkNodeBean networkNodeBean) {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (networkNodeBean instanceof Router || networkNodeBean instanceof Subnet) break block6;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw ModelUtil.a(illegalArgumentException);
                            }
                            if (!(networkNodeBean instanceof Switch)) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ModelUtil.a(illegalArgumentException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isSubnetsLevelConnection(NetworkConnection networkConnection) {
        boolean bl2;
        block5: {
            block4: {
                NetworkNodeBean networkNodeBean = networkConnection.getNetworkInterface1().getHostNode();
                NetworkNodeBean networkNodeBean2 = networkConnection.getNetworkInterface2().getHostNode();
                try {
                    try {
                        if (!ModelUtil.isSubnetsLevel(networkNodeBean) || !ModelUtil.isSubnetsLevel(networkNodeBean2)) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static String getSubnetAddress(String string) {
        block4: {
            try {
                try {
                    if (string != null && string.length() != 0) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Not valid IP address");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ModelUtil.a(illegalArgumentException);
            }
        }
        return string.substring(0, string.lastIndexOf(46) + 1) + "0";
    }

    public static String getGraphType(NetworkGraphModel networkGraphModel) {
        try {
            if (networkGraphModel instanceof SubnetGraphModel) {
                return "s";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            if (networkGraphModel instanceof CustomerGraphModel) {
                return "c";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        try {
            if (networkGraphModel instanceof MasterGraphModel) {
                return "m";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ModelUtil.a(illegalArgumentException);
        }
        return "v";
    }

    public static void updateBean(NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2) {
        networkNodeBean2.getOtherProperties().putAll(networkNodeBean.getOtherProperties());
    }

    public static void updateConnections(NetworkGraphModel networkGraphModel, NetworkNode networkNode, NetworkNodeBean networkNodeBean) {
        Command[] commandArray;
        Object[] objectArray;
        block13: {
            Object[] objectArray2;
            Object[] objectArray3;
            block14: {
                block12: {
                    objectArray3 = NetworkGraphModel.getIncomingEdges((GraphModel)networkGraphModel, (Object)networkNode);
                    objectArray2 = NetworkGraphModel.getOutgoingEdges((GraphModel)networkGraphModel, (Object)networkNode);
                    objectArray = null;
                    commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
                    try {
                        if (objectArray3 == null || objectArray3.length <= 0) break block12;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                    objectArray = objectArray3;
                }
                try {
                    try {
                        if (objectArray2 == null || objectArray2.length <= 0) break block13;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ModelUtil.a(illegalArgumentException);
                    }
                    if (objectArray != null) break block14;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ModelUtil.a(illegalArgumentException);
                }
                objectArray = objectArray2;
                if (commandArray == null) break block13;
            }
            objectArray = new Object[objectArray3.length + objectArray2.length];
            System.arraycopy(objectArray3, 0, objectArray, 0, objectArray3.length);
            System.arraycopy(objectArray2, 0, objectArray, objectArray3.length, objectArray2.length);
        }
        if (objectArray != null) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                NetworkInterface networkInterface;
                NetworkConnection networkConnection = (NetworkConnection)objectArray[i2];
                EthernetInterface ethernetInterface = (EthernetInterface)networkConnection.getNetworkInterface1();
                EthernetInterface ethernetInterface2 = (EthernetInterface)networkConnection.getNetworkInterface2();
                if (ethernetInterface.getHostNode() == networkNode.getBean()) {
                    networkInterface = networkNodeBean.getInterfaceByIP(ethernetInterface.getIpAddress());
                    networkConnection.setAntecedent(networkInterface);
                }
                if (ethernetInterface2.getHostNode() != networkNode.getBean()) continue;
                networkInterface = networkNodeBean.getInterfaceByIP(ethernetInterface2.getIpAddress());
                networkConnection.setDependent(networkInterface);
                if (commandArray == null) continue;
            }
        }
    }

    public static NetworkNodeBean conver2Type(NetworkNodeBean networkNodeBean, String string) {
        Class clazz = ClassMap.getClass(string);
        try {
            if (clazz.equals(networkNodeBean.getClass())) {
                return networkNodeBean;
            }
        }
        catch (InstantiationException instantiationException) {
            throw ModelUtil.a(instantiationException);
        }
        try {
            NetworkNodeBean networkNodeBean2 = (NetworkNodeBean)clazz.newInstance();
            networkNodeBean2.setDisplayName(networkNodeBean.getDisplayName());
            networkNodeBean2.setInterfaces(networkNodeBean.getInterfaces());
            networkNodeBean2.getOtherProperties().putAll(networkNodeBean.getOtherProperties());
            networkNodeBean2.setSysObjectIdValue(networkNodeBean.getSysObjectIdValue());
            networkNodeBean2.setReadCommunity(networkNodeBean.getReadCommunity());
            return networkNodeBean2;
        }
        catch (InstantiationException instantiationException) {
            _logger.error((Object)"", (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.error((Object)"", (Throwable)illegalAccessException);
        }
        return networkNodeBean;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

