/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import java.io.Serializable;
import java.text.NumberFormat;

public class TypedNumber
extends Number
implements Serializable {
    private String _errorcode = "";
    private double _value;
    public static final String NON_NUMBER = "N/A";
    private static final NumberFormat _format = NumberFormat.getNumberInstance();

    public TypedNumber(double d10) {
        this._value = d10;
    }

    public TypedNumber(String string, double d10) {
        this._errorcode = string;
        this._value = d10;
    }

    public boolean isError() {
        return this._errorcode.equals("E");
    }

    public boolean isUnavailable() {
        return this._errorcode.equals("U");
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        return (float)this._value;
    }

    @Override
    public int intValue() {
        return (int)this._value;
    }

    @Override
    public long longValue() {
        return (long)this._value;
    }

    public String getValue() {
        if (this.isError() && this.isUnavailable()) {
            return _format.format(this._value);
        }
        return NON_NUMBER;
    }

    public String toString() {
        return this.getValue();
    }

    static {
        _format.setMaximumFractionDigits(3);
        _format.setGroupingUsed(false);
    }
}

