/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.LineLayoutAlgorithm;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphPreprocessor;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.model.Layer2Connection;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.TopologyData;
import java.util.List;
import java.util.Map;
import org.jgraph.graph.ConnectionSet;

public class SubnetGraphModel
extends TopologyGraphModel {
    public SubnetGraphModel(TopologyData topologyData, GraphID graphID, Map map, List list) {
        super(topologyData, graphID, new SubnetGraphPreprocessor(map, list));
        this._layoutAlgorithm = new LineLayoutAlgorithm();
    }

    public String getOwnIP(NetworkNodeBean networkNodeBean) {
        String string = this.getID().getGraphName();
        return networkNodeBean.getIPInSubnet(string);
    }

    @Override
    public Path getPath() {
        Path path = super.getPath();
        path.setSubDeviceID(this._id.getGraphName());
        return path;
    }

    @Override
    public String getGraphType() {
        return "s";
    }

    @Override
    public void insertLink(NetworkConnection networkConnection) {
        if (!this._connections.contains(networkConnection)) {
            Layer2Connection layer2Connection = (Layer2Connection)networkConnection;
            NetworkNodeBean networkNodeBean = layer2Connection.getSourceBean();
            NetworkNodeBean networkNodeBean2 = layer2Connection.getTargetBean();
            NetworkNode networkNode = null;
            if (networkNodeBean != null) {
                networkNode = (NetworkNode)this._bean2NodeMap.get(networkNodeBean);
            }
            NetworkNode networkNode2 = null;
            if (networkNodeBean2 != null) {
                networkNode2 = (NetworkNode)this._bean2NodeMap.get(networkNodeBean2);
            }
            ConnectionSet connectionSet = new ConnectionSet();
            if (networkNode != null) {
                connectionSet.connect((Object)networkConnection, (Object)networkNode.getFirstChild(), true);
            }
            if (networkNode2 != null) {
                connectionSet.connect((Object)networkConnection, (Object)networkNode2.getFirstChild(), false);
            }
            this.insert(new Object[]{networkConnection}, null, connectionSet, null, null);
        }
    }

    public Layer2Connection findLayer2Connection(String string, String string2) {
        int[] nArray = NetworkGraphModel.b();
        if (this._connections != null) {
            int n2 = this._connections.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Layer2Connection layer2Connection = (Layer2Connection)this._connections.get(i2);
                String string3 = layer2Connection.getSourceBean().getID();
                String string4 = layer2Connection.getTargetBean().getID();
                if ((!string3.equals(string) || !string4.equals(string2)) && (!string3.equals(string2) || !string4.equals(string))) continue;
                return layer2Connection;
            }
        }
        return null;
    }
}

