/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.GraphScheduleBean;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.ClassMap;
import com.sysuptime.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class PortScheduleBean
extends GraphScheduleBean {
    public static final int SCHEDULE_ID_PORT = 2;
    public static final String SCHEDULE_NAME_PORT = "port";
    private double _from;
    private double _to;
    private List _deviceTypes;

    @Override
    public int getScheduleId() {
        return 2;
    }

    @Override
    public String getScheduleName() {
        return SCHEDULE_NAME_PORT;
    }

    public void setFrom(double d10) {
        this._from = d10;
    }

    public double getFrom() {
        return this._from;
    }

    public void setTo(double d10) {
        this._to = d10;
    }

    public double getTo() {
        return this._to;
    }

    public int getSeverity(double d10) {
        if (d10 >= this._to) {
            return 3;
        }
        if (d10 >= this._from && d10 < this._to) {
            return 2;
        }
        return 1;
    }

    public void addDeviceType(String string) {
        if (this._deviceTypes == null) {
            this._deviceTypes = new ArrayList();
        }
        this._deviceTypes.add(string);
    }

    public void setDeviceTypes(List list) {
        this._deviceTypes = list;
    }

    public void setDeviceTypes(String string) {
        String[] stringArray = StringUtil.split(string, ", ");
        int[] nArray = NetworkGraphModel.b();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addDeviceType(stringArray[i2]);
            if (nArray != null) continue;
        }
    }

    public List getDeviceTypesList() {
        return this._deviceTypes;
    }

    public String getDeviceTypes() {
        return StringUtil.list2String(this._deviceTypes);
    }

    public boolean supportType(Class clazz) {
        String string = ClassMap.getType(clazz);
        if (this._deviceTypes != null) {
            return this._deviceTypes.contains(string);
        }
        return false;
    }

    public static String getDefaultDeviceTypes() {
        return "Router, Switch";
    }
}

