/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.CustomerGraphModel;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphXMLConstants;
import com.sysuptime.common.graph.Layer2ConnectionWriter;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.PropertiesWriter;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.graph.ViewGraphModel;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.Layer2Connection;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.DomUtil;
import com.sysuptime.common.util.StringUtil;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GraphModelXMLWriter
implements Serializable,
GraphXMLConstants {
    private static PropertiesWriter _propertiesWriter = new PropertiesWriter();
    private static Logger _logger = Logger.getLogger((String)GraphModelXMLWriter.class.getName());

    public static Document createViewDocument(NetworkGraphModel networkGraphModel) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("model");
        document.setRootElement(element);
        if (networkGraphModel != null) {
            Object[] objectArray = networkGraphModel.getNodes();
            List list = networkGraphModel.getConnections();
            GraphModelXMLWriter.a(element, networkGraphModel);
            GraphModelXMLWriter.c(element, networkGraphModel);
            GraphModelXMLWriter.b(element, networkGraphModel);
            GraphModelXMLWriter.d(element, networkGraphModel);
            if (objectArray != null && objectArray.length > 0) {
                GraphModelXMLWriter.a(element, objectArray, networkGraphModel);
                GraphModelXMLWriter.a(element, list, networkGraphModel);
            }
        }
        return document;
    }

    private static void a(Element element, NetworkGraphModel networkGraphModel) {
        String string = null;
        if (networkGraphModel instanceof CustomerGraphModel) {
            string = "c";
        }
        if (networkGraphModel instanceof SubnetGraphModel) {
            string = "s";
        }
        if (networkGraphModel instanceof ViewGraphModel) {
            string = "v";
        }
        if (networkGraphModel instanceof MasterGraphModel) {
            string = "m";
        }
        if (string != null) {
            element.addAttribute("type", string);
        }
    }

    private static void b(Element element, NetworkGraphModel networkGraphModel) {
        Element element2 = element.addElement("graphID");
        GraphID graphID = networkGraphModel.getID();
        String string = graphID.getCustomerID();
        String string2 = graphID.getGraphName();
        element2.addAttribute("customerId", string);
        element2.addAttribute("graphName", string2);
    }

    private static void c(Element element, NetworkGraphModel networkGraphModel) {
        GraphID graphID = networkGraphModel.getParentGraph();
        if (graphID != null) {
            Element element2 = element.addElement("parentGraph");
            String string = graphID.getCustomerID();
            String string2 = graphID.getGraphName();
            element2.addAttribute("customerId", string);
            element2.addAttribute("graphName", string2);
        }
    }

    private static void d(Element element, NetworkGraphModel networkGraphModel) {
        String string = networkGraphModel.getBackgroundImagePath();
        if (string != null) {
            Element element2 = element.addElement("backgroundPath");
            element2.addAttribute("value", StringUtil.replaceString(string, GraphXMLConstants.APP_HOME, "@HOME@"));
        }
    }

    private static void a(Element element, Object[] objectArray, NetworkGraphModel networkGraphModel) {
        Element element2 = element.addElement("nodes");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            NetworkNode networkNode = (NetworkNode)objectArray[i2];
            _propertiesWriter.writeViewProperties(element2, networkNode, networkGraphModel);
        }
    }

    private static void a(Element element, List list, NetworkGraphModel networkGraphModel) {
        block4: {
            Element element2 = element.addElement("connections");
            if (list == null) break block4;
            if (networkGraphModel instanceof SubnetGraphModel || networkGraphModel instanceof ViewGraphModel) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Layer2Connection layer2Connection = (Layer2Connection)list.get(i2);
                    Layer2ConnectionWriter layer2ConnectionWriter = new Layer2ConnectionWriter();
                    layer2ConnectionWriter.write(element2, layer2Connection, networkGraphModel);
                }
            } else {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    NetworkConnection networkConnection = (NetworkConnection)list.get(i3);
                    GraphModelXMLWriter.a(element2, networkConnection, networkGraphModel);
                }
            }
        }
    }

    private static void a(Element element, NetworkConnection networkConnection, NetworkGraphModel networkGraphModel) {
        Element element2;
        Element element3 = element.addElement("connection");
        element3.addAttribute("bandwidth", String.valueOf(networkConnection.getBandwidth()));
        EthernetInterface ethernetInterface = (EthernetInterface)networkConnection.getNetworkInterface1();
        EthernetInterface ethernetInterface2 = (EthernetInterface)networkConnection.getNetworkInterface2();
        if (ethernetInterface != null || ethernetInterface2 != null) {
            Element element4;
            element2 = element3.addElement("interfaces");
            if (ethernetInterface != null) {
                element4 = element2.addElement("smallerInterface");
                GraphModelXMLWriter.a(element4, ethernetInterface);
            }
            if (ethernetInterface2 != null) {
                element4 = element2.addElement("biggerInterface");
                GraphModelXMLWriter.a(element4, ethernetInterface2);
            }
        }
        element2 = element3.addElement("viewProp");
        _propertiesWriter.writeViewProperties(element2, networkConnection, networkGraphModel);
        _propertiesWriter.writeLinkProperties(element3, networkConnection);
    }

    private static void a(Element element, EthernetInterface ethernetInterface) {
        NetworkNodeBean networkNodeBean = ethernetInterface.getHostNode();
        if (networkNodeBean != null) {
            element.addAttribute("hostNodeId", networkNodeBean.getID());
        }
        element.addAttribute("ip", ethernetInterface.getIpAddress());
        element.addAttribute("MAC", ethernetInterface.getMacAddress());
        element.addAttribute("index", "" + ethernetInterface.getIfIndex());
        element.addAttribute("isVirtual", "" + ethernetInterface.isVirtual());
    }

    public static String asViewXML(NetworkGraphModel networkGraphModel) {
        return GraphModelXMLWriter.createViewDocument(networkGraphModel).asXML();
    }

    public static boolean writeView(NetworkGraphModel networkGraphModel, String string) {
        Document document = GraphModelXMLWriter.createViewDocument(networkGraphModel);
        try {
            if (document == null) {
                return false;
            }
            DomUtil.write(document, string);
            return true;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return false;
        }
    }
}

