/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.B;
import com.ireasoning.protocol.snmp.C;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.T;
import com.ireasoning.protocol.snmp.U;
import com.ireasoning.protocol.snmp.aW;
import com.ireasoning.protocol.snmp.c;
import com.ireasoning.protocol.snmp.d;
import com.ireasoning.util.aU;
import com.ireasoning.util.bk;
import com.sysuptime.server.msp.Command;
import java.util.Random;

public class SnmpPdu
extends aW
implements SnmpDataType {
    static int _sequence = 0;
    int _version;
    String _community = "public";
    int _command;
    int _requestID;
    String _senderAddress;
    int _senderPort;
    String _receiverAddress;
    int _receiverPort;
    boolean _hasMore = true;
    boolean _isAuthFailed = false;
    static final String[] ERR_STATUS_STRING = new String[]{"No Error", "Too Big", "No Such Name", "Bad Value", "Read Only", "General Error", "No Access", "Wrong Type", "Wrong Length", "Wrong Encoding", "Wrong Value", "No Creation", "Inconsistent Value", "Resource Unavailable", "Commit Failed", "Undo Failed", "Authorization Error", "Not Writable", "Inconsistent Name"};
    int _errStatus;
    int _errIndex;
    String _contextName;
    byte[] _contextEngineID;
    boolean _endOfMibView = false;
    B _v3MsgHeader;
    C _v3MsgParameters;

    SnmpPdu() {
        this._command = 0;
        this._requestID = SnmpPdu.c();
        this._errStatus = 0;
        this._errIndex = 0;
    }

    public SnmpPdu(SnmpPdu snmpPdu) {
        super(snmpPdu);
        this._version = snmpPdu._version;
        this._community = aU.cloneString(snmpPdu._community);
        this._command = snmpPdu._command;
        this._requestID = snmpPdu._requestID;
        this._errStatus = snmpPdu._errStatus;
        this._errIndex = snmpPdu._errIndex;
        this._contextEngineID = bk.cloneArray(snmpPdu._contextEngineID);
        this._contextName = aU.cloneString(snmpPdu._contextName);
        this._endOfMibView = snmpPdu._endOfMibView;
        this._senderAddress = snmpPdu._senderAddress;
        this._senderPort = snmpPdu._senderPort;
        this._receiverAddress = snmpPdu._receiverAddress;
        this._receiverPort = snmpPdu._receiverPort;
        this._hasMore = snmpPdu._hasMore;
        this._isAuthFailed = snmpPdu._isAuthFailed;
    }

    public SnmpPdu(int n2) {
        this();
        this._command = n2;
    }

    public SnmpPdu(int n2, SnmpVarBind[] snmpVarBindArray) {
        this(n2);
        Command[] commandArray = SnmpVarBind.b();
        if (snmpVarBindArray != null) {
            this._varbinds.ensureCapacity(snmpVarBindArray.length);
            for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
                SnmpVarBind snmpVarBind = snmpVarBindArray[i2];
                this.addVarBind(new SnmpVarBind(snmpVarBind));
                if (commandArray != null) continue;
            }
        }
    }

    public SnmpPdu(int n2, SnmpVarBind[] snmpVarBindArray, int n3) {
        this(n2, snmpVarBindArray);
        this._requestID = n3;
    }

    public static SnmpPdu decodePdu(byte[] byArray, int n2) throws c {
        T t2;
        block4: {
            t2 = new T(byArray, n2);
            int n3 = T.getSnmpVersion(byArray, n2);
            try {
                try {
                    if (n3 == 0 || n3 == 1) break block4;
                }
                catch (c c10) {
                    throw SnmpPdu.a(c10);
                }
                return null;
            }
            catch (c c11) {
                throw SnmpPdu.a(c11);
            }
        }
        return (SnmpPdu)t2.a(false);
    }

    public static byte[] encodePdu(SnmpPdu snmpPdu) throws d {
        U u2 = new U();
        u2.a(snmpPdu, snmpPdu.getVersion(), snmpPdu.getCommunity(), snmpPdu.getCommunity());
        byte[] byArray = u2.a();
        int n2 = u2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public boolean hasMore() {
        return !this.a() && this._hasMore;
    }

    public void setHasMore(boolean bl2) {
        this._hasMore = bl2;
    }

    private boolean a() {
        return this._errStatus != 0 || this._endOfMibView || this._isAuthFailed;
    }

    void b() {
        this._requestID = SnmpPdu.c();
    }

    static synchronized int c() {
        if (_sequence == 0) {
            Random random = new Random(System.currentTimeMillis());
            _sequence = random.nextInt();
        }
        if (++_sequence >= Integer.MAX_VALUE || _sequence < 0) {
            if (_sequence < 0) {
                _sequence = -_sequence;
            }
            _sequence %= Integer.MAX_VALUE;
        }
        return _sequence;
    }

    public void setCommand(int n2) {
        this._command = n2;
    }

    public int getRequestID() {
        return this._requestID;
    }

    public void setRequestID(int n2) {
        this._requestID = n2;
    }

    public void setOID(String string) {
        this.setOID(new SnmpOID(string));
    }

    public void setOID(SnmpOID snmpOID) {
        this.removeAllVarBinds();
        SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID);
        this.addVarBind(snmpVarBind);
        this._requestID = SnmpPdu.c();
    }

    public void setOIDs(String[] stringArray) {
        block2: {
            SnmpOID[] snmpOIDArray = new SnmpOID[stringArray.length];
            Command[] commandArray = SnmpVarBind.b();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                snmpOIDArray[i2] = new SnmpOID(stringArray[i2]);
                if (commandArray != null) {
                    if (commandArray != null) continue;
                }
                break block2;
            }
            this.setOIDs(snmpOIDArray);
        }
    }

    public void setOIDs(SnmpOID[] snmpOIDArray) {
        block2: {
            SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpOIDArray.length];
            Command[] commandArray = SnmpVarBind.b();
            for (int i2 = 0; i2 < snmpVarBindArray.length; ++i2) {
                snmpVarBindArray[i2] = new SnmpVarBind(snmpOIDArray[i2]);
                if (commandArray != null) {
                    if (commandArray != null) continue;
                }
                break block2;
            }
            this.setVarBinds(snmpVarBindArray);
            this._requestID = SnmpPdu.c();
        }
    }

    public int getCommand() {
        return (byte)(this._command & 0xFF);
    }

    @Override
    public int getType() {
        return 320;
    }

    @Override
    public String getTypeString() {
        return "PDU";
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n2) {
        this._version = n2;
    }

    public String getCommunity() {
        return this._community;
    }

    public void setCommunity(String string) {
        this._community = string;
    }

    public boolean isSnmpV3AuthenticationFailed() {
        return this._isAuthFailed;
    }

    public String getErrorString() {
        if (this._isAuthFailed) {
            return "Authentication failure";
        }
        return this.getErrorStatusString();
    }

    public String getErrorStatusString() {
        return SnmpPdu.getErrorStatusString(this._errStatus);
    }

    public static String getErrorStatusString(int n2) {
        if (n2 >= 0 && n2 < ERR_STATUS_STRING.length) {
            return ERR_STATUS_STRING[n2];
        }
        if (n2 == -2) {
            return "AuthFailed";
        }
        return ERR_STATUS_STRING[5];
    }

    public int getErrorStatus() {
        return this._errStatus;
    }

    public void setErrorStatus(int n2) {
        this._errStatus = n2;
    }

    public int getErrorIndex() {
        return this._errIndex;
    }

    public void setErrorIndex(int n2) {
        this._errIndex = n2;
    }

    public int getNonRepeaters() {
        return this._errStatus;
    }

    public void setNonRepeaters(int n2) {
        this._errStatus = n2;
    }

    public int getMaxRepetitions() {
        return this._errIndex;
    }

    public void setMaxRepetitions(int n2) {
        this._errIndex = n2;
    }

    public String getContextName() {
        return this._contextName;
    }

    public void setContextName(String string) {
        this._contextName = string;
    }

    public byte[] getContextEngineID() {
        return this._contextEngineID;
    }

    public void setContextEngineID(byte[] byArray) {
        this._contextEngineID = byArray;
    }

    public String getSourceAddress() {
        return this._senderAddress;
    }

    public void setSourceAddress(String string) {
        this._senderAddress = string;
    }

    public int getSourcePort() {
        return this._senderPort;
    }

    public void setSourcePort(int n2) {
        this._senderPort = n2;
    }

    public int getDestinationPort() {
        return this._receiverPort;
    }

    public void setDestinationPort(int n2) {
        this._receiverPort = n2;
    }

    public String getDestinationAddress() {
        return this._receiverAddress;
    }

    public void setDestinationAddress(String string) {
        this._receiverAddress = string;
    }

    public String getIpAddress() {
        return this._senderAddress;
    }

    public void setIpAddress(String string) {
        this._senderAddress = string;
    }

    public B getSnmpV3MsgHeader() {
        return this._v3MsgHeader;
    }

    public C getSnmpv3MsgSecurityParameters() {
        return this._v3MsgParameters;
    }

    public String toString() {
        String string;
        int n2 = this.getVersion();
        Command[] commandArray = SnmpVarBind.b();
        if (n2 < 3) {
            ++n2;
        }
        String string2 = "SNMP version:" + n2 + "; Community:" + this.getCommunity();
        if (this._varbinds != null) {
            for (int i2 = 0; i2 < this._varbinds.size(); ++i2) {
                string = string2 + "\n" + this._varbinds.get(i2).toString();
                if (commandArray != null) {
                    string2 = string;
                    if (commandArray != null) continue;
                }
                break;
            }
        } else {
            string = string2;
        }
        return string;
    }

    @Override
    public SnmpDataType copy() {
        return new SnmpPdu(this);
    }

    @Override
    public int encode(U u2) throws d {
        return u2.a(this);
    }

    static int b(int n2) {
        if (n2 == 7 || n2 == 9 || n2 == 10 || n2 == 8 || n2 == 12) {
            return 3;
        }
        if (n2 == 17 || n2 == 6 || n2 == 11 || n2 == 18 || n2 == 16) {
            return 2;
        }
        return 5;
    }

    private static c a(c c10) {
        return c10;
    }
}

