/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.view;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.ValidationUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public final class ValidationComponentUtils {
    private static final Color MANDATORY_FOREGROUND = new Color(70, 70, 210);
    private static final Color MANDATORY_BACKGROUND = new Color(235, 235, 255);
    private static final Color ERROR_BACKGROUND = new Color(255, 215, 215);
    private static final Color WARNING_BACKGROUND = new Color(255, 235, 205);
    private static final String MANDATORY_KEY = "validation.isMandatory";
    private static final String MESSAGE_KEY = "validation.messageKey";
    private static final String INPUT_HINT_KEY = "validation.inputHint";
    private static final String SEVERITY_KEY = "validation.severity";
    private static final String STORED_BACKGROUND_KEY = "validation.storedBackground";
    private static Border mandatoryBorder;
    private static final Map PROTOTYPE_COMPONENTS;

    private ValidationComponentUtils() {
    }

    public static boolean isMandatory(JComponent comp) {
        return Boolean.TRUE.equals(comp.getClientProperty(MANDATORY_KEY));
    }

    public static boolean isMandatoryAndBlank(JComponent comp) {
        if (!(comp instanceof JTextComponent)) {
            return false;
        }
        JTextComponent textComponent = (JTextComponent)comp;
        return ValidationComponentUtils.isMandatory(textComponent) && ValidationUtils.isBlank(textComponent.getText());
    }

    public static void setMandatory(JComponent comp, boolean mandatory) {
        boolean oldMandatory = ValidationComponentUtils.isMandatory(comp);
        if (oldMandatory != mandatory) {
            comp.putClientProperty(MANDATORY_KEY, mandatory);
        }
    }

    public static Severity getSeverity(JComponent comp) {
        return (Severity)comp.getClientProperty(SEVERITY_KEY);
    }

    public static void setSeverity(JComponent comp, Severity severity) {
        comp.putClientProperty(SEVERITY_KEY, severity);
    }

    public static Object getMessageKey(JComponent comp) {
        return comp.getClientProperty(MESSAGE_KEY);
    }

    public static void setMessageKey(JComponent comp, Object messageKey) {
        comp.putClientProperty(MESSAGE_KEY, messageKey);
    }

    public static Object getInputHint(JComponent comp) {
        return comp.getClientProperty(INPUT_HINT_KEY);
    }

    public static void setInputHint(JComponent comp, Object hint) {
        comp.putClientProperty(INPUT_HINT_KEY, hint);
    }

    public static boolean hasError(JComponent comp, ValidationResult result) {
        return result.subResult(ValidationComponentUtils.getMessageKey(comp)).hasErrors();
    }

    public static boolean hasWarning(JComponent comp, ValidationResult result) {
        return result.subResult(ValidationComponentUtils.getMessageKey(comp)).hasWarnings();
    }

    public static Color getMandatoryBackground() {
        return MANDATORY_BACKGROUND;
    }

    public static Color getMandatoryForeground() {
        return MANDATORY_FOREGROUND;
    }

    public static void setMandatoryBackground(JTextComponent comp) {
        ValidationComponentUtils.ensureBackgroundStored(comp);
        comp.setBackground(MANDATORY_BACKGROUND);
    }

    public static Color getErrorBackground() {
        return ERROR_BACKGROUND;
    }

    public static void setErrorBackground(JTextComponent comp) {
        ValidationComponentUtils.ensureBackgroundStored(comp);
        comp.setBackground(ERROR_BACKGROUND);
    }

    public static Color getWarningBackground() {
        return WARNING_BACKGROUND;
    }

    public static void setWarningBackground(JTextComponent comp) {
        ValidationComponentUtils.ensureBackgroundStored(comp);
        comp.setBackground(WARNING_BACKGROUND);
    }

    public static void setMandatoryBorder(JTextComponent comp) {
        Container grandpa;
        Container parent = comp.getParent();
        if (parent instanceof JViewport && (grandpa = parent.getParent()) instanceof JScrollPane) {
            ((JScrollPane)grandpa).setBorder(ValidationComponentUtils.getMandatoryBorder());
            return;
        }
        comp.setBorder(ValidationComponentUtils.getMandatoryBorder());
    }

    public static Border getMandatoryBorder() {
        if (mandatoryBorder == null) {
            mandatoryBorder = new CompoundBorder(new LineBorder(ValidationComponentUtils.getMandatoryForeground()), new BasicBorders.MarginBorder());
        }
        return mandatoryBorder;
    }

    public static void updateComponentTreeMandatoryBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryAndBlankBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryAndBlankBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryBorder(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBorderVisitor());
    }

    public static void updateComponentTreeValidationBackground(Container container, ValidationResult result) {
        ValidationComponentUtils.visitComponentTree(container, result.keyMap(), new MandatoryAndBlankOrSeverityBackgroundVisitor());
    }

    public static void updateComponentTreeSeverityBackground(Container container, ValidationResult result) {
        ValidationComponentUtils.visitComponentTree(container, result.keyMap(), new SeverityBackgroundVisitor());
    }

    public static void updateComponentTreeSeverity(Container container, ValidationResult result) {
        ValidationComponentUtils.visitComponentTree(container, result.keyMap(), new SeverityVisitor());
    }

    public static void visitComponentTree(Container container, Map keyMap, Visitor visitor) {
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = container.getComponent(i);
            if (child instanceof JTextComponent) {
                JComponent component = (JComponent)child;
                visitor.visit(component, keyMap);
                continue;
            }
            if (!(child instanceof Container)) continue;
            ValidationComponentUtils.visitComponentTree((Container)child, keyMap, visitor);
        }
    }

    private static ValidationResult getAssociatedResult(JComponent comp, Map keyMap) {
        Object messageKey = ValidationComponentUtils.getMessageKey(comp);
        if (messageKey == null || keyMap == null) {
            return null;
        }
        ValidationResult result = (ValidationResult)keyMap.get(messageKey);
        return result == null ? ValidationResult.EMPTY : result;
    }

    private static Color getDefaultBackground(JTextComponent component) {
        JTextComponent prototype = ValidationComponentUtils.getPrototypeFor(component.getClass());
        prototype.setEnabled(component.isEnabled());
        prototype.setEditable(component.isEditable());
        return prototype.getBackground();
    }

    private static JTextComponent getPrototypeFor(Class prototypeClass) {
        JTextComponent prototype = (JTextComponent)PROTOTYPE_COMPONENTS.get(prototypeClass);
        if (prototype == null) {
            try {
                prototype = (JTextComponent)prototypeClass.newInstance();
            }
            catch (Exception e) {
                prototype = new JTextField();
            }
            PROTOTYPE_COMPONENTS.put(prototypeClass, prototype);
        }
        return prototype;
    }

    private static Color getStoredBackground(JTextComponent comp) {
        return (Color)comp.getClientProperty(STORED_BACKGROUND_KEY);
    }

    private static void ensureBackgroundStored(JTextComponent comp) {
        if (ValidationComponentUtils.getStoredBackground(comp) != null) {
            return;
        }
        comp.putClientProperty(STORED_BACKGROUND_KEY, comp.getBackground());
    }

    private static void restoreBackground(JTextComponent comp) {
        Color storedBackground = ValidationComponentUtils.getStoredBackground(comp);
        comp.setBackground(storedBackground == null ? ValidationComponentUtils.getDefaultBackground(comp) : storedBackground);
    }

    static {
        PROTOTYPE_COMPONENTS = new HashMap();
    }

    private static final class SeverityVisitor
    implements Visitor {
        private SeverityVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            ValidationResult result = ValidationComponentUtils.getAssociatedResult(component, keyMap);
            Severity severity = result == null ? null : result.getSeverity();
            ValidationComponentUtils.setSeverity(component, severity);
        }
    }

    private static final class SeverityBackgroundVisitor
    implements Visitor {
        private SeverityBackgroundVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            JTextComponent textChild = (JTextComponent)component;
            ValidationResult result = ValidationComponentUtils.getAssociatedResult(component, keyMap);
            if (result == null || result.isEmpty()) {
                ValidationComponentUtils.restoreBackground(textChild);
            } else if (result.hasErrors()) {
                ValidationComponentUtils.setErrorBackground(textChild);
            } else if (result.hasWarnings()) {
                ValidationComponentUtils.setWarningBackground(textChild);
            }
        }
    }

    private static final class MandatoryBorderVisitor
    implements Visitor {
        private MandatoryBorderVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            if (component instanceof JTextComponent && ValidationComponentUtils.isMandatory(component)) {
                ValidationComponentUtils.setMandatoryBorder((JTextComponent)component);
            }
        }
    }

    private static final class MandatoryAndBlankOrSeverityBackgroundVisitor
    implements Visitor {
        private MandatoryAndBlankOrSeverityBackgroundVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            JTextComponent textChild = (JTextComponent)component;
            ValidationResult result = ValidationComponentUtils.getAssociatedResult(component, keyMap);
            if (ValidationComponentUtils.isMandatoryAndBlank(component)) {
                ValidationComponentUtils.setMandatoryBackground(textChild);
            } else if (result == null || result.isEmpty()) {
                ValidationComponentUtils.restoreBackground(textChild);
            } else if (result.hasErrors()) {
                ValidationComponentUtils.setErrorBackground(textChild);
            } else if (result.hasWarnings()) {
                ValidationComponentUtils.setWarningBackground(textChild);
            }
        }
    }

    private static final class MandatoryAndBlankBackgroundVisitor
    implements Visitor {
        private MandatoryAndBlankBackgroundVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            JTextComponent textChild = (JTextComponent)component;
            if (ValidationComponentUtils.isMandatoryAndBlank(textChild)) {
                ValidationComponentUtils.setMandatoryBackground(textChild);
            } else {
                ValidationComponentUtils.restoreBackground(textChild);
            }
        }
    }

    private static final class MandatoryBackgroundVisitor
    implements Visitor {
        private MandatoryBackgroundVisitor() {
        }

        public void visit(JComponent component, Map keyMap) {
            if (component instanceof JTextComponent && ValidationComponentUtils.isMandatory(component)) {
                ValidationComponentUtils.setMandatoryBackground((JTextComponent)component);
            }
        }
    }

    public static interface Visitor {
        public void visit(JComponent var1, Map var2);
    }
}

