/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.util.ValidationResultModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ValidationResultModelContainer
extends DefaultValidationResultModel {
    public static final String PROPERTYNAME_EXPANDED = "expanded";
    private final ValidationMessage collapsedMessage;
    private boolean expanded;
    private final List childResultModels;
    private final PropertyChangeListener childResultUpdateHandler;

    public ValidationResultModelContainer(ValidationMessage collapsedMessage) {
        this.collapsedMessage = collapsedMessage;
        this.childResultModels = new LinkedList();
        this.expanded = true;
        this.childResultUpdateHandler = new ChildResultUpdateHandler();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        boolean oldExpanded = this.isExpanded();
        this.expanded = expanded;
        this.updateContainerResult();
        this.firePropertyChange(PROPERTYNAME_EXPANDED, oldExpanded, expanded);
    }

    public ValidationResult getCollapsedValidationResult() {
        ValidationResult wrapper = new ValidationResult();
        wrapper.add(this.collapsedMessage);
        return wrapper;
    }

    public ValidationResult getExpandedValidationResult() {
        ValidationResult concatenation = new ValidationResult();
        Iterator it = this.childResultModels.iterator();
        while (it.hasNext()) {
            ValidationResultModel resultModel = (ValidationResultModel)it.next();
            concatenation.addAllFrom(resultModel.getResult());
        }
        return concatenation;
    }

    public void add(ValidationResultModel resultModel) {
        this.childResultModels.add(resultModel);
        resultModel.addPropertyChangeListener("result", this.childResultUpdateHandler);
    }

    public void remove(ValidationResultModel resultModel) {
        this.childResultModels.remove(resultModel);
        resultModel.removePropertyChangeListener("result", this.childResultUpdateHandler);
    }

    public final void setResult(ValidationResult newResult) {
        throw new UnsupportedOperationException("Cannot set a validation result for ValidationResultModelContainer. The result will be computed from the contained results instead.");
    }

    private void updateContainerResult() {
        this.setValidationResult0(this.isExpanded() ? this.getExpandedValidationResult() : this.getCollapsedValidationResult());
    }

    private final class ChildResultUpdateHandler
    implements PropertyChangeListener {
        private ChildResultUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ValidationResultModelContainer.this.updateContainerResult();
        }
    }
}

