/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.message.PropertyValidationMessage;

public final class PropertyValidationSupport {
    private ValidationResult defaultResult;
    private final Severity defaultSeverity;
    private final Object target;
    private final String role;

    public PropertyValidationSupport(Object target, String role) {
        this(Severity.WARNING, target, role);
    }

    public PropertyValidationSupport(Severity defaultSeverity, Object target, String role) {
        this(new ValidationResult(), defaultSeverity, target, role);
    }

    public PropertyValidationSupport(ValidationResult defaultResult, Severity defaultSeverity, Object target, String role) {
        if (defaultSeverity == Severity.OK) {
            throw new IllegalArgumentException("Severity.OK must not be used in validation messages.");
        }
        this.defaultResult = defaultResult;
        this.defaultSeverity = defaultSeverity;
        this.target = target;
        this.role = role;
    }

    public void clearResult() {
        this.defaultResult = new ValidationResult();
    }

    public ValidationResult getResult() {
        return this.defaultResult;
    }

    public PropertyValidationMessage createError(String property, String text) {
        return this.create(Severity.ERROR, property, text);
    }

    public PropertyValidationMessage createWarning(String property, String text) {
        return this.create(Severity.WARNING, property, text);
    }

    public PropertyValidationMessage create(String property, String text) {
        return this.create(this.defaultSeverity, property, text);
    }

    public PropertyValidationMessage create(Severity severity, String property, String text) {
        return new PropertyValidationMessage(severity, text, this.target, this.role, property);
    }

    public void addError(String property, String text) {
        this.addError(this.defaultResult, property, text);
    }

    public void addWarning(String property, String text) {
        this.addWarning(this.defaultResult, property, text);
    }

    public void add(String property, String text) {
        this.add(this.defaultResult, property, text);
    }

    public void add(Severity severity, String property, String text) {
        this.add(this.defaultResult, severity, property, text);
    }

    public void addError(ValidationResult result, String property, String text) {
        result.add(this.createError(property, text));
    }

    public void addWarning(ValidationResult result, String property, String text) {
        result.add(this.createWarning(property, text));
    }

    public void add(ValidationResult result, String property, String text) {
        result.add(this.create(property, text));
    }

    public void add(ValidationResult result, Severity severity, String property, String text) {
        if (severity == Severity.OK) {
            throw new IllegalArgumentException("Severity.OK must not be used in validation messages.");
        }
        result.add(this.create(severity, property, text));
    }
}

