/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.trapreceiver;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.sysuptime.common.trapreceiver.AlarmActions;
import com.sysuptime.common.trapreceiver.ClearTrapObject;
import com.sysuptime.common.trapreceiver.DedupEventObject;
import com.sysuptime.common.trapreceiver.EnterpriseObject;
import com.sysuptime.common.trapreceiver.ToBeClearedTrapObject;
import com.sysuptime.common.trapreceiver.TrapFilterData;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.common.util.TextProcessor;
import com.sysuptime.common.util.TrapProperties;
import com.sysuptime.server.login.UserPropertyConfig;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.performance.NoUseStateTimebucketCache;
import com.sysuptime.server.trapreceiver.ClearSql;
import com.sysuptime.server.trapreceiver.DupSql;
import com.sysuptime.server.trapreceiver.EventConfigSql;
import com.sysuptime.server.trapreceiver.GeneralTimeEmailDao;
import com.sysuptime.server.trapreceiver.PooledPerformer;
import com.sysuptime.server.trapreceiver.SmtpConfig;
import com.sysuptime.server.trapreceiver.TestActionsPerformer;
import com.sysuptime.server.trapreceiver.TrapCallbackServer;
import com.sysuptime.server.trapreceiver.TrapReceiver;
import com.sysuptime.server.trapreceiver.TrapReceiverConfigMBean;
import com.sysuptime.server.trapreceiver.TrapReceiverSql;
import com.sysuptime.server.trapreceiver.TrapReceiverUtil;
import com.sysuptime.server.util.BootFinder;
import com.sysuptime.server.util.ServerConfig;
import com.sysuptime.server.util.ServerPropertiesFile;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TrapReceiverConfig
implements TrapReceiverConfigMBean {
    private static final Logger _logger = Logger.getLogger((String)TrapReceiverConfig.class.getName());
    private TrapReceiver _trapReceiver;

    @Override
    public void startService() {
        block3: {
            block2: {
                String[] stringArray = PooledPerformer.b();
                if (!ServerPropertiesFile.isEnabled("trapReceiver")) break block2;
                _logger.info((Object)"Start Trap Receiver ...");
                this._trapReceiver = new TrapReceiver();
                String string = BootFinder.getLocalBindAddress();
                TrapReceiver.setIp(string);
                this._trapReceiver.start();
                _logger.info((Object)"Trap receiver is started");
                if (stringArray != null) break block3;
            }
            _logger.warn((Object)"Trap receiver is not started.");
        }
    }

    @Override
    public void stopService() {
        if (this._trapReceiver != null) {
            this._trapReceiver.stopService();
            this._trapReceiver.interrupt();
            this._trapReceiver = null;
        }
    }

    @Override
    public RmiResponse addV3Property(TrapProperties trapProperties) {
        TrapReceiverSql trapReceiverSql = new TrapReceiverSql();
        RmiResponse rmiResponse = trapReceiverSql.addV3Property(trapProperties, this._trapReceiver);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.addSnmpV3Param(trapProperties, true);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse deleteV3Property(String string, String string2) {
        TrapReceiverSql trapReceiverSql = new TrapReceiverSql();
        RmiResponse rmiResponse = trapReceiverSql.deleteV3Property(string, string2);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.deleteSnmpV3UsmUser(string, string2.getBytes(), true);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse modifyV3Property(TrapProperties trapProperties) {
        TrapReceiverSql trapReceiverSql = new TrapReceiverSql();
        RmiResponse rmiResponse = trapReceiverSql.modifyV3Property(trapProperties, this._trapReceiver);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            String string = trapProperties.getUsername();
            String string2 = trapProperties.getEngineID();
            TrapReceiver.deleteSnmpV3UsmUser(string, string2.getBytes(), true);
            TrapReceiver.addSnmpV3Param(trapProperties, true);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse getV3Properties() {
        TrapReceiverSql trapReceiverSql = new TrapReceiverSql();
        return trapReceiverSql.getProperties(this._trapReceiver);
    }

    @Override
    public RmiResponse getEnterprises() throws RemoteException {
        return EventConfigSql.getEnterprises();
    }

    @Override
    public RmiResponse getMailSetting() {
        Properties properties = new Properties();
        properties.put("enable", ServerConfig.getProperty("trapReceiver.mailEnabled", "No"));
        properties.put("severity", ServerConfig.getProperty("trapReceiver.severityOfMail", "0"));
        properties.put("group", ServerConfig.getProperty("trapReceiver.groupName", "test"));
        return new RmiResponse(properties);
    }

    @Override
    public RmiResponse mailSetting(List list, String string, String string2) {
        RmiResponse rmiResponse = ServerConfig.updatePropertyForRmi("trapReceiver.mailEnabled", string2);
        RmiResponse rmiResponse2 = ServerConfig.updatePropertyForRmi("trapReceiver.severityOfMail", string);
        RmiResponse rmiResponse3 = GeneralTimeEmailDao.saveGeneralTimeMails(list);
        if (rmiResponse.getValue().equals(Boolean.FALSE) || rmiResponse2.getValue().equals(Boolean.FALSE) || rmiResponse3.getValue().equals(Boolean.FALSE)) {
            RmiResponse rmiResponse4 = new RmiResponse(Boolean.FALSE);
            rmiResponse4.setErrorMessage("MailSetting ErrorMessage:");
            if (rmiResponse.getErrorMessage() != null) {
                rmiResponse4.setErrorMessage(rmiResponse4.getErrorMessage() + rmiResponse.getErrorMessage());
            }
            if (rmiResponse2.getErrorMessage() != null) {
                rmiResponse4.setErrorMessage(rmiResponse4.getErrorMessage() + rmiResponse2.getErrorMessage());
            }
            if (rmiResponse3.getErrorMessage() != null) {
                rmiResponse4.setErrorMessage(rmiResponse4.getErrorMessage() + rmiResponse3.getErrorMessage());
            }
            return rmiResponse4;
        }
        return new RmiResponse(Boolean.TRUE);
    }

    @Override
    public RmiResponse getConfig() {
        Properties properties = new Properties();
        properties.put("port", ServerConfig.getProperty("trapReceiver.port", "162"));
        properties.put("forwardEnabled", ServerConfig.getProperty("trapReceiver.forwardEnabled", "No"));
        properties.put("serverAddress", ServerConfig.getProperty("trapReceiver.serverAddress", ""));
        properties.put("serverPort", ServerConfig.getProperty("trapReceiver.serverPort", "162"));
        properties.put("storeUnknownTraps", ServerConfig.getProperty("trapReceiver.storeUnknownTraps", "Yes"));
        properties.put("unknownTrapsSeverity", ServerConfig.getProperty("trapReceiver.unknownTrapsSeverity", "0"));
        properties.put("unknownTrapsMessage", ServerConfig.getProperty("trapReceiver.unknownTrapsMessage", "$oid"));
        return new RmiResponse(properties);
    }

    @Override
    public RmiResponse getDedupConfig() {
        Properties properties = new Properties();
        properties.put("enable", ServerConfig.getProperty("trapReceiver.dedupEnabled", "No"));
        properties.put("time", ServerConfig.getProperty("trapReceiver.dedupTime", "60"));
        return new RmiResponse(properties);
    }

    @Override
    public RmiResponse getClearConfig() {
        Properties properties = new Properties();
        properties.put("enable", ServerConfig.getProperty("trapReceiver.clearTrapEnabled", "No"));
        properties.put("time", ServerConfig.getProperty("trapReceiver.clearTrapTime", "60"));
        return new RmiResponse(properties);
    }

    @Override
    public RmiResponse getDBClearConfig() {
        Properties properties = new Properties();
        properties.put("snmp", ServerConfig.getProperty("trapReceiver.snmpKeepDay", "10"));
        properties.put("performance", ServerConfig.getProperty("trapReceiver.performanceKeepDay", "10"));
        return new RmiResponse(properties);
    }

    @Override
    public RmiResponse getDedupEvents() {
        DupSql dupSql = new DupSql();
        return dupSql.getDedupEvents();
    }

    @Override
    public RmiResponse addDedupEvent(DedupEventObject dedupEventObject) {
        DupSql dupSql = new DupSql();
        RmiResponse rmiResponse = dupSql.addDedupEvent(dedupEventObject);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.addDedup(dedupEventObject);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse deleteDedupEvent(String string) {
        DupSql dupSql = new DupSql();
        RmiResponse rmiResponse = dupSql.deleteDedupEvent(string);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.deleteDedup(string);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse modifyDedupEvent(DedupEventObject dedupEventObject) {
        DupSql dupSql = new DupSql();
        RmiResponse rmiResponse = dupSql.modifyDedupEvent(dedupEventObject);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.modifyDedup(dedupEventObject);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse changeServerConfig(Properties properties) {
        String string = ServerConfig.getProperty("trapReceiver.port", "162");
        String[] stringArray = PooledPerformer.b();
        if (!string.equals(properties.get("port").toString())) {
            TrapReceiver.restartTrapReceiver(true);
        }
        RmiResponse rmiResponse = ServerConfig.updatePropertyForRmi("trapReceiver.port", properties.get("port").toString());
        RmiResponse rmiResponse2 = ServerConfig.updatePropertyForRmi("trapReceiver.forwardEnabled", properties.get("forwardEnabled").toString());
        RmiResponse rmiResponse3 = ServerConfig.updatePropertyForRmi("trapReceiver.serverAddress", properties.get("serverAddress").toString());
        RmiResponse rmiResponse4 = ServerConfig.updatePropertyForRmi("trapReceiver.serverPort", properties.get("serverPort").toString());
        RmiResponse rmiResponse5 = ServerConfig.updatePropertyForRmi("trapReceiver.storeUnknownTraps", properties.get("storeUnknownTraps").toString());
        RmiResponse rmiResponse6 = ServerConfig.updatePropertyForRmi("trapReceiver.unknownTrapsSeverity", properties.get("unknownTrapsSeverity").toString());
        RmiResponse rmiResponse7 = ServerConfig.updatePropertyForRmi("trapReceiver.unknownTrapsMessage", properties.get("unknownTrapsMessage").toString());
        if (rmiResponse.getValue().equals(Boolean.FALSE) || rmiResponse2.getValue().equals(Boolean.FALSE) || rmiResponse3.getValue().equals(Boolean.FALSE) || rmiResponse4.getValue().equals(Boolean.FALSE) || rmiResponse5.getValue().equals(Boolean.FALSE) || rmiResponse6.getValue().equals(Boolean.FALSE) || rmiResponse7.getValue().equals(Boolean.FALSE)) {
            RmiResponse rmiResponse8 = new RmiResponse(Boolean.FALSE);
            rmiResponse8.setErrorMessage("ChangeServerConfig ErrorMessage: \r\n");
            if (rmiResponse.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse.getErrorMessage() + "\r\n");
            }
            if (rmiResponse2.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse2.getErrorMessage() + "\r\n");
            }
            if (rmiResponse3.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse3.getErrorMessage() + "\r\n");
            }
            if (rmiResponse4.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse4.getErrorMessage() + "\r\n");
            }
            if (rmiResponse5.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse5.getErrorMessage() + "\r\n");
            }
            if (rmiResponse6.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse6.getErrorMessage() + "\r\n");
            }
            if (rmiResponse7.getErrorMessage() != null) {
                rmiResponse8.setErrorMessage(rmiResponse8.getErrorMessage() + rmiResponse7.getErrorMessage() + "\r\n");
            }
            return rmiResponse8;
        }
        RmiResponse rmiResponse9 = new RmiResponse(Boolean.TRUE);
        if (Command.b() != null) {
            PooledPerformer.b(new String[1]);
        }
        return rmiResponse9;
    }

    @Override
    public RmiResponse changededup(String string, String string2) {
        RmiResponse rmiResponse = ServerConfig.updatePropertyForRmi("trapReceiver.dedupEnabled", string);
        RmiResponse rmiResponse2 = ServerConfig.updatePropertyForRmi("trapReceiver.dedupTime", string2);
        if (rmiResponse.getValue().equals(Boolean.FALSE) || rmiResponse2.getValue().equals(Boolean.FALSE)) {
            RmiResponse rmiResponse3 = new RmiResponse(Boolean.FALSE);
            rmiResponse3.setErrorMessage("Changededup ErrorMessage: ");
            if (rmiResponse.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse.getErrorMessage());
            }
            if (rmiResponse2.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse2.getErrorMessage());
            }
            return rmiResponse3;
        }
        return new RmiResponse(Boolean.TRUE);
    }

    @Override
    public RmiResponse changeDBClearConfig(String string, String string2) {
        RmiResponse rmiResponse = ServerConfig.updatePropertyForRmi("trapReceiver.snmpKeepDay", string);
        RmiResponse rmiResponse2 = ServerConfig.updatePropertyForRmi("trapReceiver.performanceKeepDay", string2);
        if (rmiResponse.getValue().equals(Boolean.FALSE) || rmiResponse2.getValue().equals(Boolean.FALSE)) {
            RmiResponse rmiResponse3 = new RmiResponse(Boolean.FALSE);
            rmiResponse3.setErrorMessage("ChangeDBClearConfig ErrorMessage: ");
            if (rmiResponse.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse.getErrorMessage());
            }
            if (rmiResponse2.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse2.getErrorMessage());
            }
            return rmiResponse3;
        }
        return new RmiResponse(Boolean.TRUE);
    }

    @Override
    public RmiResponse changeClear(String string, String string2) {
        RmiResponse rmiResponse = ServerConfig.updatePropertyForRmi("trapReceiver.clearTrapEnabled", string);
        RmiResponse rmiResponse2 = ServerConfig.updatePropertyForRmi("trapReceiver.clearTrapTime", string2);
        if (rmiResponse.getValue().equals(Boolean.FALSE) || rmiResponse2.getValue().equals(Boolean.FALSE)) {
            RmiResponse rmiResponse3 = new RmiResponse(Boolean.FALSE);
            rmiResponse3.setErrorMessage("ChangeClear ErrorMessage: ");
            if (rmiResponse.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse.getErrorMessage());
            }
            if (rmiResponse2.getErrorMessage() != null) {
                rmiResponse3.setErrorMessage(rmiResponse3.getErrorMessage() + rmiResponse2.getErrorMessage());
            }
            return rmiResponse3;
        }
        return new RmiResponse(Boolean.TRUE);
    }

    @Override
    public RmiResponse addClear(ClearTrapObject clearTrapObject) {
        ClearSql clearSql = new ClearSql();
        RmiResponse rmiResponse = clearSql.addClear(clearTrapObject);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.addClear(clearTrapObject);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse modifyClear(ClearTrapObject clearTrapObject) {
        ClearSql clearSql = new ClearSql();
        RmiResponse rmiResponse = clearSql.modifyClear(clearTrapObject);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.modifyClear(clearTrapObject);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse getClearTraps() {
        ClearSql clearSql = new ClearSql();
        return clearSql.getClearTraps();
    }

    @Override
    public RmiResponse deleteClear(String string) {
        ClearSql clearSql = new ClearSql();
        RmiResponse rmiResponse = clearSql.deleteClear(string);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.deleteClear(string);
        }
        return rmiResponse;
    }

    @Override
    public Object smtpServerConfig(String string, String string2, String string3, String string4) {
        return TrapReceiver.configSmtpServer(string, string2, string3, string4, true);
    }

    @Override
    public RmiResponse isSmtpServerConfigured() throws RemoteException {
        return TrapReceiverUtil.isSmtpServerConfigured();
    }

    @Override
    public RmiResponse modifyBeClear(String string, ToBeClearedTrapObject toBeClearedTrapObject) {
        ClearSql clearSql = new ClearSql();
        RmiResponse rmiResponse = clearSql.modifyBeClear(string, toBeClearedTrapObject);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapReceiver.modifyBeClear(string, toBeClearedTrapObject);
        }
        return rmiResponse;
    }

    @Override
    public List getGeneralMailTimePairList() {
        return GeneralTimeEmailDao.getMailTimePairList();
    }

    @Override
    public RmiResponse addEnterprise(EnterpriseObject enterpriseObject) {
        EventConfigSql eventConfigSql = new EventConfigSql();
        RmiResponse rmiResponse = eventConfigSql.addEnterprise(enterpriseObject);
        if (rmiResponse.getValue().equals(Boolean.FALSE)) {
            return rmiResponse;
        }
        TrapReceiver.resetEvents();
        return rmiResponse;
    }

    @Override
    public RmiResponse modifyEnterprise(EnterpriseObject enterpriseObject) {
        EventConfigSql eventConfigSql = new EventConfigSql();
        RmiResponse rmiResponse = eventConfigSql.modifyEnterprise(enterpriseObject);
        if (rmiResponse.getValue().equals(Boolean.FALSE)) {
            return rmiResponse;
        }
        TrapReceiver.resetEvents();
        return rmiResponse;
    }

    @Override
    public RmiResponse deleteEnterprise(String string) {
        EventConfigSql eventConfigSql = new EventConfigSql();
        RmiResponse rmiResponse = eventConfigSql.deleteEnterprise(string);
        if (rmiResponse.getValue().equals(Boolean.FALSE)) {
            return rmiResponse;
        }
        TrapReceiver.resetEvents();
        return rmiResponse;
    }

    @Override
    public RmiResponse loadDefaultActions() {
        RmiResponse rmiResponse = new RmiResponse();
        String string = ServerConfig.getProperty("trapEvent.defaultActions");
        string = TextProcessor.decodeFromBase64Format(string, "aBCde1235EaaaaNbbbbb");
        rmiResponse.setValue((Serializable)((Object)string));
        return rmiResponse;
    }

    @Override
    public RmiResponse saveAsDefaultActions(String string) {
        string = TextProcessor.encodeToBase64Format(string, "aBCde1235EaaaaNbbbbb");
        return ServerConfig.updatePropertyForRmi("trapEvent.defaultActions", string);
    }

    @Override
    public RmiResponse testActions(String string, boolean bl2) {
        try {
            AlarmActions alarmActions = AlarmActions.fromXML(string, NoUseStateTimebucketCache.getCacheMap());
            PooledExecutor pooledExecutor = new PooledExecutor();
            pooledExecutor.setKeepAliveTime(0L);
            RmiResponse rmiResponse = new RmiResponse();
            StringBuffer stringBuffer = new StringBuffer();
            if (alarmActions != null) {
                TestActionsPerformer testActionsPerformer = new TestActionsPerformer(pooledExecutor, stringBuffer, bl2);
                testActionsPerformer.perform(alarmActions);
            }
            pooledExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
            try {
                pooledExecutor.awaitTerminationAfterShutdown();
            }
            catch (InterruptedException interruptedException) {
                _logger.error((Object)"await", (Throwable)interruptedException);
            }
            rmiResponse.setValue((Serializable)((Object)stringBuffer.toString()));
            return rmiResponse;
        }
        catch (Exception exception) {
            _logger.error((Object)"internal", (Throwable)exception);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public RmiResponse startOrStopTrapReceiver(Boolean bl2) {
        RmiResponse rmiResponse = new RmiResponse(Boolean.FALSE);
        try {
            block12: {
                block14: {
                    block13: {
                        block15: {
                            if (!bl2.booleanValue()) break block12;
                            if (this._trapReceiver == null) break block13;
                            break block15;
                            catch (Exception exception) {
                                throw TrapReceiverConfig.a(exception);
                            }
                        }
                        try {
                            block16: {
                                if (this._trapReceiver.getSession() == null) break block13;
                                break block16;
                                catch (Exception exception) {
                                    throw TrapReceiverConfig.a(exception);
                                }
                            }
                            this.stopService();
                        }
                        catch (Exception exception) {
                            throw TrapReceiverConfig.a(exception);
                        }
                    }
                    this.startService();
                    Thread.sleep(500L);
                    if (this._trapReceiver == null) break block14;
                    try {
                        block17: {
                            if (this._trapReceiver.getSession() == null) break block14;
                            break block17;
                            catch (Exception exception) {
                                throw TrapReceiverConfig.a(exception);
                            }
                        }
                        rmiResponse.setValue(Boolean.TRUE);
                    }
                    catch (Exception exception) {
                        throw TrapReceiverConfig.a(exception);
                    }
                }
                return rmiResponse;
            }
            this.stopService();
            rmiResponse.setValue(Boolean.TRUE);
            String string = BootFinder.getLocalBindAddress();
            TrapCallbackServer.getInstance().trapReceiverStatus(bl2, string);
            return rmiResponse;
        }
        catch (Exception exception) {
            _logger.info((Object)"change trap receiver service status is failed", (Throwable)exception);
            return null;
        }
    }

    @Override
    public RmiResponse trapReceiverStatus() {
        if (this._trapReceiver == null) {
            return new RmiResponse(Boolean.FALSE);
        }
        if (this._trapReceiver.getSession() != null) {
            return new RmiResponse(Boolean.TRUE);
        }
        return new RmiResponse(Boolean.FALSE);
    }

    @Override
    public RmiResponse getTrapReceiverIpAndPort() {
        String string = System.getProperty("bind.address");
        String string2 = ServerConfig.getProperty("trapReceiver.port", "161");
        return new RmiResponse((Serializable)new String[]{string, string2});
    }

    @Override
    public boolean getShouldConfigSMTPServer() {
        boolean bl2 = Boolean.TRUE.toString().equals(ServerConfig.getProperty("trapReceiver.shouldConfigSmtp", Boolean.toString(true)));
        boolean bl3 = SmtpConfig.getSMTPConfig() == null;
        return bl2 && bl3;
    }

    @Override
    public void setShouldConfigSMTPServer(boolean bl2) {
        ServerConfig.updateProperty("trapReceiver.shouldConfigSmtp", Boolean.toString(bl2));
    }

    @Override
    public boolean getEmailTemplateEnabled() throws RemoteException {
        block7: {
            String string = ServerConfig.getProperty("trapReceiver.templateEnabled");
            try {
                block6: {
                    try {
                        try {
                            if (string == null || string.trim().length() == 0) break block6;
                        }
                        catch (RemoteException remoteException) {
                            throw TrapReceiverConfig.a(remoteException);
                        }
                        if (StringUtil.getBool(string)) break block7;
                    }
                    catch (RemoteException remoteException) {
                        throw TrapReceiverConfig.a(remoteException);
                    }
                }
                return false;
            }
            catch (RemoteException remoteException) {
                throw TrapReceiverConfig.a(remoteException);
            }
        }
        return true;
    }

    @Override
    public boolean getEmailSubjectTemplateEnabled() throws RemoteException {
        block7: {
            String string = ServerConfig.getProperty("trapReceiver.subjectTemplateEnabled");
            try {
                block6: {
                    try {
                        try {
                            if (string == null || string.trim().length() == 0) break block6;
                        }
                        catch (RemoteException remoteException) {
                            throw TrapReceiverConfig.a(remoteException);
                        }
                        if (StringUtil.getBool(string)) break block7;
                    }
                    catch (RemoteException remoteException) {
                        throw TrapReceiverConfig.a(remoteException);
                    }
                }
                return false;
            }
            catch (RemoteException remoteException) {
                throw TrapReceiverConfig.a(remoteException);
            }
        }
        return true;
    }

    @Override
    public void setEmailTemplateEnabled(boolean bl2) throws RemoteException {
        ServerConfig.updateProperty("trapReceiver.templateEnabled", Boolean.toString(bl2));
    }

    @Override
    public void setEmailSubjectTemplateEnabled(boolean bl2) throws RemoteException {
        ServerConfig.updateProperty("trapReceiver.subjectTemplateEnabled", Boolean.toString(bl2));
    }

    @Override
    public RmiResponse getEmailTemplate() throws RemoteException {
        String string = ServerConfig.getProperty("trapReceiver.template");
        if (string == null) {
            string = "";
        }
        return new RmiResponse((Serializable)((Object)string));
    }

    @Override
    public RmiResponse getEmailSubjectTemplate() throws RemoteException {
        String string = ServerConfig.getProperty("trapReceiver.subjectTemplate");
        if (string == null) {
            string = "";
        }
        return new RmiResponse((Serializable)((Object)string));
    }

    @Override
    public void updateEmailTemplate(String string) throws RemoteException {
        ServerConfig.updateProperty("trapReceiver.template", string);
    }

    public TrapReceiver getTrapReceiver() {
        return this._trapReceiver;
    }

    @Override
    public void updateEmailSubjectTemplate(String string) throws RemoteException {
        ServerConfig.updateProperty("trapReceiver.subjectTemplate", string);
    }

    @Override
    public void saveFilterSettings(TrapFilterData trapFilterData) throws RemoteException {
        block6: {
            String[] stringArray = PooledPerformer.b();
            try {
                if (!UserPropertyConfig.deleteProperties(trapFilterData.getUser(), "trap.")) break block6;
                String[] stringArray2 = new String[]{"severity", "source", "acknowledge", "keywordmessage", "clear", "category"};
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    try {
                        stringArray2[i2] = "trap." + stringArray2[i2];
                        if (stringArray != null) {
                            if (stringArray != null) continue;
                            break;
                        }
                        break block6;
                    }
                    catch (Exception exception) {
                        throw TrapReceiverConfig.a(exception);
                    }
                }
                String[] stringArray3 = new String[]{trapFilterData.getSeverityStr(), trapFilterData.getSourceStr(), trapFilterData.getAcknowledgement(), trapFilterData.getKeywordMessage(), trapFilterData.getClear(), String.valueOf(trapFilterData.getCategoryID())};
                UserPropertyConfig.addProperties(trapFilterData.getUser(), stringArray2, stringArray3);
                TrapCallbackServer.getInstance().addSettingFlas(trapFilterData.getUser());
            }
            catch (Exception exception) {
                _logger.error((Object)"saveFilterSettings Error::", (Throwable)exception);
            }
        }
    }

    @Override
    public RmiResponse getFilterSettings(String string) throws RemoteException {
        try {
            if (string == null) {
                return RmiResponse.FALSE;
            }
        }
        catch (Exception exception) {
            throw TrapReceiverConfig.a(exception);
        }
        TrapFilterData trapFilterData = new TrapFilterData(string);
        RmiResponse rmiResponse = RmiResponse.FALSE;
        try {
            Map<String, String> map = UserPropertyConfig.getUserProperties(string, "trap.");
            try {
                if (!map.isEmpty()) {
                    trapFilterData.setSeverityList(map.get("trap.severity"));
                    trapFilterData.setSourceList(map.get("trap.source"));
                    trapFilterData.setAcknowledgement(map.get("trap.acknowledge"));
                    trapFilterData.setKeywordMessage(map.get("trap.keywordmessage"));
                    trapFilterData.setClear(map.get("trap.clear"));
                    trapFilterData.setCategoryID(map.get("trap.category"));
                }
            }
            catch (Exception exception) {
                throw TrapReceiverConfig.a(exception);
            }
            rmiResponse = new RmiResponse(trapFilterData);
        }
        catch (Exception exception) {
            _logger.error((Object)"get trap filter setting ", (Throwable)exception);
        }
        return rmiResponse;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

