/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.reportschedule;

import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.report.ScheduleObject;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.schedule.RealSchedule;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.MonitorProcessor;
import com.sysuptime.server.performance.ProtocolQueryResultReader;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.reportschedule.ReportBundle;
import com.sysuptime.server.reportschedule.ReportDB;
import com.sysuptime.server.reportschedule.ReportDBScheduleProviderMBean;
import com.sysuptime.server.reportschedule.ReportSchedule$1;
import com.sysuptime.server.reportschedule.ReportScheduleMBean;
import com.sysuptime.server.reportschedule.TimeSeriesItem$ValueWithState;
import com.sysuptime.server.trapreceiver.TrapReceiverUtil;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.MBeanManager;
import com.sysuptime.server.util.mail.SendMail;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ReportSchedule
implements ReportScheduleMBean {
    private static final Logger _logger = Logger.getLogger((String)ReportSchedule.class.getName());

    @Override
    public RmiResponse getObjects() {
        return ReportDB.getObjects();
    }

    @Override
    public RmiResponse getSchedules() {
        return ReportDB.getSchedules();
    }

    @Override
    public RmiResponse getReport(ScheduleObject scheduleObject) {
        RmiResponse rmiResponse = this.a(scheduleObject);
        if (!scheduleObject.isView()) {
            JasperPrint jasperPrint = null;
            Object object = rmiResponse.getValue();
            if (!Boolean.FALSE.equals(object)) {
                jasperPrint = (JasperPrint)object;
            }
            rmiResponse = this.a(jasperPrint, scheduleObject.getMailArray(), NbBundle.getMessage(ReportSchedule.class, (String)"Quick_Report"), rmiResponse.getErrorMessage());
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse getSqlReport(ScheduleObject scheduleObject, Map<String, List<String>> map) {
        RmiResponse rmiResponse = RmiResponse.FALSE;
        rmiResponse = this.a(scheduleObject, map);
        if (!scheduleObject.isView()) {
            JasperPrint jasperPrint = null;
            Object object = rmiResponse.getValue();
            if (!Boolean.FALSE.equals(object)) {
                jasperPrint = (JasperPrint)object;
            }
            rmiResponse = this.a(jasperPrint, scheduleObject.getMailArray(), NbBundle.getMessage(ReportSchedule.class, (String)"Quick_Report"), rmiResponse.getErrorMessage());
        }
        return rmiResponse;
    }

    private RmiResponse a(JasperPrint jasperPrint, Object[] objectArray, String string, String string2) {
        RmiResponse rmiResponse;
        block14: {
            Object object;
            int n2;
            String[] stringArray;
            block12: {
                stringArray = new String[objectArray.length];
                n2 = TimeSeriesItem$ValueWithState.b();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    stringArray[i2] = objectArray[i2].toString();
                    if (n2 != 0) continue;
                }
                rmiResponse = new RmiResponse(Boolean.TRUE);
                try {
                    if (TrapReceiverUtil.isSmtpServerConfigured().getValue().equals(Boolean.FALSE)) {
                        _logger.error((Object)"SMTP Server is not configured. Report can't be sent");
                        rmiResponse.setValue(Boolean.FALSE);
                        rmiResponse.setErrorMessage(NbBundle.getMessage(ReportSchedule.class, (String)"snmp_configure"));
                        return rmiResponse;
                    }
                }
                catch (JRException jRException) {
                    throw ReportSchedule.a(jRException);
                }
                object = ReportSchedule.a("MSG_report_subject");
                try {
                    if (string == null || string.length() == 0) break block12;
                }
                catch (JRException jRException) {
                    throw ReportSchedule.a(jRException);
                }
                object = (String)object + " - " + string;
            }
            try {
                block13: {
                    try {
                        if (jasperPrint == null || jasperPrint.getPages().size() <= 0) break block13;
                    }
                    catch (JRException jRException) {
                        throw ReportSchedule.a(jRException);
                    }
                    rmiResponse = SendMail.sendMails((String)object, ReportSchedule.a("MSG_report_body"), stringArray, JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint), "text/plain");
                    if (n2 != 0) break block14;
                }
                Object object2 = string2;
                if (string != null) {
                    object2 = NbBundle.getMessage(ReportSchedule.class, (String)"monitor_name") + ": " + string + "\n" + (String)object2;
                }
                rmiResponse = SendMail.sendMails((String)object, (String)object2, stringArray, null, "text/plain");
            }
            catch (JRException jRException) {
                rmiResponse.setValue(Boolean.FALSE);
                rmiResponse.setErrorMessage(ReportBundle.getString("send_report_fail") + ": " + jRException.getMessage());
                _logger.error((Object)"Report can't be sent", (Throwable)jRException);
            }
        }
        return rmiResponse;
    }

    private String a(Monitor monitor, int n2, String string) {
        int n3 = monitor.getMetricsListSize();
        int n4 = TimeSeriesItem$ValueWithState.c();
        for (int i2 = 0; i2 < n3; ++i2) {
            Baseline baseline = (Baseline)monitor.getMetrics(i2);
            if (baseline.getResultTypeId() != n2) continue;
            return baseline.getThresholdToken(false, string);
        }
        return "";
    }

    private String a(ScheduleObject scheduleObject, long l2, long l3, Properties properties) throws Exception {
        boolean bl2;
        StringBuffer stringBuffer;
        block7: {
            boolean bl3 = false;
            stringBuffer = new StringBuffer();
            Map map = MonitorProcessor.getScheduleNameToId();
            Object[] objectArray = scheduleObject.getNodeArray();
            int n2 = TimeSeriesItem$ValueWithState.c();
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                String string;
                String string2;
                int n4;
                String string3;
                String string4;
                String string5;
                block9: {
                    block8: {
                        QueryParameter queryParameter = (QueryParameter)objectArray[i2];
                        String string6 = queryParameter.get(1).toString();
                        string5 = QueryFactory.getResultTableName(Short.parseShort(string6));
                        string4 = queryParameter.get(2).toString();
                        String string7 = queryParameter.get(3).toString();
                        properties.setProperty(string4, string7);
                        string3 = queryParameter.get(4).toString();
                        n4 = ((Number)map.get(string3)).intValue();
                        int n5 = Integer.parseInt(string4);
                        properties.setProperty("threshold" + string4, this.a(MonitorCache.getMonitor(n4), n5, scheduleObject.getResultValueUnit()));
                        string2 = queryParameter.get(5).toString();
                        string = null;
                        try {
                            bl2 = MonitorHost.isMultiHosts(string2);
                            if (n2 != 0) break block7;
                            if (!bl2) break block8;
                        }
                        catch (Exception exception) {
                            throw ReportSchedule.a(exception);
                        }
                        string = MonitorHost.getMetricsHost(string2, ExecutorHelper.getName(n5));
                        break block9;
                    }
                    string = string2;
                }
                properties.setProperty(string3 + string4 + string2, string);
                if (i2 > 0) {
                    bl3 = true;
                    stringBuffer.append(" union ");
                }
                stringBuffer.append("select schedule_name_c,ip_address_c,result_type_id_c,run_date_time_c,result_value_c,threshold_state_c,error_code_c ");
                stringBuffer.append(" from pm_schedule_host inner join pm_schedule on pm_schedule_host.schedule_id_c=pm_schedule.schedule_id_c");
                stringBuffer.append(" inner join ");
                stringBuffer.append(string5);
                stringBuffer.append(" on pm_schedule_host.schedule_host_id_c=");
                stringBuffer.append(string5);
                stringBuffer.append(".schedule_host_id_c and ");
                stringBuffer.append(string5).append(".result_type_id_c=").append(string4);
                stringBuffer.append(" and pm_schedule.schedule_id_c=").append("").append(n4);
                stringBuffer.append(" and pm_schedule_host.ip_address_c='").append(string2);
                stringBuffer.append("' and run_date_time_c between ").append(l2).append(" and ").append(l3);
                if (n2 == 0) continue;
            }
            bl2 = bl3;
        }
        try {
            if (!bl2) {
                stringBuffer.append(" order by schedule_name_c,ip_address_c,result_type_id_c,run_date_time_c");
            }
        }
        catch (Exception exception) {
            throw ReportSchedule.a(exception);
        }
        return stringBuffer.toString();
    }

    @Override
    public void sendReport(Integer n2) {
        ScheduleObject scheduleObject;
        block5: {
            block7: {
                block6: {
                    scheduleObject = ReportDB.getSchedule(n2);
                    int n3 = TimeSeriesItem$ValueWithState.c();
                    if (scheduleObject != null && !scheduleObject.getPauseOfBoolean().booleanValue()) break block5;
                    if (scheduleObject == null) break block6;
                    _logger.info((Object)("Schedule ( " + scheduleObject.getScheduleName() + " ) has been suspended."));
                    if (n3 == 0) break block7;
                }
                _logger.error((Object)("Schedule ( " + n2 + " ) is null"));
            }
            return;
        }
        RmiResponse rmiResponse = this.a(scheduleObject);
        Object object = rmiResponse.getValue();
        JasperPrint jasperPrint = null;
        if (!Boolean.FALSE.equals(object)) {
            jasperPrint = (JasperPrint)object;
        }
        this.a(jasperPrint, scheduleObject.getMailArray(), scheduleObject.getScheduleName(), rmiResponse.getErrorMessage());
        if (scheduleObject.getDateType() == 2) {
            Calendar calendar = Calendar.getInstance();
            scheduleObject.setStartDateTime(calendar.getTimeInMillis() - 1000L);
            long l2 = (long)calendar.getActualMaximum(5) * 86400000L;
            scheduleObject.setPeriod(l2);
            this.d(scheduleObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RmiResponse a(ScheduleObject scheduleObject) {
        RmiResponse rmiResponse;
        block15: {
            Serializable serializable;
            long l2;
            long l3;
            int n2;
            Connection connection;
            JasperPrint jasperPrint;
            block17: {
                block16: {
                    rmiResponse = new RmiResponse();
                    jasperPrint = null;
                    connection = null;
                    n2 = TimeSeriesItem$ValueWithState.c();
                    if (!scheduleObject.isQuick()) break block16;
                    l3 = scheduleObject.getStartDateTime();
                    l2 = scheduleObject.getEndDateTime();
                    if (n2 == 0) break block17;
                }
                int n3 = scheduleObject.getDateType();
                serializable = Calendar.getInstance();
                long l4 = scheduleObject.getPeriod();
                l2 = ((Calendar)serializable).getTimeInMillis();
                l3 = l2 - l4;
                if (n3 == 3) {
                    ((Calendar)serializable).set(5, 1);
                    ((Calendar)serializable).set(11, scheduleObject.getTimeIndex());
                    l3 = ((Calendar)serializable).getTimeInMillis();
                }
            }
            try {
                connection = DefaultConnection.getConnection();
                jasperPrint = scheduleObject.isSingle() ? this.a(connection, scheduleObject, l3, l2) : this.b(connection, scheduleObject, l3, l2);
            }
            catch (Throwable throwable) {
                System.out.print("Error report>>>>>>>>>>>>>>>>>>>");
                _logger.error((Object)"", throwable);
                rmiResponse.setValue(Boolean.FALSE);
                rmiResponse.setErrorMessage(ReportBundle.getString("create_report_error"));
                serializable = rmiResponse;
                return serializable;
            }
            finally {
                DefaultConnection.closeConnection(connection);
            }
            List list = jasperPrint.getPages();
            try {
                block14: {
                    try {
                        if (list.size() <= 0) break block14;
                        rmiResponse.setValue((Serializable)jasperPrint);
                        if (n2 == 0) break block15;
                    }
                    catch (Throwable throwable) {
                        throw ReportSchedule.a(throwable);
                    }
                }
                rmiResponse.setValue(Boolean.FALSE);
                rmiResponse.setErrorMessage(NbBundle.getMessage(ReportSchedule.class, (String)"MSG_report_body_no_data"));
            }
            catch (Throwable throwable) {
                throw ReportSchedule.a(throwable);
            }
        }
        return rmiResponse;
    }

    private JasperPrint a(Connection connection, ScheduleObject scheduleObject, long l2, long l3) throws Exception {
        Map map = this.b(scheduleObject);
        this.a(map, scheduleObject);
        Properties properties = new Properties();
        map.put("sql", this.a(scheduleObject, l2, l3, properties));
        map.put("map", properties);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + AppUtil.getAppServerHomeDirectory() + "/conf/report/")}));
        JasperPrint jasperPrint = JasperFillManager.fillReport((String)(AppUtil.getAppServerHomeDirectory() + "/conf/report/" + ReportBundle.getString("schedule_report")), (Map)map, (Connection)connection);
        Thread.currentThread().setContextClassLoader(classLoader);
        return jasperPrint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RmiResponse a(ScheduleObject scheduleObject, Map<String, List<String>> map) {
        RmiResponse rmiResponse;
        block11: {
            Connection connection = null;
            rmiResponse = new RmiResponse();
            int n2 = TimeSeriesItem$ValueWithState.b();
            JasperPrint jasperPrint = null;
            try {
                connection = DefaultConnection.getConnection();
                jasperPrint = this.a(connection, scheduleObject, map);
            }
            catch (Throwable throwable) {
                _logger.error((Object)"Create Sql Report Throwable:", throwable);
            }
            finally {
                DefaultConnection.closeConnection(connection);
            }
            List list = jasperPrint.getPages();
            try {
                block10: {
                    try {
                        if (list.size() <= 0) break block10;
                        rmiResponse.setValue((Serializable)jasperPrint);
                        if (n2 != 0) break block11;
                    }
                    catch (Throwable throwable) {
                        throw ReportSchedule.a(throwable);
                    }
                }
                rmiResponse.setValue(Boolean.FALSE);
                rmiResponse.setErrorMessage(NbBundle.getMessage(ReportSchedule.class, (String)"MSG_report_body_no_data"));
            }
            catch (Throwable throwable) {
                throw ReportSchedule.a(throwable);
            }
        }
        return rmiResponse;
    }

    private JasperPrint a(Connection connection, ScheduleObject scheduleObject, Map<String, List<String>> map) {
        Map map2 = this.b(scheduleObject);
        int n2 = TimeSeriesItem$ValueWithState.c();
        this.a(map2, scheduleObject);
        int n3 = n2;
        try {
            Calendar calendar;
            long l2;
            long l3;
            Properties properties;
            block7: {
                block6: {
                    properties = new Properties();
                    l3 = 0L;
                    l2 = 0L;
                    if (!scheduleObject.isQuick()) break block6;
                    l3 = scheduleObject.getStartDateTime();
                    l2 = scheduleObject.getEndDateTime();
                    if (n3 == 0) break block7;
                }
                int n4 = scheduleObject.getDateType();
                calendar = Calendar.getInstance();
                long l4 = scheduleObject.getPeriod();
                l2 = calendar.getTimeInMillis();
                l3 = l2 - l4;
                if (n4 == 3) {
                    calendar.set(5, 1);
                    calendar.set(11, scheduleObject.getTimeIndex());
                    l3 = calendar.getTimeInMillis();
                }
            }
            map2.put("sql", this.a(scheduleObject, l3, l2, properties));
            map2.put("map", properties);
            map2.put("args", map);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + AppUtil.getAppServerHomeDirectory() + "/conf/report/")}));
            calendar = JasperFillManager.fillReport((String)(AppUtil.getAppServerHomeDirectory() + "/conf/report/" + ReportBundle.getString("sql_monitor")), (Map)map2, (Connection)connection);
            Thread.currentThread().setContextClassLoader(classLoader);
            return calendar;
        }
        catch (Exception exception) {
            _logger.error((Object)"Get Sql Print Error Occured:", (Throwable)exception);
            return null;
        }
    }

    private Map b(ScheduleObject scheduleObject) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (scheduleObject.isSingle()) {
            hashMap.put("table", scheduleObject.includeContent(1));
            hashMap.put("graph", scheduleObject.includeContent(0));
            hashMap.put("error", scheduleObject.includeContent(2));
        }
        return hashMap;
    }

    private void a(Map map, ScheduleObject scheduleObject) {
        String string = scheduleObject.getScheduleName();
        if (string == null) {
            string = "";
        }
        map.put("name", string);
        String string2 = scheduleObject.getResultValueUnit();
        if (string2 != null && string2.length() != 0) {
            map.put("unit", scheduleObject.getResultValueUnit());
        }
    }

    private JasperPrint b(Connection connection, ScheduleObject scheduleObject, long l2, long l3) throws Exception {
        String string;
        Object object;
        ArrayList arrayList;
        Map map;
        block12: {
            int n2;
            int n3;
            int n4;
            block10: {
                map = this.c(scheduleObject);
                int n5 = TimeSeriesItem$ValueWithState.c();
                this.a(map, scheduleObject);
                arrayList = new ArrayList(scheduleObject.getNodeArray().length);
                n4 = n5;
                for (n3 = 0; n3 < scheduleObject.getNodeArray().length; ++n3) {
                    object = (QueryParameter)scheduleObject.getNodeArray()[n3];
                    string = ((QueryParameter)object).get(1).toString();
                    String string2 = QueryFactory.getResultTableName(Short.parseShort(string));
                    int n6 = Integer.parseInt(((QueryParameter)object).get(2).toString());
                    try {
                        block11: {
                            try {
                                try {
                                    n2 = scheduleObject.isAvg() ? 1 : 0;
                                    if (n4 != 0) break block10;
                                    if (n2 == 0) break block11;
                                }
                                catch (Exception exception) {
                                    throw ReportSchedule.a(exception);
                                }
                                arrayList.addAll(ProtocolQueryResultReader.getReportAvgList(connection, string2, n6, l2, l3, scheduleObject.isAscend(), scheduleObject.getTop(), ((QueryParameter)object).get(6).toString(), ((QueryParameter)object).get(5).toString(), scheduleObject.getShowType()));
                                if (n4 == 0) continue;
                            }
                            catch (Exception exception) {
                                throw ReportSchedule.a(exception);
                            }
                        }
                        arrayList.addAll(ProtocolQueryResultReader.getReportAlarmList(connection, string2, n6, l2, l3, scheduleObject.isAscend(), scheduleObject.getTop(), (QueryParameter)object, scheduleObject.getShowType()));
                        continue;
                    }
                    catch (Exception exception) {
                        throw ReportSchedule.a(exception);
                    }
                }
                ReportSchedule.sortReportMonitorBeanList(arrayList, scheduleObject.isAscend());
                n2 = scheduleObject.getTop();
            }
            try {
                if (n2 == -1 || scheduleObject.getTop() >= arrayList.size()) break block12;
            }
            catch (Exception exception) {
                throw ReportSchedule.a(exception);
            }
            for (n3 = arrayList.size() - 1; n3 >= scheduleObject.getTop(); --n3) {
                arrayList.remove(n3);
                if (n4 == 0) continue;
            }
        }
        JRBeanCollectionDataSource jRBeanCollectionDataSource = new JRBeanCollectionDataSource(arrayList);
        object = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + AppUtil.getAppServerHomeDirectory() + "/conf/report/")}));
        string = null;
        string = scheduleObject.isAvg() ? JasperFillManager.fillReport((String)(AppUtil.getAppServerHomeDirectory() + "/conf/report/" + ReportBundle.getString("monitor_avg_report")), (Map)map, (JRDataSource)jRBeanCollectionDataSource) : JasperFillManager.fillReport((String)(AppUtil.getAppServerHomeDirectory() + "/conf/report/" + ReportBundle.getString("monitor_alarms_report")), (Map)map, (JRDataSource)jRBeanCollectionDataSource);
        Thread.currentThread().setContextClassLoader((ClassLoader)object);
        return string;
    }

    private Map c(ScheduleObject scheduleObject) {
        HashMap<String, Object> hashMap;
        block11: {
            QueryParameter queryParameter;
            block10: {
                int n2;
                block9: {
                    block8: {
                        boolean bl2;
                        block7: {
                            block6: {
                                hashMap = new HashMap<String, Object>();
                                n2 = TimeSeriesItem$ValueWithState.b();
                                int n3 = scheduleObject.getTop();
                                bl2 = scheduleObject.isAscend();
                                if (n3 == -1) break block6;
                                hashMap.put("top", String.valueOf(n3));
                                if (n2 != 0) break block7;
                            }
                            hashMap.put("top", ReportBundle.getString("all"));
                        }
                        if (!bl2) break block8;
                        hashMap.put("order", ReportBundle.getString("ascend"));
                        if (n2 != 0) break block9;
                    }
                    hashMap.put("order", ReportBundle.getString("descend"));
                }
                queryParameter = (QueryParameter)scheduleObject.getNodeArray()[0];
                if (scheduleObject.getNodeArray().length <= 1) break block10;
                hashMap.put("type", "");
                if (n2 != 0) break block11;
            }
            hashMap.put("type", queryParameter.get(3));
        }
        return hashMap;
    }

    private void d(ScheduleObject scheduleObject) {
        Object[] objectArray = new Object[]{scheduleObject};
        String[] stringArray = new String[]{RealSchedule.class.getName()};
        try {
            MBeanManager.getInstance().invoke(ReportDBScheduleProviderMBean.OBJECT_NAME, "modifyRealSchedule", objectArray, stringArray);
        }
        catch (Exception exception) {
            _logger.error((Object)exception, (Throwable)exception);
        }
    }

    public static void sortReportMonitorBeanList(List list, boolean bl2) {
        block3: {
            block2: {
                int n2 = TimeSeriesItem$ValueWithState.c();
                if (!bl2) break block2;
                Collections.sort(list);
                if (n2 == 0) break block3;
            }
            Collections.sort(list, new ReportSchedule$1());
        }
    }

    private static String a(String string) {
        return NbBundle.getMessage(ReportSchedule.class, (String)string);
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

