/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MonitorWriter {
    private MonitorWriter() {
    }

    public static synchronized void setSuspended(Connection connection, int n2, boolean bl2, long l2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_SCHEDULE SET IS_SUSPENDED_C=?, RESUME_TIME_C=? WHERE SCHEDULE_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            SqlUtil.setBoolean(preparedStatement, 1, bl2);
            preparedStatement.setLong(2, l2);
            preparedStatement.setInt(3, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Update pm_schedule to set is_suspended flag " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void setExpiring(Connection connection, int n2, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_SCHEDULE SET is_expired_c= ? WHERE SCHEDULE_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            SqlUtil.setBoolean(preparedStatement, 1, bl2);
            preparedStatement.setInt(2, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Update pm_schedule to set is_expiring flag " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void storeScheduleData(Connection connection, Monitor monitor) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_SCHEDULE(schedule_id_c, schedule_name_c, start_date_time_c, end_date_time_c, period_c, repetitions_c, is_suspended_c, period_unit_c, multiple_c, resume_time_c, group_id_c, is_expired_c, type_c) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            MonitorWriter.a(preparedStatement, monitor);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                try {
                    if (sQLException.getMessage().contains("duplicate")) {
                        throw new SQLException("Duplicate monitor name.");
                    }
                }
                catch (SQLException sQLException2) {
                    throw MonitorWriter.a(sQLException2);
                }
                throw sQLException;
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static void a(PreparedStatement preparedStatement, Monitor monitor) throws SQLException {
        int n2 = monitor.getScheduleId();
        preparedStatement.setInt(1, n2);
        String string = monitor.getScheduleName();
        preparedStatement.setString(2, string);
        long l2 = monitor.getStartDateTime();
        preparedStatement.setLong(3, l2);
        long l3 = monitor.getEndDateTime();
        preparedStatement.setLong(4, l3);
        long l4 = monitor.getPeriod();
        preparedStatement.setLong(5, l4);
        int n3 = monitor.getRepetitions();
        preparedStatement.setInt(6, n3);
        boolean bl2 = monitor.isSuspended();
        SqlUtil.setBoolean(preparedStatement, 7, bl2);
        short s2 = monitor.getUnit();
        preparedStatement.setShort(8, s2);
        short s3 = monitor.getMultiple();
        preparedStatement.setShort(9, s3);
        long l5 = monitor.getResumeTime();
        preparedStatement.setLong(10, l5);
        long l6 = monitor.getGroupId();
        preparedStatement.setLong(11, l6);
        boolean bl3 = monitor.isExpired();
        SqlUtil.setBoolean(preparedStatement, 12, bl3);
        int n4 = monitor.getMonitorType();
        preparedStatement.setInt(13, n4);
    }

    public static void deleteAllSchedule(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM PM_SCHEDULE";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Delete all pm_schedule records " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void deleteSchedule(Connection connection, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM PM_SCHEDULE WHERE SCHEDULE_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Delete pm_schedule one record " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void deleteSchedule(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string2 = "DELETE FROM PM_SCHEDULE WHERE SCHEDULE_NAME_C=?";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Delete pm_schedule one record " + sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void updateGroup(Connection connection, long l2, long l3) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_SCHEDULE SET GROUP_ID_C=? WHERE GROUP_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Update group " + sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

